/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.OptionSetDataType;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Variant {
    private static Logger logger = LoggerFactory.getLogger(Variant.class);
    public static final Variant NULL = new Variant(null);
    final Object value;
    final Class<?> pd;

    public static Object[] asObjectArray(Variant ... variantArray) {
        if (variantArray == null) {
            return null;
        }
        if (variantArray.length == 0) {
            return new Object[0];
        }
        Object[] objectArray = new Object[variantArray.length];
        for (int i2 = 0; i2 < variantArray.length; ++i2) {
            objectArray[i2] = variantArray[i2] == null ? null : variantArray[i2].getValue();
        }
        return objectArray;
    }

    public static Variant[] asVariantArray(Object ... objectArray) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return new Variant[0];
        }
        Variant[] variantArray = new Variant[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            variantArray[i2] = new Variant(objectArray[i2]);
        }
        return variantArray;
    }

    private static Object byteArraysToByteStrings(Object object) {
        Class<?> clazz = object.getClass();
        if (byte[].class.isAssignableFrom(clazz)) {
            return ByteString.valueOf((byte[])object);
        }
        if (byte[][].class.isAssignableFrom(clazz)) {
            byte[][] byArray = (byte[][])object;
            ByteString[] byteStringArray = new ByteString[byArray.length];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byteStringArray[i2] = ByteString.valueOf(byArray[i2]);
            }
            return byteStringArray;
        }
        int[] nArray = Variant.calculateArrayDimensions(object, true);
        MultiDimensionArrayUtils.ArrayIterator arrayIterator = MultiDimensionArrayUtils.arrayIterator(object, nArray);
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
        while (arrayIterator.hasNext()) {
            arrayList.add(ByteString.valueOf((byte[])arrayIterator.next()));
        }
        return MultiDimensionArrayUtils.demuxArray((Object)arrayList.toArray(), nArray, ByteString.class);
    }

    private static int[] calculateArrayDimensions(Object object, boolean bl) {
        int n2 = MultiDimensionArrayUtils.getDimension(object);
        if (bl) {
            --n2;
        }
        int[] nArray = new int[n2];
        if (n2 == 0) {
            return nArray;
        }
        Object object2 = object;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object[] objectArray = (Object[])object2;
            nArray[i2] = objectArray.length;
            if (objectArray.length == 0) break;
            object2 = objectArray[0];
        }
        return nArray;
    }

    private static Object enumsToInts(Object object) {
        Class<?> clazz = object.getClass();
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return ((Enumeration)object).getValue();
        }
        if (Enumeration[].class.isAssignableFrom(clazz)) {
            Enumeration[] enumerationArray = (Enumeration[])object;
            Integer[] integerArray = new Integer[enumerationArray.length];
            for (int i2 = 0; i2 < enumerationArray.length; ++i2) {
                integerArray[i2] = enumerationArray[i2] == null ? null : Integer.valueOf(enumerationArray[i2].getValue());
            }
            return integerArray;
        }
        int[] nArray = Variant.calculateArrayDimensions(object, false);
        Enumeration[] enumerationArray = (Enumeration[])MultiDimensionArrayUtils.muxArray(object, nArray);
        Integer[] integerArray = new Integer[enumerationArray.length];
        for (int i3 = 0; i3 < enumerationArray.length; ++i3) {
            integerArray[i3] = enumerationArray[i3] == null ? null : Integer.valueOf(enumerationArray[i3].getValue());
        }
        return MultiDimensionArrayUtils.demuxArray(integerArray, nArray);
    }

    private static Class<?> optionSetsToCompositeClass(Object object) {
        Class<?> clazz = object.getClass();
        if (OptionSetDataType.class.isAssignableFrom(clazz)) {
            return ((OptionSetDataType)object).getBuiltInTypeClass();
        }
        if (OptionSetDataType[].class.isAssignableFrom(clazz)) {
            OptionSetDataType[] optionSetDataTypeArray = (OptionSetDataType[])object;
            for (int i2 = 0; i2 < optionSetDataTypeArray.length; ++i2) {
                if (optionSetDataTypeArray[i2] == null) continue;
                return optionSetDataTypeArray[i2].getBuiltInTypeClass();
            }
            throw new IllegalArgumentException("Variant cannot accept OptionSetDataType arrays that consists only of nulls");
        }
        int[] nArray = Variant.calculateArrayDimensions(object, false);
        OptionSetDataType[] optionSetDataTypeArray = (OptionSetDataType[])MultiDimensionArrayUtils.muxArray(object, nArray);
        for (int i3 = 0; i3 < optionSetDataTypeArray.length; ++i3) {
            if (optionSetDataTypeArray[i3] == null) continue;
            return optionSetDataTypeArray[i3].getBuiltInTypeClass();
        }
        throw new IllegalArgumentException("Variant cannot accept OptionSetDataType arrays that consists only of nulls");
    }

    private static Object optionSetsToInts(Object object) {
        Class<?> clazz = object.getClass();
        if (OptionSetDataType.class.isAssignableFrom(clazz)) {
            return ((OptionSetDataType)object).getAsBuiltInType();
        }
        if (OptionSetDataType[].class.isAssignableFrom(clazz)) {
            OptionSetDataType[] optionSetDataTypeArray = (OptionSetDataType[])object;
            Object[] objectArray = (Object[])Array.newInstance(Variant.optionSetsToCompositeClass(object), optionSetDataTypeArray.length);
            for (int i2 = 0; i2 < optionSetDataTypeArray.length; ++i2) {
                objectArray[i2] = optionSetDataTypeArray[i2] == null ? null : optionSetDataTypeArray[i2].getAsBuiltInType();
            }
            return objectArray;
        }
        int[] nArray = Variant.calculateArrayDimensions(object, false);
        OptionSetDataType[] optionSetDataTypeArray = (OptionSetDataType[])MultiDimensionArrayUtils.muxArray(object, nArray);
        Object[] objectArray = (Object[])Array.newInstance(Variant.optionSetsToCompositeClass(object), optionSetDataTypeArray.length);
        for (int i3 = 0; i3 < objectArray.length; ++i3) {
            objectArray[i3] = optionSetDataTypeArray[i3] == null ? null : optionSetDataTypeArray[i3].getAsBuiltInType();
        }
        return MultiDimensionArrayUtils.demuxArray(objectArray, nArray);
    }

    public Variant(Object object) {
        if (object == null) {
            this.value = null;
            this.pd = null;
            return;
        }
        Class<?> clazz = MultiDimensionArrayUtils.getComponentType(object.getClass());
        if (OptionSetDataType.class.isAssignableFrom(clazz)) {
            this.pd = Variant.optionSetsToCompositeClass(object);
            this.value = Variant.optionSetsToInts(object);
            return;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            this.value = Variant.enumsToInts(object);
            this.pd = Integer.class;
            return;
        }
        if (Byte.TYPE.isAssignableFrom(clazz)) {
            this.value = Variant.byteArraysToByteStrings(object);
            this.pd = ByteString.class;
            return;
        }
        this.f(clazz);
        this.value = object;
        this.pd = clazz;
    }

    public <T> T asClass(Class<T> clazz, T t) {
        if (this.value == null) {
            return t;
        }
        try {
            return clazz.cast(this.value);
        }
        catch (ClassCastException classCastException) {
            return t;
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T extends Enum<T>> Object asEnum(Class<T> clazz) {
        if (this.value == null) {
            return null;
        }
        if (!Integer.class.equals(this.pd)) {
            throw new ClassCastException("Variant.asEnum can only be called on non-null Variants that have compositeClass of Integer, was: " + this.toStringWithType());
        }
        Enum[] enumArray2 = (Enum[])clazz.getEnumConstants();
        HashMap<Integer, Enum> hashMap = new HashMap<Integer, Enum>();
        for (Enum i2 : enumArray2) {
            hashMap.put(((Enumeration)((Object)i2)).getValue(), i2);
        }
        Class<?> clazz2 = this.value.getClass();
        if (Integer.class.equals(clazz2)) {
            Integer integerArray = (Integer)this.value;
            return hashMap.get(integerArray);
        }
        if (Integer[].class.equals(clazz2)) {
            void var7_15;
            Integer[] nArray = (Integer[])this.value;
            Enum[] integerArray = (Enum[])Array.newInstance(clazz, nArray.length);
            boolean bl = false;
            while (var7_15 < nArray.length) {
                integerArray[var7_15] = (Enum)hashMap.get(nArray[var7_15]);
                ++var7_15;
            }
            return integerArray;
        }
        int[] nArray = Variant.calculateArrayDimensions(this.value, false);
        Integer[] integerArray = (Integer[])MultiDimensionArrayUtils.muxArray(this.value, nArray);
        Enum[] enumArray = (Enum[])Array.newInstance(clazz, integerArray.length);
        for (int i2 = 0; i2 < enumArray.length; ++i2) {
            enumArray[i2] = (Enum)hashMap.get(integerArray[i2]);
        }
        return MultiDimensionArrayUtils.demuxArray(enumArray, nArray);
    }

    public boolean booleanValue() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        if (this.isNumber()) {
            return this.longValue() != 0L;
        }
        if (this.isEmpty()) {
            throw new ClassCastException("Variant null cannot be cast to boolean");
        }
        if (this.getCompositeClass().equals(String.class)) {
            String string = ((String)this.getValue()).toLowerCase();
            if (string.equals("true") || string.equals("1")) {
                return true;
            }
            if (string.equals("false") || string.equals("0")) {
                return false;
            }
            throw new ClassCastException("Variant String cannot be cast to boolean: " + string);
        }
        return this.asClass(Boolean.class, false);
    }

    public byte byteValue() {
        return this.toNumber().byteValue();
    }

    public int compareTo(Variant variant) {
        if (variant == null) {
            throw new NullPointerException("cannot compare to null");
        }
        if (this.isEmpty() && variant.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (variant.isEmpty()) {
            return 1;
        }
        if (this.isNumber() && variant.isNumber()) {
            float f2 = this.floatValue() - variant.floatValue();
            return (int)Math.signum(f2);
        }
        if (this.isComparable()) {
            Object object = this.getCompositeClass().equals(variant.getCompositeClass()) ? variant.getValue() : variant.asClass(this.getCompositeClass(), null);
            if (object == null) {
                throw new ClassCastException(String.format("Cannot compare the variants of types %s vs. %s", this.getCompositeClass(), variant.getCompositeClass()));
            }
            return ((Comparable)this.getValue()).compareTo(object);
        }
        if (variant.isComparable()) {
            Object object = this.getCompositeClass().equals(variant.getCompositeClass()) ? this.getValue() : this.asClass(variant.getCompositeClass(), null);
            if (object == null) {
                throw new ClassCastException(String.format("Cannot compare the variants of types %s vs. %s", this.getCompositeClass(), variant.getCompositeClass()));
            }
            return ((Comparable)variant.getValue()).compareTo(object);
        }
        throw new ClassCastException(String.format("Cannot compare the variants of types %s vs. %s", this.getCompositeClass(), variant.getCompositeClass()));
    }

    public double doubleValue() {
        return this.toNumber().doubleValue();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Variant)) {
            return false;
        }
        Variant variant = (Variant)object;
        if (this.value == null && variant.value == null) {
            return true;
        }
        if (this.value == null && variant.value != null) {
            return false;
        }
        if (this.value != null && variant.value == null) {
            return false;
        }
        Class<?> clazz = this.value.getClass();
        if (!clazz.equals(variant.value.getClass())) {
            return false;
        }
        if (!this.isArray()) {
            return this.value.equals(variant.value);
        }
        return Arrays.deepEquals((Object[])this.value, (Object[])variant.value);
    }

    public float floatValue() {
        return this.toNumber().floatValue();
    }

    public int[] getArrayDimensions() {
        return Variant.calculateArrayDimensions(this.value, false);
    }

    public Class<?> getCompositeClass() {
        return this.pd;
    }

    public int getDimension() {
        return MultiDimensionArrayUtils.getDimension(this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        if (!this.isArray()) {
            return this.value.hashCode();
        }
        return Arrays.deepHashCode((Object[])this.value);
    }

    public int intValue() {
        return this.toNumber().intValue();
    }

    public boolean isArray() {
        if (this.value == null) {
            return false;
        }
        return this.value.getClass().isArray();
    }

    public boolean isComparable() {
        return this.value instanceof Comparable;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isNumber() {
        return this.value instanceof Number || this.value instanceof Boolean;
    }

    public long longValue() {
        return this.toNumber().longValue();
    }

    public short shortValue() {
        return this.toNumber().shortValue();
    }

    public Number toNumber() {
        if (this.value instanceof Boolean) {
            return this.booleanValue() ? 1 : 0;
        }
        if (this.isNumber()) {
            return (Number)this.value;
        }
        throw new ClassCastException("Variant is not a Number; CompositeClass=" + this.pd);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        String string;
        if (this.value == null) {
            return "(null)";
        }
        String string2 = "";
        if (this.isArray()) {
            if (bl) {
                int[] nArray = this.getArrayDimensions();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(nArray[0]);
                for (int i2 = 1; i2 < this.getDimension(); ++i2) {
                    stringBuilder.append(",").append(nArray[i2]);
                }
                string2 = String.format("(%s[%s]) ", this.compositeClassToString(), stringBuilder.toString());
            }
            string = MultiDimensionArrayUtils.toString(this.value);
        } else {
            if (bl) {
                string2 = String.format("(%s) ", this.compositeClassToString());
            }
            string = MultiDimensionArrayUtils.toString(this.value);
        }
        return string2 + string;
    }

    public String toStringWithType() {
        return this.toString(true);
    }

    public boolean valueEquals(Variant variant) {
        if (variant == null) {
            return false;
        }
        if (this.isEmpty() || variant.isEmpty()) {
            return false;
        }
        if (this.getCompositeClass().equals(variant.getCompositeClass())) {
            return this.equals(variant);
        }
        if (this.isNumber() && variant.isNumber()) {
            return this.floatValue() == variant.floatValue();
        }
        Object var2_2 = variant.asClass(this.getCompositeClass(), null);
        if (var2_2 != null) {
            return this.equals(new Variant(var2_2));
        }
        return variant.equals(this.asClass(variant.getCompositeClass(), null));
    }

    protected String compositeClassToString() {
        String string = this.pd.getSimpleName();
        return string;
    }

    void f(Class<?> clazz) {
        if (clazz.equals(Boolean.class)) {
            return;
        }
        if (clazz.equals(Byte.class)) {
            return;
        }
        if (clazz.equals(UnsignedByte.class)) {
            return;
        }
        if (clazz.equals(Short.class)) {
            return;
        }
        if (clazz.equals(UnsignedShort.class)) {
            return;
        }
        if (clazz.equals(Integer.class)) {
            return;
        }
        if (clazz.equals(UnsignedInteger.class)) {
            return;
        }
        if (clazz.equals(Long.class)) {
            return;
        }
        if (clazz.equals(UnsignedLong.class)) {
            return;
        }
        if (clazz.equals(Float.class)) {
            return;
        }
        if (clazz.equals(Double.class)) {
            return;
        }
        if (clazz.equals(String.class)) {
            return;
        }
        if (clazz.equals(DateTime.class)) {
            return;
        }
        if (clazz.equals(UUID.class)) {
            return;
        }
        if (clazz.equals(XmlElement.class)) {
            return;
        }
        if (clazz.equals(NodeId.class)) {
            return;
        }
        if (clazz.equals(ExpandedNodeId.class)) {
            return;
        }
        if (clazz.equals(StatusCode.class)) {
            return;
        }
        if (clazz.equals(QualifiedName.class)) {
            return;
        }
        if (clazz.equals(LocalizedText.class)) {
            return;
        }
        if (clazz.equals(ExtensionObject.class)) {
            return;
        }
        if (clazz.equals(DataValue.class)) {
            return;
        }
        if (clazz.equals(DiagnosticInfo.class)) {
            return;
        }
        if (clazz.equals(Variant.class)) {
            return;
        }
        if (ByteString.class.equals(clazz)) {
            return;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return;
        }
        throw new IllegalArgumentException("Variant cannot be " + clazz.getCanonicalName());
    }
}

