/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.BitField;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Identifiers;

public final class UnsignedByte
extends Number
implements BitField,
Comparable<UnsignedByte> {
    @Deprecated
    public static final NodeId ID = Identifiers.Byte;
    private static final long serialVersionUID = 4691302796477290208L;
    private static final UnsignedByte[] CACHE = new UnsignedByte[256];
    public static final long L_MAX_VALUE = 255L;
    public static final long L_MIN_VALUE = 0L;
    public static final UnsignedByte MAX_VALUE;
    public static final UnsignedByte MIN_VALUE;
    public static final UnsignedByte ZERO;
    public static final UnsignedByte ONE;
    private static final UnsignedByte[] EMPTY_ARRAY;
    private final int value;

    public static UnsignedByte[] arrayOf() {
        return EMPTY_ARRAY;
    }

    public static UnsignedByte[] arrayOf(long ... lArray) {
        if (lArray == null) {
            return null;
        }
        if (lArray.length == 0) {
            return EMPTY_ARRAY;
        }
        UnsignedByte[] unsignedByteArray = new UnsignedByte[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            unsignedByteArray[i2] = UnsignedByte.valueOf(lArray[i2]);
        }
        return unsignedByteArray;
    }

    public static UnsignedByte[] arrayOf(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return EMPTY_ARRAY;
        }
        UnsignedByte[] unsignedByteArray = new UnsignedByte[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            unsignedByteArray[i2] = UnsignedByte.valueOf(stringArray[i2]);
        }
        return unsignedByteArray;
    }

    public static void assertValueInRange(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Data value underflow!");
        }
        if (n2 > 255) {
            throw new IllegalArgumentException("Data value overflow!");
        }
    }

    public static void assertValueInRange(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Data value underflow!");
        }
        if (l2 > 255L) {
            throw new IllegalArgumentException("Data value overflow!");
        }
    }

    public static UnsignedByte getFromBits(byte by) {
        return CACHE[by & 0xFF];
    }

    public static UnsignedByte max(UnsignedByte unsignedByte, UnsignedByte unsignedByte2) {
        return unsignedByte.intValue() < unsignedByte2.intValue() ? unsignedByte2 : unsignedByte;
    }

    public static UnsignedByte min(UnsignedByte unsignedByte, UnsignedByte unsignedByte2) {
        return unsignedByte.intValue() < unsignedByte2.intValue() ? unsignedByte : unsignedByte2;
    }

    public static UnsignedByte parseUnsignedByte(String string) {
        return UnsignedByte.valueOf(Integer.parseInt(string));
    }

    public static UnsignedByte parseUnsignedByte(String string, int n2) {
        return UnsignedByte.valueOf(Integer.parseInt(string, n2));
    }

    public static UnsignedByte valueOf(int n2) {
        UnsignedByte.assertValueInRange(n2);
        return CACHE[n2];
    }

    public static UnsignedByte valueOf(long l2) {
        UnsignedByte.assertValueInRange(l2);
        return CACHE[(int)l2];
    }

    public static UnsignedByte valueOf(String string) {
        return UnsignedByte.parseUnsignedByte(string);
    }

    public static UnsignedByte valueOf(String string, int n2) {
        return UnsignedByte.parseUnsignedByte(string, n2);
    }

    @Deprecated
    public UnsignedByte() {
        this.value = 0;
    }

    @Deprecated
    public UnsignedByte(byte by) throws IllegalArgumentException {
        UnsignedByte.assertValueInRange(by);
        this.value = by;
    }

    @Deprecated
    public UnsignedByte(int n2) throws IllegalArgumentException {
        UnsignedByte.assertValueInRange(n2);
        this.value = n2;
    }

    @Deprecated
    public UnsignedByte(long l2) throws IllegalArgumentException {
        UnsignedByte.assertValueInRange(l2);
        this.value = (int)l2;
    }

    @Deprecated
    public UnsignedByte(String string) throws IllegalArgumentException {
        short s2 = Short.parseShort(string);
        if (s2 < MIN_VALUE.getValue() || s2 > MAX_VALUE.getValue()) {
            throw new IllegalArgumentException("Value out of bounds!");
        }
        this.value = s2;
        UnsignedByte.assertValueInRange(this.value);
    }

    public UnsignedByte add(int n2) {
        return UnsignedByte.valueOf(this.getValue() + n2);
    }

    public UnsignedByte add(UnsignedByte unsignedByte) {
        return UnsignedByte.valueOf(this.getValue() + unsignedByte.getValue());
    }

    @Override
    public byte byteValue() {
        return (byte)(this.value & 0xFF);
    }

    @Override
    public int compareTo(UnsignedByte unsignedByte) {
        return this.value - unsignedByte.getValue();
    }

    public UnsignedByte dec() {
        return UnsignedByte.valueOf(this.getValue() - 1);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(UnsignedByte.class)) {
            return false;
        }
        UnsignedByte unsignedByte = (UnsignedByte)object;
        return this.value == unsignedByte.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public UnsignedByte inc() {
        return UnsignedByte.valueOf(this.getValue() + 1);
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public boolean isBitSet(int n2) {
        if (n2 < 0 || n2 > 7) {
            return false;
        }
        return (this.value >> n2 & 1) >= 1;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public UnsignedByte subtract(int n2) {
        return UnsignedByte.valueOf(this.getValue() - n2);
    }

    public UnsignedByte subtract(UnsignedByte unsignedByte) {
        return UnsignedByte.valueOf(this.getValue() - unsignedByte.getValue());
    }

    public byte toByteBits() {
        return (byte)(this.value & 0xFF);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    static {
        ZERO = new UnsignedByte(0);
        ONE = new UnsignedByte(1);
        EMPTY_ARRAY = new UnsignedByte[0];
        UnsignedByte.CACHE[0] = ZERO;
        UnsignedByte.CACHE[1] = ONE;
        for (int i2 = 2; i2 < CACHE.length; ++i2) {
            UnsignedByte.CACHE[i2] = new UnsignedByte(i2);
        }
        MIN_VALUE = CACHE[0];
        MAX_VALUE = CACHE[255];
    }
}

