/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.util.Arrays;
import java.util.Locale;

public class ServiceResult {
    private StatusCode code;
    private String symbolicId;
    private String namespaceUri;
    private LocalizedText localizedText;
    private String additionalInfo;
    private ServiceResult innerResult;

    public static String buildExceptionTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        return throwable.getStackTrace().toString();
    }

    public static ServiceResult toServiceResult(Throwable throwable) {
        ServiceResult serviceResult = new ServiceResult();
        serviceResult.setCode(throwable instanceof ServiceResultException ? ((ServiceResultException)throwable).getStatusCode() : new StatusCode(StatusCodes.Bad_UnexpectedError));
        serviceResult.setSymbolicId(serviceResult.toString());
        serviceResult.setLocalizedText(new LocalizedText(throwable.getMessage(), ""));
        serviceResult.setAdditionalInfo(Arrays.toString(throwable.getStackTrace()));
        return serviceResult;
    }

    public ServiceResult() {
        this.initialize();
    }

    public ServiceResult(StatusCode statusCode) {
        this.initialize(statusCode);
    }

    public ServiceResult(StatusCode statusCode, Throwable throwable) {
        this.initialize(statusCode, throwable);
    }

    public ServiceResult(UnsignedInteger unsignedInteger) {
        this.initialize(new StatusCode(unsignedInteger));
    }

    public ServiceResult(UnsignedInteger unsignedInteger, Throwable throwable) {
        this.initialize(new StatusCode(unsignedInteger), throwable);
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public StatusCode getCode() {
        return this.code;
    }

    public ServiceResult getInnerResult() {
        return this.innerResult;
    }

    public LocalizedText getLocalizedText() {
        return this.localizedText;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getSymbolicId() {
        return this.symbolicId;
    }

    public boolean isBad() {
        if (this.code == null) {
            return false;
        }
        return this.code.isBad();
    }

    public boolean isGood() {
        if (this.code == null) {
            return false;
        }
        return this.code.isGood();
    }

    public void setAdditionalInfo(String string) {
        this.additionalInfo = string;
    }

    public void setCode(StatusCode statusCode) {
        this.code = statusCode;
    }

    public void setInnerResult(ServiceResult serviceResult) {
        this.innerResult = serviceResult;
    }

    public void setLocalizedText(LocalizedText localizedText) {
        this.localizedText = localizedText;
    }

    public void setNamespaceUri(String string) {
        this.namespaceUri = string;
    }

    public void setSymbolicId(String string) {
        this.symbolicId = string;
    }

    private void initialize() {
        this.initialize(StatusCode.GOOD, null);
    }

    private void initialize(StatusCode statusCode) {
        this.code = statusCode;
        this.symbolicId = this.lookUpSymbolicId(statusCode);
        this.localizedText = null;
        this.additionalInfo = null;
    }

    private void initialize(StatusCode statusCode, Throwable throwable) {
        this.code = statusCode;
        this.symbolicId = this.lookUpSymbolicId(this.code);
        this.localizedText = new LocalizedText(throwable.getMessage(), Locale.ENGLISH);
        this.additionalInfo = ServiceResult.buildExceptionTrace(throwable);
    }

    private String lookUpSymbolicId(StatusCode statusCode) {
        return statusCode.getName();
    }
}

