/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.core.IdType;
import java.util.UUID;

public class NodeReference {
    public static String OPCUA_NAMESPACE = "http://opcfoundation.org/UA/";
    IdType oR;
    String namespaceUri;
    String serverUri;
    Object value;
    int hashCode;

    public static NodeReference createFromNodeId(ExpandedNodeId expandedNodeId, NamespaceTable namespaceTable, ServerTable serverTable) {
        if (expandedNodeId.getNamespaceUri() != null) {
            return new NodeReference(serverTable.getUri(expandedNodeId.getServerIndex().intValue()), expandedNodeId.getNamespaceUri(), expandedNodeId.getValue());
        }
        return new NodeReference(serverTable.getUri(expandedNodeId.getServerIndex().intValue()), namespaceTable.getUri(expandedNodeId.getNamespaceIndex()), expandedNodeId.getValue());
    }

    public static NodeReference createFromNodeId(NodeId nodeId, NamespaceTable namespaceTable, ServerTable serverTable) {
        return new NodeReference(serverTable.getUri(0), namespaceTable.getUri(nodeId.getNamespaceIndex()), nodeId.getValue());
    }

    public NodeReference(String string, String string2, Object object) {
        if (object == null || string2 == null || string == null) {
            throw new IllegalArgumentException("argument is null");
        }
        this.namespaceUri = string2;
        this.serverUri = string;
        if (object instanceof Integer) {
            object = UnsignedInteger.getFromBits((Integer)object);
        }
        this.value = object;
        if (object instanceof UnsignedInteger) {
            this.oR = IdType.Numeric;
        } else if (object instanceof String) {
            this.oR = IdType.String;
        } else if (object instanceof UUID) {
            this.oR = IdType.Guid;
        } else if (object instanceof ByteString) {
            this.oR = IdType.Opaque;
        } else {
            throw new IllegalArgumentException("value cannot be " + object.getClass().getName());
        }
        this.hashCode += 3 * object.hashCode();
        if (string2 != null) {
            this.hashCode += 13 * string2.hashCode();
        }
        if (string != null) {
            this.hashCode += 17 * string.hashCode();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof NodeReference)) {
            return false;
        }
        NodeReference nodeReference = (NodeReference)object;
        if (!nodeReference.getNamespaceUri().equals(this.namespaceUri)) {
            return false;
        }
        if (!nodeReference.getServerUri().equals(this.serverUri)) {
            return false;
        }
        return nodeReference.getValue().equals(this.value);
    }

    public IdType getIdType() {
        return this.oR;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

