/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.IdType;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.ObjectUtils;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NodeId
implements Comparable<NodeId> {
    @Deprecated
    public static final NodeId ZERO = new NodeId(0, UnsignedInteger.getFromBits(0));
    public static final NodeId NULL_NUMERIC = new NodeId(0, UnsignedInteger.getFromBits(0));
    public static final NodeId NULL_STRING = NodeId.get(IdType.String, 0, "");
    public static final NodeId NULL_GUID = NodeId.get(IdType.Guid, 0, new UUID(0L, 0L));
    public static final NodeId NULL_OPAQUE = NodeId.get(IdType.Opaque, 0, ByteString.EMPTY);
    public static final NodeId NULL = NULL_NUMERIC;
    @Deprecated
    public static final NodeId ID = Identifiers.NodeId;
    static final Pattern oV = Pattern.compile("ns=(\\d*);i=(\\d*)");
    static final Pattern oW = Pattern.compile("i=(\\d*)");
    static final Pattern oX = Pattern.compile("ns=(\\d*);s=(.*)");
    static final Pattern oY = Pattern.compile("s=(.*)");
    static final Pattern oZ = Pattern.compile("ns=(\\d*);g=([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})");
    static final Pattern pa = Pattern.compile("g=([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})");
    static final Pattern pb = Pattern.compile("ns=(\\d*);b=([0-9a-zA-Z\\+/=]*)");
    static final Pattern pc = Pattern.compile("b=([0-9a-zA-Z\\+/=]*)");
    final IdType oR;
    final int namespaceIndex;
    final Object value;

    @Deprecated
    public static NodeId decode(String string) throws IllegalArgumentException {
        return NodeId.parseNodeId(string);
    }

    @Deprecated
    public static boolean equals(NodeId nodeId, NodeId nodeId2) {
        return ObjectUtils.equals(nodeId, nodeId2);
    }

    public static NodeId get(IdType idType, int n2, Object object) {
        if (idType == IdType.Guid) {
            return new NodeId(n2, (UUID)object);
        }
        if (idType == IdType.Numeric) {
            return new NodeId(n2, (UnsignedInteger)object);
        }
        if (idType == IdType.Opaque) {
            if (object instanceof byte[]) {
                return new NodeId(n2, ByteString.valueOf((byte[])object));
            }
            return new NodeId(n2, (ByteString)object);
        }
        if (idType == IdType.String) {
            return new NodeId(n2, (String)object);
        }
        throw new IllegalArgumentException("bad type");
    }

    public static boolean isNull(NodeId nodeId) {
        return nodeId == null || nodeId.isNullNodeId();
    }

    public static NodeId parseNodeId(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null arg");
        }
        Matcher matcher = oY.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            return new NodeId(0, string2);
        }
        matcher = oW.matcher(string);
        if (matcher.matches()) {
            UnsignedInteger unsignedInteger = UnsignedInteger.valueOf(matcher.group(1));
            return new NodeId(0, unsignedInteger);
        }
        matcher = pa.matcher(string);
        if (matcher.matches()) {
            UUID uUID = UUID.fromString(matcher.group(1));
            return new NodeId(0, uUID);
        }
        matcher = pc.matcher(string);
        if (matcher.matches()) {
            byte[] byArray = CryptoUtil.base64Decode(matcher.group(1));
            return new NodeId(0, ByteString.valueOf(byArray));
        }
        matcher = oV.matcher(string);
        if (matcher.matches()) {
            Integer n2 = Integer.valueOf(matcher.group(1));
            UnsignedInteger unsignedInteger = UnsignedInteger.valueOf(matcher.group(2));
            return new NodeId((int)n2, unsignedInteger);
        }
        matcher = oX.matcher(string);
        if (matcher.matches()) {
            Integer n3 = Integer.valueOf(matcher.group(1));
            String string3 = matcher.group(2);
            return new NodeId((int)n3, string3);
        }
        matcher = oZ.matcher(string);
        if (matcher.matches()) {
            Integer n4 = Integer.valueOf(matcher.group(1));
            UUID uUID = UUID.fromString(matcher.group(2));
            return new NodeId((int)n4, uUID);
        }
        matcher = pb.matcher(string);
        if (matcher.matches()) {
            Integer n5 = Integer.valueOf(matcher.group(1));
            byte[] byArray = CryptoUtil.base64Decode(matcher.group(2));
            return new NodeId((int)n5, ByteString.valueOf(byArray));
        }
        throw new IllegalArgumentException("Invalid string representation of a nodeId: " + string);
    }

    public static NodeId randomGUID(int n2) {
        return new NodeId(n2, UUID.randomUUID());
    }

    public NodeId(int n2, byte[] byArray) {
        this(n2, ByteString.valueOf(byArray));
    }

    public NodeId(int n2, ByteString byteString) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("namespaceIndex out of bounds");
        }
        if (byteString != null && byteString.getLength() > 4096) {
            throw new IllegalArgumentException("The length is restricted to 4096 bytes");
        }
        this.oR = IdType.Opaque;
        this.value = byteString;
        this.namespaceIndex = n2;
    }

    public NodeId(int n2, int n3) {
        this(n2, UnsignedInteger.getFromBits(n3));
    }

    public NodeId(int n2, String string) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("namespaceIndex out of bounds");
        }
        if (string != null && string.length() > 4096) {
            throw new IllegalArgumentException("The length is restricted to 4096 characters");
        }
        this.oR = IdType.String;
        this.value = string;
        this.namespaceIndex = n2;
    }

    public NodeId(int n2, UnsignedInteger unsignedInteger) {
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("Numeric NodeId cannot be null");
        }
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("namespaceIndex out of bounds");
        }
        this.value = unsignedInteger;
        this.namespaceIndex = n2;
        this.oR = IdType.Numeric;
    }

    public NodeId(int n2, UUID uUID) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("namespaceIndex out of bounds");
        }
        if (uUID == null) {
            throw new IllegalArgumentException("Numeric NodeId cannot be null");
        }
        this.oR = IdType.Guid;
        this.value = uUID;
        this.namespaceIndex = n2;
    }

    @Override
    public int compareTo(NodeId nodeId) {
        int n2 = this.namespaceIndex - nodeId.namespaceIndex;
        if (n2 == 0) {
            n2 = this.oR.getValue() - nodeId.oR.getValue();
        }
        if (n2 == 0) {
            switch (this.oR) {
                case Numeric: {
                    return ((UnsignedInteger)this.value).compareTo((UnsignedInteger)nodeId.value);
                }
                case String: {
                    return ((String)this.value).compareTo((String)nodeId.value);
                }
                case Guid: {
                    return ((UUID)this.value).compareTo((UUID)nodeId.value);
                }
                case Opaque: {
                    return ((ByteString)this.value).compareTo((ByteString)nodeId.value);
                }
            }
            throw new Error("Unkonwn IdType:" + this.oR);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return NodeId.isNull(this);
        }
        if (object instanceof NodeId) {
            NodeId nodeId = (NodeId)object;
            if (NodeId.isNull(this) || NodeId.isNull(nodeId)) {
                return NodeId.isNull(this) == NodeId.isNull(nodeId);
            }
            if (nodeId.namespaceIndex != this.namespaceIndex || nodeId.oR != this.oR) {
                return false;
            }
            if (this.value == nodeId.value) {
                return true;
            }
            return nodeId.value.equals(this.value);
        }
        if (object instanceof ExpandedNodeId) {
            ExpandedNodeId expandedNodeId = (ExpandedNodeId)object;
            if (expandedNodeId.namespaceUri != null && expandedNodeId.namespaceUri != NamespaceTable.OPCUA_NAMESPACE || !expandedNodeId.isLocal()) {
                return false;
            }
            if (this.namespaceIndex != expandedNodeId.namespaceIndex || this.oR != expandedNodeId.oR) {
                return false;
            }
            if (this.value == expandedNodeId.value) {
                return true;
            }
            return this.value.equals(expandedNodeId.value);
        }
        return false;
    }

    public IdType getIdType() {
        return this.oR;
    }

    public int getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        int n2 = 13 * this.namespaceIndex;
        if (this.value != null) {
            n2 += 3 * this.value.hashCode();
        }
        return n2;
    }

    public boolean isNullNodeId() {
        if (this.value == null) {
            return true;
        }
        if (this.namespaceIndex != 0) {
            return false;
        }
        switch (this.oR) {
            case Numeric: {
                return ((UnsignedInteger)this.value).intValue() == 0;
            }
            case String: {
                return ((String)this.value).length() == 0;
            }
            case Guid: {
                return this.value.equals(NodeId.NULL_GUID.value);
            }
            case Opaque: {
                return this.value.equals(NodeId.NULL_OPAQUE.value);
            }
        }
        return false;
    }

    public String toString() {
        String string;
        String string2 = string = this.namespaceIndex > 0 ? "ns=" + this.namespaceIndex + ";" : "";
        if (this.oR == IdType.Numeric) {
            return string + "i=" + this.value;
        }
        if (this.oR == IdType.String) {
            return string + "s=" + this.value;
        }
        if (this.oR == IdType.Guid) {
            return string + "g=" + this.value;
        }
        if (this.oR == IdType.Opaque) {
            if (this.value == null) {
                return string + "b=null";
            }
            return string + "b=" + new String(CryptoUtil.base64Encode(((ByteString)this.value).getValue()));
        }
        return "error";
    }
}

