/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.encoding.binary.IEncodeableSerializer;
import com.prosysopc.ua.stack.encoding.json.JsonEncoder;
import com.prosysopc.ua.stack.encoding.xml.XmlDecoder;
import com.prosysopc.ua.stack.utils.LimitedByteArrayOutputStream;
import com.prosysopc.ua.stack.utils.ObjectUtils;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionObject {
    private static Logger logger = LoggerFactory.getLogger(ExtensionObject.class);
    final Object object;
    final ExpandedNodeId oT;
    final EncodeType oU;

    public static ExtensionObject binaryEncode(Structure structure, EncoderContext encoderContext) throws EncodingException {
        return ExtensionObject.binaryEncode(structure, null, encoderContext);
    }

    @Deprecated
    public static ExtensionObject binaryEncode(Structure structure, IEncodeableSerializer iEncodeableSerializer, EncoderContext encoderContext) throws EncodingException {
        EncoderContext encoderContext2;
        if (iEncodeableSerializer == null) {
            encoderContext2 = encoderContext;
        } else {
            encoderContext2 = encoderContext.shallowCopy();
            encoderContext2.setEncodeableSerializer(iEncodeableSerializer);
        }
        int n2 = encoderContext2.getMaxByteStringLength();
        if (n2 == 0) {
            n2 = encoderContext2.getMaxMessageSize();
        }
        if (n2 == 0) {
            n2 = Integer.MAX_VALUE;
        }
        LimitedByteArrayOutputStream limitedByteArrayOutputStream = LimitedByteArrayOutputStream.withSizeLimit(n2);
        BinaryEncoder binaryEncoder = new BinaryEncoder(limitedByteArrayOutputStream);
        binaryEncoder.setEncoderContext(encoderContext2);
        structure.specification().putEncodeable(structure, binaryEncoder);
        return new ExtensionObject(structure.specification().getBinaryEncodeId().asExpandedNodeId(), ByteString.valueOf(limitedByteArrayOutputStream.toByteArray()));
    }

    public static ExtensionObject encode(Structure structure, QualifiedName qualifiedName, EncoderContext encoderContext) throws EncodingException {
        return ExtensionObject.encode(structure, qualifiedName, StackUtils.getDefaultSerializer(), encoderContext);
    }

    @Deprecated
    public static ExtensionObject encode(Structure structure, QualifiedName qualifiedName, IEncodeableSerializer iEncodeableSerializer, EncoderContext encoderContext) throws EncodingException {
        if (structure == null) {
            return null;
        }
        if (qualifiedName.equals(QualifiedName.DEFAULT_BINARY_ENCODING)) {
            return ExtensionObject.binaryEncode(structure, iEncodeableSerializer, encoderContext);
        }
        if (qualifiedName.equals(QualifiedName.DEFAULT_XML_ENCODING)) {
            return ExtensionObject.xmlEncode(structure, iEncodeableSerializer);
        }
        throw new EncodingException(StatusCodes.Bad_DataEncodingUnsupported);
    }

    @Deprecated
    public static ExtensionObject jsonEncode(Structure structure, IEncodeableSerializer iEncodeableSerializer, EncoderContext encoderContext) throws EncodingException {
        EncoderContext encoderContext2;
        if (iEncodeableSerializer == null) {
            encoderContext2 = encoderContext;
        } else {
            encoderContext2 = encoderContext.shallowCopy();
            encoderContext2.setEncodeableSerializer(iEncodeableSerializer);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        try {
            JsonEncoder jsonEncoder = new JsonEncoder(outputStreamWriter);
            jsonEncoder.setEncoderContext(encoderContext2);
            structure.specification().putEncodeable(structure, jsonEncoder);
            return new ExtensionObject(structure.specification().getJsonEncodeId().asExpandedNodeId(), byteArrayOutputStream.toString());
        }
        catch (IOException iOException) {
            throw new EncodingException(iOException);
        }
    }

    public static ExtensionObject xmlEncode(Structure structure) throws EncodingException {
        throw new EncodingException(StatusCodes.Bad_DataEncodingUnsupported);
    }

    public static ExtensionObject xmlEncode(Structure structure, IEncodeableSerializer iEncodeableSerializer) throws EncodingException {
        throw new EncodingException(StatusCodes.Bad_DataEncodingUnsupported);
    }

    public ExtensionObject(ExpandedNodeId expandedNodeId) {
        if (expandedNodeId == null) {
            throw new IllegalArgumentException("typeId argument must not be null");
        }
        this.oT = expandedNodeId;
        this.object = null;
        this.oU = null;
    }

    @Deprecated
    public ExtensionObject(ExpandedNodeId expandedNodeId, byte[] byArray) {
        this(expandedNodeId, ByteString.valueOf(byArray));
    }

    public ExtensionObject(ExpandedNodeId expandedNodeId, ByteString byteString) {
        if (expandedNodeId == null) {
            throw new IllegalArgumentException("typeId argument must not be null");
        }
        this.oT = expandedNodeId;
        if (byteString != null) {
            this.object = byteString;
            this.oU = EncodeType.Binary;
        } else {
            this.object = null;
            this.oU = null;
        }
    }

    public ExtensionObject(ExpandedNodeId expandedNodeId, String string) {
        if (expandedNodeId == null) {
            throw new IllegalArgumentException("typeId argument must not be null");
        }
        this.oT = expandedNodeId;
        if (string != null) {
            this.object = string;
            this.oU = EncodeType.Json;
        } else {
            this.object = null;
            this.oU = null;
        }
    }

    public ExtensionObject(ExpandedNodeId expandedNodeId, XmlElement xmlElement) {
        if (expandedNodeId == null) {
            throw new IllegalArgumentException("typeId argument must not be null");
        }
        this.object = xmlElement == null ? new XmlElement("") : xmlElement;
        this.oT = expandedNodeId;
        this.oU = EncodeType.Xml;
    }

    public ExtensionObject(Structure structure) {
        this.oU = null;
        this.oT = null;
        this.object = structure;
    }

    public <T extends IEncodeable> T decode(EncoderContext encoderContext) throws DecodingException {
        return this.decode(encoderContext, encoderContext.getNamespaceTable());
    }

    public <T extends IEncodeable> T decode(EncoderContext encoderContext, Class<T> clazz, UnsignedInteger unsignedInteger) throws StatusException {
        try {
            return (T)((IEncodeable)clazz.cast(this.decode(encoderContext)));
        }
        catch (Exception exception) {
            throw new StatusException(unsignedInteger, (Throwable)exception);
        }
    }

    public <T extends IEncodeable> T decode(EncoderContext encoderContext, NamespaceTable namespaceTable) throws DecodingException {
        return this.decode(encoderContext.getEncodeableSerializer(), encoderContext, namespaceTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T extends IEncodeable> T decode(IEncodeableSerializer iEncodeableSerializer, EncoderContext encoderContext, NamespaceTable namespaceTable) throws DecodingException {
        if (iEncodeableSerializer != encoderContext.getEncodeableSerializer()) {
            encoderContext = encoderContext.shallowCopy();
        }
        if (this.object == null) {
            Class<? extends IEncodeable> clazz = iEncodeableSerializer.getClass(this.oT);
            try {
                return (T)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new DecodingException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new DecodingException(illegalAccessException);
            }
        }
        if (this.object instanceof Structure) {
            IEncodeable iEncodeable = (IEncodeable)this.object;
            return (T)iEncodeable;
        }
        if (this.object instanceof XmlElement) {
            void var7_18;
            encoderContext.setEncodeableSerializer(iEncodeableSerializer);
            XmlDecoder xmlDecoder = new XmlDecoder((XmlElement)this.object, encoderContext);
            xmlDecoder.setNamespaceTable(namespaceTable);
            UaNodeId uaNodeId = UaNodeId.fromLocal(this.oT);
            StructureSpecification structureSpecification = encoderContext.getStructureSpecification(uaNodeId);
            if (structureSpecification != null) {
                try {
                    boolean bl = xmlDecoder.peek(structureSpecification.getName());
                    if (bl) {
                        xmlDecoder.getStartElement();
                    }
                    Structure structure = structureSpecification.getEncodeable(xmlDecoder);
                    if (!bl) return var7_18;
                    xmlDecoder.getEndElement();
                    return var7_18;
                }
                finally {
                    xmlDecoder.close();
                }
            }
            Class<? extends IEncodeable> clazz = iEncodeableSerializer.getClass(this.oT);
            logger.debug("decode: typeId={} class={}", (Object)this.oT, clazz);
            if (clazz == null) {
                throw new DecodingException("No serializer defined for class " + this.oT);
            }
            try {
                boolean bl = xmlDecoder.peek(clazz.getSimpleName());
                if (bl) {
                    xmlDecoder.getStartElement();
                }
                IEncodeable iEncodeable = iEncodeableSerializer.getEncodeable(clazz, xmlDecoder);
                if (!bl) return var7_18;
                xmlDecoder.getEndElement();
                return var7_18;
            }
            finally {
                xmlDecoder.close();
            }
        }
        if (!(this.object instanceof ByteString)) throw new Error("unexpected");
        encoderContext.setEncodeableSerializer(iEncodeableSerializer);
        BinaryDecoder binaryDecoder = new BinaryDecoder(((ByteString)this.object).getValue());
        binaryDecoder.setEncoderContext(encoderContext);
        UaNodeId uaNodeId = UaNodeId.fromLocal(this.oT);
        StructureSpecification structureSpecification = encoderContext.getStructureSpecification(uaNodeId);
        if (structureSpecification != null) {
            return (T)structureSpecification.getEncodeable(binaryDecoder);
        }
        Class<? extends IEncodeable> clazz = iEncodeableSerializer.getClass(this.oT);
        return (T)iEncodeableSerializer.getEncodeable(clazz, binaryDecoder);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ExtensionObject)) {
            return false;
        }
        ExtensionObject extensionObject = (ExtensionObject)object;
        if (!ObjectUtils.equals(this.oT, extensionObject.oT)) {
            return false;
        }
        return ObjectUtils.equals(this.object, extensionObject.object);
    }

    public EncodeType getEncodeType() {
        return this.oU;
    }

    public Object getObject() {
        return this.object;
    }

    public ExpandedNodeId getTypeId() {
        return this.oT;
    }

    public int hashCode() {
        if (this.object == null) {
            return 0;
        }
        return this.object.hashCode();
    }

    public boolean isEncoded() {
        if (this.object == null) {
            return true;
        }
        return !(this.object instanceof Structure);
    }

    public String toString() {
        return "ExtensionObject [typeId=" + this.oT + ", encodeType=" + (Object)((Object)this.oU) + ", object=" + this.object + "]";
    }
}

