/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.IdType;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.UUID;

public final class ExpandedNodeId
implements Comparable<ExpandedNodeId> {
    public static final ExpandedNodeId NULL_NUMERIC = new ExpandedNodeId(NodeId.NULL_NUMERIC);
    public static final ExpandedNodeId NULL_STRING = new ExpandedNodeId(NodeId.NULL_STRING);
    public static final ExpandedNodeId NULL_GUID = new ExpandedNodeId(NodeId.NULL_GUID);
    public static final ExpandedNodeId NULL_OPAQUE = new ExpandedNodeId(NodeId.NULL_OPAQUE);
    public static final ExpandedNodeId NULL = NULL_NUMERIC;
    @Deprecated
    public static final NodeId ID = Identifiers.ExpandedNodeId;
    final IdType oR;
    final int namespaceIndex;
    final UnsignedInteger aG;
    final String namespaceUri;
    final Object value;

    public static boolean isNull(ExpandedNodeId expandedNodeId) {
        return expandedNodeId == null || expandedNodeId.isNullNodeId();
    }

    public static ExpandedNodeId parseExpandedNodeId(String string) {
        String[] stringArray = string.split(";");
        ExpandedNodeId.assertExpandedNodeIdParts(string, stringArray, 1);
        int n2 = 0;
        int n3 = 0;
        NodeId nodeId = NodeId.parseNodeId(stringArray[stringArray.length - 1]);
        ExpandedNodeId expandedNodeId = null;
        for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
            String[] stringArray2 = stringArray[i2].split("=");
            ExpandedNodeId.assertExpandedNodeIdParts(string, stringArray2, 2);
            if (stringArray2[0].equalsIgnoreCase("svr")) {
                n2 = Integer.parseInt(stringArray2[1]);
                continue;
            }
            if (stringArray2[0].equalsIgnoreCase("ns")) {
                n3 = Integer.parseInt(stringArray2[1]);
                expandedNodeId = new ExpandedNodeId(UnsignedInteger.valueOf(n2), n3, nodeId.getValue());
                continue;
            }
            if (stringArray2[0].equalsIgnoreCase("nsu")) {
                String string2 = stringArray2[1];
                expandedNodeId = new ExpandedNodeId(UnsignedInteger.valueOf(n2), string2, nodeId.getValue());
                continue;
            }
            ExpandedNodeId.throwExpandedNodeIdCastException(string);
        }
        if (expandedNodeId == null) {
            expandedNodeId = new ExpandedNodeId(UnsignedInteger.valueOf(n2), n3, nodeId.getValue());
        }
        return expandedNodeId;
    }

    private static void assertExpandedNodeIdParts(String string, String[] stringArray, int n2) throws ClassCastException {
        if (stringArray.length < n2) {
            ExpandedNodeId.throwExpandedNodeIdCastException(string);
        }
    }

    private static void throwExpandedNodeIdCastException(String string) throws ClassCastException {
        throw new ClassCastException("String is not a valid ExpandedNodeId: " + string);
    }

    public ExpandedNodeId(NodeId nodeId) {
        this(null, nodeId.getNamespaceIndex(), nodeId.getValue());
    }

    public ExpandedNodeId(String string, Object object) {
        this(UnsignedInteger.ZERO, string, object);
    }

    public ExpandedNodeId(UnsignedInteger unsignedInteger, int n2, Object object) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("namespaceIndex out of bounds");
        }
        UnsignedInteger unsignedInteger2 = this.aG = unsignedInteger == null ? UnsignedInteger.ZERO : unsignedInteger;
        if (object instanceof Integer) {
            object = UnsignedInteger.getFromBits((Integer)object);
        }
        if (object instanceof byte[]) {
            object = ByteString.valueOf((byte[])object);
        }
        this.value = object;
        this.namespaceIndex = n2;
        this.namespaceUri = null;
        if (object == null) {
            this.oR = IdType.String;
        } else if (object instanceof UnsignedInteger) {
            this.oR = IdType.Numeric;
        } else if (object instanceof String) {
            this.oR = IdType.String;
        } else if (object instanceof UUID) {
            this.oR = IdType.Guid;
        } else if (object instanceof ByteString) {
            this.oR = IdType.Opaque;
        } else {
            throw new IllegalArgumentException("value cannot be " + object.getClass().getName());
        }
    }

    public ExpandedNodeId(UnsignedInteger unsignedInteger, NodeId nodeId) {
        this(unsignedInteger, nodeId.getNamespaceIndex(), nodeId.getValue());
    }

    public ExpandedNodeId(UnsignedInteger unsignedInteger, String string, Object object) {
        if (string == null) {
            throw new NullPointerException("namespaceUri; value=" + object);
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("namespaceUri not defined");
        }
        UnsignedInteger unsignedInteger2 = this.aG = unsignedInteger == null ? UnsignedInteger.ZERO : unsignedInteger;
        if (object instanceof Integer) {
            object = UnsignedInteger.valueOf(((Integer)object).intValue());
        }
        if (object instanceof byte[]) {
            object = ByteString.valueOf((byte[])object);
        }
        this.value = object;
        this.namespaceUri = string;
        this.namespaceIndex = 0;
        if (object == null) {
            this.oR = IdType.String;
        } else if (object instanceof UnsignedInteger) {
            this.oR = IdType.Numeric;
        } else if (object instanceof String) {
            this.oR = IdType.String;
        } else if (object instanceof UUID) {
            this.oR = IdType.Guid;
        } else if (object instanceof ByteString) {
            this.oR = IdType.Opaque;
        } else {
            throw new IllegalArgumentException("value cannot be " + object.getClass().getName());
        }
    }

    @Override
    public int compareTo(ExpandedNodeId expandedNodeId) {
        int n2 = this.namespaceUri != null && expandedNodeId.namespaceUri != null ? this.namespaceUri.compareTo(expandedNodeId.namespaceUri) : this.namespaceIndex - expandedNodeId.namespaceIndex;
        if (n2 == 0) {
            n2 = this.oR.getValue() - expandedNodeId.oR.getValue();
        }
        if (n2 == 0) {
            switch (this.oR) {
                case Numeric: {
                    n2 = ((UnsignedInteger)this.value).compareTo((UnsignedInteger)expandedNodeId.value);
                    break;
                }
                case String: {
                    n2 = ((String)this.value).compareTo((String)expandedNodeId.value);
                    break;
                }
                case Guid: {
                    n2 = ((UUID)this.value).compareTo((UUID)expandedNodeId.value);
                    break;
                }
                case Opaque: {
                    n2 = ((ByteString)this.value).compareTo((ByteString)expandedNodeId.value);
                }
            }
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return this.equals(NULL);
        }
        if (object instanceof NodeId) {
            if (this.namespaceUri != null && this.namespaceUri != NamespaceTable.OPCUA_NAMESPACE || !this.isLocal()) {
                return false;
            }
            NodeId nodeId = (NodeId)object;
            if (nodeId.namespaceIndex != this.namespaceIndex || nodeId.oR != this.oR) {
                return false;
            }
            if (this.value == nodeId.value) {
                return true;
            }
            return nodeId.value.equals(this.value);
        }
        if (object instanceof ExpandedNodeId) {
            ExpandedNodeId expandedNodeId = (ExpandedNodeId)object;
            if (this.namespaceUri != null) {
                if (expandedNodeId.namespaceUri == null || !expandedNodeId.namespaceUri.equals(this.namespaceUri)) {
                    return false;
                }
            } else {
                if (expandedNodeId.namespaceUri != null) {
                    return false;
                }
                if (expandedNodeId.namespaceIndex != this.namespaceIndex) {
                    return false;
                }
            }
            if (!this.isLocal() ? expandedNodeId.isLocal() || !expandedNodeId.aG.equals(this.aG) : !expandedNodeId.isLocal()) {
                return false;
            }
            if (expandedNodeId.oR != this.oR) {
                return false;
            }
            if (this.value == expandedNodeId.value) {
                return true;
            }
            if (expandedNodeId.value != null) {
                return expandedNodeId.value.equals(this.value);
            }
            return this.value == null;
        }
        return false;
    }

    public IdType getIdType() {
        return this.oR;
    }

    public int getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public UnsignedInteger getServerIndex() {
        return this.aG;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.value != null) {
            n2 += 3 * this.value.hashCode();
        }
        if (this.aG != null) {
            n2 += this.aG.hashCode() * 17;
        }
        return n2;
    }

    public boolean isAbsolute() {
        return this.namespaceUri != null && !this.namespaceUri.isEmpty() || !this.isLocal();
    }

    public boolean isLocal() {
        return this.aG == null || this.aG.getValue() == 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isNullNodeId() {
        int n2;
        if (this.namespaceUri != null && !this.namespaceUri.isEmpty()) {
            if (!NamespaceTable.OPCUA_NAMESPACE.equals(this.namespaceUri)) return false;
            n2 = 0;
            return NodeId.get(this.oR, n2, this.value).isNullNodeId();
        } else {
            n2 = this.namespaceIndex;
        }
        return NodeId.get(this.oR, n2, this.value).isNullNodeId();
    }

    public String toString() {
        try {
            String string;
            String string2;
            String string3 = string2 = !this.isLocal() ? "svr=" + this.aG + ";" : "";
            String string4 = this.namespaceUri != null ? "nsu=" + URLEncoder.encode(this.namespaceUri, "ISO8859-1") + ";" : (string = this.namespaceIndex > 0 ? "ns=" + this.namespaceIndex + ";" : "");
            if (this.oR == IdType.Numeric) {
                return string2 + string + "i=" + this.value;
            }
            if (this.oR == IdType.String) {
                return string2 + string + "s=" + this.value;
            }
            if (this.oR == IdType.Guid) {
                return string2 + string + "g=" + this.value;
            }
            if (this.oR == IdType.Opaque) {
                if (this.value == null) {
                    return string2 + string + "b=null";
                }
                return string2 + string + "b=" + new String(CryptoUtil.base64Encode(((ByteString)this.value).getValue()));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "error";
    }
}

