/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.util.Arrays;

public final class ByteString
implements Comparable<ByteString> {
    public static final ByteString EMPTY = new ByteString(new byte[0]);
    private final byte[] value;

    public static byte[] asByteArray(ByteString byteString) {
        return byteString == null ? null : byteString.getValue();
    }

    public static ByteString valueOf(byte ... byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return EMPTY;
        }
        return new ByteString(byArray);
    }

    private ByteString(byte[] byArray) {
        this.value = Arrays.copyOf(byArray, byArray.length);
    }

    @Override
    public int compareTo(ByteString byteString) {
        if (this.equals(byteString)) {
            return 0;
        }
        return this.toString().compareTo(byteString.toString());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ByteString byteString = (ByteString)object;
        return Arrays.equals(this.value, byteString.value);
    }

    public int getLength() {
        return this.value.length;
    }

    public byte[] getValue() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Arrays.hashCode(this.value);
        return n3;
    }

    public String toString() {
        return CryptoUtil.toHex(this.value, 0);
    }
}

