/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.UaTypeNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.DataTypeAttributes;
import com.prosysopc.ua.stack.core.DataTypeDefinition;
import com.prosysopc.ua.stack.core.EnumDefinition;
import com.prosysopc.ua.stack.core.EnumField;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.StructureDefinition;
import com.prosysopc.ua.stack.core.StructureField;
import com.prosysopc.ua.stack.core.StructureType;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

public class UaDataTypeNode
extends UaTypeNode
implements UaDataType {
    public UaDataTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public UaDataTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new DataTypeAttributes());
    }

    @Override
    public DataTypeDefinition getDataTypeDefinition() {
        NamespaceTable namespaceTable = this.getAddressSpace().getNamespaceTable();
        UaNodeId uaNodeId = UaNodeId.fromLocal(this.getNodeId(), namespaceTable);
        StructureSpecification structureSpecification = this.getAddressSpace().getServer().getEncoderContext().getStructureSpecification(uaNodeId);
        if (structureSpecification != null) {
            return this.b(structureSpecification);
        }
        EnumerationSpecification enumerationSpecification = this.getAddressSpace().getServer().getEncoderContext().getEnumerationSpecification(uaNodeId);
        if (enumerationSpecification != null) {
            return this.a(enumerationSpecification);
        }
        return null;
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.DataType;
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        this.setIsAbstract(((DataTypeAttributes)nodeAttributes).getIsAbstract());
        super.setAttributes(nodeAttributes);
    }

    private DataTypeDefinition a(EnumerationSpecification enumerationSpecification) {
        EnumDefinition.Builder builder = EnumDefinition.builder();
        ArrayList<EnumField> arrayList = new ArrayList<EnumField>();
        for (Map.Entry<Integer, String> entry : enumerationSpecification.getIntToStringMappings().entrySet()) {
            EnumField.Builder builder2 = EnumField.builder();
            builder2.setDescription(null);
            builder2.setDisplayName(new LocalizedText(entry.getValue()));
            builder2.setName(entry.getValue());
            builder2.setValue(entry.getKey().longValue());
            arrayList.add(builder2.build());
        }
        builder.setFields(arrayList.toArray(new EnumField[0]));
        return builder.build();
    }

    private DataTypeDefinition b(StructureSpecification structureSpecification) {
        NamespaceTable namespaceTable = this.getAddressSpace().getNamespaceTable();
        StructureDefinition.Builder builder = StructureDefinition.builder();
        builder.setBaseDataType(this.getSuperType().getNodeId());
        if (structureSpecification.getBinaryEncodeId() != null) {
            builder.setDefaultEncodingId(structureSpecification.getBinaryEncodeId().asNodeId(namespaceTable));
        }
        switch (structureSpecification.getStructureType()) {
            case NORMAL: {
                builder.setStructureType(StructureType.Structure);
                break;
            }
            case OPTIONAL: {
                builder.setStructureType(StructureType.StructureWithOptionalFields);
                break;
            }
            case UNION: {
                builder.setStructureType(StructureType.Union);
                break;
            }
            default: {
                throw new IllegalStateException("unknown enum constant: " + (Object)((Object)structureSpecification.getStructureType()));
            }
        }
        ArrayList<StructureField> arrayList = new ArrayList<StructureField>();
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            StructureField.Builder builder2 = StructureField.builder();
            if (fieldSpecification.getArrayDimensions() == null) {
                builder2.setArrayDimensions(null);
            } else {
                UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[fieldSpecification.getArrayDimensions().length];
                for (int i2 = 0; i2 < fieldSpecification.getArrayDimensions().length; ++i2) {
                    unsignedIntegerArray[i2] = UnsignedInteger.valueOf(fieldSpecification.getArrayDimensions()[i2]);
                }
                builder2.setArrayDimensions(unsignedIntegerArray);
            }
            builder2.setDataType(fieldSpecification.getDataTypeId().asNodeId(namespaceTable));
            builder2.setDescription(fieldSpecification.getDescription() == null ? null : new LocalizedText(fieldSpecification.getDescription()));
            builder2.setIsOptional(fieldSpecification.isOptional());
            builder2.setMaxStringLength(UnsignedInteger.valueOf(fieldSpecification.getMaxStringLength()));
            builder2.setName(fieldSpecification.getName());
            builder2.setValueRank(fieldSpecification.getValueRank());
            arrayList.add(builder2.build());
        }
        builder.setFields(arrayList.toArray(new StructureField[0]));
        return builder.build();
    }

    protected DataTypeAttributes getAttributes(DataTypeAttributes dataTypeAttributes) {
        super.getAttributes(dataTypeAttributes);
        dataTypeAttributes.setIsAbstract(this.getIsAbstract());
        return dataTypeAttributes;
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (Attributes.DataTypeDefinition.equals(unsignedInteger)) {
            dataValue.setValue(new Variant(this.getDataTypeDefinition()));
        } else {
            super.readAttributeValue(unsignedInteger, dataValue);
        }
    }
}

