/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.instantiation;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.BrowsePath;
import com.prosysopc.ua.server.instantiation.b;
import com.prosysopc.ua.server.instantiation.h;
import com.prosysopc.ua.server.instantiation.k;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class TemporaryInstanceDeclaration {
    private final Set<BrowsePath> nf;
    private final Set<b> ng;
    private final Set<h> nu;
    private final transient UaNode node;
    private final NodeId nodeId;

    public static Builder builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration) {
        return new Builder(temporaryInstanceDeclaration);
    }

    public static Builder builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration, BrowsePath browsePath) {
        return new Builder(temporaryInstanceDeclaration, browsePath);
    }

    public static Builder builder(UaNode uaNode, BrowsePath browsePath) {
        return new Builder(uaNode, browsePath);
    }

    public static Builder builder(UaType uaType) {
        return TemporaryInstanceDeclaration.builder(uaType, BrowsePath.EMPTY);
    }

    private TemporaryInstanceDeclaration(UaNode uaNode, LinkedHashSet<BrowsePath> linkedHashSet, Set<b> set, Set<h> set2) {
        this.node = uaNode;
        this.nodeId = uaNode.getNodeId();
        this.nf = Collections.unmodifiableSet(linkedHashSet);
        this.ng = Collections.unmodifiableSet(set);
        this.nu = Collections.unmodifiableSet(set2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TemporaryInstanceDeclaration temporaryInstanceDeclaration = (TemporaryInstanceDeclaration)object;
        if (this.nf == null ? temporaryInstanceDeclaration.nf != null : !((Object)this.nf).equals(temporaryInstanceDeclaration.nf)) {
            return false;
        }
        if (this.ng == null ? temporaryInstanceDeclaration.ng != null : !((Object)this.ng).equals(temporaryInstanceDeclaration.ng)) {
            return false;
        }
        if (this.nu == null ? temporaryInstanceDeclaration.nu != null : !((Object)this.nu).equals(temporaryInstanceDeclaration.nu)) {
            return false;
        }
        return !(this.nodeId == null ? temporaryInstanceDeclaration.nodeId != null : !this.nodeId.equals(temporaryInstanceDeclaration.nodeId));
    }

    public Set<BrowsePath> getBrowsePaths() {
        return this.nf;
    }

    public Set<b> getExternalReferences() {
        return this.ng;
    }

    public Set<h> getInternalReferences() {
        return this.nu;
    }

    public UaNode getNode() {
        return this.node;
    }

    public BrowsePath getPrimaryPath() {
        return this.nf.iterator().next();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.nf == null ? 0 : ((Object)this.nf).hashCode());
        n3 = 31 * n3 + (this.ng == null ? 0 : ((Object)this.ng).hashCode());
        n3 = 31 * n3 + (this.nu == null ? 0 : ((Object)this.nu).hashCode());
        n3 = 31 * n3 + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return n3;
    }

    public boolean hasPath(BrowsePath browsePath) {
        return this.nf.contains(browsePath);
    }

    public boolean isRoot() {
        return this.nf.size() == 1 && this.getPrimaryPath().isEmpty();
    }

    public String toString() {
        return "Paths=" + this.nf;
    }

    TemporaryInstanceDeclaration b(TemporaryInstanceDeclaration temporaryInstanceDeclaration) {
        Builder builder = TemporaryInstanceDeclaration.builder(this);
        builder.addBrowsePath(temporaryInstanceDeclaration.nf);
        builder.addExternalReference(temporaryInstanceDeclaration.ng);
        builder.addInternalReference(temporaryInstanceDeclaration.nu);
        return builder.build();
    }

    public static class Builder {
        private final LinkedHashSet<BrowsePath> nv = new LinkedHashSet();
        private final Set<b> ng = new HashSet<b>();
        private final Set<h> nu = new HashSet<h>();
        private final UaNode node;

        private Builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration) {
            this.node = temporaryInstanceDeclaration.node;
            this.nv.addAll(temporaryInstanceDeclaration.nf);
            this.ng.addAll(temporaryInstanceDeclaration.ng);
            this.nu.addAll(temporaryInstanceDeclaration.nu);
        }

        private Builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration, BrowsePath browsePath) {
            this.node = temporaryInstanceDeclaration.node;
            for (Comparable<BrowsePath> comparable : temporaryInstanceDeclaration.nf) {
                this.nv.add(browsePath.append((BrowsePath)comparable));
            }
            this.ng.addAll(temporaryInstanceDeclaration.ng);
            for (Comparable<BrowsePath> comparable : temporaryInstanceDeclaration.nu) {
                this.nu.add(new h(((k)comparable).getReferenceType(), browsePath.append(((h)comparable).eq())));
            }
        }

        private Builder(UaNode uaNode, BrowsePath browsePath) {
            this.node = uaNode;
            this.nv.add(browsePath);
        }

        public void addBrowsePath(BrowsePath browsePath) {
            this.nv.add(browsePath);
        }

        public void addBrowsePath(Collection<? extends BrowsePath> collection) {
            this.nv.addAll(collection);
        }

        public void addExternalReference(Collection<? extends b> collection) {
            this.ng.addAll(collection);
        }

        public void addExternalReference(b b2) {
            this.ng.add(b2);
        }

        public void addInternalReference(Collection<? extends h> collection) {
            this.nu.addAll(collection);
        }

        public void addInternalReference(h h2) {
            this.nu.add(h2);
        }

        public TemporaryInstanceDeclaration build() {
            return new TemporaryInstanceDeclaration(this.node, this.nv, this.ng, this.nu);
        }

        public UaNode getNode() {
            return this.node;
        }

        public BrowsePath getPrimaryPath() {
            return (BrowsePath)this.nv.iterator().next();
        }
    }
}

