/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.instantiation;

import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.UaInstantiationException;
import com.prosysopc.ua.server.instantiation.InstantiationParameters;
import com.prosysopc.ua.server.instantiation.InstantiationStrategy;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.core.NodeClass;

public class DefaultInstantiationStrategy
implements InstantiationStrategy {
    private final MethodInstantiationLogic mC;

    public DefaultInstantiationStrategy() {
        this(MethodInstantiationLogic.SHARED);
    }

    public DefaultInstantiationStrategy(MethodInstantiationLogic methodInstantiationLogic) {
        if (methodInstantiationLogic == null) {
            throw new IllegalArgumentException("Given MethodInstantiationLogic cannot be null");
        }
        this.mC = methodInstantiationLogic;
    }

    @Override
    public UaNode createInstance(InstantiationParameters instantiationParameters) {
        NodeClass nodeClass;
        NodeClass nodeClass2 = instantiationParameters.getNode().getNodeClass();
        switch (nodeClass2) {
            case ObjectType: {
                nodeClass = NodeClass.Object;
                break;
            }
            case VariableType: {
                nodeClass = NodeClass.Variable;
                break;
            }
            case Method: {
                if (MethodInstantiationLogic.SHARED == this.mC) {
                    return instantiationParameters.getNode();
                }
                return instantiationParameters.getNodeManager().getNodeFactory().createNode(NodeClass.Method, instantiationParameters.getNodeId(), instantiationParameters.getBrowseName(), instantiationParameters.getDisplayName());
            }
            case Object: 
            case Variable: {
                nodeClass = nodeClass2;
                break;
            }
            default: {
                throw new UaInstantiationException("DefaultInstantiationStrategy: the NodeClass of InstanceDeclaration is unsupported:" + nodeClass2);
            }
        }
        ExpandedNodeId expandedNodeId = null;
        if (instantiationParameters.getNode() instanceof UaInstance) {
            expandedNodeId = ((UaInstance)instantiationParameters.getNode()).getTypeDefinitionId();
        }
        if (instantiationParameters.getNode() instanceof UaType) {
            expandedNodeId = instantiationParameters.getNodeManager().getNamespaceTable().toExpandedNodeId(instantiationParameters.getNode().getNodeId());
        }
        if (expandedNodeId != null) {
            return instantiationParameters.getNodeManager().getNodeFactory().createNode(nodeClass, instantiationParameters.getNodeId(), instantiationParameters.getBrowseName(), instantiationParameters.getDisplayName(), expandedNodeId);
        }
        throw new UaInstantiationException("DefaultInstantiationStrategy: instancedeclaration does not have typedefinition, is not Method or Type");
    }

    @Override
    public boolean createsCompleteHierarchy() {
        return false;
    }

    public static enum MethodInstantiationLogic {
        SHARED,
        UNIQUE;

    }
}

