/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.SubscriptionManager;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceManagerBase {
    private static final Logger logger = LoggerFactory.getLogger(ServiceManagerBase.class);
    private final AtomicReference<UaNode> iY = new AtomicReference<Object>(null);
    private final UaServer fQ;

    public ServiceManagerBase(UaServer uaServer) {
        this.fQ = uaServer;
    }

    public UaNode getNode(ExpandedNodeId expandedNodeId) throws StatusException {
        try {
            return this.getNode(this.getNodeManagerTable().getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(serviceResultException);
        }
    }

    public <T extends UaNode> T getNode(ExpandedNodeId expandedNodeId, Class<T> clazz) throws StatusException {
        UaNode uaNode = this.getNode(expandedNodeId);
        return (T)uaNode;
    }

    public UaNode getNode(NodeId nodeId) throws StatusException {
        UaNode uaNode = this.iY.get();
        if (uaNode != null && nodeId != null && nodeId.equals(uaNode.getNodeId())) {
            return uaNode;
        }
        UaNode uaNode2 = this.getNodeManagerTable().getNode(nodeId);
        if (uaNode2 != null && !(uaNode2 instanceof UaExternalNode)) {
            this.iY.set(uaNode2);
        }
        return uaNode2;
    }

    public <T extends UaNode> T getNode(NodeId nodeId, Class<T> clazz) throws StatusException {
        return this.getNode(this.getNodeManagerTable().getNamespaceTable().toExpandedNodeId(nodeId), clazz);
    }

    public NodeManagerTable getNodeManagerTable() {
        return this.fQ.getAddressSpace();
    }

    public UaServer getServer() {
        return this.fQ;
    }

    private boolean d(UaNode uaNode) {
        return uaNode == null || uaNode instanceof UaMethod;
    }

    protected boolean arrayDimensionsMatch(Variant variant, Integer n2, UnsignedInteger[] unsignedIntegerArray) {
        Integer n3 = n2;
        if (n3 == null) {
            return true;
        }
        if (variant == null || variant.getValue() == null) {
            return true;
        }
        switch (n3) {
            case -3: {
                return variant.getDimension() < 2;
            }
            case -2: {
                return true;
            }
            case -1: {
                return !variant.isArray();
            }
            case 0: {
                return variant.isArray();
            }
        }
        return variant.getDimension() == n3.intValue();
    }

    protected void checkIsMethod(UaNode uaNode) throws StatusException {
        if (!this.d(uaNode)) {
            throw new StatusException(StatusCodes.Bad_AttributeIdInvalid);
        }
    }

    protected void checkIsValueNode(UaNode uaNode) throws StatusException {
        if (!this.isValueNode(uaNode)) {
            throw new StatusException("Node " + uaNode.getNodeId() + " is not a Variable or VariableType", StatusCodes.Bad_AttributeIdInvalid);
        }
    }

    protected void checkIsVariable(UaNode uaNode) throws StatusException {
        if (!this.isVariable(uaNode)) {
            throw new StatusException("Node " + uaNode.getNodeId() + " is not a Variable or VariableType", StatusCodes.Bad_AttributeIdInvalid);
        }
    }

    @Deprecated
    protected void checkIsVariableOrVariableType(UaNode uaNode) throws StatusException {
        this.checkIsValueNode(uaNode);
    }

    protected boolean dataTypeEquals(Variant variant, NodeId nodeId) {
        if (variant.getValue() == null) {
            return this.getNodeManagerTable().getNodeManagerRoot().getDataTypeConverter().isNullable(nodeId);
        }
        if (Identifiers.BaseDataType.equals(nodeId)) {
            return true;
        }
        Class<?> clazz = variant.getValue().getClass();
        if (clazz.equals(ByteString.class) && (nodeId.equals(Identifiers.ByteString) || nodeId.equals(Identifiers.Byte))) {
            return true;
        }
        if (DynamicStructure.class.equals(variant.getCompositeClass())) {
            UaDataType[] uaDataTypeArray = new UaDataType[]{};
            return true;
        }
        UaDataType[] uaDataTypeArray = this.getNodeManagerTable().getNodeManagerRoot().getDataTypeConverter().getDataTypesForJavaClass(variant.getCompositeClass());
        try {
            UaDataType uaDataType;
            for (uaDataType = (UaDataType)this.getNode(nodeId); uaDataType != null && uaDataType.getJavaClass() == null; uaDataType = (UaDataType)uaDataType.getSuperType()) {
            }
            for (UaDataType uaDataType2 : uaDataTypeArray) {
                if (uaDataType2.inheritsFrom(nodeId)) {
                    return true;
                }
                if (uaDataType == null || uaDataType.getJavaClass() == null || !uaDataType.getJavaClass().isAssignableFrom(variant.getCompositeClass())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        logger.debug("dataTypeEquals: variant={} dataType={}", (Object)variant, (Object)nodeId);
        return false;
    }

    protected SubscriptionManager getSubscriptionManager() {
        return this.getServer().getSubscriptionManager();
    }

    protected boolean isValueNode(UaNode uaNode) {
        return uaNode == null || uaNode instanceof UaValueNode;
    }

    protected boolean isVariable(UaNode uaNode) {
        return uaNode == null || uaNode instanceof UaVariable;
    }

    protected void listenerError(String string, Object object, RuntimeException runtimeException) {
        logger.error("Exception while calling " + string + " on object " + object, (Throwable)runtimeException);
        throw runtimeException;
    }

    protected boolean requireUaNode() {
        return false;
    }
}

