/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.RequestHeader;

public class ServiceContext {
    public static final ServiceContext INTERNAL_OPERATION_CONTEXT = new ServiceContext(Session.INTERNAL_SESSION, null);
    final RequestHeader requestHeader;
    final Session iV;

    public ServiceContext(Session session, RequestHeader requestHeader) {
        this.iV = session;
        this.requestHeader = requestHeader;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ServiceContext)) {
            return false;
        }
        ServiceContext serviceContext = (ServiceContext)object;
        if (this.requestHeader == null) {
            return serviceContext.requestHeader == null;
        }
        if (serviceContext.requestHeader == null) {
            return false;
        }
        if (this.requestHeader.getRequestHandle() != null && this.requestHeader.getRequestHandle().getValue() != 0L) {
            return this.requestHeader.getRequestHandle().equals(serviceContext.requestHeader.getRequestHandle());
        }
        if (this.requestHeader.getRequestHandle() != null && this.requestHeader.getTimestamp() != null) {
            return this.requestHeader.getTimestamp().equals(serviceContext.requestHeader.getTimestamp());
        }
        return false;
    }

    public String getAuditEntryId() {
        return this.requestHeader.getAuditEntryId();
    }

    public UnsignedInteger getReturnDiagnostics() {
        return this.requestHeader.getReturnDiagnostics();
    }

    public Session getSession() {
        return this.iV;
    }

    public UnsignedInteger getTimeoutHint() {
        return this.requestHeader.getTimeoutHint();
    }

    public DateTime getTimestamp() {
        return this.requestHeader.getTimestamp();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.requestHeader == null ? 0 : this.requestHeader.hashCode());
        n3 = 31 * n3 + (this.iV == null ? 0 : this.iV.hashCode());
        return n3;
    }

    public boolean isInternal() {
        return this.equals(INTERNAL_OPERATION_CONTEXT);
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > this.getTimestamp().getTimeInMillis() + this.getTimeoutHint().getValue();
    }
}

