/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.DataTypeConverter;
import com.prosysopc.ua.ModelException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.BrowseContinuationPoint;
import com.prosysopc.ua.server.ExternalNodeManager;
import com.prosysopc.ua.server.HistoryContinuationPoint;
import com.prosysopc.ua.server.HistoryManager;
import com.prosysopc.ua.server.HistoryResult;
import com.prosysopc.ua.server.IoManager;
import com.prosysopc.ua.server.ModelParser;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.NamespacePair;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.server.NodeManagerTableListener;
import com.prosysopc.ua.server.PredefinedIdPair;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.StructureInfoCache;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.instantiation.InstanceDeclarationHierarchyCache;
import com.prosysopc.ua.server.instantiation.TypeDefinitionBasedNodeBuilderConfiguration;
import com.prosysopc.ua.server.instantiation.UaNodeBuilderConfiguration;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.IdentifierDescriptions;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AddNodesItem;
import com.prosysopc.ua.stack.core.AddReferencesItem;
import com.prosysopc.ua.stack.core.AggregateFilterResult;
import com.prosysopc.ua.stack.core.Argument;
import com.prosysopc.ua.stack.core.BrowseDirection;
import com.prosysopc.ua.stack.core.BrowsePathTarget;
import com.prosysopc.ua.stack.core.BrowseResultMask;
import com.prosysopc.ua.stack.core.DataTypeAttributes;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.EventFilterResult;
import com.prosysopc.ua.stack.core.HistoryReadDetails;
import com.prosysopc.ua.stack.core.HistoryUpdateDetails;
import com.prosysopc.ua.stack.core.HistoryUpdateResult;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.MethodAttributes;
import com.prosysopc.ua.stack.core.MonitoringFilter;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.core.MonitoringParameters;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ObjectAttributes;
import com.prosysopc.ua.stack.core.ObjectTypeAttributes;
import com.prosysopc.ua.stack.core.QueryFirstRequest;
import com.prosysopc.ua.stack.core.QueryFirstResponse;
import com.prosysopc.ua.stack.core.QueryNextRequest;
import com.prosysopc.ua.stack.core.QueryNextResponse;
import com.prosysopc.ua.stack.core.ReferenceDescription;
import com.prosysopc.ua.stack.core.ReferenceTypeAttributes;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.VariableAttributes;
import com.prosysopc.ua.stack.core.VariableTypeAttributes;
import com.prosysopc.ua.stack.core.ViewAttributes;
import com.prosysopc.ua.stack.core.ViewDescription;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.utils.NumericRange;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class NodeManagerTable
implements UaAddressSpace {
    private static final Logger logger = LoggerFactory.getLogger(NodeManagerTable.class);
    private DataTypeConverter ct;
    private final ExternalNodeManager hm;
    private final InstanceDeclarationHierarchyCache hn = new InstanceDeclarationHierarchyCache();
    private NodeManagerTableListener ho = null;
    private boolean hp;
    private final Map<Integer, NodeManager> hq = new ConcurrentSkipListMap<Integer, NodeManager>();
    private final UaServer fQ;
    private final StructureInfoCache hr = new StructureInfoCache();
    private final AtomicReference<UaNodeBuilderConfiguration> hs;

    public NodeManagerTable(UaServer uaServer) {
        this.fQ = uaServer;
        TypeDefinitionBasedNodeBuilderConfiguration typeDefinitionBasedNodeBuilderConfiguration = TypeDefinitionBasedNodeBuilderConfiguration.builder().build();
        this.hs = new AtomicReference<TypeDefinitionBasedNodeBuilderConfiguration>(typeDefinitionBasedNodeBuilderConfiguration);
        this.hm = new ExternalNodeManager(this);
    }

    @Override
    public void addNode(UaNode uaNode) {
        NodeManager nodeManager = this.hq.get(uaNode.getNodeId().getNamespaceIndex());
        if (nodeManager != null) {
            try {
                nodeManager.addNode(uaNode);
            }
            catch (StatusException statusException) {
                logger.error("Could not add node", (Throwable)statusException);
                throw new IllegalStateException("Could not add node", statusException);
            }
        }
    }

    public int addNodeManager(int n2, NodeManager nodeManager) {
        String string = nodeManager.getNamespaceUri();
        int n3 = this.getNamespaceTable().getIndex(string);
        if (n3 == -1) {
            n3 = this.getNamespaceTable().add(n2, string);
        }
        this.hq.put(n3, nodeManager);
        if (this.fQ.isRunning()) {
            this.fQ.updateNamespaceArray();
        }
        return n3;
    }

    public void close() {
        for (NodeManager nodeManager : this.hq.values()) {
            nodeManager.close();
        }
    }

    @Override
    @Deprecated
    public UaNode findNode(NodeId nodeId) {
        if (NodeId.isNull(nodeId)) {
            return null;
        }
        try {
            return this.getNodeManager(nodeId).findNode(nodeId);
        }
        catch (StatusException statusException) {
            return null;
        }
    }

    @Override
    public DataTypeConverter getDataTypeConverter() {
        if (this.ct == null) {
            this.ct = new DataTypeConverter(this);
        }
        return this.ct;
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.fQ.getEncoderContext();
    }

    public UaNode getExternalNode(NodeId nodeId) throws StatusException {
        return this.hm.getNode(nodeId);
    }

    public ExternalNodeManager getExternalNodeManager() {
        return this.hm;
    }

    public HistoryManager getHistoryManager(NodeId nodeId) throws StatusException {
        HistoryManager historyManager = this.getNodeManager(nodeId).getHistoryManager();
        if (historyManager == null) {
            throw new StatusException(StatusCodes.Bad_NotSupported);
        }
        return historyManager;
    }

    public InstanceDeclarationHierarchyCache getInstanceDeclarationHierarchyCache() {
        return this.hn;
    }

    public IoManager getIoManager(NodeId nodeId) throws StatusException {
        IoManager ioManager = this.getNodeManager(nodeId).getIoManager();
        if (ioManager == null) {
            throw new StatusException(StatusCodes.Bad_NotSupported);
        }
        return ioManager;
    }

    public NodeManagerTableListener getListener() {
        return this.ho;
    }

    @Override
    public NamespaceTable getNamespaceTable() {
        return this.getServer().getNamespaceTable();
    }

    @Override
    public UaNode getNode(ExpandedNodeId expandedNodeId) throws StatusException {
        if (ExpandedNodeId.isNull(expandedNodeId)) {
            throw new StatusException("nodeId==null", StatusCodes.Bad_NodeIdUnknown);
        }
        try {
            return this.getNode(this.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(serviceResultException);
        }
    }

    @Override
    public <T extends UaNode> T getNode(ExpandedNodeId expandedNodeId, Class<T> clazz) throws StatusException {
        UaNode uaNode = this.getNode(expandedNodeId);
        return (T)uaNode;
    }

    @Override
    public UaNode getNode(NodeId nodeId) throws StatusException {
        if (NodeId.isNull(nodeId)) {
            throw new StatusException("nodeId==null", StatusCodes.Bad_NodeIdUnknown);
        }
        NodeManager nodeManager = this.getNodeManager(nodeId);
        UaNode uaNode = nodeManager.findNode(nodeId);
        if ((uaNode == null || uaNode instanceof UaExternalNode) && nodeManager.requireUaNode() || !nodeManager.hasNode(nodeId)) {
            logger.debug("getNode: nodeId={} nodeManager={}", (Object)nodeId, (Object)nodeManager);
            throw new StatusException("nodeId=" + nodeId, StatusCodes.Bad_NodeIdUnknown);
        }
        return uaNode;
    }

    @Override
    public <T extends UaNode> T getNode(NodeId nodeId, Class<T> clazz) throws StatusException {
        ExpandedNodeId expandedNodeId = this.getNamespaceTable().toExpandedNodeId(nodeId);
        return this.getNode(expandedNodeId, clazz);
    }

    public UaNodeBuilderConfiguration getNodeBuilderConfiguration() {
        return this.hs.get();
    }

    public NodeClass getNodeClass(ExpandedNodeId expandedNodeId, UaNode uaNode) {
        try {
            return this.getNodeManager(expandedNodeId).getNodeClass(expandedNodeId, uaNode);
        }
        catch (StatusException statusException) {
            return null;
        }
    }

    public NodeClass getNodeClass(NodeId nodeId, UaNode uaNode) {
        try {
            return this.getNodeManager(nodeId).getNodeClass(nodeId, uaNode);
        }
        catch (StatusException statusException) {
            return null;
        }
    }

    public boolean getNodeManagementEnabled() {
        return this.hp;
    }

    public NodeManager getNodeManager(ExpandedNodeId expandedNodeId) throws StatusException {
        int n2 = expandedNodeId.getNamespaceIndex();
        if (n2 == 0) {
            try {
                n2 = this.getNamespaceTable().toNodeId(expandedNodeId).getNamespaceIndex();
            }
            catch (ServiceResultException serviceResultException) {
                throw new StatusException(serviceResultException);
            }
        }
        return this.getNodeManager(n2);
    }

    public NodeManager getNodeManager(int n2) throws StatusException {
        NodeManager nodeManager = this.hq.get(n2);
        if (nodeManager == null) {
            throw new StatusException(StatusCodes.Bad_NodeIdUnknown);
        }
        return nodeManager;
    }

    public NodeManager getNodeManager(NodeId nodeId) throws StatusException {
        return this.getNodeManager(nodeId.getNamespaceIndex());
    }

    public NodeManager getNodeManager(String string) throws StatusException {
        return this.getNodeManager(this.getNamespaceTable().getIndex(string));
    }

    public NodeManagerRoot getNodeManagerRoot() {
        return this.fQ.getNodeManagerRoot();
    }

    public UaNode getNodeOrExternal(NodeId nodeId) throws StatusException {
        try {
            UaNode uaNode = this.getNodeManager(nodeId).findNode(nodeId);
            if (uaNode == null) {
                return this.getExternalNode(nodeId);
            }
            return uaNode;
        }
        catch (StatusException statusException) {
            return this.hm.getNode(nodeId);
        }
    }

    public UaServer getServer() {
        return this.fQ;
    }

    public ServerTable getServerTable() {
        return this.getEncoderContext().getServerTable();
    }

    public StructureInfoCache getStructureInfoCache() {
        return this.hr;
    }

    public UaType getType(NodeId nodeId) throws StatusException {
        return (UaType)this.getNode(nodeId);
    }

    public boolean hasNode(NodeId nodeId) {
        try {
            return this.getNodeManager(nodeId).hasNode(nodeId);
        }
        catch (StatusException statusException) {
            return false;
        }
    }

    public boolean hasNodeManager(String string) {
        return this.hq.get(this.getNamespaceTable().getIndex(string)) != null;
    }

    public boolean isTypeOf(NodeId nodeId, UaType uaType, NodeId nodeId2, UaType uaType2) throws StatusException {
        return this.getNodeManager(nodeId).getIsOfType(nodeId, uaType, nodeId2, uaType2);
    }

    @Override
    public void loadModel(InputStream inputStream) throws SAXException, IOException, ModelException {
        this.loadModel(inputStream, null, false);
    }

    public void loadModel(InputStream inputStream, Collection<ExpandedNodeId> collection, boolean bl) throws SAXException, ModelException, IOException {
        logger.info("Loading model from inputStream");
        ModelParser modelParser = new ModelParser(this);
        modelParser.setIgnoredNodes(collection);
        logger.debug("loadModel: Parsing XML");
        modelParser.parseFile(inputStream);
        logger.debug("loadModel: Creating model");
        try {
            modelParser.createModel(bl);
            logger.debug("loadModel: Completed");
        }
        catch (ServiceException serviceException) {
            logger.warn("Failed to load model from stream", (Throwable)serviceException);
            throw new RuntimeException(serviceException);
        }
    }

    @Override
    public void loadModel(URI uRI) throws SAXException, IOException, ModelException {
        this.loadModel(uRI, null, false);
    }

    public synchronized void loadModel(URI uRI, Collection<ExpandedNodeId> collection, boolean bl) throws SAXException, IOException, ModelException {
        logger.info("Loading model from {}", (Object)uRI);
        ModelParser modelParser = new ModelParser(this);
        modelParser.setIgnoredNodes(collection);
        logger.debug("loadModel: Parsing XML");
        modelParser.parseFile(uRI);
        logger.debug("loadModel: Creating model");
        try {
            modelParser.createModel(bl);
            logger.debug("loadModel: Completed");
        }
        catch (ServiceException serviceException) {
            logger.warn("Failed to load model from " + uRI, (Throwable)serviceException);
            throw new RuntimeException(serviceException);
        }
    }

    @Deprecated
    public void loadNodesFromXml(URL uRL, URL uRL2, Map<String, ModelParserForUaDefinedTypes.ParentDefinition> map) throws NumberFormatException, IllegalArgumentException, IOException, IllegalAccessException {
        this.loadNodesFromXml(uRL, uRL2, map, null);
    }

    @Deprecated
    public synchronized void loadNodesFromXml(URL uRL, URL uRL2, Map<String, ModelParserForUaDefinedTypes.ParentDefinition> map, String string) throws NumberFormatException, IllegalArgumentException, IOException, IllegalAccessException {
        ModelParserForUaDefinedTypes modelParserForUaDefinedTypes = new ModelParserForUaDefinedTypes(this, uRL, uRL2 == null ? ModelParserForUaDefinedTypes.getStandardIds() : ModelParserForUaDefinedTypes.getCsvIds(uRL2), this.getNamespaceTable(), map);
        modelParserForUaDefinedTypes.setTargetNamespace(string);
        List<Exception> list = modelParserForUaDefinedTypes.parseFile();
        for (Exception exception : list) {
            logger.error("Parsing error - " + uRL + " - ", (Throwable)exception);
        }
        if (list.isEmpty()) {
            try {
                modelParserForUaDefinedTypes.createModel();
            }
            catch (ServiceFaultException serviceFaultException) {
                logger.error("Model creation failed due to ServiceFaultException - " + uRL + " - ", (Throwable)serviceFaultException);
                return;
            }
            catch (ServiceResultException serviceResultException) {
                logger.error("Model creation failed due to ServiceResultException - " + uRL + " - ", (Throwable)serviceResultException);
                return;
            }
            catch (StatusException statusException) {
                logger.error("Model creation failed due to StatusException - " + uRL + " - ", (Throwable)statusException);
                return;
            }
        }
    }

    public NodeManager removeNodeManager(int n2) {
        this.getNamespaceTable().remove(n2);
        return this.hq.remove(n2);
    }

    public void setListener(NodeManagerTableListener nodeManagerTableListener) {
        this.ho = nodeManagerTableListener;
    }

    public void setNodeBuilderConfiguration(UaNodeBuilderConfiguration uaNodeBuilderConfiguration) {
        this.hs.set(uaNodeBuilderConfiguration);
    }

    public void setNodeManagementEnabled(boolean bl) {
        this.hp = bl;
    }

    public BrowsePathTarget[] translateBrowsePathToNodeIds(NodeId nodeId, RelativePath relativePath) throws StatusException, ServiceException {
        return this.translateBrowsePath(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId, relativePath);
    }

    private void a(ServiceContext serviceContext, AddReferencesItem addReferencesItem, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, boolean bl, NodeClass nodeClass, String string) throws StatusException {
        this.getNodeManager(addReferencesItem.getSourceNodeId()).addReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, nodeClass, string);
    }

    protected NodeId addNode(ServiceContext serviceContext, AddNodesItem addNodesItem) throws StatusException {
        NodeAttributes nodeAttributes;
        ExpandedNodeId expandedNodeId = addNodesItem.getRequestedNewNodeId();
        NodeId nodeId = null;
        NodeId nodeId2 = null;
        try {
            try {
                nodeId = this.getNamespaceTable().toNodeId(expandedNodeId);
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("addNode: NodeManager for namespace {} not found: trying to create", (Object)expandedNodeId.getNamespaceUri());
                this.createNewNodeManager(serviceContext, expandedNodeId.getNamespaceUri());
                nodeId = this.getNamespaceTable().toNodeId(expandedNodeId);
            }
        }
        catch (ServiceResultException serviceResultException) {
            logger.error("addNode: ", (Throwable)serviceResultException);
            throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
        }
        try {
            nodeId2 = this.getNamespaceTable().toNodeId(addNodesItem.getParentNodeId());
        }
        catch (ServiceResultException serviceResultException) {
            logger.error("addNode: ", (Throwable)serviceResultException);
            throw new StatusException(StatusCodes.Bad_ParentNodeIdInvalid);
        }
        try {
            nodeAttributes = (NodeAttributes)addNodesItem.getNodeAttributes().decode(this.getEncoderContext());
        }
        catch (DecodingException decodingException) {
            logger.error("addNode: ", (Throwable)decodingException);
            throw new StatusException(StatusCodes.Bad_NodeAttributesInvalid);
        }
        ExpandedNodeId expandedNodeId2 = addNodesItem.getTypeDefinition();
        QualifiedName qualifiedName = addNodesItem.getBrowseName();
        NodeClass nodeClass = addNodesItem.getNodeClass();
        NodeId nodeId3 = addNodesItem.getReferenceTypeId();
        return this.addNode(serviceContext, nodeId, nodeId2, qualifiedName, nodeClass, expandedNodeId2, nodeAttributes, nodeId3);
    }

    protected NodeId addNode(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, QualifiedName qualifiedName, NodeClass nodeClass, ExpandedNodeId expandedNodeId, NodeAttributes nodeAttributes, NodeId nodeId3) throws StatusException {
        return this.getNodeManager(nodeId).addNode(serviceContext, nodeId, nodeId2, qualifiedName, nodeClass, expandedNodeId, nodeAttributes, nodeId3);
    }

    protected void addReference(ServiceContext serviceContext, AddReferencesItem addReferencesItem) throws StatusException {
        NodeId nodeId = addReferencesItem.getSourceNodeId();
        ExpandedNodeId expandedNodeId = addReferencesItem.getTargetNodeId();
        NodeId nodeId2 = addReferencesItem.getReferenceTypeId();
        boolean bl = addReferencesItem.getIsForward();
        NodeClass nodeClass = addReferencesItem.getTargetNodeClass();
        String string = addReferencesItem.getTargetServerUri();
        this.a(serviceContext, addReferencesItem, nodeId, expandedNodeId, nodeId2, bl, nodeClass, string);
    }

    protected void afterCreateMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) throws StatusException {
        this.getNodeManager(monitoredDataItem.getNodeId()).afterCreateMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
    }

    protected void afterCreateMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) throws StatusException {
        this.getNodeManager(monitoredEventItem.getNodeId()).afterCreateMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected void afterDeleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) throws StatusException {
        this.getNodeManager(monitoredItem.getNodeId()).afterDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
    }

    protected void afterModifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) throws StatusException {
        this.getNodeManager(monitoredDataItem.getNodeId()).afterModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
    }

    protected void afterModifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) throws StatusException {
        this.getNodeManager(monitoredEventItem.getNodeId()).afterModifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected BrowseContinuationPoint browseNode(ServiceContext serviceContext, List<ReferenceDescription> list, NodeId nodeId, int n2, BrowseDirection browseDirection, NodeId nodeId2, Boolean bl, QualifiedName qualifiedName, EnumSet<NodeClass> enumSet, EnumSet<BrowseResultMask> enumSet2, ViewDescription viewDescription, int n3) throws ServiceException, StatusException {
        return this.getNodeManager(nodeId).browseNode(serviceContext, list, nodeId, n2, browseDirection, nodeId2, bl, qualifiedName, enumSet, enumSet2, viewDescription, n3);
    }

    protected Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        logger.debug("callMethod: objectId={}; methodId={}", (Object)nodeId, (Object)nodeId2);
        logger.debug(" inputArguments={}", (Object)Arrays.toString(variantArray));
        return this.getNodeManager(nodeId).callMethod(serviceContext, nodeId, nodeId2, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    protected void checkNodeManagementEnabled() throws ServiceException {
        if (!this.getNodeManagementEnabled()) {
            throw new ServiceException(StatusCodes.Bad_ServiceUnsupported);
        }
    }

    protected void createMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult, MonitoringMode monitoringMode) throws StatusException {
        this.getNodeManager(nodeId).createMonitoredDataItem(serviceContext, subscription, nodeId, unsignedInteger, numericRange, monitoringParameters, monitoringFilter, aggregateFilterResult, monitoringMode);
    }

    protected void createMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.getNodeManager(nodeId).createMonitoredEventItem(serviceContext, subscription, nodeId, eventFilter, eventFilterResult);
    }

    protected void createNewNodeManager(ServiceContext serviceContext, String string) throws StatusException {
        NodeManager nodeManager;
        if (serviceContext.isInternal() || this.getNodeManagementEnabled()) {
            nodeManager = this.fQ.createNewNodeManager(serviceContext, string);
            if (nodeManager == null) {
                throw new StatusException(StatusCodes.Bad_NodeIdRejected);
            }
        } else {
            throw new StatusException(StatusCodes.Bad_NodeIdRejected);
        }
        int n2 = nodeManager.getNamespaceIndex();
        this.addNodeManager(n2, nodeManager);
        this.fQ.updateNamespaceArray();
        logger.debug("createNewNodeManager: newNodeManager={}", (Object)nodeManager);
    }

    protected void deleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) throws StatusException {
        this.getNodeManager(monitoredItem.getNodeId()).deleteMonitoredItem(serviceContext, subscription, monitoredItem);
    }

    protected void deleteNode(ServiceContext serviceContext, ExpandedNodeId expandedNodeId, boolean bl) throws StatusException {
        NodeId nodeId;
        try {
            nodeId = this.getNamespaceTable().toNodeId(expandedNodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
        }
        this.getNodeManager(expandedNodeId).deleteNode(serviceContext, nodeId, bl);
    }

    protected void deleteNode(ServiceContext serviceContext, NodeId nodeId, Boolean bl) throws StatusException {
        this.getNodeManager(nodeId).deleteNode(serviceContext, nodeId, bl);
    }

    protected void deleteReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, Boolean bl, Boolean bl2) throws StatusException {
        this.getNodeManager(nodeId).deleteReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, bl2);
        if (!this.getNamespaceTable().namespaceEquals(nodeId, expandedNodeId)) {
            this.getNodeManager(expandedNodeId).deleteReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, bl2);
        }
    }

    protected HistoryResult historyRead(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, NumericRange numericRange, HistoryContinuationPoint historyContinuationPoint, HistoryReadDetails historyReadDetails, int n2) throws StatusException {
        return this.getHistoryManager(nodeId).historyRead(serviceContext, object, timestampsToReturn, nodeId, numericRange, historyContinuationPoint, historyReadDetails, n2);
    }

    protected void historyUpdate(ServiceContext serviceContext, Object object, HistoryUpdateDetails historyUpdateDetails, HistoryUpdateResult historyUpdateResult) throws StatusException {
        this.getHistoryManager(historyUpdateDetails.getNodeId()).historyUpdate(serviceContext, object, historyUpdateDetails, historyUpdateResult);
    }

    protected void init() throws StatusException, UaNodeFactoryException {
        for (NodeManager nodeManager : this.hq.values()) {
            logger.debug("Initializing NodeManager: {}", (Object)nodeManager);
            nodeManager.init();
        }
    }

    protected void initializeMonitoredDataItem(ServiceContext serviceContext, MonitoredDataItem monitoredDataItem, DataValue dataValue) throws StatusException {
        this.getIoManager(monitoredDataItem.getNodeId()).initializeMonitoredDataItem(serviceContext, monitoredDataItem, dataValue);
    }

    protected void modifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult) throws StatusException {
        this.getNodeManager(monitoredDataItem.getNodeId()).modifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem, monitoringParameters, monitoringFilter, aggregateFilterResult);
    }

    protected void modifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.getNodeManager(monitoredEventItem.getNodeId()).modifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem, eventFilter, eventFilterResult);
    }

    protected void queryFirst(ServiceContext serviceContext, QueryFirstRequest queryFirstRequest, QueryFirstResponse queryFirstResponse) throws ServiceException {
        if (this.ho == null) {
            throw new ServiceException(StatusCodes.Bad_NotImplemented);
        }
        this.ho.queryFirst(serviceContext, queryFirstRequest, queryFirstResponse);
    }

    protected void queryNext(ServiceContext serviceContext, QueryNextRequest queryNextRequest, QueryNextResponse queryNextResponse) throws ServiceException {
        if (this.ho == null) {
            throw new ServiceException(StatusCodes.Bad_NotImplemented);
        }
        this.ho.queryNext(serviceContext, queryNextRequest, queryNextResponse);
    }

    protected void readAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
        this.getIoManager(nodeId).readAttribute(serviceContext, object, nodeId, unsignedInteger, numericRange, timestampsToReturn, dateTime, dataValue);
    }

    protected NodeId registerNode(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        return this.getNodeManager(nodeId).registerNode(serviceContext, nodeId);
    }

    protected void releaseHistoryContinuationPoint(ServiceContext serviceContext, NodeId nodeId, ByteString byteString) throws StatusException {
        this.getHistoryManager(nodeId).releaseHistoryContinuationPoint(serviceContext, nodeId, byteString);
    }

    protected void start() throws StatusException, UaNodeFactoryException {
        for (NodeManager nodeManager : this.hq.values()) {
            nodeManager.start();
        }
    }

    protected BrowsePathTarget[] translateBrowsePath(ServiceContext serviceContext, NodeId nodeId, RelativePath relativePath) throws StatusException, ServiceException {
        return this.getNodeManager(nodeId).translateBrowsePath(serviceContext, nodeId, relativePath);
    }

    protected void unregisterNode(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        this.getNodeManager(nodeId).unregisterNode(serviceContext, nodeId);
    }

    protected boolean writeAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, DataValue dataValue) throws StatusException {
        return this.getIoManager(nodeId).writeAttribute(serviceContext, object, nodeId, unsignedInteger, numericRange, dataValue);
    }

    Map<Integer, NodeManager> bk() {
        return Collections.unmodifiableMap(this.hq);
    }

    @Deprecated
    public static class ModelParserForUaDefinedTypes
    extends DefaultHandler {
        private static final ExpandedNodeId hu = new ExpandedNodeId(Identifiers.PropertyType);
        private static Map<String, PredefinedIdPair> hv = null;
        private static final Logger logger = LoggerFactory.getLogger(ModelParserForUaDefinedTypes.class);
        private static Map<Object, String> hw = null;
        private List<Argument> hx;
        private String hy;
        private AddReferencesItem hz;
        private Locale defaultLocale;
        private List<a> hA;
        private final EncoderContext hB;
        private final NodeManagerTable hC;
        private String hD;
        private List<NamespacePair> hE;
        private final NamespaceTable namespaceTable;
        private List<NodeAttributes> hF;
        private List<AddNodesItem> hG;
        private List<AddNodesItem> hH;
        private Map<String, ParentDefinition> hI;
        private final List<Exception> hJ;
        private final Map<String, PredefinedIdPair> hK;
        private String ay;
        private boolean aA;
        private boolean hL;
        private List<AddReferencesItem> hM;
        private List<String> hN;
        private String targetNamespace;
        private final URL hO;

        public static Map<String, PredefinedIdPair> getCsvIds(URL uRL) throws NumberFormatException, IllegalArgumentException, IOException {
            HashMap<String, PredefinedIdPair> hashMap = new HashMap<String, PredefinedIdPair>();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(",");
                try {
                    hashMap.put(stringArray[0], new PredefinedIdPair(new UnsignedInteger(Integer.parseInt(stringArray[1])), NodeClass.valueOf(stringArray[2])));
                }
                catch (NumberFormatException numberFormatException) {
                    hashMap.put(stringArray[0], new PredefinedIdPair(stringArray[1], NodeClass.valueOf(stringArray[2])));
                }
            }
            return hashMap;
        }

        public static synchronized Map<String, PredefinedIdPair> getIdentifierPairs() {
            if (hv == null) {
                Field[] fieldArray;
                hv = new ConcurrentHashMap<String, PredefinedIdPair>();
                Class<Identifiers> clazz = Identifiers.class;
                for (Field field : fieldArray = clazz.getFields()) {
                    Object object;
                    try {
                        object = field.get(null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        continue;
                    }
                    if (!(object instanceof NodeId)) continue;
                    hv.put(field.getName(), new PredefinedIdPair(((NodeId)object).getValue(), null));
                }
            }
            return hv;
        }

        public static synchronized Map<Object, String> getReverseIdentifierPairs() {
            if (hw == null) {
                Field[] fieldArray;
                hw = new ConcurrentHashMap<Object, String>();
                Class<Identifiers> clazz = Identifiers.class;
                for (Field field : fieldArray = clazz.getFields()) {
                    Object object;
                    try {
                        object = field.get(null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        continue;
                    }
                    if (!(object instanceof NodeId)) continue;
                    hw.put(((NodeId)object).getValue(), field.getName());
                }
            }
            return hw;
        }

        public static Map<String, PredefinedIdPair> getStandardIds() throws IOException, IllegalArgumentException, IllegalAccessException {
            return ModelParserForUaDefinedTypes.getIdentifierPairs();
        }

        public ModelParserForUaDefinedTypes(NodeManagerTable nodeManagerTable, URL uRL, Map<String, PredefinedIdPair> map, NamespaceTable namespaceTable) {
            this.hC = nodeManagerTable;
            this.hB = nodeManagerTable.getEncoderContext();
            this.hO = uRL;
            this.hK = map;
            this.namespaceTable = namespaceTable;
            this.hJ = new ArrayList<Exception>();
        }

        public ModelParserForUaDefinedTypes(NodeManagerTable nodeManagerTable, URL uRL, Map<String, PredefinedIdPair> map, NamespaceTable namespaceTable, Map<String, ParentDefinition> map2) {
            this(nodeManagerTable, uRL, map, namespaceTable);
            this.hI = map2;
        }

        @Override
        public void characters(char[] cArray, int n2, int n3) throws SAXException {
            if (this.aA) {
                this.ay = this.ay + new String(cArray, n2, n3);
            }
        }

        public void createModel() throws ServiceResultException, StatusException {
            ArrayList<AddNodesItem> arrayList = new ArrayList<AddNodesItem>();
            for (AddNodesItem abstractStructure : this.hH) {
                if (abstractStructure.getNodeClass().equals(NodeClass.ReferenceType)) {
                    this.hC.addNode(ServiceContext.INTERNAL_OPERATION_CONTEXT, abstractStructure);
                    continue;
                }
                arrayList.add(abstractStructure);
            }
            for (AddNodesItem addNodesItem : arrayList) {
                this.hC.addNode(ServiceContext.INTERNAL_OPERATION_CONTEXT, addNodesItem);
            }
            for (AddReferencesItem addReferencesItem : this.hM) {
                this.hC.addReference(ServiceContext.INTERNAL_OPERATION_CONTEXT, addReferencesItem);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            a a2 = a.valueOf(string2);
            switch (a2) {
                case ik: 
                case it: 
                case ip: 
                case hT: 
                case if: 
                case ij: 
                case ir: 
                case im: 
                case iu: 
                case ic: 
                case il: {
                    Object object;
                    if (a2 == a.ip && this.aA && this.hG.size() != 0) {
                        ExpandedNodeId expandedNodeId = this.f(this.ay);
                        try {
                            this.hz.setReferenceTypeId(this.namespaceTable.toNodeId(expandedNodeId));
                        }
                        catch (ServiceResultException serviceResultException) {
                            this.a(serviceResultException);
                        }
                        this.aA = false;
                        break;
                    }
                    if (a2.equals((Object)a.ic) || a2.equals((Object)a.il)) {
                        object = this.hx.toArray(new Argument[0]);
                        ((VariableAttributes)this.bp()).setValue(object);
                        ((VariableAttributes)this.bp()).setValueRank(1);
                        ((VariableAttributes)this.bp()).setArrayDimensions(new UnsignedInteger[]{new UnsignedInteger(((Argument[])object).length)});
                    }
                    object = null;
                    try {
                        object = ExtensionObject.binaryEncode(this.bp(), this.hB);
                    }
                    catch (EncodingException encodingException) {
                        this.a(encodingException);
                    }
                    this.br().setNodeAttributes((ExtensionObject)object);
                    AddNodesItem addNodesItem = this.bw();
                    if (a.valueOf(string2) == a.im) {
                        addNodesItem.setTypeDefinition(this.namespaceTable.toExpandedNodeId(Identifiers.PropertyType));
                    }
                    this.hH.add(addNodesItem);
                    this.bx();
                    this.bu();
                    break;
                }
                case hQ: {
                    if (this.aA) {
                        this.br().setBrowseName(new QualifiedName(this.ay));
                    }
                    this.aA = false;
                    break;
                }
                case hX: {
                    if (this.aA) {
                        this.bp().setDisplayName(new LocalizedText(this.ay, this.defaultLocale));
                    }
                    this.aA = false;
                    break;
                }
                case hU: {
                    this.aA = false;
                    break;
                }
                case ie: {
                    if (this.aA) {
                        ((ReferenceTypeAttributes)this.bp()).setInverseName(new LocalizedText(this.ay, this.defaultLocale));
                    }
                    this.aA = false;
                    break;
                }
                case hV: {
                    if (this.aA) {
                        if (this.c(2).equals((Object)a.hP)) {
                            this.bo().setDescription(new LocalizedText(this.ay, this.defaultLocale));
                        } else {
                            this.bp().setDescription(new LocalizedText(this.ay, this.defaultLocale));
                        }
                    }
                    this.aA = false;
                    break;
                }
                case in: {
                    ExpandedNodeId expandedNodeId = this.br().getRequestedNewNodeId();
                    ExpandedNodeId expandedNodeId2 = this.hz.getTargetNodeId();
                    AddReferencesItem addReferencesItem = this.hz.clone();
                    try {
                        logger.debug("sourceId={}", (Object)expandedNodeId);
                        addReferencesItem.setSourceNodeId(this.toNodeId(expandedNodeId));
                    }
                    catch (ServiceResultException serviceResultException) {
                        this.a(serviceResultException);
                        break;
                    }
                    addReferencesItem.setTargetNodeId(expandedNodeId2);
                    this.hM.add(addReferencesItem);
                    break;
                }
                case iq: {
                    if (!this.aA) break;
                    this.hz.setTargetNodeId(this.f(this.ay));
                    this.aA = false;
                    break;
                }
                case ig: {
                    break;
                }
                case ih: {
                    if (!this.aA) break;
                    try {
                        this.a(this.hy, this.ay);
                    }
                    catch (Exception exception) {
                        this.a(exception);
                    }
                    this.aA = false;
                    break;
                }
                case hP: {
                    break;
                }
                case hR: {
                    break;
                }
                case ii: {
                    break;
                }
                case io: {
                    break;
                }
                case hW: {
                    break;
                }
                case hS: {
                    break;
                }
                case ib: {
                    break;
                }
                case hZ: {
                    break;
                }
                case ia: {
                    break;
                }
            }
            this.bv();
        }

        public List<Exception> parseFile() {
            InputStreamReader inputStreamReader;
            XMLReader xMLReader;
            this.hx = new ArrayList<Argument>();
            this.hH = new ArrayList<AddNodesItem>();
            this.hM = new ArrayList<AddReferencesItem>();
            this.hA = new ArrayList<a>();
            this.hF = new ArrayList<NodeAttributes>();
            this.hG = new ArrayList<AddNodesItem>();
            this.hN = new ArrayList<String>();
            this.defaultLocale = Locale.ENGLISH;
            if (this.targetNamespace == null) {
                this.targetNamespace = "http://opcfoundation.org/UA/";
            }
            this.hE = new ArrayList<NamespacePair>();
            try {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            catch (Exception exception) {
                this.a(exception);
                return this.hJ;
            }
            logger.debug("XMLReader class: {}", xMLReader.getClass());
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            try {
                inputStreamReader = new InputStreamReader(this.hO.openStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.a(fileNotFoundException);
                return this.hJ;
            }
            catch (IOException iOException) {
                this.a(iOException);
                return this.hJ;
            }
            try {
                xMLReader.parse(new InputSource(inputStreamReader));
            }
            catch (Exception exception) {
                logger.error("Exception while parsing", (Throwable)exception);
                return this.hJ;
            }
            return this.hJ;
        }

        public void setTargetNamespace(String string) {
            this.targetNamespace = string;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            a a2 = a.valueOf(string2);
            this.a(a2);
            switch (a2) {
                case ik: {
                    this.a(attributes, this.H(attributes), NodeClass.ObjectType);
                    break;
                }
                case it: {
                    this.a(attributes, this.K(attributes), NodeClass.VariableType);
                    break;
                }
                case ip: {
                    if (this.br() != null) {
                        this.n();
                        break;
                    }
                    this.a(attributes, this.I(attributes), NodeClass.ReferenceType);
                    break;
                }
                case hT: {
                    this.a(attributes, this.D(attributes), NodeClass.DataType);
                    break;
                }
                case if: {
                    this.a(attributes, this.E(attributes), NodeClass.Method);
                    break;
                }
                case ij: {
                    this.a(attributes, this.G(attributes), NodeClass.Object);
                    break;
                }
                case ir: {
                    VariableAttributes variableAttributes = this.C(attributes);
                    this.a(attributes, variableAttributes, NodeClass.Variable);
                    break;
                }
                case im: {
                    VariableAttributes variableAttributes = this.C(attributes);
                    this.a(attributes, variableAttributes, NodeClass.Variable, hu);
                    break;
                }
                case iu: {
                    this.a(attributes, this.L(attributes), NodeClass.View);
                    break;
                }
                case hQ: {
                    this.n();
                    break;
                }
                case hX: {
                    this.n();
                    break;
                }
                case hU: {
                    this.n();
                    break;
                }
                case ie: {
                    this.n();
                    break;
                }
                case hV: {
                    this.n();
                    break;
                }
                case in: {
                    this.hz = this.y(attributes);
                    break;
                }
                case iq: {
                    this.n();
                    break;
                }
                case ig: {
                    for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                        if (!attributes.getLocalName(i2).equalsIgnoreCase("TargetNamespace")) continue;
                        this.targetNamespace = attributes.getValue(i2);
                    }
                    break;
                }
                case ih: {
                    this.F(attributes);
                    this.n();
                    break;
                }
                case ic: {
                    this.bl();
                    this.hx.clear();
                    break;
                }
                case il: {
                    this.bm();
                    this.hx.clear();
                    break;
                }
                case hP: {
                    this.x(attributes);
                    break;
                }
                case hR: {
                    break;
                }
                case ii: {
                    break;
                }
                case io: {
                    break;
                }
                case hW: {
                    break;
                }
                case hS: {
                    break;
                }
                case ib: {
                    break;
                }
                case hZ: {
                    break;
                }
                case ia: {
                    break;
                }
            }
        }

        private void a(Exception exception) {
            this.hJ.add(exception);
        }

        private void x(Attributes attributes) {
            Argument argument;
            String string = null;
            String string2 = null;
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (attributes.getLocalName(i2).equalsIgnoreCase("Name")) {
                    string = attributes.getValue(i2);
                }
                if (!attributes.getLocalName(i2).equalsIgnoreCase("DataType")) continue;
                string2 = attributes.getValue(i2);
            }
            try {
                argument = new Argument(string, this.namespaceTable.toNodeId(this.f(string2)), -1, null, null);
            }
            catch (ServiceResultException serviceResultException) {
                this.hJ.add(new Exception("Unable to get a data type for argument=" + string + ", data type=" + string2));
                return;
            }
            this.a(argument);
        }

        private void bl() {
            VariableAttributes variableAttributes = new VariableAttributes();
            variableAttributes.setDataType(Identifiers.Argument);
            this.a(variableAttributes);
            ExpandedNodeId expandedNodeId = this.br().getRequestedNewNodeId();
            String string = this.bn() + "_InputArguments";
            ExpandedNodeId expandedNodeId2 = new ExpandedNodeId(new UnsignedInteger(0), this.targetNamespace, this.hK.get(string).getId());
            ExpandedNodeId expandedNodeId3 = this.namespaceTable.toExpandedNodeId(Identifiers.PropertyType);
            NodeId nodeId = Identifiers.HasProperty;
            AddNodesItem addNodesItem = new AddNodesItem(expandedNodeId, nodeId, expandedNodeId2, new QualifiedName(0, "InputArguments"), NodeClass.Variable, null, expandedNodeId3);
            this.b(addNodesItem);
            this.g(this.hD);
        }

        private void a(Attributes attributes, NodeAttributes nodeAttributes, NodeClass nodeClass) {
            ExpandedNodeId expandedNodeId = this.B(attributes);
            this.a(attributes, nodeAttributes, nodeClass, expandedNodeId);
        }

        private void a(Attributes attributes, NodeAttributes nodeAttributes, NodeClass nodeClass, ExpandedNodeId expandedNodeId) {
            ExtensionObject extensionObject;
            if (nodeAttributes == null) {
                return;
            }
            this.a(nodeAttributes);
            ExpandedNodeId expandedNodeId2 = this.a(nodeClass, attributes);
            ExpandedNodeId expandedNodeId3 = this.A(attributes);
            NodeId nodeId = this.b(nodeClass, expandedNodeId);
            try {
                extensionObject = ExtensionObject.binaryEncode(nodeAttributes, this.hB);
            }
            catch (EncodingException encodingException) {
                logger.error("EncodingException: ", (Throwable)encodingException);
                extensionObject = null;
            }
            AddNodesItem addNodesItem = new AddNodesItem(expandedNodeId2, nodeId, expandedNodeId3, this.z(attributes), nodeClass, extensionObject, expandedNodeId);
            this.b(addNodesItem);
            this.g(this.hD);
        }

        private void bm() {
            VariableAttributes variableAttributes = new VariableAttributes();
            variableAttributes.setDataType(Identifiers.Argument);
            this.a(variableAttributes);
            ExpandedNodeId expandedNodeId = this.br().getRequestedNewNodeId();
            String string = this.br().getBrowseName().getName() + "_OutputArguments";
            ExpandedNodeId expandedNodeId2 = new ExpandedNodeId(new UnsignedInteger(0), this.targetNamespace, this.hK.get(string).getId());
            ExpandedNodeId expandedNodeId3 = this.namespaceTable.toExpandedNodeId(Identifiers.PropertyType);
            NodeId nodeId = Identifiers.HasProperty;
            AddNodesItem addNodesItem = new AddNodesItem(expandedNodeId, nodeId, expandedNodeId2, new QualifiedName(0, "OutputArguments"), NodeClass.Variable, null, expandedNodeId3);
            this.b(addNodesItem);
            this.g(this.hD);
        }

        private void a(String string, String string2) throws Exception {
            this.namespaceTable.add(-1, string2);
        }

        private AddReferencesItem y(Attributes attributes) {
            boolean bl = false;
            boolean bl2 = true;
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (attributes.getLocalName(i2).equalsIgnoreCase("IsInverse")) {
                    bl = Boolean.parseBoolean(attributes.getValue(i2));
                }
                if (!attributes.getLocalName(i2).equalsIgnoreCase("IsOneWay")) continue;
                bl2 = Boolean.parseBoolean(attributes.getValue(i2));
            }
            this.hL = bl2;
            AddReferencesItem addReferencesItem = new AddReferencesItem(null, null, !bl, null, null, null);
            return addReferencesItem;
        }

        private ExpandedNodeId b(NodeClass nodeClass) {
            NodeId nodeId = this.c(nodeClass);
            return new ExpandedNodeId(new UnsignedInteger(0), nodeId.getNamespaceIndex(), nodeId.getValue());
        }

        private NodeId c(NodeClass nodeClass) {
            switch (nodeClass) {
                case Object: {
                    return Identifiers.ObjectsFolder;
                }
                case Variable: {
                    this.a(new Exception("No default parent id for Variables"));
                    return NodeId.NULL;
                }
                case Method: {
                    return Identifiers.ObjectTypesFolder;
                }
                case ObjectType: {
                    return Identifiers.BaseObjectType;
                }
                case VariableType: {
                    return Identifiers.BaseVariableType;
                }
                case ReferenceType: {
                    return Identifiers.ReferenceTypesFolder;
                }
                case DataType: {
                    return Identifiers.DataTypesFolder;
                }
                case View: {
                    return Identifiers.ViewsFolder;
                }
            }
            return NodeId.NULL;
        }

        private NodeId a(NodeClass nodeClass, ExpandedNodeId expandedNodeId) {
            if (hu.equals(expandedNodeId)) {
                return Identifiers.HasProperty;
            }
            switch (nodeClass) {
                case ObjectType: 
                case VariableType: 
                case ReferenceType: 
                case DataType: {
                    return Identifiers.HasSubtype;
                }
                case Object: 
                case Variable: 
                case Method: {
                    return Identifiers.HasComponent;
                }
                case View: {
                    return Identifiers.Organizes;
                }
            }
            return null;
        }

        private QualifiedName z(Attributes attributes) {
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("SymbolicName")) continue;
                String[] stringArray = attributes.getValue(i2).split(":");
                return new QualifiedName(stringArray[stringArray.length - 1]);
            }
            return new QualifiedName("");
        }

        private NodeId a(int n2, String string) {
            Object object = this.hK.get(string).getId();
            if (object instanceof UnsignedInteger) {
                return new NodeId(n2, (UnsignedInteger)object);
            }
            if (object instanceof String) {
                return new NodeId(n2, (String)object);
            }
            throw new RuntimeException("Other Id types than UnsignedIntegers and Strings are not yet supported");
        }

        private ExpandedNodeId A(Attributes attributes) {
            String string = attributes.getValue("", "SymbolicName");
            if (string == null) {
                return ExpandedNodeId.NULL;
            }
            String[] stringArray = string.split(":");
            String string2 = stringArray[stringArray.length - 1];
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < this.hG.size(); ++i2) {
                String[] stringArray2 = this.hN.get(i2).split(":");
                String string3 = stringArray2[stringArray2.length - 1];
                stringBuilder.append(string3);
                stringBuilder.append("_");
            }
            stringBuilder.append(string2);
            String string4 = stringBuilder.toString();
            try {
                return new ExpandedNodeId(UnsignedInteger.ZERO, this.targetNamespace, this.hK.get(string4).getId());
            }
            catch (Exception exception) {
                this.a(new RuntimeException("NodeId not found for designId=" + string4, exception));
                return null;
            }
        }

        private ExpandedNodeId a(NodeClass nodeClass, Attributes attributes) {
            Object object;
            ParentDefinition parentDefinition;
            ExpandedNodeId expandedNodeId = null;
            if (this.hI != null && (parentDefinition = this.hI.get(this.hD)) != null && (object = parentDefinition.getParent()) != null) {
                return this.namespaceTable.toExpandedNodeId((NodeId)object);
            }
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("BaseType")) continue;
                object = attributes.getValue(i2).replaceAll("tns:", "");
                expandedNodeId = this.namespaceTable.toExpandedNodeId(this.a(0, (String)object));
                break;
            }
            if (expandedNodeId != null) {
                return expandedNodeId;
            }
            if (this.hG.size() > 0) {
                expandedNodeId = this.br().getRequestedNewNodeId();
            }
            if (expandedNodeId != null) {
                return expandedNodeId;
            }
            String[] stringArray = this.hD.split("_");
            if (stringArray.length > 1) {
                object = this.hD.replaceAll("_" + stringArray[stringArray.length - 1], "").replaceAll("tns:", "");
                try {
                    expandedNodeId = new ExpandedNodeId(this.a(0, (String)object));
                }
                catch (Exception exception) {
                    try {
                        new ExpandedNodeId(this.a(0, (String)object + "Type"));
                    }
                    catch (Exception exception2) {
                        this.a(new Exception("Unable to find implicit parent " + (String)object));
                        expandedNodeId = this.namespaceTable.toExpandedNodeId(this.c(this.br().getNodeClass()));
                    }
                }
            }
            if (expandedNodeId != null) {
                return expandedNodeId;
            }
            expandedNodeId = this.b(nodeClass);
            return expandedNodeId;
        }

        private NodeId b(NodeClass nodeClass, ExpandedNodeId expandedNodeId) {
            NodeId nodeId;
            ParentDefinition parentDefinition;
            if (this.hI != null && (parentDefinition = this.hI.get(this.hD)) != null && (nodeId = parentDefinition.getParentReferenceType()) != null) {
                return nodeId;
            }
            return this.a(nodeClass, expandedNodeId);
        }

        private String bn() {
            if (this.hN.size() != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i2 = 0; i2 < this.hN.size(); ++i2) {
                    String[] stringArray = this.hN.get(i2).split(":");
                    String string = stringArray[stringArray.length - 1];
                    if (i2 > 0) {
                        stringBuilder.append("_");
                    }
                    stringBuilder.append(string);
                }
                return stringBuilder.toString();
            }
            return null;
        }

        private ExpandedNodeId B(Attributes attributes) {
            String string = null;
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                String string2 = attributes.getLocalName(i2);
                if (!string2.equalsIgnoreCase("TypeDefinition")) continue;
                string = attributes.getValue(i2);
            }
            if (string == null) {
                return null;
            }
            return this.f(string);
        }

        private ExpandedNodeId f(String string) {
            String[] stringArray = string.split(":");
            if (stringArray.length == 1) {
                return new ExpandedNodeId(this.a(this.namespaceTable.getIndex(this.targetNamespace), string));
            }
            if (stringArray.length == 2) {
                if (stringArray[0].equals("ua") || stringArray[0].equals("tns")) {
                    NodeId nodeId = IdentifierDescriptions.toNodeId(stringArray[1]);
                    return new ExpandedNodeId(new UnsignedInteger(0), "http://opcfoundation.org/UA/", nodeId.getValue());
                }
                return new ExpandedNodeId(this.a(this.namespaceTable.getIndex(this.targetNamespace), stringArray[1]));
            }
            return ExpandedNodeId.NULL;
        }

        private VariableAttributes C(Attributes attributes) {
            VariableAttributes variableAttributes;
            try {
                variableAttributes = this.J(attributes);
            }
            catch (ServiceResultException serviceResultException) {
                logger.error("ServiceResultException: ", (Throwable)serviceResultException);
                return null;
            }
            if (variableAttributes.getAccessLevel() == null || variableAttributes.getAccessLevel().intValue() == 0) {
                variableAttributes.setAccessLevel(AccessLevelType.CurrentRead.getAsBuiltInType());
            }
            return variableAttributes;
        }

        private Variant parseVariant(String string, NodeId nodeId) {
            return this.hC.getNodeManagerRoot().getDataTypeConverter().parseVariant(string, nodeId);
        }

        private Argument bo() {
            if (this.hx.size() != 0) {
                return this.hx.get(this.hx.size() - 1);
            }
            return null;
        }

        private NodeAttributes bp() {
            if (this.hF.size() != 0) {
                return this.hF.get(this.hF.size() - 1);
            }
            return null;
        }

        private a bq() {
            if (this.hA.size() != 0) {
                return this.hA.get(this.hA.size() - 1);
            }
            return null;
        }

        private a c(int n2) {
            if (this.hA.size() >= n2) {
                return this.hA.get(this.hA.size() - n2);
            }
            return null;
        }

        private AddNodesItem br() {
            if (this.hG.size() != 0) {
                return this.hG.get(this.hG.size() - 1);
            }
            return null;
        }

        private String bs() {
            if (this.hN.size() != 0) {
                return this.hN.get(this.hN.size() - 1);
            }
            return null;
        }

        private Argument bt() {
            Argument argument = this.bo();
            if (argument != null) {
                this.hx.remove(argument);
            }
            return argument;
        }

        private NodeAttributes bu() {
            NodeAttributes nodeAttributes = this.bp();
            if (nodeAttributes != null) {
                this.hF.remove(nodeAttributes);
            }
            return nodeAttributes;
        }

        private a bv() {
            a a2 = this.bq();
            if (a2 != null) {
                this.hA.remove((Object)a2);
            }
            return a2;
        }

        private AddNodesItem bw() {
            AddNodesItem addNodesItem = this.br();
            if (addNodesItem != null) {
                this.hG.remove(addNodesItem);
            }
            return addNodesItem;
        }

        private String bx() {
            String string = this.bs();
            if (string != null) {
                this.hN.remove(string);
            }
            return string;
        }

        private void n() {
            this.aA = true;
            this.ay = "";
        }

        private void a(Argument argument) {
            this.hx.add(argument);
        }

        private void a(NodeAttributes nodeAttributes) {
            this.hF.add(nodeAttributes);
        }

        private void a(a a2) {
            this.hA.add(a2);
        }

        private void b(AddNodesItem addNodesItem) {
            this.br();
            this.hG.add(addNodesItem);
        }

        private void g(String string) {
            this.hN.add(string);
        }

        private DataTypeAttributes D(Attributes attributes) {
            DataTypeAttributes dataTypeAttributes = new DataTypeAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("IsAbstract")) continue;
                dataTypeAttributes.setIsAbstract(Boolean.parseBoolean(attributes.getValue(i2)));
            }
            this.a(dataTypeAttributes, attributes);
            return dataTypeAttributes;
        }

        private MethodAttributes E(Attributes attributes) {
            MethodAttributes methodAttributes = new MethodAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("NonExecutable")) continue;
                methodAttributes.setExecutable(!Boolean.parseBoolean(attributes.getValue(i2)));
            }
            this.a(methodAttributes, attributes);
            return methodAttributes;
        }

        private void F(Attributes attributes) {
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("Name")) continue;
                this.hy = attributes.getValue(i2);
            }
        }

        private void a(NodeAttributes nodeAttributes, Attributes attributes) {
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (attributes.getLocalName(i2).equalsIgnoreCase("SymbolicName")) {
                    this.hD = attributes.getValue(i2);
                }
                if (!attributes.getLocalName(i2).equalsIgnoreCase("WriteAccess")) continue;
                nodeAttributes.setWriteMask(new UnsignedInteger(Long.parseLong(attributes.getValue(i2))));
            }
        }

        private ObjectAttributes G(Attributes attributes) {
            ObjectAttributes objectAttributes = new ObjectAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            }
            this.a(objectAttributes, attributes);
            return objectAttributes;
        }

        private ObjectTypeAttributes H(Attributes attributes) {
            ObjectTypeAttributes objectTypeAttributes = new ObjectTypeAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("IsAbstract")) continue;
                objectTypeAttributes.setIsAbstract(Boolean.parseBoolean(attributes.getValue(i2)));
            }
            this.a(objectTypeAttributes, attributes);
            return objectTypeAttributes;
        }

        private ReferenceTypeAttributes I(Attributes attributes) {
            ReferenceTypeAttributes referenceTypeAttributes = new ReferenceTypeAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (attributes.getLocalName(i2).equalsIgnoreCase("IsAbstract")) {
                    referenceTypeAttributes.setIsAbstract(Boolean.parseBoolean(attributes.getValue(i2)));
                }
                if (!attributes.getLocalName(i2).equalsIgnoreCase("Symmetric")) continue;
                referenceTypeAttributes.setSymmetric(Boolean.parseBoolean(attributes.getValue(i2)));
            }
            this.a(referenceTypeAttributes, attributes);
            return referenceTypeAttributes;
        }

        private VariableAttributes J(Attributes attributes) throws ServiceResultException {
            VariableAttributes variableAttributes = new VariableAttributes();
            String string = null;
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (attributes.getLocalName(i2).equalsIgnoreCase("DataType")) {
                    variableAttributes.setDataType(this.namespaceTable.toNodeId(this.f(attributes.getValue(i2))));
                }
                if (attributes.getLocalName(i2).equalsIgnoreCase("Historizing")) {
                    variableAttributes.setHistorizing(Boolean.parseBoolean(attributes.getValue(i2)));
                }
                if (attributes.getLocalName(i2).equalsIgnoreCase("MinimumSamplingInterval")) {
                    variableAttributes.setMinimumSamplingInterval(Double.parseDouble(attributes.getValue(i2)));
                }
                if (!attributes.getLocalName(i2).equalsIgnoreCase("DefaultValue")) continue;
                string = attributes.getValue(i2);
            }
            NodeId nodeId = variableAttributes.getDataType();
            if (string != null && nodeId != null) {
                variableAttributes.setValue(this.parseVariant(string, nodeId).getValue());
            } else {
                variableAttributes.setValue(string);
            }
            this.a(variableAttributes, attributes);
            return variableAttributes;
        }

        private VariableTypeAttributes K(Attributes attributes) {
            VariableTypeAttributes variableTypeAttributes = new VariableTypeAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("AccessLevel")) continue;
                variableTypeAttributes.setIsAbstract(Boolean.parseBoolean(attributes.getValue(i2)));
            }
            this.a(variableTypeAttributes, attributes);
            return variableTypeAttributes;
        }

        private ViewAttributes L(Attributes attributes) {
            ViewAttributes viewAttributes = new ViewAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("ContainsNoLoops")) continue;
                viewAttributes.setContainsNoLoops(Boolean.parseBoolean(attributes.getValue(i2)));
            }
            this.a(viewAttributes, attributes);
            return viewAttributes;
        }

        private NodeId toNodeId(ExpandedNodeId expandedNodeId) throws ServiceResultException {
            return this.namespaceTable.toNodeId(expandedNodeId);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        private static enum a {
            hP,
            hQ,
            hR,
            hS,
            hT,
            hU,
            hV,
            hW,
            hX,
            hY,
            hZ,
            ia,
            ib,
            ic,
            ie,
            if,
            ig,
            ih,
            ii,
            ij,
            ik,
            il,
            im,
            in,
            io,
            ip,
            iq,
            ir,
            it,
            iu;

        }

        public static class ParentDefinition {
            private final NodeId iw;
            private final NodeId ix;

            public ParentDefinition(NodeId nodeId, NodeId nodeId2) {
                this.iw = nodeId;
                this.ix = nodeId2;
            }

            public NodeId getParent() {
                return this.iw;
            }

            public NodeId getParentReferenceType() {
                return this.ix;
            }
        }
    }
}

