/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ModelParserBase;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.server.GeneratedNode;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.core.AddNodesItem;
import com.prosysopc.ua.stack.core.AddReferencesItem;
import com.prosysopc.ua.stack.core.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelParser
extends ModelParserBase {
    public static boolean callAfterCreateForTopLevelNodes = true;
    private static final Logger logger = LoggerFactory.getLogger(ModelParser.class);
    private final NodeManagerTable nodeManagerTable;

    public ModelParser(NodeManagerTable nodeManagerTable) {
        super(nodeManagerTable.getServer());
        this.nodeManagerTable = nodeManagerTable;
    }

    @Override
    protected void addNamespaceUri(String string) {
        super.addNamespaceUri(string);
        if (!this.nodeManagerTable.hasNodeManager(string)) {
            try {
                this.nodeManagerTable.createNewNodeManager(ServiceContext.INTERNAL_OPERATION_CONTEXT, string);
            }
            catch (StatusException statusException) {
                throw new RuntimeException(statusException);
            }
        }
    }

    @Override
    protected void afterCreate(AddNodesItem addNodesItem) {
        if (!callAfterCreateForTopLevelNodes) {
            return;
        }
        try {
            UaReference[] uaReferenceArray;
            UaNode uaNode = this.getNode(this.nodeManagerTable.getNamespaceTable().toNodeId(addNodesItem.getRequestedNewNodeId()));
            if (uaNode.getReference(Identifiers.HasModellingRule, false) != null) {
                return;
            }
            if (uaNode instanceof GeneratedNode && ((uaReferenceArray = uaNode.getInverseReferences(Identifiers.Aggregates)) == null || uaReferenceArray.length == 0)) {
                ((GeneratedNode)uaNode).afterCreate();
            }
        }
        catch (Exception exception) {
            logger.error("Could not call afterCreate for item {}", (Object)addNodesItem, (Object)exception);
        }
    }

    @Override
    protected NodeId doAddNode(AddNodesItem addNodesItem) throws StatusException {
        logger.debug("doAddNode: {}", (Object)addNodesItem);
        return this.nodeManagerTable.addNode(ServiceContext.INTERNAL_OPERATION_CONTEXT, addNodesItem);
    }

    @Override
    protected void doAddReference(AddReferencesItem addReferencesItem) throws StatusException {
        this.nodeManagerTable.addReference(ServiceContext.INTERNAL_OPERATION_CONTEXT, addReferencesItem);
    }

    @Override
    protected NamespaceTable getNamespaceTable() {
        return this.nodeManagerTable.getNamespaceTable();
    }

    @Override
    protected UaNode getNode(NodeId nodeId) throws StatusException {
        return this.nodeManagerTable.getNode(nodeId);
    }

    @Override
    protected ServerTable getServerTable() {
        return this.nodeManagerTable.getServerTable();
    }
}

