/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ContentFilterBuilder;
import com.prosysopc.ua.DataTypeConversionException;
import com.prosysopc.ua.EventData;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AttributeOperand;
import com.prosysopc.ua.stack.core.ContentFilterElementResult;
import com.prosysopc.ua.stack.core.ElementOperand;
import com.prosysopc.ua.stack.core.FilterOperand;
import com.prosysopc.ua.stack.core.FilterOperator;
import com.prosysopc.ua.stack.core.LiteralOperand;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.core.RelativePathElement;
import com.prosysopc.ua.stack.core.SimpleAttributeOperand;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterOperatorDefinition {
    static Logger logger = LoggerFactory.getLogger(FilterOperatorDefinition.class);
    static final Map<Class<? extends FilterOperand>, Constructor<? extends OperandDefinition>> gc = new ConcurrentHashMap<Class<? extends FilterOperand>, Constructor<? extends OperandDefinition>>();
    static Map<FilterOperator, Constructor<? extends FilterOperatorDefinition>> gd = new ConcurrentHashMap<FilterOperator, Constructor<? extends FilterOperatorDefinition>>();
    private DiagnosticInfo ge;
    private final ContentFilterElementResult gf = new ContentFilterElementResult();
    private NodeManagerRoot gg;
    protected List<OperandDefinition> operandList;

    public static FilterOperatorDefinition newOperator(FilterOperator filterOperator, ExtensionObject[] extensionObjectArray, NodeManagerRoot nodeManagerRoot, FilterOperatorDefinition[] filterOperatorDefinitionArray) {
        FilterOperatorDefinition filterOperatorDefinition;
        logger.debug("newOperator: {} operandCount: {}", (Object)filterOperator, (Object)extensionObjectArray.length);
        ContentFilterBuilder.checkOperandCount(filterOperator, extensionObjectArray.length);
        Constructor<? extends FilterOperatorDefinition> constructor = gd.get(filterOperator);
        if (constructor == null) {
            return null;
        }
        try {
            filterOperatorDefinition = constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        filterOperatorDefinition.parse(extensionObjectArray, filterOperatorDefinitionArray, nodeManagerRoot);
        return filterOperatorDefinition;
    }

    private static void a(Class<? extends FilterOperand> clazz, Class<? extends OperandDefinition> clazz2) {
        try {
            Constructor<? extends OperandDefinition> constructor = clazz2.getConstructor(FilterOperand.class);
            gc.put(clazz, constructor);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    private static void a(FilterOperator filterOperator, Class<? extends FilterOperatorDefinition> clazz) {
        try {
            Constructor<? extends FilterOperatorDefinition> constructor = clazz.getConstructor(new Class[0]);
            gd.put(filterOperator, constructor);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    protected static boolean setTypeOfEventData(EventData eventData, NodeManagerUaNode nodeManagerUaNode) {
        UaType uaType = eventData.getEventType();
        if (uaType == null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("eventData.getEventTypeId()={}", (Object)eventData.getEventTypeId());
                }
                uaType = nodeManagerUaNode.getType(eventData.getEventTypeId());
                logger.debug("eventDataEventType={}", (Object)uaType);
                eventData.setEventType(uaType);
            }
            catch (StatusException statusException) {
                logger.warn("eventTypeEquals: Cannot find type node of eventData (eventTypeId=" + eventData.getEventTypeId() + ")", (Throwable)statusException);
                return false;
            }
        }
        return true;
    }

    public Object evaluate(EventData eventData, Boolean bl) {
        logger.debug("FilterOperatorDefinition.evaluate: return={}", (Object)bl);
        return null;
    }

    public DiagnosticInfo getElementDiagnosticInfo() {
        return this.ge;
    }

    public ContentFilterElementResult getElementResult() {
        return this.gf;
    }

    public final boolean parse(ExtensionObject[] extensionObjectArray, FilterOperatorDefinition[] filterOperatorDefinitionArray, NodeManagerRoot nodeManagerRoot) {
        logger.debug("{} parse", this.getClass());
        this.operandList = new ArrayList<OperandDefinition>(extensionObjectArray.length);
        this.gf.setStatusCode(StatusCode.GOOD);
        StatusCode[] statusCodeArray = new StatusCode[extensionObjectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[extensionObjectArray.length];
        for (int i2 = 0; i2 < extensionObjectArray.length; ++i2) {
            Object object;
            try {
                FilterOperand filterOperand = (FilterOperand)extensionObjectArray[i2].decode(nodeManagerRoot.getNodeManagerTable().getEncoderContext());
                try {
                    object = gc.get(filterOperand.getClass());
                    if (object == null) {
                        statusCodeArray[i2] = new StatusCode(StatusCodes.Bad_FilterOperandInvalid);
                    } else {
                        OperandDefinition operandDefinition = (OperandDefinition)((Constructor)object).newInstance(filterOperand);
                        operandDefinition.applyOperators(filterOperatorDefinitionArray);
                        try {
                            operandDefinition.applyNodeManager(nodeManagerRoot);
                            this.operandList.add(operandDefinition);
                            this.validateOperand(operandDefinition, i2);
                            statusCodeArray[i2] = StatusCode.GOOD;
                        }
                        catch (StatusException statusException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("FilterOperand {} invalid: {} diagnostics: {}", new Object[]{i2, statusException.getStatusCode(), statusException.getDiagnosticInfo()});
                            }
                            statusCodeArray[i2] = statusException.getStatusCode();
                            diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
                        }
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            catch (DecodingException decodingException) {
                logger.warn("FilterOperatorDefinition: ", (Throwable)decodingException);
                object = new ServiceException(decodingException);
                statusCodeArray[i2] = new StatusCode(StatusCodes.Bad_FilterOperandInvalid);
                diagnosticInfoArray[i2] = ((ServiceException)object).getDiagnosticInfo();
                if (this.gf.getStatusCode().isGood()) {
                    this.gf.setStatusCode(new StatusCode(StatusCodes.Bad_FilterOperatorInvalid));
                }
            }
            catch (ClassCastException classCastException) {
                logger.warn("FilterOperatorDefinition: ", (Throwable)classCastException);
                statusCodeArray[i2] = new StatusCode(StatusCodes.Bad_FilterOperandInvalid);
                diagnosticInfoArray[i2] = null;
            }
            if (!statusCodeArray[i2].isBad() || !this.gf.getStatusCode().isGood()) continue;
            this.gf.setStatusCode(new StatusCode(StatusCodes.Bad_FilterOperatorInvalid));
        }
        this.gf.setOperandStatusCodes(statusCodeArray);
        this.gf.setOperandDiagnosticInfos(diagnosticInfoArray);
        try {
            this.applyNodeManager(nodeManagerRoot);
        }
        catch (StatusException statusException) {
            this.gf.setStatusCode(new StatusCode(StatusCodes.Bad_FilterOperatorInvalid));
        }
        return this.gf.getStatusCode().isGood();
    }

    protected void applyNodeManager(NodeManagerRoot nodeManagerRoot) throws StatusException {
        this.gg = nodeManagerRoot;
    }

    protected Boolean asBoolean(Variant variant) {
        if (this.isNull(variant)) {
            return null;
        }
        try {
            return variant.booleanValue();
        }
        catch (ClassCastException classCastException) {
            logger.warn("Cannot convert variant {} to Boolean: using null", (Object)variant);
            return null;
        }
    }

    protected Boolean eventTypeEquals(UaType uaType, NodeId nodeId, EventData eventData) {
        try {
            return this.getNodeManager().isOfType(eventData.getEventTypeId(), eventData.getEventType(), nodeId, uaType);
        }
        catch (StatusException statusException) {
            logger.debug("EventTypeId not referring to a valid node", (Throwable)statusException);
            return false;
        }
    }

    protected NodeManagerRoot getNodeManager() {
        return this.gg;
    }

    protected boolean isNull(Variant variant) {
        return variant == null || variant.isEmpty();
    }

    protected void validateOperand(OperandDefinition operandDefinition, int n2) throws StatusException {
    }

    static {
        FilterOperatorDefinition.a(LiteralOperand.class, OperandDefinition.LiteralOperandDefinition.class);
        FilterOperatorDefinition.a(ElementOperand.class, OperandDefinition.ElementOperandDefinition.class);
        FilterOperatorDefinition.a(SimpleAttributeOperand.class, OperandDefinition.SimpleAttributeOperandDefinition.class);
        FilterOperatorDefinition.a(AttributeOperand.class, OperandDefinition.AttributeOperandDefinition.class);
        FilterOperatorDefinition.a(FilterOperator.OfType, r.class);
        FilterOperatorDefinition.a(FilterOperator.Equals, i.class);
        FilterOperatorDefinition.a(FilterOperator.IsNull, m.class);
        FilterOperatorDefinition.a(FilterOperator.GreaterThan, j.class);
        FilterOperatorDefinition.a(FilterOperator.GreaterThanOrEqual, k.class);
        FilterOperatorDefinition.a(FilterOperator.LessThan, n.class);
        FilterOperatorDefinition.a(FilterOperator.LessThanOrEqual, o.class);
        FilterOperatorDefinition.a(FilterOperator.Like, p.class);
        FilterOperatorDefinition.a(FilterOperator.Not, q.class);
        FilterOperatorDefinition.a(FilterOperator.Between, b.class);
        FilterOperatorDefinition.a(FilterOperator.InList, l.class);
        FilterOperatorDefinition.a(FilterOperator.And, a.class);
        FilterOperatorDefinition.a(FilterOperator.Or, s.class);
        FilterOperatorDefinition.a(FilterOperator.Cast, g.class);
        FilterOperatorDefinition.a(FilterOperator.BitwiseAnd, c.class);
        FilterOperatorDefinition.a(FilterOperator.BitwiseOr, e.class);
    }

    static class s
    extends f {
        @Override
        protected Object a(boolean bl, boolean bl2) {
            return bl || bl2;
        }

        @Override
        protected Boolean aX() {
            return true;
        }
    }

    static class OperandDefinition {
        protected final FilterOperand operand;

        public OperandDefinition(FilterOperand filterOperand) {
            this.operand = filterOperand;
        }

        public void applyOperators(FilterOperatorDefinition[] filterOperatorDefinitionArray) {
        }

        public FilterOperatorDefinition getOperator() {
            return null;
        }

        public Variant getValue(EventData eventData, Boolean bl) {
            return null;
        }

        protected void applyNodeManager(NodeManagerUaNode nodeManagerUaNode) throws StatusException {
        }

        public static class SimpleAttributeOperandDefinition
        extends AbstractAttributeOperandDefinition {
            final SimpleAttributeOperand go;

            public SimpleAttributeOperandDefinition(FilterOperand filterOperand) {
                super(filterOperand);
                this.go = (SimpleAttributeOperand)filterOperand;
            }

            public SimpleAttributeOperand getOperand() {
                return this.go;
            }

            @Override
            protected QualifiedName[] getBrowsePath() {
                return this.go.getBrowsePath();
            }

            @Override
            protected NodeId getTypeDefinitionId() {
                return this.go.getTypeDefinitionId();
            }
        }

        public static class LiteralOperandDefinition
        extends OperandDefinition {
            private final Variant gn;

            public LiteralOperandDefinition(FilterOperand filterOperand) {
                super(filterOperand);
                this.gn = new Variant(((LiteralOperand)filterOperand).getValue());
            }

            @Override
            public Variant getValue(EventData eventData, Boolean bl) {
                return this.gn;
            }
        }

        public static class ElementOperandDefinition
        extends OperandDefinition {
            private final int index;
            private FilterOperatorDefinition gm;

            public ElementOperandDefinition(FilterOperand filterOperand) {
                super(filterOperand);
                this.index = ((ElementOperand)filterOperand).getIndex().intValue();
            }

            @Override
            public void applyOperators(FilterOperatorDefinition[] filterOperatorDefinitionArray) {
                super.applyOperators(filterOperatorDefinitionArray);
                this.gm = filterOperatorDefinitionArray[this.index];
            }

            public long getIndex() {
                return this.index;
            }

            @Override
            public FilterOperatorDefinition getOperator() {
                return this.gm;
            }

            @Override
            public Variant getValue(EventData eventData, Boolean bl) {
                Object object = this.getOperator().evaluate(eventData, bl);
                if (object instanceof Variant) {
                    return (Variant)object;
                }
                return new Variant(object);
            }
        }

        public static class AttributeOperandDefinition
        extends AbstractAttributeOperandDefinition {
            final AttributeOperand gl;

            public AttributeOperandDefinition(FilterOperand filterOperand) {
                super(filterOperand);
                this.gl = (AttributeOperand)filterOperand;
            }

            public AttributeOperand getOperand() {
                return this.gl;
            }

            private QualifiedName[] a(RelativePath relativePath) {
                ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>();
                for (RelativePathElement relativePathElement : relativePath.getElements()) {
                    arrayList.add(relativePathElement.getTargetName());
                }
                return arrayList.toArray(new QualifiedName[arrayList.size()]);
            }

            @Override
            protected QualifiedName[] getBrowsePath() {
                return this.a(this.gl.getBrowsePath());
            }

            @Override
            protected NodeId getTypeDefinitionId() {
                return this.gl.getNodeId();
            }
        }

        public static abstract class AbstractAttributeOperandDefinition
        extends OperandDefinition {
            private UaType ae;
            private NodeManagerUaNode nodeManager;

            public AbstractAttributeOperandDefinition(FilterOperand filterOperand) {
                super(filterOperand);
            }

            public UaType getEventType() {
                return this.ae;
            }

            @Override
            public Variant getValue(EventData eventData, Boolean bl) {
                logger.debug("getValue: eventType={}", (Object)this.ae);
                if (this.ae != null) {
                    FilterOperatorDefinition.setTypeOfEventData(eventData, this.nodeManager);
                    logger.debug("getValue: eventData.getEventType()={}", (Object)eventData.getEventType());
                    if (!this.eventTypeEquals(this.ae, this.getTypeDefinitionId(), eventData).booleanValue()) {
                        return null;
                    }
                }
                return eventData.getFieldValue(this.getBrowsePath());
            }

            public void setEventType(UaType uaType) {
                this.ae = uaType;
            }

            @Override
            protected void applyNodeManager(NodeManagerUaNode nodeManagerUaNode) throws StatusException {
                logger.debug("SimpleAttributeOperandDefinition.applyNodeManager: {}", (Object)nodeManagerUaNode);
                this.nodeManager = nodeManagerUaNode;
                super.applyNodeManager(nodeManagerUaNode);
                logger.debug("getTypeDefinitionId()={}", (Object)this.getTypeDefinitionId());
                if (!NodeId.isNull(this.getTypeDefinitionId())) {
                    this.ae = nodeManagerUaNode != null ? nodeManagerUaNode.getType(this.getTypeDefinitionId()) : null;
                }
            }

            protected Boolean eventTypeEquals(UaType uaType, NodeId nodeId, EventData eventData) {
                try {
                    return this.nodeManager.isOfType(eventData.getEventTypeId(), eventData.getEventType(), nodeId, uaType);
                }
                catch (StatusException statusException) {
                    logger.debug("EventTypeId not referring to a valid node", (Throwable)statusException);
                    return false;
                }
            }

            protected abstract QualifiedName[] getBrowsePath();

            protected abstract NodeId getTypeDefinitionId();
        }
    }

    static class r
    extends FilterOperatorDefinition {
        private UaType gj;
        private NodeId gk;

        @Override
        public Object evaluate(EventData eventData, Boolean bl) {
            logger.debug("OfType evaluate: filteredEventTypeId={}", (Object)this.gk);
            if (!NodeId.isNull(this.gk)) {
                logger.debug("OfType evaluate: filteredEventType={}", (Object)this.gj);
                if (this.gj != null) {
                    r.setTypeOfEventData(eventData, this.getNodeManager());
                }
                Boolean bl2 = this.eventTypeEquals(this.gj, this.gk, eventData);
                logger.debug("OfType evaluate: return={}", (Object)bl2);
                return bl2;
            }
            return bl != false ? null : Boolean.valueOf(false);
        }

        public UaType aY() {
            return this.gj;
        }

        public NodeId aZ() {
            return this.gk;
        }

        @Override
        protected void applyNodeManager(NodeManagerRoot nodeManagerRoot) throws StatusException {
            logger.debug("OfTypeOperatorDefinition.applyNodeManager");
            super.applyNodeManager(nodeManagerRoot);
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            Variant variant = operandDefinition.getValue(null, null);
            this.gk = variant == null ? NodeId.NULL : variant.asClass(NodeId.class, NodeId.NULL);
            try {
                if (NodeId.isNull(this.gk)) {
                    throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
                }
                this.gj = nodeManagerRoot != null ? nodeManagerRoot.getType(this.gk) : null;
                logger.debug("OfTypeOperatorDefinition.applyNodeManager: filteredEventType={}", (Object)this.gj);
            }
            catch (ClassCastException classCastException) {
                StatusCode statusCode;
                this.getElementResult().getOperandStatusCodes()[0] = statusCode = new StatusCode(StatusCodes.Bad_FilterOperandInvalid);
                throw new StatusException("Node is not a Type", statusCode);
            }
            catch (StatusException statusException) {
                this.getElementResult().getOperandStatusCodes()[0] = new StatusCode(StatusCodes.Bad_NodeIdUnknown);
                throw statusException;
            }
        }
    }

    static class q
    extends FilterOperatorDefinition {
        @Override
        public Object evaluate(EventData eventData, Boolean bl) {
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            Variant variant = operandDefinition.getValue(eventData, bl);
            Boolean bl2 = this.asBoolean(variant);
            return bl2 == null ? null : Boolean.valueOf(bl2 == false);
        }
    }

    static class p
    extends h {
        private String gi = null;

        private String d(String string) {
            string = string.replace("*", "[*]").replace(".", "[.]");
            string = string.replace("%", ".*").replace("_", ".");
            string = string.replace("\\.*", "%").replace("\\.", "_");
            return string;
        }

        private String e(String string) {
            int n2;
            int n3;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n4 = 0;
            while (n4 < string.length() && (n3 = string.indexOf(91, n4)) >= 0 && (n2 = string.indexOf(93, n3)) >= 0) {
                arrayList.add(this.d(string.substring(n4, n3)));
                n4 = n2 + 1;
                arrayList.add(string.substring(n3, n4));
            }
            arrayList.add(this.d(string.substring(n4)));
            StringBuilder stringBuilder = new StringBuilder();
            if (!string.startsWith(".*")) {
                stringBuilder.append("^");
            }
            for (String string2 : arrayList) {
                stringBuilder.append(string2);
            }
            if (!string.endsWith(".*")) {
                stringBuilder.append("$");
            }
            String string3 = stringBuilder.toString();
            return string3;
        }

        @Override
        protected Object b(Variant variant, Variant variant2) {
            String string = variant.getValue().toString();
            String string2 = this.gi != null ? this.gi : this.e(variant2.getValue().toString());
            logger.debug("regexp={}", (Object)string2);
            return string.matches(string2);
        }

        @Override
        protected void validateOperand(OperandDefinition operandDefinition, int n2) throws StatusException {
            super.validateOperand(operandDefinition, n2);
            if (n2 == 1 && operandDefinition instanceof OperandDefinition.LiteralOperandDefinition) {
                try {
                    this.gi = this.e(operandDefinition.getValue(null, true).getValue().toString());
                    this.evaluate(null, true);
                }
                catch (Exception exception) {
                    throw new StatusException(StatusCodes.Bad_FilterOperandInvalid, (Throwable)exception);
                }
            }
        }
    }

    static class o
    extends h {
        @Override
        protected Object b(Variant variant, Variant variant2) {
            return variant.compareTo(variant2) <= 0;
        }
    }

    static class n
    extends h {
        @Override
        protected Object b(Variant variant, Variant variant2) {
            return variant.compareTo(variant2) < 0;
        }
    }

    static class m
    extends FilterOperatorDefinition {
        @Override
        public Object evaluate(EventData eventData, Boolean bl) {
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            Variant variant = operandDefinition.getValue(eventData, bl);
            logger.debug("value={}", (Object)variant);
            boolean bl2 = this.isNull(variant);
            if (bl2 && bl.booleanValue()) {
                return null;
            }
            return bl2;
        }
    }

    static class l
    extends FilterOperatorDefinition {
        @Override
        public Object evaluate(EventData eventData, Boolean bl) {
            if (logger.isDebugEnabled()) {
                logger.debug("evaluate: operandList.count={}", (Object)this.operandList.size());
            }
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            Variant variant = operandDefinition.getValue(eventData, bl);
            logger.debug("evaluate: value1={}", (Object)variant);
            if (variant == null) {
                return null;
            }
            for (int i2 = 1; i2 < this.operandList.size(); ++i2) {
                OperandDefinition operandDefinition2 = (OperandDefinition)this.operandList.get(i2);
                Variant variant2 = operandDefinition2.getValue(eventData, bl);
                logger.debug("evaluate: value2={}", (Object)variant2);
                if (this.isNull(variant2)) continue;
                try {
                    if (!variant.valueEquals(variant2)) continue;
                    return true;
                }
                catch (RuntimeException runtimeException) {
                    logger.warn("Cannot compare filtered values {} vs. {}", (Object)operandDefinition, (Object)operandDefinition2);
                }
            }
            return false;
        }
    }

    static class k
    extends h {
        @Override
        protected Object b(Variant variant, Variant variant2) {
            return variant.compareTo(variant2) >= 0;
        }
    }

    static class j
    extends h {
        @Override
        protected Object b(Variant variant, Variant variant2) {
            return variant.compareTo(variant2) > 0;
        }
    }

    static class i
    extends h {
        @Override
        protected Object b(Variant variant, Variant variant2) {
            return variant.valueEquals(variant2);
        }
    }

    static abstract class h
    extends FilterOperatorDefinition {
        private static final Map<Class<?>, Integer> gh = new HashMap();
        static Logger logger = LoggerFactory.getLogger(h.class);

        h() {
        }

        private static int b(Class<?> clazz) throws IllegalArgumentException {
            Integer n2 = gh.get(clazz);
            logger.debug("classPrecedenceIndex: clazz={}->{}", clazz, (Object)n2);
            if (n2 == null) {
                throw new IllegalArgumentException("Class not found from precedence table: " + clazz);
            }
            return n2;
        }

        private static boolean b(Class<?> clazz, Class<?> clazz2) {
            try {
                return h.b(clazz) < h.b(clazz2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        @Override
        public Object evaluate(EventData eventData, Boolean bl) {
            if (logger.isDebugEnabled()) {
                logger.debug("evaluate: operandList.count={}", (Object)this.operandList.size());
            }
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            OperandDefinition operandDefinition2 = (OperandDefinition)this.operandList.get(1);
            Variant variant = operandDefinition.getValue(eventData, bl);
            Variant variant2 = operandDefinition2.getValue(eventData, bl);
            logger.debug("evaluate: value1={}", (Object)variant);
            logger.debug("evaluate: value2={}", (Object)variant2);
            if (!this.isNull(variant) && !this.isNull(variant2)) {
                try {
                    variant = this.a(variant, variant2);
                    variant2 = this.a(variant2, variant);
                    logger.debug("evaluate (convertImplicit): value1={}", (Object)variant);
                    logger.debug("evaluate (convertImplicit): value2={}", (Object)variant2);
                    return this.b(variant, variant2);
                }
                catch (DataTypeConversionException dataTypeConversionException) {
                    logger.warn(String.format("Cannot compare filtered values %s vs. %s: ", operandDefinition, operandDefinition2), (Throwable)dataTypeConversionException);
                    return null;
                }
            }
            return super.evaluate(eventData, bl);
        }

        private Variant a(Variant variant, Variant variant2) throws DataTypeConversionException {
            if (variant.isEmpty() || variant2.isEmpty()) {
                return variant;
            }
            Class<?> clazz = variant.getCompositeClass();
            Class<?> clazz2 = variant2.getCompositeClass();
            if (variant.isArray() && !variant2.isArray() || h.b(clazz2, clazz)) {
                if (variant2.isArray()) {
                    clazz2 = Array.newInstance(clazz2, 0).getClass();
                }
                return this.getNodeManager().getDataTypeConverter().convert(variant, clazz2);
            }
            return variant;
        }

        protected abstract Object b(Variant var1, Variant var2);

        static {
            gh.put(Double.class, 1);
            gh.put(Float.class, 2);
            gh.put(Long.class, 3);
            gh.put(UnsignedLong.class, 4);
            gh.put(Integer.class, 5);
            gh.put(UnsignedInteger.class, 6);
            gh.put(StatusCode.class, 7);
            gh.put(Short.class, 8);
            gh.put(UnsignedShort.class, 9);
            gh.put(Byte.class, 10);
            gh.put(UnsignedByte.class, 11);
            gh.put(Boolean.class, 12);
            gh.put(UUID.class, 13);
            gh.put(String.class, 14);
            gh.put(ExpandedNodeId.class, 15);
            gh.put(NodeId.class, 16);
            gh.put(LocalizedText.class, 17);
            gh.put(QualifiedName.class, 18);
        }
    }

    static class g
    extends FilterOperatorDefinition {
        @Override
        public Object evaluate(EventData eventData, Boolean bl) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cast evaluate: operandList.count={}", (Object)this.operandList.size());
            }
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            OperandDefinition operandDefinition2 = (OperandDefinition)this.operandList.get(1);
            Variant variant = operandDefinition.getValue(eventData, bl);
            Variant variant2 = operandDefinition2.getValue(eventData, bl);
            logger.debug("Cast evaluate: value1={}", (Object)variant);
            logger.debug("Cast evaluate: value2={}", (Object)variant2);
            if (!this.isNull(variant) && !this.isNull(variant2)) {
                NodeId nodeId = variant2.asClass(NodeId.class, null);
                if (nodeId == null) {
                    logger.warn("Cannot find type to cast: {}", (Object)operandDefinition2);
                    return null;
                }
                try {
                    Variant variant3 = this.getNodeManager().getDataTypeConverter().convert(variant, nodeId);
                    logger.debug("result={}", (Object)variant3);
                    return variant3;
                }
                catch (DataTypeConversionException dataTypeConversionException) {
                    logger.warn(String.format("Cast of value %s to type %s failed:", variant, variant2), (Throwable)dataTypeConversionException);
                    return null;
                }
            }
            return super.evaluate(eventData, bl);
        }
    }

    static abstract class f
    extends FilterOperatorDefinition {
        f() {
        }

        @Override
        public Object evaluate(EventData eventData, Boolean bl) {
            if (logger.isDebugEnabled()) {
                logger.debug("evaluate: operandList.count={}", (Object)this.operandList.size());
            }
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            OperandDefinition operandDefinition2 = (OperandDefinition)this.operandList.get(1);
            Variant variant = operandDefinition.getValue(eventData, bl);
            Variant variant2 = operandDefinition2.getValue(eventData, bl);
            logger.debug("BooleanOperatorDefinition.evaluate: value1={}", (Object)variant);
            logger.debug("BooleanOperatorDefinition.evaluate: value2={}", (Object)variant2);
            Boolean bl2 = this.asBoolean(variant);
            Boolean bl3 = this.asBoolean(variant2);
            Object object = bl2 == null && bl3 == null ? super.evaluate(eventData, bl) : (bl2 == null ? (bl.booleanValue() ? bl3 : (bl3 == this.aX() ? this.aX() : super.evaluate(eventData, bl))) : (bl3 == null ? (bl.booleanValue() ? bl2 : (bl2 == this.aX() ? this.aX() : super.evaluate(eventData, bl))) : this.a(bl2, bl3)));
            logger.debug("BooleanOperatorDefinition.evaluate: result={}", object);
            return object;
        }

        protected abstract Object a(boolean var1, boolean var2);

        protected abstract Boolean aX();
    }

    static class e
    extends d {
        @Override
        protected long a(long l2, long l3) {
            return l2 | l3;
        }
    }

    static abstract class d
    extends FilterOperatorDefinition {
        @Override
        public Object evaluate(EventData eventData, Boolean bl) {
            if (logger.isDebugEnabled()) {
                logger.debug("evaluate: operandList.count={}", (Object)this.operandList.size());
            }
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            OperandDefinition operandDefinition2 = (OperandDefinition)this.operandList.get(1);
            Variant variant = operandDefinition.getValue(eventData, bl);
            Variant variant2 = operandDefinition2.getValue(eventData, bl);
            logger.debug("evaluate: value1={}", (Object)variant);
            logger.debug("evaluate: value2={}", (Object)variant2);
            if (!this.isNull(variant) && !this.isNull(variant2)) {
                try {
                    long l2 = variant.longValue();
                    long l3 = variant2.longValue();
                    long l4 = this.a(l2, l3);
                    logger.debug("result={}", (Object)l4);
                    return l4;
                }
                catch (ClassCastException classCastException) {
                    logger.warn("Cannot compare filtered values {} vs. {}", (Object)operandDefinition, (Object)operandDefinition2);
                }
            }
            return super.evaluate(eventData, bl);
        }

        protected abstract long a(long var1, long var3);
    }

    static class c
    extends d {
        @Override
        protected long a(long l2, long l3) {
            return l2 & l3;
        }
    }

    static class b
    extends FilterOperatorDefinition {
        @Override
        public Object evaluate(EventData eventData, Boolean bl) {
            if (logger.isDebugEnabled()) {
                logger.debug("evaluate: operandList.count={}", (Object)this.operandList.size());
            }
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            OperandDefinition operandDefinition2 = (OperandDefinition)this.operandList.get(1);
            OperandDefinition operandDefinition3 = (OperandDefinition)this.operandList.get(2);
            Variant variant = operandDefinition.getValue(eventData, bl);
            Variant variant2 = operandDefinition2.getValue(eventData, bl);
            Variant variant3 = operandDefinition3.getValue(eventData, bl);
            logger.debug("evaluate: value1={}", (Object)variant);
            logger.debug("evaluate: value2={}", (Object)variant2);
            logger.debug("evaluate: value3={}", (Object)variant3);
            if (!this.isNull(variant) && !this.isNull(variant2)) {
                try {
                    return variant.compareTo(variant2) >= 0 && variant.compareTo(variant3) <= 0;
                }
                catch (RuntimeException runtimeException) {
                    logger.warn("Cannot compare filtered values {} vs. {}", (Object)operandDefinition, (Object)operandDefinition2);
                }
            }
            return super.evaluate(eventData, bl);
        }
    }

    static class a
    extends f {
        @Override
        protected Object a(boolean bl, boolean bl2) {
            return bl && bl2;
        }

        @Override
        protected Boolean aX() {
            return false;
        }
    }
}

