/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.nodes.UaClientReference;
import com.prosysopc.ua.client.nodes.UaTypeImpl;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ReferenceTypeAttributes;
import java.util.List;
import java.util.Locale;

public class UaReferenceTypeImpl
extends UaTypeImpl
implements UaReferenceType {
    LocalizedText inverseName = null;
    Boolean symmetric = true;

    public UaReferenceTypeImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    public UaReferenceTypeImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
        this.symmetric = false;
        this.inverseName = localizedText2;
    }

    public UaReferenceTypeImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, AttributeWriteMask attributeWriteMask, AttributeWriteMask attributeWriteMask2, UaClientReference[] uaClientReferenceArray, UaProperty[] uaPropertyArray, Boolean bl, Boolean bl2, LocalizedText localizedText3) {
        super(addressSpace, nodeId, qualifiedName, localizedText, localizedText2, attributeWriteMask, attributeWriteMask2, uaClientReferenceArray, uaPropertyArray, bl);
        this.symmetric = bl2;
        this.inverseName = localizedText3;
    }

    public UaReferenceTypeImpl(AddressSpace addressSpace, NodeId nodeId, String string, Locale locale) {
        super(addressSpace, nodeId, string, locale);
    }

    public UaReferenceTypeImpl(AddressSpace addressSpace, NodeId nodeId, String string, String string2, Locale locale) {
        super(addressSpace, nodeId, string, locale);
        this.symmetric = false;
        this.inverseName = new LocalizedText(string2, locale);
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new ReferenceTypeAttributes());
    }

    @Override
    public LocalizedText getInverseName() {
        if (this.symmetric.booleanValue()) {
            return this.getDisplayName();
        }
        return this.inverseName;
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.ReferenceType;
    }

    @Override
    public Boolean getSymmetric() {
        return this.symmetric;
    }

    public void setAttributes(ReferenceTypeAttributes referenceTypeAttributes) {
        this.setInverseName(referenceTypeAttributes.getInverseName());
        this.setSymmetric(referenceTypeAttributes.getSymmetric());
        super.setAttributes(referenceTypeAttributes);
    }

    @Override
    public void setInverseName(LocalizedText localizedText) {
        this.inverseName = localizedText;
        this.symmetric = localizedText == null;
    }

    @Override
    public void setSymmetric(Boolean bl) {
        this.symmetric = bl;
        if (bl.booleanValue()) {
            this.inverseName = null;
        }
    }

    @Override
    public String toString() {
        return super.toString() + String.format(", Symmetric=%s, InverseName=%s", this.symmetric, this.inverseName);
    }

    protected ReferenceTypeAttributes getAttributes(ReferenceTypeAttributes referenceTypeAttributes) {
        super.getAttributes(referenceTypeAttributes);
        referenceTypeAttributes.setInverseName(this.getInverseName());
        referenceTypeAttributes.setIsAbstract(this.getIsAbstract());
        referenceTypeAttributes.setSymmetric(this.getSymmetric());
        return referenceTypeAttributes;
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.Symmetric);
        list.add(Attributes.InverseName);
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals(Attributes.Symmetric)) {
            dataValue.setValue(new Variant(this.symmetric));
        } else if (unsignedInteger.equals(Attributes.InverseName)) {
            dataValue.setValue(new Variant(this.inverseName));
        } else {
            super.readAttributeValue(unsignedInteger, dataValue);
        }
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        if (unsignedInteger.equals(Attributes.Symmetric)) {
            this.symmetric = (Boolean)object;
        } else if (unsignedInteger.equals(Attributes.InverseName)) {
            this.inverseName = (LocalizedText)object;
        } else {
            super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
        }
    }
}

