/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client.nodes;

import com.prosysopc.ua.RegisteredClasses;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.nodes.UaDataTypeImpl;
import com.prosysopc.ua.client.nodes.UaMethodImpl;
import com.prosysopc.ua.client.nodes.UaObjectImpl;
import com.prosysopc.ua.client.nodes.UaObjectTypeImpl;
import com.prosysopc.ua.client.nodes.UaPropertyImpl;
import com.prosysopc.ua.client.nodes.UaReferenceTypeImpl;
import com.prosysopc.ua.client.nodes.UaVariableImpl;
import com.prosysopc.ua.client.nodes.UaVariableTypeImpl;
import com.prosysopc.ua.client.nodes.UaViewImpl;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactory;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeClass;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaClientNodeFactory
implements UaNodeFactory {
    private static final Logger logger = LoggerFactory.getLogger(UaClientNodeFactory.class);
    private static final Map<NodeId, Class<?>> fi = new HashMap();
    private final AddressSpace addressSpace;
    private final Map<NodeClass, Constructor<? extends UaNode>> fj;
    private final Map<NodeId, Constructor<? extends UaNode>> fk;
    final RegisteredClasses cc;

    public UaClientNodeFactory(AddressSpace addressSpace) {
        this.addressSpace = addressSpace;
        this.cc = addressSpace != null ? addressSpace.getClient().getRegisteredClasses() : null;
        this.fj = new HashMap<NodeClass, Constructor<? extends UaNode>>();
        this.fk = new HashMap<NodeId, Constructor<? extends UaNode>>();
        try {
            this.registerNodeClass(NodeClass.Object, UaObjectImpl.class);
            this.registerNodeClass(NodeClass.Variable, UaVariableImpl.class);
            this.registerNodeClass(NodeClass.Method, UaMethodImpl.class);
            this.registerNodeClass(NodeClass.ObjectType, UaObjectTypeImpl.class);
            this.registerNodeClass(NodeClass.VariableType, UaVariableTypeImpl.class);
            this.registerNodeClass(NodeClass.ReferenceType, UaReferenceTypeImpl.class);
            this.registerNodeClass(NodeClass.DataType, UaDataTypeImpl.class);
            this.registerNodeClass(NodeClass.View, UaViewImpl.class);
            this.registerTypeDefinition(Identifiers.PropertyType, UaPropertyImpl.class);
        }
        catch (UaNodeFactoryException uaNodeFactoryException) {
            uaNodeFactoryException.printStackTrace();
        }
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, qualifiedName, localizedText, (NodeId)null);
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, ExpandedNodeId expandedNodeId) throws UaNodeFactoryException {
        Constructor<? extends UaNode> constructor = this.getConstructor(nodeClass, expandedNodeId);
        if (constructor == null) {
            throw new UaNodeFactoryException(String.format("Cannot find constructor for nodeClass=%s typeDefinition=%s", nodeClass, expandedNodeId), null);
        }
        return this.a(constructor, nodeId, qualifiedName, localizedText, expandedNodeId);
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, NodeId nodeId2) throws UaNodeFactoryException {
        Constructor<? extends UaNode> constructor = this.getConstructor(nodeClass, nodeId2);
        return this.a(constructor, nodeId, qualifiedName, localizedText, nodeId2 == null ? null : new ExpandedNodeId(nodeId2));
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, String string, Locale locale) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, new QualifiedName(string), new LocalizedText(string, locale));
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, String string, Locale locale, ExpandedNodeId expandedNodeId) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, new QualifiedName(string), new LocalizedText(string, locale), expandedNodeId);
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, String string, Locale locale, NodeId nodeId2) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, new QualifiedName(string), new LocalizedText(string, locale), nodeId2);
    }

    @Override
    public Class<? extends UaNode> getClassType(NodeClass nodeClass, ExpandedNodeId expandedNodeId) {
        return this.getConstructor(nodeClass, expandedNodeId).getDeclaringClass();
    }

    @Override
    public Class<? extends UaNode> getClassType(NodeClass nodeClass, NodeId nodeId) {
        return this.getConstructor(nodeClass, nodeId).getDeclaringClass();
    }

    @Override
    public void registerNodeClass(NodeClass nodeClass, Class<? extends UaNode> clazz) throws UaNodeFactoryException {
        this.fj.put(nodeClass, this.a(clazz));
    }

    @Override
    public void registerTypeDefinition(NodeId nodeId, Class<? extends UaNode> clazz) throws UaNodeFactoryException {
        this.fk.put(nodeId, this.a(clazz));
    }

    private UaNode a(Constructor<? extends UaNode> constructor, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, ExpandedNodeId expandedNodeId) throws UaNodeFactoryException {
        logger.debug("createInstance: {}", constructor);
        try {
            UaNode uaNode = constructor.newInstance(this.addressSpace, nodeId, qualifiedName, localizedText);
            if (uaNode instanceof UaInstance) {
                ((UaInstance)uaNode).setTypeDefinitionId(expandedNodeId);
            }
            if (uaNode instanceof UaType && fi.containsKey(uaNode.getNodeId())) {
                ((UaType)uaNode).setJavaClass(fi.get(uaNode.getNodeId()));
            }
            return uaNode;
        }
        catch (Exception exception) {
            throw new UaNodeFactoryException("Cannot create a new UaNode instance of class " + constructor.getName(), exception);
        }
    }

    private Constructor<? extends UaNode> a(Class<? extends UaNode> clazz) throws UaNodeFactoryException {
        try {
            Constructor<? extends UaNode> constructor = clazz.getDeclaredConstructor(AddressSpace.class, NodeId.class, QualifiedName.class, LocalizedText.class);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new UaNodeFactoryException("Cannot create a new UaNode instance: The constructor(NodeId, QualifiedName, LocalizedText) is not found from class " + clazz.getName(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new UaNodeFactoryException("Cannot create a new UaNode instance: The constructor(NodeId, QualifiedName, LocalizedText) is not public or accessible in class " + clazz.getName(), securityException);
        }
    }

    protected Constructor<? extends UaNode> getConstructor(NodeClass nodeClass, ExpandedNodeId expandedNodeId) {
        NodeId nodeId = null;
        if (!ExpandedNodeId.isNull(expandedNodeId) && expandedNodeId.isLocal()) {
            try {
                nodeId = this.addressSpace.getNamespaceTable().toNodeId(expandedNodeId);
            }
            catch (ServiceResultException serviceResultException) {
                logger.warn("ServiceResultException: ", (Throwable)serviceResultException);
            }
        }
        return this.getConstructor(nodeClass, nodeId);
    }

    protected Constructor<? extends UaNode> getConstructor(NodeClass nodeClass, NodeId nodeId) {
        if (nodeId != null) {
            if (this.fk.containsKey(nodeId)) {
                return this.fk.get(nodeId);
            }
            ExpandedNodeId expandedNodeId = new ExpandedNodeId(null, this.addressSpace.getNamespaceTable().getUri(nodeId.getNamespaceIndex()), nodeId.getValue());
            if (this.cc.containsClass(expandedNodeId)) {
                return this.a(this.cc.getClass(expandedNodeId));
            }
            UaType uaType = null;
            try {
                UaType uaType2 = this.addressSpace.getType(nodeId);
                uaType = uaType2.getSuperType();
            }
            catch (Exception exception) {
                logger.error("Could not resolve super type as UaType, typeId: " + nodeId);
            }
            if (uaType != null) {
                return this.getConstructor(nodeClass, uaType.getNodeId());
            }
        }
        return this.fj.get(nodeClass);
    }

    static {
        fi.put(Identifiers.Integer, Integer.class);
        fi.put(Identifiers.SByte, Byte.class);
        fi.put(Identifiers.Int16, Short.class);
        fi.put(Identifiers.Int32, Integer.class);
        fi.put(Identifiers.Int64, Long.class);
        fi.put(Identifiers.UInteger, UnsignedInteger.class);
        fi.put(Identifiers.Byte, UnsignedByte.class);
        fi.put(Identifiers.UInt16, UnsignedShort.class);
        fi.put(Identifiers.UInt32, UnsignedInteger.class);
        fi.put(Identifiers.UInt64, UnsignedLong.class);
        fi.put(Identifiers.Float, Float.class);
        fi.put(Identifiers.Decimal, BigDecimal.class);
        fi.put(Identifiers.Double, Double.class);
        fi.put(Identifiers.Boolean, Boolean.class);
        fi.put(Identifiers.ByteString, ByteString.class);
        fi.put(Identifiers.Enumeration, Integer.class);
        fi.put(Identifiers.QualifiedName, QualifiedName.class);
        fi.put(Identifiers.String, String.class);
        fi.put(Identifiers.Guid, UUID.class);
        fi.put(Identifiers.DateTime, DateTime.class);
        fi.put(Identifiers.DataValue, DataValue.class);
        fi.put(Identifiers.DiagnosticInfo, DiagnosticInfo.class);
        fi.put(Identifiers.LocalizedText, LocalizedText.class);
        fi.put(Identifiers.ExpandedNodeId, ExpandedNodeId.class);
        fi.put(Identifiers.NodeId, NodeId.class);
        fi.put(Identifiers.XmlElement, XmlElement.class);
        fi.put(Identifiers.StatusCode, StatusCode.class);
    }
}

