/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.DataTypeConversionException;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.OperationLimits;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.SessionActivationException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.UaAddress;
import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UserIdentity;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.ClientCodegenModel;
import com.prosysopc.ua.client.ClientCodegenModelProvider;
import com.prosysopc.ua.client.ConnectException;
import com.prosysopc.ua.client.InvalidServerEndpointException;
import com.prosysopc.ua.client.ServerConnectionException;
import com.prosysopc.ua.client.ServerStatusListener;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.UaClientListener;
import com.prosysopc.ua.client.h;
import com.prosysopc.ua.client.i;
import com.prosysopc.ua.stack.application.Application;
import com.prosysopc.ua.stack.application.Client;
import com.prosysopc.ua.stack.application.Session;
import com.prosysopc.ua.stack.application.SessionChannel;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ActivateSessionResponse;
import com.prosysopc.ua.stack.core.AggregateConfiguration;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.BuildInfo;
import com.prosysopc.ua.stack.core.CallMethodRequest;
import com.prosysopc.ua.stack.core.CallMethodResult;
import com.prosysopc.ua.stack.core.CallRequest;
import com.prosysopc.ua.stack.core.CallResponse;
import com.prosysopc.ua.stack.core.CreateSubscriptionResponse;
import com.prosysopc.ua.stack.core.DeleteAtTimeDetails;
import com.prosysopc.ua.stack.core.DeleteEventDetails;
import com.prosysopc.ua.stack.core.DeleteRawModifiedDetails;
import com.prosysopc.ua.stack.core.DeleteSubscriptionsResponse;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.GetEndpointsRequest;
import com.prosysopc.ua.stack.core.GetEndpointsResponse;
import com.prosysopc.ua.stack.core.HistoryData;
import com.prosysopc.ua.stack.core.HistoryEvent;
import com.prosysopc.ua.stack.core.HistoryEventFieldList;
import com.prosysopc.ua.stack.core.HistoryModifiedData;
import com.prosysopc.ua.stack.core.HistoryReadDetails;
import com.prosysopc.ua.stack.core.HistoryReadResponse;
import com.prosysopc.ua.stack.core.HistoryReadResult;
import com.prosysopc.ua.stack.core.HistoryReadValueId;
import com.prosysopc.ua.stack.core.HistoryUpdateDetails;
import com.prosysopc.ua.stack.core.HistoryUpdateResponse;
import com.prosysopc.ua.stack.core.HistoryUpdateResult;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.IssuedIdentityToken;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.ModificationInfo;
import com.prosysopc.ua.stack.core.ModifySubscriptionResponse;
import com.prosysopc.ua.stack.core.PerformUpdateType;
import com.prosysopc.ua.stack.core.PublishRequest;
import com.prosysopc.ua.stack.core.PublishResponse;
import com.prosysopc.ua.stack.core.ReadAtTimeDetails;
import com.prosysopc.ua.stack.core.ReadEventDetails;
import com.prosysopc.ua.stack.core.ReadProcessedDetails;
import com.prosysopc.ua.stack.core.ReadRawModifiedDetails;
import com.prosysopc.ua.stack.core.ReadRequest;
import com.prosysopc.ua.stack.core.ReadResponse;
import com.prosysopc.ua.stack.core.ReadValueId;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.stack.core.ServerStatusDataType;
import com.prosysopc.ua.stack.core.SetPublishingModeResponse;
import com.prosysopc.ua.stack.core.SignatureData;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.SubscriptionAcknowledgement;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.TransferResult;
import com.prosysopc.ua.stack.core.TransferSubscriptionsResponse;
import com.prosysopc.ua.stack.core.UpdateDataDetails;
import com.prosysopc.ua.stack.core.UpdateEventDetails;
import com.prosysopc.ua.stack.core.UpdateStructureDataDetails;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.core.UserNameIdentityToken;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.core.UserTokenType;
import com.prosysopc.ua.stack.core.VariableIdentifiers;
import com.prosysopc.ua.stack.core.WriteRequest;
import com.prosysopc.ua.stack.core.WriteResponse;
import com.prosysopc.ua.stack.core.WriteValue;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.ChannelService;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.ResultListener;
import com.prosysopc.ua.stack.transport.ReverseConnectionListener;
import com.prosysopc.ua.stack.transport.ReverseTransportChannelSettings;
import com.prosysopc.ua.stack.transport.SecureChannel;
import com.prosysopc.ua.stack.transport.TransportChannelSettings;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.impl.AsyncResultImpl;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.HttpsSecurityPolicy;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.EndpointUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.stack.utils.ObjectUtils;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.TypeDictionary;
import com.prosysopc.ua.typedictionary.TypeDictionaryException;
import com.prosysopc.ua.types.gds.client.GdsClientInformationModel;
import com.prosysopc.ua.types.opcua.client.ClientInformationModel;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaClient
extends UaApplication {
    public static final Double MAX_CACHE_AGE = new Double(2.147483647E9);
    private static UaApplication.Protocol bU = UaApplication.Protocol.OpcTcp;
    static Logger logger = LoggerFactory.getLogger(UaClient.class);
    private static final Map<UnsignedInteger, Class<?>> ea = new HashMap();
    private List<SubscriptionAcknowledgement> eb = new ArrayList<SubscriptionAcknowledgement>();
    private OperationLimits ec;
    private UaAddress ed = null;
    private AddressSpace addressSpace;
    private ApplicationIdentity applicationIdentity = new ApplicationIdentity();
    private String auditEntryId = null;
    private volatile boolean ee = true;
    private final AtomicReference<SessionChannel> ef = new AtomicReference<Object>(null);
    private final Client eg = Client.createClientApplication(null);
    private int connectTimeout = 60000;
    private UnsignedInteger eh = UnsignedInteger.valueOf(0L);
    private EndpointDescription[] ei;
    private double ej = 0.0;
    private TimestampsToReturn ek = TimestampsToReturn.Both;
    private EndpointDescription el;
    private final EndpointConfiguration em = Endpoint.createDefaultEndpointConfiguration();
    private volatile boolean en;
    private final HttpsSettings eo = new HttpsSettings();
    private boolean ep;
    private final AtomicReference<DiagnosticInfo[]> eq = new AtomicReference<Object>(null);
    private final AtomicLong er = new AtomicLong();
    private final AtomicReference<ResponseHeader> es = new AtomicReference<Object>(null);
    private UaClientListener et = null;
    private Locale locale = Locale.getDefault();
    private UnsignedInteger maxResponseMessageSize = UnsignedInteger.ZERO;
    private boolean eu;
    private EnumSet<UaApplication.DiagnosticMask> ev = EnumSet.noneOf(UaApplication.DiagnosticMask.class);
    private double ew = 2.0;
    private final AtomicInteger ex = new AtomicInteger(0);
    private UnsignedInteger ey = UnsignedInteger.MAX_VALUE;
    private a ez;
    private volatile Thread eA;
    private Timer eB;
    private SecureChannel eC;
    private SecurityMode eD = SecurityMode.BASIC128RSA15_SIGN_ENCRYPT;
    private ApplicationIdentity eE = new ApplicationIdentity();
    private final AtomicReference<ServerStatusDataType> eF = new AtomicReference<Object>(null);
    private final AtomicReference<StatusCode> eG = new AtomicReference<Object>(null);
    private final List<ServerStatusListener> eH = new CopyOnWriteArrayList<ServerStatusListener>();
    private final AtomicBoolean eI = new AtomicBoolean(false);
    private boolean eJ;
    private final AtomicLong eK = new AtomicLong(0L);
    private EnumSet<UaApplication.DiagnosticMask> eL = EnumSet.noneOf(UaApplication.DiagnosticMask.class);
    private volatile Session eM;
    private String sessionName;
    private Double eN = 3600000.0;
    private long eO;
    private long eP = 1000L;
    private long eQ = 10000L;
    private UnsignedInteger timeoutHint = null;
    private UserIdentity bS = new UserIdentity();
    private boolean eR = true;
    private boolean eS = true;
    private TypeDictionary eT = new TypeDictionary(this);
    final List<Subscription> eU = new CopyOnWriteArrayList<Subscription>();
    private ReverseConnectionListener eV = null;
    private UaAddress eW = null;
    private boolean eX = true;
    private boolean eY = true;

    public static UaApplication.Protocol getDefaultProtocol() {
        return bU;
    }

    public static void setDefaultProtocol(UaApplication.Protocol protocol) {
        bU = protocol;
    }

    private static void a(UnsignedInteger unsignedInteger, Class<?> clazz) {
        Class<?> clazz2 = ea.put(unsignedInteger, clazz);
        if (clazz2 != null) {
            throw new Error("Duplication mapping for AttributeId " + unsignedInteger + " existing: " + clazz2 + ", new:" + clazz);
        }
    }

    public UaClient() {
    }

    public UaClient(String string) {
        this();
        this.setAddress(string);
    }

    public UaClient(UaAddress uaAddress) {
        this.setAddress(uaAddress);
    }

    public void addServerStatusListener(ServerStatusListener serverStatusListener) {
        if (!this.hasServerStatusListener(serverStatusListener)) {
            this.eH.add(serverStatusListener);
        }
    }

    public Subscription addSubscription(Subscription subscription) throws ServiceException, StatusException {
        logger.debug("addSubscription ID was:{}", (Object)subscription.getSubscriptionId());
        if (subscription.getClient() != null) {
            subscription.transferTo(this);
        } else {
            subscription.setClient(this);
            if (!this.eU.contains(subscription)) {
                this.eU.add(subscription);
            }
            if (this.isConnected()) {
                this.a(subscription, false);
            }
        }
        logger.debug("addSubscription: added subscription={}", (Object)subscription);
        this.au();
        return subscription;
    }

    public CallResponse call(CallMethodRequest ... callMethodRequestArray) throws ServiceException {
        try {
            CallResponse callResponse = this.u().Call(this.getRequestHeader(), callMethodRequestArray);
            this.checkServiceResult(callResponse, callResponse.getDiagnosticInfos());
            return callResponse;
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public Variant[] call(NodeId nodeId, NodeId nodeId2, Variant ... variantArray) throws ServiceException, MethodCallStatusException {
        CallMethodRequest callMethodRequest = new CallMethodRequest(nodeId, nodeId2, Variant.asObjectArray(variantArray));
        CallResponse callResponse = this.call(callMethodRequest);
        CallMethodResult callMethodResult = callResponse.getResults()[0];
        DiagnosticInfo[] diagnosticInfoArray = callResponse.getDiagnosticInfos();
        this.a(callMethodResult, diagnosticInfoArray == null || diagnosticInfoArray.length == 0 ? null : diagnosticInfoArray[0]);
        return Variant.asVariantArray(callMethodResult.getOutputArguments());
    }

    public AsyncResult<CallResponse> callAsync(CallMethodRequest ... callMethodRequestArray) {
        return this.u().CallAsync(new CallRequest(this.getRequestHeader(), callMethodRequestArray));
    }

    public synchronized void connect() throws ServiceException, ConnectException, SessionActivationException, InvalidServerEndpointException {
        logger.debug("connect");
        if (this.eA != null) {
            if (this.ee) {
                logger.warn("connect() should not be called after obtaining the initial connection. AutoReconnect is true, SDK is handling all reconnections.");
            } else {
                logger.warn("connect() should not be called after obtaining the initial connection. AutoReconnect is false, call reconnect() in a loop instead for making manual reconnection attempts.");
            }
        }
        if (!this.isConnected()) {
            try {
                this.am();
                if (this.el == null) {
                    this.an();
                }
                this.am();
                this.al();
                this.aq();
                this.ac();
                this.ad();
                this.W();
                this.aa();
                this.startPublishing();
                this.ao();
                DataValue dataValue = this.ap();
                try {
                    logger.debug("NamespaceTable: {}", (Object)this.a(true, dataValue));
                }
                catch (StatusException statusException) {
                    logger.error("Cannot Read NamespaceArray from the server", (Throwable)statusException);
                }
                this.ar();
            }
            catch (ServiceException serviceException) {
                this.disconnect();
                throw serviceException;
            }
            catch (RuntimeException runtimeException) {
                this.disconnect();
                throw runtimeException;
            }
        }
    }

    public void disconnect() {
        this.disconnect(60000L);
    }

    public void disconnect(long l2) {
        this.disconnect(UnsignedInteger.valueOf(l2));
    }

    public void disconnect(long l2, TimeUnit timeUnit) {
        this.disconnect(timeUnit.toMillis(l2));
    }

    public synchronized void disconnect(UnsignedInteger unsignedInteger) {
        this.stopPublishing();
        this.d(unsignedInteger);
        this.Y();
    }

    public EndpointDescription[] discoverEndpoints() throws InvalidServerEndpointException, ConnectException, ServiceException {
        return this.discoverEndpoints(this.ag());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointDescription[] discoverEndpoints(UaApplication.Protocol ... protocolArray) throws InvalidServerEndpointException, ConnectException, ServiceException {
        SecureChannel secureChannel;
        Object object;
        String string;
        Client client = this.eg != null ? this.eg : Client.createClientApplication(null);
        String string2 = string = this.ed == null ? null : this.ed.getAddress();
        if (logger.isDebugEnabled()) {
            logger.debug("discoverEndpoints: connectUri=" + string + " protocols=" + Arrays.toString((Object[])protocolArray));
        }
        EndpointDescription endpointDescription = new EndpointDescription();
        endpointDescription.setEndpointUrl(string);
        endpointDescription.setSecurityMode(MessageSecurityMode.None);
        endpointDescription.setSecurityPolicyUri(SecurityPolicy.NONE.getPolicyUri());
        if (this.isInReverseMode()) {
            object = new ReverseTransportChannelSettings();
            ((ReverseTransportChannelSettings)object).setReverseConnectionListener(this.eV);
            ((TransportChannelSettings)object).setDescription(endpointDescription);
            ((TransportChannelSettings)object).setOpctcpSettings(null);
            secureChannel = client.createReverseSecureChannel(this.eW.getAddress(), (ReverseTransportChannelSettings)object);
            if (string == null) {
                string = endpointDescription.getEndpointUrl();
            }
        } else {
            object = new TransportChannelSettings();
            ((TransportChannelSettings)object).setDescription(endpointDescription);
            ((TransportChannelSettings)object).setOpctcpSettings(null);
            secureChannel = client.createSecureChannel(string, (TransportChannelSettings)object);
        }
        object = new ChannelService(secureChannel);
        try {
            EndpointDescription[] endpointDescriptionArray = this.a((ChannelService)object, string, protocolArray);
            if (endpointDescriptionArray == null || endpointDescriptionArray.length == 0) {
                endpointDescriptionArray = this.a((ChannelService)object, null, new UaApplication.Protocol[0]);
            }
            EndpointDescription[] endpointDescriptionArray2 = endpointDescriptionArray;
            secureChannel.close();
            secureChannel.dispose();
            return endpointDescriptionArray2;
        }
        catch (Throwable throwable) {
            try {
                secureChannel.close();
                secureChannel.dispose();
                throw throwable;
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("Connection failed", (Throwable)serviceResultException);
                if (serviceResultException.getStatusCode().getValue().equals(StatusCodes.Bad_ServerUriInvalid)) {
                    throw new InvalidServerEndpointException("Server URI invalid", this.aj(), null, serviceResultException);
                }
                throw new ConnectException("Failed to retrieve endpoints. The server is not available", this.aj(), null, serviceResultException);
            }
        }
    }

    public OperationLimits getActualOperationLimits() {
        return this.ec;
    }

    public int getActualPublishRequestSetpoint() {
        int n2 = this.ex.get();
        if (n2 > 0) {
            return n2;
        }
        return (int)Math.ceil((double)this.eU.size() * this.getPublishRequestFactor());
    }

    public UaAddress getAddress() {
        return this.ed;
    }

    @Override
    public AddressSpace getAddressSpace() {
        if (this.addressSpace == null) {
            this.addressSpace = new AddressSpace(this);
        }
        return this.addressSpace;
    }

    public ApplicationIdentity getApplicationIdentity() {
        return this.applicationIdentity;
    }

    public String getAuditEntryId() {
        return this.auditEntryId;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public double getDefaultMaxAge() {
        return this.ej;
    }

    public TimestampsToReturn getDefaultTimestampsToReturn() {
        return this.ek;
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.eg.getEncoderContext();
    }

    public EndpointDescription getEndpoint() {
        return this.el;
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.em;
    }

    @Deprecated
    public String getHost() {
        return this.af();
    }

    public HttpsSettings getHttpsSettings() {
        if (this.eg != null) {
            return this.eg.getApplicationHttpsSettings();
        }
        return this.eo;
    }

    public DiagnosticInfo[] getLastOperationDiagnostics() {
        return this.eq.get();
    }

    public DateTime getLastResponseTimestamp() {
        return this.es.get().getTimestamp();
    }

    public DiagnosticInfo getLastServiceDiagnostics() {
        return this.es.get().getServiceDiagnostics();
    }

    public StatusCode getLastServiceResult() {
        return this.es.get().getServiceResult();
    }

    public UaClientListener getListener() {
        return this.et;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public UnsignedInteger getMaxResponseMessageSize() {
        return this.maxResponseMessageSize;
    }

    @Override
    public NamespaceTable getNamespaceTable() {
        if (!this.eu) {
            try {
                this.b((DataValue)null);
            }
            catch (Exception exception) {
                logger.error("Could not get namespace table from server", (Throwable)exception);
            }
        }
        return super.getNamespaceTable();
    }

    public NamespaceTable getNamespaceTable(boolean bl) throws ServiceException, StatusException {
        if (!this.eu || bl) {
            this.b((DataValue)null);
        }
        return this.getNamespaceTable();
    }

    public EnumSet<UaApplication.DiagnosticMask> getOperationDiagnosticMask() {
        return this.ev;
    }

    @Deprecated
    public int getPort() {
        if (this.ed == null) {
            return 0;
        }
        return this.ed.getPort();
    }

    @Deprecated
    public UaApplication.Protocol getProtocol() {
        return this.ag();
    }

    public double getPublishRequestFactor() {
        return this.ew;
    }

    public int getPublishRequestSetpoint() {
        return this.ex.get();
    }

    public UnsignedInteger getPublishRequestTimeout() {
        return this.ey;
    }

    public UaAddress getReverseAddress() {
        return this.eW;
    }

    public ReverseConnectionListener getReverseConnectionListener() {
        return this.eV;
    }

    public SecureChannel getSecureChannel() throws ServerConnectionException {
        return this.u().getSecureChannel();
    }

    public SecurityMode getSecurityMode() {
        return this.eD;
    }

    public ApplicationIdentity getServerIdentity() {
        return this.eE;
    }

    @Deprecated
    public String getServerName() {
        if (this.ed == null) {
            return "";
        }
        return this.ed.getServerName();
    }

    public ServerState getServerState() {
        ServerStatusDataType serverStatusDataType = this.ai();
        StatusCode statusCode = this.ah();
        return serverStatusDataType != null ? serverStatusDataType.getState() : (statusCode == null || statusCode.equals(StatusCode.BAD) ? ServerState.Unknown : ServerState.CommunicationFault);
    }

    public ServerStatusDataType getServerStatus() throws StatusException, ServerConnectionException {
        if (!this.isConnected()) {
            throw new ServerConnectionException("Not connected to server", this.aj(), this.eD);
        }
        StatusCode statusCode = this.ah();
        if (statusCode != null && statusCode.isBad()) {
            throw new StatusException("ServerStatus not available", statusCode);
        }
        if (this.eP > 0L) {
            int n2 = 0;
            try {
                while (this.ai() == null && this.isConnected() && n2++ < 10) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.ai();
    }

    public StatusCode getServerStatusError() {
        return this.eG.get();
    }

    public ServerTable getServerTable() {
        if (!this.eJ) {
            try {
                this.ax();
            }
            catch (Exception exception) {
                logger.error("Could not get namespace table from server", (Throwable)exception);
            }
        }
        return this.getEncoderContext().getServerTable();
    }

    public ServerTable getServerTable(boolean bl) throws ServiceException, StatusException {
        if (!this.eJ || bl) {
            this.ax();
        }
        return this.getEncoderContext().getServerTable();
    }

    public long getServerTimeDifference() {
        return this.eK.get();
    }

    public EnumSet<UaApplication.DiagnosticMask> getServiceDiagnosticMask() {
        return this.eL;
    }

    public Session getSession() {
        SessionChannel sessionChannel = this.ef.get();
        logger.trace("getSession: sessionChannel={}", (Object)sessionChannel);
        if (sessionChannel == null) {
            return null;
        }
        return sessionChannel.getSession();
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public double getSessionTimeout() {
        return this.eN;
    }

    public long getStatusCheckInterval() {
        return this.eP;
    }

    public long getStatusCheckTimeout() {
        return this.eQ;
    }

    public Subscription getSubscription(int n2) {
        return this.eU.get(n2);
    }

    public Subscription getSubscriptionById(UnsignedInteger unsignedInteger) {
        if (unsignedInteger != null) {
            for (Subscription subscription : this.eU) {
                if (!unsignedInteger.equals(subscription.getSubscriptionId())) continue;
                return subscription;
            }
        }
        return null;
    }

    public int getSubscriptionCount() {
        return this.eU.size();
    }

    public Subscription[] getSubscriptions() {
        return this.eU.toArray(new Subscription[this.eU.size()]);
    }

    public List<SecurityMode> getSupportedSecurityModes() throws InvalidServerEndpointException, ServerConnectionException, ServiceException {
        EndpointDescription[] endpointDescriptionArray = this.discoverEndpoints();
        ArrayList<SecurityMode> arrayList = new ArrayList<SecurityMode>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            try {
                SecurityMode securityMode = new SecurityMode(SecurityPolicy.getSecurityPolicy(endpointDescription.getSecurityPolicyUri()), endpointDescription.getSecurityMode());
                if (arrayList.contains(securityMode)) continue;
                arrayList.add(securityMode);
            }
            catch (ServiceResultException serviceResultException) {
                logger.info("Unknown security policy supported by the server.", (Throwable)serviceResultException);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserTokenPolicy[] getSupportedUserIdentityTokens() throws ServerConnectionException, ServiceException {
        EndpointDescription endpointDescription = this.el;
        try {
            if (this.el == null) {
                this.an();
            }
            UserTokenPolicy[] userTokenPolicyArray = this.el.getUserIdentityTokens();
            return userTokenPolicyArray;
        }
        finally {
            this.el = endpointDescription;
        }
    }

    public int getTimeout() {
        if (this.timeoutHint == null) {
            return -1;
        }
        return this.timeoutHint.intValue();
    }

    public TypeDictionary getTypeDictionary() {
        return this.eT;
    }

    @Deprecated
    public String getUri() {
        return this.aj();
    }

    public UserIdentity getUserIdentity() {
        return this.bS;
    }

    public boolean hasServerStatusListener(ServerStatusListener serverStatusListener) {
        if (serverStatusListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.eH.contains(serverStatusListener);
    }

    public boolean hasSubscription(UnsignedInteger unsignedInteger) {
        return this.getSubscriptionById(unsignedInteger) != null;
    }

    public HistoryUpdateResult historyDeleteAtTimes(NodeId nodeId, DateTime[] dateTimeArray) throws StatusException, ServerConnectionException, ServiceException {
        DeleteAtTimeDetails deleteAtTimeDetails = new DeleteAtTimeDetails(nodeId, dateTimeArray);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(deleteAtTimeDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyDeleteEvents(NodeId nodeId, List<ByteString> list) throws StatusException, ServerConnectionException, ServiceException {
        DeleteEventDetails deleteEventDetails = new DeleteEventDetails(nodeId, list.toArray(new ByteString[list.size()]));
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(deleteEventDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyDeleteModified(NodeId nodeId, DateTime dateTime, DateTime dateTime2) throws StatusException, ServerConnectionException, ServiceException {
        DeleteRawModifiedDetails deleteRawModifiedDetails = new DeleteRawModifiedDetails(nodeId, true, dateTime, dateTime2);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(deleteRawModifiedDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyDeleteRaw(NodeId nodeId, DateTime dateTime, DateTime dateTime2) throws StatusException, ServerConnectionException, ServiceException {
        DeleteRawModifiedDetails deleteRawModifiedDetails = new DeleteRawModifiedDetails(nodeId, false, dateTime, dateTime2);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(deleteRawModifiedDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryReadResult[] historyRead(HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, Boolean bl, HistoryReadValueId ... historyReadValueIdArray) throws ServerConnectionException, ServiceException {
        if (historyReadDetails == null) {
            throw new NullPointerException("details");
        }
        if (historyReadValueIdArray == null) {
            throw new NullPointerException("nodesToRead");
        }
        try {
            HistoryReadResponse historyReadResponse = this.u().HistoryRead(this.getRequestHeader(), ExtensionObject.binaryEncode(historyReadDetails, this.eg.getEncoderContext()), timestampsToReturn, bl, historyReadValueIdArray);
            this.checkServiceResult(historyReadResponse, historyReadResponse.getDiagnosticInfos());
            this.a(historyReadResponse.getResults(), historyReadValueIdArray);
            return historyReadResponse.getResults();
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(encodingException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public AsyncResult<HistoryReadResponse> historyReadAsync(HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, Boolean bl, HistoryReadValueId ... historyReadValueIdArray) {
        if (historyReadDetails == null) {
            throw new NullPointerException("details");
        }
        if (historyReadValueIdArray == null) {
            throw new NullPointerException("nodesToRead");
        }
        try {
            return this.u().HistoryReadAsync(this.getRequestHeader(), ExtensionObject.binaryEncode(historyReadDetails, this.eg.getEncoderContext()), timestampsToReturn, bl, historyReadValueIdArray);
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(encodingException);
        }
    }

    public DataValue[] historyReadAtTimes(NodeId nodeId, DateTime[] dateTimeArray, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        return this.historyReadAtTimes(nodeId, dateTimeArray, numericRange, timestampsToReturn, false);
    }

    public DataValue[] historyReadAtTimes(NodeId nodeId, DateTime[] dateTimeArray, NumericRange numericRange, TimestampsToReturn timestampsToReturn, Boolean bl) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        ReadAtTimeDetails readAtTimeDetails = new ReadAtTimeDetails(dateTimeArray, bl);
        return this.a(nodeId, numericRange, timestampsToReturn, readAtTimeDetails);
    }

    public HistoryEventFieldList[] historyReadEvents(NodeId nodeId, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, EventFilter eventFilter, TimestampsToReturn timestampsToReturn) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        ReadEventDetails readEventDetails = new ReadEventDetails(unsignedInteger, dateTime, dateTime2, eventFilter);
        return this.b(nodeId, null, timestampsToReturn, readEventDetails);
    }

    public HistoryModifiedData historyReadModified(NodeId nodeId, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        ReadRawModifiedDetails readRawModifiedDetails = new ReadRawModifiedDetails(true, dateTime, dateTime2, unsignedInteger, false);
        return this.c(nodeId, numericRange, timestampsToReturn, readRawModifiedDetails);
    }

    public DataValue[] historyReadProcessed(NodeId nodeId, DateTime dateTime, DateTime dateTime2, Double d2, NodeId nodeId2, AggregateConfiguration aggregateConfiguration, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, StatusException {
        ReadProcessedDetails readProcessedDetails = new ReadProcessedDetails(dateTime, dateTime2, d2, new NodeId[]{nodeId2}, aggregateConfiguration);
        return this.a(nodeId, numericRange, timestampsToReturn, readProcessedDetails);
    }

    public DataValue[] historyReadRaw(NodeId nodeId, DateTime dateTime, DateTime dateTime2, long l2, Boolean bl, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, DecodingException, ServiceException, StatusException {
        return this.historyReadRaw(nodeId, dateTime, dateTime2, UnsignedInteger.valueOf(l2), bl, numericRange, timestampsToReturn);
    }

    public DataValue[] historyReadRaw(NodeId nodeId, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, Boolean bl, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, StatusException {
        ReadRawModifiedDetails readRawModifiedDetails = new ReadRawModifiedDetails(false, dateTime, dateTime2, unsignedInteger, bl);
        return this.a(nodeId, numericRange, timestampsToReturn, readRawModifiedDetails);
    }

    public HistoryUpdateResult[] historyUpdate(HistoryUpdateDetails ... historyUpdateDetailsArray) throws ServerConnectionException, ServiceException {
        if (historyUpdateDetailsArray == null) {
            throw new NullPointerException("details");
        }
        try {
            ExtensionObject[] extensionObjectArray = new ExtensionObject[historyUpdateDetailsArray.length];
            for (int i2 = 0; i2 < historyUpdateDetailsArray.length; ++i2) {
                extensionObjectArray[i2] = ExtensionObject.binaryEncode(historyUpdateDetailsArray[i2], this.eg.getEncoderContext());
            }
            HistoryUpdateResponse historyUpdateResponse = this.u().HistoryUpdate(this.getRequestHeader(), extensionObjectArray);
            this.checkServiceResult(historyUpdateResponse, historyUpdateResponse.getDiagnosticInfos());
            this.a(historyUpdateResponse.getResults(), historyUpdateDetailsArray);
            return historyUpdateResponse.getResults();
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(encodingException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public AsyncResult<HistoryUpdateResponse> historyUpdateAsync(HistoryUpdateDetails ... historyUpdateDetailsArray) throws ServerConnectionException {
        if (historyUpdateDetailsArray == null) {
            throw new NullPointerException("details");
        }
        try {
            ExtensionObject[] extensionObjectArray = new ExtensionObject[historyUpdateDetailsArray.length];
            for (int i2 = 0; i2 < historyUpdateDetailsArray.length; ++i2) {
                extensionObjectArray[i2] = ExtensionObject.binaryEncode(historyUpdateDetailsArray[i2], this.eg.getEncoderContext());
            }
            return this.u().HistoryUpdateAsync(this.getRequestHeader(), extensionObjectArray);
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(encodingException);
        }
    }

    public HistoryUpdateResult historyUpdateData(NodeId nodeId, PerformUpdateType performUpdateType, DataValue[] dataValueArray) throws StatusException, ServerConnectionException, ServiceException {
        UpdateDataDetails updateDataDetails = new UpdateDataDetails(nodeId, performUpdateType, dataValueArray);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(updateDataDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyUpdateEvent(NodeId nodeId, PerformUpdateType performUpdateType, EventFilter eventFilter, HistoryEventFieldList[] historyEventFieldListArray) throws StatusException, ServerConnectionException, ServiceException {
        UpdateEventDetails updateEventDetails = new UpdateEventDetails(nodeId, performUpdateType, eventFilter, historyEventFieldListArray);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(updateEventDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyUpdateStructureData(NodeId nodeId, PerformUpdateType performUpdateType, DataValue[] dataValueArray) throws StatusException, ServerConnectionException, ServiceException {
        UpdateStructureDataDetails updateStructureDataDetails = new UpdateStructureDataDetails(nodeId, performUpdateType, dataValueArray);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(updateStructureDataDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public boolean isAutoReconnect() {
        return this.ee;
    }

    public boolean isConnected() {
        return this.getSession() != null;
    }

    public boolean isInitTypeDictionaryAutoUsage() {
        return this.eY;
    }

    public boolean isInitTypeDictionaryOnConnect() {
        return this.eX;
    }

    public boolean isInReverseMode() {
        return this.eW != null;
    }

    public boolean isKeepSubscriptions() {
        return this.ep;
    }

    public boolean isValidateCreateSessionResponseCert() {
        return this.eS;
    }

    public boolean isValidateDiscoveredEndpoints() {
        return this.eR;
    }

    public ReadResponse read(Double d2, TimestampsToReturn timestampsToReturn, ReadValueId ... readValueIdArray) throws ServiceException {
        int n2 = 0;
        if (readValueIdArray.length > 1 && this.getActualOperationLimits() != null) {
            try {
                n2 = this.getActualOperationLimits().getMaxNodesPerRead().intValue();
            }
            catch (Exception exception) {
                logger.debug("read: Failed to get operationLimits.MaxNodesPerRead: ", (Throwable)exception);
            }
        }
        if (n2 > 0 && n2 < readValueIdArray.length) {
            ResponseHeader responseHeader = null;
            DataValue[] dataValueArray = new DataValue[readValueIdArray.length];
            DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[readValueIdArray.length];
            for (int i2 = 0; i2 < readValueIdArray.length; i2 += n2) {
                int n3 = Math.min(n2, readValueIdArray.length - i2);
                ReadValueId[] readValueIdArray2 = Arrays.copyOfRange(readValueIdArray, i2, i2 + n3);
                ReadResponse readResponse = this.a(d2, timestampsToReturn, readValueIdArray2);
                responseHeader = readResponse.getResponseHeader();
                for (int i3 = 0; i3 < n3; ++i3) {
                    dataValueArray[i2 + i3] = readResponse.getResults()[i3];
                }
                DiagnosticInfo[] diagnosticInfoArray2 = readResponse.getDiagnosticInfos();
                if (diagnosticInfoArray2 == null) continue;
                for (int i4 = 0; i4 < n3 && i4 < diagnosticInfoArray2.length; ++i4) {
                    diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                }
            }
            return new ReadResponse(responseHeader, dataValueArray, diagnosticInfoArray);
        }
        return this.a(d2, timestampsToReturn, readValueIdArray);
    }

    public AsyncResult<ReadResponse> readAsync(Double d2, TimestampsToReturn timestampsToReturn, ReadValueId ... readValueIdArray) {
        ReadRequest readRequest = new ReadRequest(this.getRequestHeader(), new Double(d2), timestampsToReturn, readValueIdArray);
        return this.u().ReadAsync(readRequest);
    }

    public DataValue readAttribute(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger) throws ServiceException, StatusException {
        return this.readAttribute(this.toNodeId(expandedNodeId), unsignedInteger);
    }

    public DataValue readAttribute(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        return this.readAttribute(this.toNodeId(expandedNodeId), unsignedInteger, numericRange, d2);
    }

    public DataValue readAttribute(NodeId nodeId, UnsignedInteger unsignedInteger) throws ServiceException, StatusException {
        UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[]{unsignedInteger};
        DataValue dataValue = this.readAttributes(nodeId, unsignedIntegerArray)[0];
        this.checkOperationResult(dataValue.getStatusCode());
        return dataValue;
    }

    public DataValue readAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        NumericRange[] numericRangeArray;
        UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[]{unsignedInteger};
        if (numericRange == null) {
            numericRangeArray = null;
        } else {
            NumericRange[] numericRangeArray2 = new NumericRange[1];
            numericRangeArray = numericRangeArray2;
            numericRangeArray2[0] = numericRange;
        }
        NumericRange[] numericRangeArray3 = numericRangeArray;
        DataValue dataValue = this.readAttributes(nodeId, unsignedIntegerArray, numericRangeArray3, d2)[0];
        this.checkOperationResult(dataValue.getStatusCode());
        return dataValue;
    }

    public DataValue[] readAttributes(ExpandedNodeId expandedNodeId, UnsignedInteger ... unsignedIntegerArray) throws ServiceException, StatusException {
        return this.readAttributes(this.toNodeId(expandedNodeId), unsignedIntegerArray);
    }

    public DataValue[] readAttributes(ExpandedNodeId expandedNodeId, UnsignedInteger[] unsignedIntegerArray, NumericRange[] numericRangeArray, Double d2) throws ServiceException, StatusException {
        return this.readAttributes(this.toNodeId(expandedNodeId), unsignedIntegerArray, numericRangeArray, d2);
    }

    public DataValue[] readAttributes(NodeId nodeId, UnsignedInteger ... unsignedIntegerArray) throws ServiceException {
        return this.readAttributes(nodeId, unsignedIntegerArray, null, (Double)this.getDefaultMaxAge());
    }

    public DataValue[] readAttributes(NodeId nodeId, UnsignedInteger[] unsignedIntegerArray, NumericRange[] numericRangeArray, Double d2) throws ServiceException {
        ReadValueId[] readValueIdArray = new ReadValueId[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            readValueIdArray[i2] = new ReadValueId(nodeId, unsignedIntegerArray[i2], numericRangeArray == null ? null : NumericRange.toString(numericRangeArray[i2]), null);
        }
        ReadResponse readResponse = this.read(d2, this.getDefaultTimestampsToReturn(), readValueIdArray);
        DataValue[] dataValueArray = readResponse.getResults();
        return dataValueArray;
    }

    public DataValue readValue(ExpandedNodeId expandedNodeId) throws ServiceException, StatusException {
        return this.readValue(this.toNodeId(expandedNodeId));
    }

    public DataValue readValue(ExpandedNodeId expandedNodeId, Double d2) throws ServiceException, StatusException {
        return this.readValue(this.toNodeId(expandedNodeId), d2);
    }

    public DataValue readValue(ExpandedNodeId expandedNodeId, NumericRange numericRange) throws ServiceException, StatusException {
        return this.readValue(this.toNodeId(expandedNodeId), numericRange);
    }

    public DataValue readValue(ExpandedNodeId expandedNodeId, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        return this.readValue(this.toNodeId(expandedNodeId), numericRange, d2);
    }

    public DataValue readValue(NodeId nodeId) throws ServiceException, StatusException {
        return this.readAttribute(nodeId, Attributes.Value);
    }

    public DataValue readValue(NodeId nodeId, Double d2) throws ServiceException, StatusException {
        return this.readAttribute(nodeId, Attributes.Value, null, d2);
    }

    public DataValue readValue(NodeId nodeId, NumericRange numericRange) throws ServiceException, StatusException {
        return this.readValue(nodeId, numericRange, (Double)this.getDefaultMaxAge());
    }

    public DataValue readValue(NodeId nodeId, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        return this.readAttribute(nodeId, Attributes.Value, numericRange, d2);
    }

    public DataValue[] readValues(ExpandedNodeId[] expandedNodeIdArray) throws ServiceException, StatusException {
        return this.readValues(this.a(expandedNodeIdArray));
    }

    public DataValue[] readValues(ExpandedNodeId[] expandedNodeIdArray, NumericRange[] numericRangeArray) throws ServiceException, StatusException {
        return this.readValues(this.a(expandedNodeIdArray), numericRangeArray);
    }

    public DataValue[] readValues(ExpandedNodeId[] expandedNodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn) throws ServiceException, StatusException {
        return this.readValues(this.a(expandedNodeIdArray), numericRangeArray, timestampsToReturn);
    }

    public DataValue[] readValues(ExpandedNodeId[] expandedNodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn, Double d2) throws ServiceException, StatusException {
        return this.readValues(this.a(expandedNodeIdArray), numericRangeArray, timestampsToReturn, d2);
    }

    public DataValue[] readValues(ExpandedNodeId[] expandedNodeIdArray, TimestampsToReturn timestampsToReturn) throws ServiceException, StatusException {
        return this.readValues(this.a(expandedNodeIdArray), timestampsToReturn);
    }

    public DataValue[] readValues(NodeId[] nodeIdArray) throws ServiceException {
        return this.readValues(nodeIdArray, this.getDefaultTimestampsToReturn());
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, NumericRange[] numericRangeArray) throws ServiceException {
        ReadValueId[] readValueIdArray = new ReadValueId[nodeIdArray.length];
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            readValueIdArray[i2] = new ReadValueId(nodeIdArray[i2], Attributes.Value, numericRangeArray == null ? null : NumericRange.toString(numericRangeArray[i2]), null);
        }
        ReadResponse readResponse = this.read(this.getDefaultMaxAge(), this.getDefaultTimestampsToReturn(), readValueIdArray);
        DataValue[] dataValueArray = readResponse.getResults();
        return dataValueArray;
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn) throws ServiceException {
        return this.readValues(nodeIdArray, numericRangeArray, timestampsToReturn, (Double)this.getDefaultMaxAge());
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn, Double d2) throws ServiceException {
        ReadValueId[] readValueIdArray = new ReadValueId[nodeIdArray.length];
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            readValueIdArray[i2] = new ReadValueId(nodeIdArray[i2], Attributes.Value, numericRangeArray == null ? null : NumericRange.toString(numericRangeArray[i2]), null);
        }
        ReadResponse readResponse = this.read(d2, timestampsToReturn, readValueIdArray);
        DataValue[] dataValueArray = readResponse.getResults();
        return dataValueArray;
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, TimestampsToReturn timestampsToReturn) throws ServiceException {
        return this.readValues(nodeIdArray, null, timestampsToReturn);
    }

    public boolean reconnect() throws ServiceException, ConnectException, SessionActivationException {
        logger.debug("reconnect: Reconnecting to server");
        if (this.ee && !Thread.currentThread().equals(this.eA)) {
            logger.warn("AutoReconnect is true, but encountered a call to reconnect() that didn't originate from internal calls. Either set it to false or remove manual call.");
        }
        try {
            this.ac();
        }
        catch (Exception exception) {
            logger.debug("Failed to create secure channel: {}", (Throwable)exception);
            if (exception.getCause() instanceof ServiceResultException) {
                throw new ServiceException((ServiceResultException)exception.getCause());
            }
            throw new ServiceException(exception.getMessage(), new StatusCode(StatusCodes.Bad_ServerNotConnected), null, (Throwable)exception);
        }
        logger.debug("reconnect: secure channel created");
        boolean bl = false;
        if (this.eM == null) {
            this.ab();
        } else {
            this.a(this.eM.createSessionChannel(this.eC, this.eg));
            logger.debug("reconnect: setting channel ok");
            try {
                this.W();
                logger.debug("reconnect: Old session re-activated");
                this.ay();
                this.a(true);
                bl = true;
            }
            catch (SessionActivationException sessionActivationException) {
                this.ab();
            }
        }
        logger.info("reconnect: Reconnected to server " + (bl ? "(session reactivated)" : "(new session)"));
        return bl;
    }

    public void registerModel(ClientCodegenModel clientCodegenModel) {
        this.registerModelInternal(clientCodegenModel);
    }

    public boolean removeServerStatusListener(ServerStatusListener serverStatusListener) {
        return this.eH.remove(serverStatusListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusCode removeSubscription(Subscription subscription) throws ServiceException {
        boolean bl;
        logger.debug("removeSubscription: {}", (Object)subscription);
        if (subscription == null) {
            return new StatusCode(StatusCodes.Good_NoData);
        }
        StatusCode statusCode = null;
        try {
            StatusCode[] statusCodeArray = this.a(new SubscriptionBase[]{subscription});
            if (statusCodeArray != null && statusCodeArray.length > 0) {
                statusCode = statusCodeArray[0];
            }
            if (subscription.getClient() == this) {
                subscription.reset();
            }
            bl = this.eU.remove(subscription);
        }
        catch (Throwable throwable) {
            if (subscription.getClient() == this) {
                subscription.reset();
            }
            boolean bl2 = this.eU.remove(subscription);
            logger.debug("removed: {}", (Object)bl2);
            if (statusCode == null) {
                statusCode = bl2 ? StatusCode.GOOD : new StatusCode(StatusCodes.Good_NoData);
            }
            throw throwable;
        }
        logger.debug("removed: {}", (Object)bl);
        if (statusCode == null) {
            statusCode = bl ? StatusCode.GOOD : new StatusCode(StatusCodes.Good_NoData);
        }
        return statusCode;
    }

    public StatusCode[] removeSubscriptions(Subscription[] subscriptionArray) throws ServiceException {
        StatusCode[] statusCodeArray = this.a(subscriptionArray);
        if (statusCodeArray == null) {
            statusCodeArray = new StatusCode[subscriptionArray.length];
        }
        this.resetSubscriptionsAfterRemove(subscriptionArray, statusCodeArray);
        return statusCodeArray;
    }

    public AsyncResult<StatusCode[]> removeSubscriptionsAsync(final Subscription ... subscriptionArray) throws ServiceException {
        final AsyncResultImpl<StatusCode[]> asyncResultImpl = new AsyncResultImpl<StatusCode[]>();
        AsyncResult<DeleteSubscriptionsResponse> asyncResult = this.b(subscriptionArray);
        if (asyncResult == null) {
            StatusCode[] statusCodeArray = new StatusCode[subscriptionArray.length];
            this.resetSubscriptionsAfterRemove(subscriptionArray, statusCodeArray);
            asyncResultImpl.setResult(statusCodeArray);
        } else {
            asyncResult.setListener(new ResultListener<DeleteSubscriptionsResponse>(){

                public void a(DeleteSubscriptionsResponse deleteSubscriptionsResponse) {
                    StatusCode[] statusCodeArray = deleteSubscriptionsResponse.getResults();
                    UaClient.this.resetSubscriptionsAfterRemove(subscriptionArray, statusCodeArray);
                    asyncResultImpl.setResult(statusCodeArray);
                }

                @Override
                public void onError(ServiceResultException serviceResultException) {
                    asyncResultImpl.setError(serviceResultException);
                }

                @Override
                public /* synthetic */ void onCompleted(Object object) {
                    this.a((DeleteSubscriptionsResponse)object);
                }
            });
        }
        return asyncResultImpl;
    }

    public void resetEndpoint() {
        this.el = null;
    }

    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest) throws ServiceException {
        try {
            if (serviceRequest.getRequestHeader() == null) {
                serviceRequest.setRequestHeader(this.getRequestHeader());
            }
            T t = this.u().serviceRequest(serviceRequest);
            this.checkServiceResult((ServiceResponse)t, null);
            return t;
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest) throws ServiceException {
        if (serviceRequest.getRequestHeader() == null) {
            serviceRequest.setRequestHeader(this.getRequestHeader());
        }
        return this.u().serviceRequestAsync(serviceRequest);
    }

    public <T extends ServiceResponse> T sessionlessRequest(ServiceRequest<T> serviceRequest) throws InvalidServerEndpointException, ServerConnectionException, ServiceException {
        if (this.isConnected()) {
            return this.serviceRequest(serviceRequest);
        }
        if (this.el == null) {
            this.am();
            this.an();
            this.al();
        }
        this.ac();
        try {
            T t = this.eC.serviceRequest(serviceRequest);
            return t;
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        finally {
            this.disconnect();
        }
    }

    public void setAddress(String string) {
        this.setAddress(UaAddress.parse(string));
    }

    public void setAddress(UaAddress uaAddress) {
        this.ed = uaAddress;
        this.Z();
    }

    public void setApplicationIdentity(ApplicationIdentity applicationIdentity) {
        this.applicationIdentity = applicationIdentity;
    }

    public void setAuditEntryId(String string) {
        this.auditEntryId = string;
    }

    public void setAutoReconnect(boolean bl) {
        this.ee = bl;
    }

    public void setConnectTimeout(int n2) {
        this.connectTimeout = n2;
    }

    public void setConnectTimeout(int n2, TimeUnit timeUnit) {
        this.connectTimeout = (int)timeUnit.toMillis(n2);
    }

    public void setDefaultMaxAge(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("defaultMaxAge cannot be less than 0");
        }
        this.ej = d2;
    }

    public void setDefaultTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
        this.ek = timestampsToReturn;
    }

    public void setEndpoint(EndpointDescription endpointDescription) throws URISyntaxException {
        this.X();
        if (endpointDescription != null) {
            this.setUri(endpointDescription.getEndpointUrl());
        }
        this.el = endpointDescription;
    }

    public void setInitTypeDictionaryAutoUsage(boolean bl) {
        this.eY = bl;
    }

    public void setInitTypeDictionaryOnConnect(boolean bl) {
        this.eX = bl;
    }

    public void setKeepSubscriptions(boolean bl) {
        this.ep = bl;
    }

    public void setListener(UaClientListener uaClientListener) {
        this.et = uaClientListener;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setMaxResponseMessageSize(int n2) {
        this.setMaxResponseMessageSize(UnsignedInteger.valueOf(n2));
    }

    public void setMaxResponseMessageSize(UnsignedInteger unsignedInteger) {
        this.maxResponseMessageSize = unsignedInteger == null ? UnsignedInteger.ZERO : unsignedInteger;
    }

    public void setOperationDiagnosticMask(EnumSet<UaApplication.DiagnosticMask> enumSet) {
        this.ev = enumSet;
        this.aA();
    }

    public synchronized void setPublishRequestFactor(double d2) {
        logger.debug("setPublishRequestFactor: {}", (Object)d2);
        this.ew = d2;
        this.resetPublishRequestSetpoint();
    }

    public void setPublishRequestSetpoint(int n2) {
        this.ex.set(n2);
    }

    public void setPublishRequestTimeout(long l2) {
        this.setPublishRequestTimeout(UnsignedInteger.valueOf(l2));
    }

    public void setPublishRequestTimeout(long l2, TimeUnit timeUnit) {
        this.setPublishRequestTimeout(timeUnit.toMillis(l2));
    }

    public void setPublishRequestTimeout(UnsignedInteger unsignedInteger) {
        this.ey = unsignedInteger.getValue() == 0L ? UnsignedInteger.MAX_VALUE : unsignedInteger;
    }

    public void setReverseAddress(UaAddress uaAddress) {
        this.eW = uaAddress;
    }

    public void setReverseConnectionListener(ReverseConnectionListener reverseConnectionListener) {
        this.eV = reverseConnectionListener;
    }

    public void setReversePort(int n2) {
        this.setReverseAddress(UaAddress.wildcardOpcTcp(n2));
    }

    public void setSecurityMode(SecurityMode securityMode) throws ServerConnectionException {
        if (!securityMode.equals(this.eD)) {
            this.X();
            this.eD = securityMode;
            this.resetEndpoint();
        }
    }

    public void setServiceDiagnosticMask(EnumSet<UaApplication.DiagnosticMask> enumSet) {
        this.eL = enumSet;
        this.aA();
    }

    public void setSessionName(String string) {
        this.sessionName = string;
    }

    public void setSessionTimeout(double d2) {
        this.eN = d2;
    }

    public void setSessionTimeout(long l2, TimeUnit timeUnit) {
        double d2;
        switch (timeUnit) {
            case MICROSECONDS: {
                d2 = (double)l2 / 1000.0;
                break;
            }
            case NANOSECONDS: {
                d2 = (double)l2 / 1000000.0;
                break;
            }
            default: {
                d2 = timeUnit.toMillis(l2);
            }
        }
        this.setSessionTimeout(d2);
    }

    public void setStatusCheckInterval(long l2) {
        if (l2 != this.eP) {
            this.eP = l2;
            this.au();
        }
    }

    public void setStatusCheckInterval(long l2, TimeUnit timeUnit) {
        this.setStatusCheckInterval(timeUnit.toMillis(l2));
    }

    public void setStatusCheckTimeout(long l2) {
        this.eQ = l2;
    }

    public void setStatusCheckTimeout(long l2, TimeUnit timeUnit) {
        this.eQ = timeUnit.toMillis(l2);
    }

    public void setTimeout(long l2) {
        this.setTimeout(new UnsignedInteger(l2));
    }

    public void setTimeout(long l2, TimeUnit timeUnit) {
        this.setTimeout(timeUnit.toMillis(l2));
    }

    public void setTimeout(UnsignedInteger unsignedInteger) {
        this.timeoutHint = unsignedInteger;
    }

    @Deprecated
    public void setUri(String string) throws URISyntaxException {
        this.setAddress(string);
        this.ei = null;
    }

    public void setUserIdentity(UserIdentity userIdentity) throws SessionActivationException {
        if (userIdentity == null) {
            userIdentity = new UserIdentity();
        }
        if (!this.bS.equals(userIdentity)) {
            this.bS = userIdentity;
            this.ak();
        }
    }

    public void setValidateCreateSessionResponseCert(boolean bl) {
        this.eS = bl;
    }

    public void setValidateDiscoveredEndpoints(boolean bl) {
        this.eR = bl;
    }

    public void updateServerStatus() {
        Cloneable cloneable;
        ServerState serverState;
        ServerState serverState2;
        block16: {
            StatusCode statusCode = this.ah();
            serverState2 = this.getServerState();
            logger.trace("updateServerStatus: oldState={} error={}", (Object)serverState2, (Object)statusCode);
            serverState = ServerState.Unknown;
            try {
                if (!this.eI.get()) {
                    cloneable = null;
                    ReadValueId readValueId = new ReadValueId(Identifiers.Server_ServerStatus, Attributes.Value, null, null);
                    RequestHeader requestHeader = this.a(UnsignedInteger.ZERO, UnsignedInteger.valueOf(this.eQ), null);
                    ReadResponse readResponse = this.u().Read(requestHeader, 0.0, TimestampsToReturn.Both, readValueId);
                    this.checkServiceResult(readResponse, readResponse.getDiagnosticInfos());
                    if (readResponse.getResults().length > 0) {
                        cloneable = readResponse.getResults()[0];
                    }
                    if (cloneable == null) {
                        this.a(null, StatusCode.BAD);
                    } else {
                        ServerStatusDataType serverStatusDataType;
                        Object object;
                        Object object2 = object = ((DataValue)cloneable).isNull() ? null : ((DataValue)cloneable).getValue().getValue();
                        boolean bl = object != null && object instanceof ServerStatusDataType && ((DataValue)cloneable).getStatusCode() != null && ((DataValue)cloneable).getStatusCode().isGood() ? (serverStatusDataType = (ServerStatusDataType)object).getBuildInfo() != null || serverStatusDataType.getCurrentTime() != null || serverStatusDataType.getSecondsTillShutdown() != null || serverStatusDataType.getShutdownReason() != null || serverStatusDataType.getStartTime() != null || serverStatusDataType.getState() != null : false;
                        if (bl) {
                            this.a((ServerStatusDataType)object, ((DataValue)cloneable).getStatusCode());
                        } else {
                            this.aw();
                        }
                        serverStatusDataType = this.ai();
                        if (serverStatusDataType.getCurrentTime() != null) {
                            this.eK.set(serverStatusDataType.getCurrentTime().getTimeInMillis() - System.currentTimeMillis());
                        }
                        serverState = serverStatusDataType.getState();
                    }
                } else {
                    this.aw();
                    cloneable = this.ai();
                    if (((ServerStatusDataType)cloneable).getCurrentTime() != null) {
                        this.eK.set(((ServerStatusDataType)cloneable).getCurrentTime().getTimeInMillis() - System.currentTimeMillis());
                    }
                    serverState = ((ServerStatusDataType)cloneable).getState();
                }
            }
            catch (ServiceException serviceException) {
                logger.debug("updateServerStatus", (Throwable)serviceException);
                this.a(null, serviceException.getServiceResult());
                serverState = ServerState.CommunicationFault;
            }
            catch (ServerConnectionException serverConnectionException) {
                logger.debug("updateServerStatus", (Throwable)serverConnectionException);
                this.a(null, new StatusCode(StatusCodes.Bad_ServerNotConnected));
                serverState = ServerState.CommunicationFault;
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("updateServerStatus", (Throwable)serviceResultException);
                this.a(null, serviceResultException.getStatusCode());
                if (serviceResultException.getStatusCode().getValue().equals(StatusCodes.Bad_SessionNotActivated)) break block16;
                serverState = ServerState.CommunicationFault;
            }
        }
        this.ae();
        if (!serverState.equals(serverState2)) {
            this.a(serverState2, serverState);
        }
        cloneable = this.ai();
        if (serverState.equals(ServerState.Shutdown)) {
            long l2;
            long l3 = l2 = cloneable == null ? 0L : ((ServerStatusDataType)cloneable).getSecondsTillShutdown().getValue();
            if (l2 > 0L) {
                this.a(l2, cloneable == null ? new LocalizedText("") : ((ServerStatusDataType)cloneable).getShutdownReason());
                this.d(null);
                this.eO = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(l2 + 10L);
            }
        }
    }

    public WriteResponse write(WriteValue ... writeValueArray) throws ServiceException {
        int n2 = 0;
        if (writeValueArray.length > 1 && this.getActualOperationLimits() != null) {
            try {
                n2 = this.getActualOperationLimits().getMaxNodesPerWrite().intValue();
            }
            catch (Exception exception) {
                logger.debug("Error while parsing operation limits", (Throwable)exception);
            }
        }
        if (n2 > 0 && n2 < writeValueArray.length) {
            ResponseHeader responseHeader = null;
            StatusCode[] statusCodeArray = new StatusCode[writeValueArray.length];
            DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[writeValueArray.length];
            for (int i2 = 0; i2 < writeValueArray.length; i2 += n2) {
                int n3 = Math.min(n2, writeValueArray.length - i2);
                WriteValue[] writeValueArray2 = Arrays.copyOfRange(writeValueArray, i2, i2 + n3);
                WriteResponse writeResponse = this.a(writeValueArray2);
                responseHeader = writeResponse.getResponseHeader();
                for (int i3 = 0; i3 < n3; ++i3) {
                    statusCodeArray[i2 + i3] = writeResponse.getResults()[i3];
                }
                DiagnosticInfo[] diagnosticInfoArray2 = writeResponse.getDiagnosticInfos();
                if (diagnosticInfoArray2 == null) continue;
                for (int i4 = 0; i4 < n3; ++i4) {
                    diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                }
            }
            return new WriteResponse(responseHeader, statusCodeArray, diagnosticInfoArray);
        }
        return this.a(writeValueArray);
    }

    public AsyncResult<WriteResponse> writeAsync(WriteValue ... writeValueArray) {
        WriteRequest writeRequest = new WriteRequest(this.getRequestHeader(), writeValueArray);
        return this.u().WriteAsync(writeRequest);
    }

    public boolean writeAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, Object object) throws ServiceException, StatusException {
        WriteValue[] writeValueArray = new WriteValue[]{new WriteValue(nodeId, unsignedInteger, null, this.a(object))};
        WriteResponse writeResponse = this.write(writeValueArray);
        StatusCode statusCode = writeResponse.getResults()[0];
        this.checkOperationResult(statusCode);
        return statusCode.equals(StatusCode.GOOD);
    }

    public boolean writeAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, Object object, boolean bl) throws DataTypeConversionException, ServiceException, StatusException {
        Object object2;
        if (bl) {
            if (Attributes.Value.equals(unsignedInteger)) {
                NodeId nodeId2;
                try {
                    nodeId2 = (NodeId)this.readAttribute(nodeId, Attributes.DataType).getValue().getValue();
                }
                catch (Exception exception) {
                    throw new DataTypeConversionException("Cannot resove DataType of node with NodeId: " + nodeId);
                }
                if (object instanceof DataValue) {
                    DataValue dataValue = ((DataValue)object).clone();
                    dataValue.setValue(this.getAddressSpace().getDataTypeConverter().convert(dataValue.getValue(), nodeId2));
                    object2 = dataValue;
                }
                object2 = this.getAddressSpace().getDataTypeConverter().convert(this.b(object), nodeId2);
            } else {
                Class<?> clazz = ea.get(unsignedInteger);
                if (clazz == null) {
                    throw new DataTypeConversionException("This method does not support autoconversion for AttributeId: " + unsignedInteger);
                }
                if (object instanceof DataValue) {
                    DataValue dataValue = ((DataValue)object).clone();
                    dataValue.setValue(this.getAddressSpace().getDataTypeConverter().convert(dataValue.getValue(), clazz));
                    object2 = dataValue;
                }
                object2 = this.getAddressSpace().getDataTypeConverter().convert(this.b(object), clazz);
            }
        } else {
            object2 = object;
        }
        return this.writeAttribute(nodeId, unsignedInteger, object2);
    }

    public boolean writeAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, Object object, NumericRange numericRange) throws ServiceException, StatusException {
        WriteValue[] writeValueArray = new WriteValue[]{new WriteValue(nodeId, unsignedInteger, NumericRange.toString(numericRange), this.a(object))};
        WriteResponse writeResponse = this.write(writeValueArray);
        StatusCode statusCode = writeResponse.getResults()[0];
        this.checkOperationResult(statusCode);
        return statusCode.equals(StatusCode.GOOD);
    }

    public boolean writeValue(NodeId nodeId, Object object) throws ServiceException, StatusException {
        return this.writeAttribute(nodeId, Attributes.Value, object);
    }

    public boolean writeValue(NodeId nodeId, Object object, boolean bl) throws DataTypeConversionException, ServiceException, StatusException {
        return this.writeAttribute(nodeId, Attributes.Value, object, bl);
    }

    public boolean writeValue(NodeId nodeId, Object object, NumericRange numericRange) throws ServiceException, StatusException {
        return this.writeAttribute(nodeId, Attributes.Value, object, numericRange);
    }

    public StatusCode[] writeValues(NodeId[] nodeIdArray, Object[] objectArray) throws ServiceException, StatusException {
        WriteValue[] writeValueArray = new WriteValue[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            writeValueArray[i2] = new WriteValue(nodeIdArray[i2], Attributes.Value, null, this.a(objectArray[i2]));
        }
        WriteResponse writeResponse = this.write(writeValueArray);
        return writeResponse.getResults();
    }

    public StatusCode[] writeValues(NodeId[] nodeIdArray, Object[] objectArray, NumericRange[] numericRangeArray) throws ServiceException, StatusException {
        WriteValue[] writeValueArray = new WriteValue[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            writeValueArray[i2] = new WriteValue(nodeIdArray[i2], Attributes.Value, NumericRange.toString(numericRangeArray[i2]), this.a(objectArray[i2]));
        }
        WriteResponse writeResponse = this.write(writeValueArray);
        return writeResponse.getResults();
    }

    private void W() throws SessionActivationException {
        Object object;
        Object object2;
        Object object3 = null;
        logger.debug("activateSessionChannel: endpoint={}", (Object)this.getSession().getEndpoint().getEndpointUrl());
        SignatureData signatureData = null;
        try {
            object2 = null;
            switch (this.bS.getType()) {
                case Anonymous: {
                    object3 = EndpointUtil.createAnonymousIdentityToken(this.getSession().getEndpoint());
                    break;
                }
                case Certificate: {
                    signatureData = new SignatureData();
                    object3 = EndpointUtil.createX509IdentityToken(this.getSession().getEndpoint(), this.getSession().getServerNonce(), this.bS.getCertificate(), this.bS.getPrivateKey().getPrivateKey(), signatureData);
                    break;
                }
                case IssuedToken: {
                    object = (Locale[])EndpointUtil.createIssuedIdentityToken(this.getSession().getEndpoint(), this.getSession().getServerNonce(), this.bS.getIssuedIdentityToken());
                    object2 = ((IssuedIdentityToken)object).getEncryptionAlgorithm();
                    object3 = object;
                    break;
                }
                case UserName: {
                    UserNameIdentityToken userNameIdentityToken = (UserNameIdentityToken)EndpointUtil.createUserNameIdentityToken(this.getSession().getEndpoint(), this.getSession().getServerNonce(), this.bS.getName(), this.bS.getPassword());
                    object2 = userNameIdentityToken.getEncryptionAlgorithm();
                    object3 = userNameIdentityToken;
                    break;
                }
            }
            logger.debug("UserToken encryption algorithm: {}", object2);
            if (object2 != null && SecurityMode.NONE.equals(this.eD) && this.validateApplicationCertificate(this.getServerIdentity()).isNotGood()) {
                throw new SessionActivationException("User Token encryption cannot be done for SecurityMode NONE, server certificate is not trusted", this.bS, new StatusCode(StatusCodes.Bad_CertificateUntrusted));
            }
        }
        catch (ServiceResultException serviceResultException) {
            logger.debug("ServiceResultException: ", (Throwable)serviceResultException);
            throw new SessionActivationException("Failed to initialize User Identity Token: " + serviceResultException.getMessage(), this.bS, serviceResultException);
        }
        try {
            object2 = this.eg.getApplication();
            for (Locale locale : ((Application)object2).getLocales()) {
                ((Application)object2).removeLocale(locale);
            }
            ((Application)object2).addLocale(this.locale);
            object = this.u().activate((UserIdentityToken)object3, signatureData);
            StatusCode statusCode = ((ActivateSessionResponse)object).getResponseHeader().getServiceResult();
            if (statusCode.isBad()) {
                throw new SessionActivationException("Failed to activate Session.", this.bS, statusCode);
            }
        }
        catch (ServiceResultException serviceResultException) {
            logger.debug("ServiceResultException: ", (Throwable)serviceResultException);
            throw new SessionActivationException("Failed to activate Session.", this.bS, serviceResultException);
        }
    }

    private void a(CallMethodResult callMethodResult, DiagnosticInfo diagnosticInfo) throws MethodCallStatusException {
        if (callMethodResult.getStatusCode().isBad()) {
            throw new MethodCallStatusException(callMethodResult.getStatusCode(), diagnosticInfo, callMethodResult.getInputArgumentResults(), callMethodResult.getInputArgumentDiagnosticInfos());
        }
    }

    private void X() throws ServerConnectionException {
        if (this.isConnected()) {
            throw new ServerConnectionException("Cannot change connection or security settings when connected.", this.aj(), this.eD);
        }
    }

    private void Y() {
        this.eF.set(null);
        this.eG.set(null);
        this.eI.set(false);
        this.eK.set(0L);
        this.eE = null;
        this.ec = null;
    }

    private void d(UnsignedInteger unsignedInteger) {
        SessionChannel sessionChannel = this.ef.get();
        if (sessionChannel != null && sessionChannel.getSession() != null) {
            try {
                sessionChannel.CloseSession(this.a(null, unsignedInteger, null), !this.ep);
            }
            catch (ServiceResultException serviceResultException) {
                logger.info("Failed to CloseSession: ", (Throwable)serviceResultException);
            }
            if (!this.ep) {
                this.a((TransferResult[])null);
            }
        }
        if (sessionChannel != null) {
            sessionChannel.closeSecureChannel();
        }
        this.a((SessionChannel)null);
    }

    private void Z() {
        this.getAddressSpace().v();
        TypeDictionary typeDictionary = this.getTypeDictionary();
        if (typeDictionary != null) {
            typeDictionary.clearCaches();
        }
        this.resetEndpoint();
        this.ei = null;
    }

    private void aa() throws ServiceException {
        logger.debug("connectSubscriptions");
        try {
            this.az();
        }
        catch (ServiceException serviceException) {
            logger.debug("transferSubscriptions: ", (Throwable)serviceException);
            this.a((TransferResult[])null);
        }
        this.a(true);
    }

    private void ab() throws ConnectException, SessionActivationException, ServiceException {
        logger.debug("createAndActivateSessionChannel: unable to activate old session");
        try {
            this.ad();
        }
        catch (Exception exception) {
            logger.debug("createAndActivateSessionChannel: re-init endpoint and retry.", (Throwable)exception);
            this.an();
            if (this.el == null) {
                throw new ConnectException("No endpoint found", this.aj(), this.eD);
            }
            this.ac();
            this.ad();
        }
        this.W();
        this.aa();
        logger.debug("createAndActivateSessionChannel: New session created and activated");
        try {
            logger.debug("NamespaceTable: {}", (Object)this.getNamespaceTable(true));
        }
        catch (StatusException statusException) {
            logger.error("Cannot Read NamespaceArray from the server", (Throwable)statusException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ac() throws ConnectException {
        SessionChannel sessionChannel = this.ef.get();
        this.a((SessionChannel)null);
        if (sessionChannel != null) {
            sessionChannel.closeSecureChannel();
        }
        UaClient uaClient = this;
        synchronized (uaClient) {
            try {
                if (this.isInReverseMode()) {
                    ReverseTransportChannelSettings reverseTransportChannelSettings = new ReverseTransportChannelSettings();
                    reverseTransportChannelSettings.setReverseConnectionListener(this.eV);
                    reverseTransportChannelSettings.setConfiguration(this.em);
                    reverseTransportChannelSettings.setDescription(this.el);
                    reverseTransportChannelSettings.setOpctcpSettings(null);
                    this.eC = this.eg.createReverseSecureChannel(this.eW.getAddress(), reverseTransportChannelSettings);
                } else {
                    TransportChannelSettings transportChannelSettings = new TransportChannelSettings();
                    transportChannelSettings.setConfiguration(this.em);
                    transportChannelSettings.setDescription(this.el);
                    transportChannelSettings.setOpctcpSettings(null);
                    this.eC = this.eg.createSecureChannel(this.ed.getAddress(), transportChannelSettings);
                }
            }
            catch (ServiceResultException serviceResultException) {
                this.eC = null;
                throw new ConnectException("Failed to create secure channel to server: ", this.el.getEndpointUrl(), this.eD, serviceResultException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ad() throws ServiceException {
        logger.debug("createSessionChannel");
        UaClient uaClient = this;
        synchronized (uaClient) {
            this.eM = null;
            try {
                Cert cert;
                Cert cert2 = null;
                if (this.el.getServerCertificate() != null && this.el.getServerCertificate().getLength() != 0) {
                    cert2 = new Cert(this.el.getServerCertificate().getValue());
                }
                EndpointDescription[] endpointDescriptionArray = this.eR ? this.ei : null;
                this.eM = this.eg.createSession(this.eC, this.getMaxResponseMessageSize(), this.getSessionTimeout(), this.getSessionName(), endpointDescriptionArray);
                ByteString byteString = this.eM.getEndpoint().getServerCertificate();
                logger.debug("createSessionChannel: session.getEndpoint().getServerCertificate()={}", (Object)byteString);
                Cert cert3 = this.eM.getServerCertificate();
                if (!EndpointUtil.needsCertificate(this.getEndpoint()) && cert3 != null) {
                    logger.info("Server sent a certificate, although SecurityPolicy NONE is used");
                }
                if ((byteString == null || byteString.getLength() == 0) && cert3 != null) {
                    logger.debug("createSessionChannel: session.getServerCertificate().getEncoded()={}", (Object)cert3.getEncoded());
                    this.eM.getEndpoint().setServerCertificate(ByteString.valueOf(cert3.getEncoded()));
                } else if (!SecurityMode.NONE.equals(this.eD)) {
                    Cert cert4 = cert = this.eM.getEndpoint().getServerCertificate() == null ? null : new Cert(this.eM.getEndpoint().getServerCertificate().getValue());
                    if (this.eS && cert3 != null && !ObjectUtils.equals(cert, cert3)) {
                        throw new ServiceException("Different cert in CreateSessionResponse.serverCertificate and endpoints", new StatusCode(StatusCodes.Bad_UnexpectedError));
                    }
                }
                if (!SecurityMode.NONE.equals(this.eD)) {
                    cert = cert3;
                    if (this.eS && !ObjectUtils.equals(cert2, cert)) {
                        throw new ServiceException("Certificates in endpoint and CreateSessionResponse not same", StatusCodes.Bad_UnexpectedError);
                    }
                }
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("createSessionChannel: serviceResult={}", (Object)serviceResultException.getStatusCode());
                this.eC.closeAsync();
                this.eC = null;
                if (StatusCodes.Bad_UnexpectedError.equals(serviceResultException.getStatusCode().getValue())) {
                    throw new InvalidServerEndpointException("Failed to create session channel to server: ", this.aj(), this.eD, serviceResultException);
                }
                throw new ConnectException("Failed to create session channel to server: ", this.aj(), this.eD, serviceResultException);
            }
        }
        this.a(this.eM.createSessionChannel(this.eC, this.eg));
        logger.debug("MessageSecurityMode: {}, SecurityPolicy: {}, UserIdentity type: {}", new Object[]{this.getSecurityMode().getMessageSecurityMode(), this.getSecurityMode().getSecurityPolicy(), this.getUserIdentity().getType()});
        if (MessageSecurityMode.None == this.getSecurityMode().getMessageSecurityMode() && SecurityPolicy.NONE == this.getSecurityMode().getSecurityPolicy() && UserTokenType.Anonymous == this.getUserIdentity().getType()) {
            logger.debug("SecurityMode NONE and UserTokenType Anonymous, skipping nonce checks");
        } else {
            logger.debug("Validating that the server send long enough nonce (min 32bytes), is: {}", (Object)this.eM.getServerNonce());
            if (this.eM.getServerNonce() == null || this.eM.getServerNonce().getLength() < 32) {
                throw new ConnectException("Received less than 32 byte nonce from the server, was:" + this.eM.getServerNonce(), this.aj(), this.eD);
            }
        }
        if (this.et != null) {
            this.et.onAfterCreateSessionChannel(this, this.getSession());
        }
    }

    private boolean a(Subscription subscription, boolean bl) throws ServiceException {
        CreateSubscriptionResponse createSubscriptionResponse;
        logger.debug("createSubscription: subscription={}, allowModification={}, isModified={}", new Object[]{subscription.getSubscriptionId(), bl, subscription.isModified()});
        if (subscription.getSubscriptionId() != null && subscription.getSubscriptionId().getValue() != 0L) {
            try {
                if (bl && subscription.isModified()) {
                    this.a((SubscriptionBase)subscription);
                }
                return false;
            }
            catch (ServiceException serviceException) {
                logger.debug("createSubscription: cannot modify: invalid subscription={} Exception={}", (Object)subscription.getSubscriptionId(), (Object)serviceException);
                subscription.reset();
            }
        }
        try {
            logger.debug("createSubscription: subscription={}", (Object)subscription);
            createSubscriptionResponse = this.u().CreateSubscription(this.getRequestHeader(), subscription.getPublishingInterval(), UnsignedInteger.valueOf(subscription.getLifetimeCount()), UnsignedInteger.valueOf(subscription.getMaxKeepAliveCount()), UnsignedInteger.valueOf(subscription.getMaxNotificationsPerPublish()), subscription.isPublishingEnabled(), UnsignedByte.valueOf(subscription.getPriority()));
            logger.debug("createSubscription: reponse={}", (Object)createSubscriptionResponse.getResponseHeader().getServiceResult());
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(createSubscriptionResponse, null);
        logger.debug("createSubscription: response.getSubscriptionId()={}", (Object)createSubscriptionResponse.getSubscriptionId());
        subscription.setSubscriptionId(createSubscriptionResponse.getSubscriptionId());
        subscription.setPublishingInterval(createSubscriptionResponse.getRevisedPublishingInterval());
        subscription.setLifetimeCount(createSubscriptionResponse.getRevisedLifetimeCount());
        subscription.setMaxKeepAliveCount(createSubscriptionResponse.getRevisedMaxKeepAliveCount());
        subscription.setClient(this);
        subscription.createItems();
        subscription.fireAfterCreate();
        return true;
    }

    private void a(boolean bl) {
        this.en = false;
        for (Subscription subscription : this.eU) {
            try {
                this.a(subscription, bl);
            }
            catch (Exception exception) {
                logger.warn("Failed to create subscription to the server: {} Exception={}", (Object)subscription, (Object)exception);
                this.en = true;
            }
        }
    }

    private StatusCode[] a(SubscriptionBase ... subscriptionBaseArray) throws ServiceException {
        if (this.isConnected()) {
            DeleteSubscriptionsResponse deleteSubscriptionsResponse;
            UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[subscriptionBaseArray.length];
            for (int i2 = 0; i2 < subscriptionBaseArray.length; ++i2) {
                unsignedIntegerArray[i2] = subscriptionBaseArray[i2].getSubscriptionId();
            }
            try {
                deleteSubscriptionsResponse = this.u().DeleteSubscriptions(this.getRequestHeader(), unsignedIntegerArray);
                logger.debug("deleteSubscriptions: response={}", (Object)deleteSubscriptionsResponse);
            }
            catch (ServiceFaultException serviceFaultException) {
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult(deleteSubscriptionsResponse, null);
            StatusCode[] statusCodeArray = deleteSubscriptionsResponse.getResults();
            if (statusCodeArray != null && statusCodeArray.length != subscriptionBaseArray.length && logger.isWarnEnabled()) {
                logger.warn("Received {} DeleteSubscriptions results when expecting {}, received StatusCodes: {}", new Object[]{statusCodeArray.length, subscriptionBaseArray.length, MultiDimensionArrayUtils.toString(statusCodeArray)});
            }
            return statusCodeArray;
        }
        return null;
    }

    private AsyncResult<DeleteSubscriptionsResponse> b(SubscriptionBase ... subscriptionBaseArray) throws ServiceException {
        if (this.isConnected()) {
            UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[subscriptionBaseArray.length];
            for (int i2 = 0; i2 < subscriptionBaseArray.length; ++i2) {
                unsignedIntegerArray[i2] = subscriptionBaseArray[i2].getSubscriptionId();
            }
            return this.u().DeleteSubscriptionsAsync(this.getRequestHeader(), unsignedIntegerArray);
        }
        return null;
    }

    private void a(TransferResult[] transferResultArray) {
        if (logger.isDebugEnabled()) {
            logger.debug("disconnectSubscriptions: " + Arrays.toString(transferResultArray));
        }
        for (int i2 = 0; i2 < this.eU.size(); ++i2) {
            if (transferResultArray != null && transferResultArray[i2] != null && !transferResultArray[i2].getStatusCode().isBad()) continue;
            this.eU.get(i2).reset();
        }
    }

    private EndpointDescription[] a(ChannelService channelService, String string, UaApplication.Protocol ... protocolArray) throws ServiceFaultException, ServiceResultException, ServiceException {
        String[] stringArray = new String[protocolArray.length];
        for (int i2 = 0; i2 < protocolArray.length; ++i2) {
            stringArray[i2] = protocolArray[i2].getTransportProfileUri();
        }
        GetEndpointsRequest getEndpointsRequest = new GetEndpointsRequest(this.getRequestHeader(), string, stringArray, stringArray);
        GetEndpointsResponse getEndpointsResponse = channelService.GetEndpoints(getEndpointsRequest);
        this.checkServiceResult(getEndpointsResponse, null);
        return getEndpointsResponse.getEndpoints();
    }

    private ReadResponse a(Double d2, TimestampsToReturn timestampsToReturn, ReadValueId ... readValueIdArray) throws ServiceException {
        try {
            ReadResponse readResponse = this.u().Read(this.getRequestHeader(), d2, timestampsToReturn, readValueIdArray);
            this.checkServiceResult(readResponse, readResponse.getDiagnosticInfos());
            this.a(readResponse.getResults(), readValueIdArray);
            return readResponse;
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    private WriteResponse a(WriteValue ... writeValueArray) throws ServiceException {
        try {
            WriteResponse writeResponse = this.u().Write(this.getRequestHeader(), writeValueArray);
            this.checkServiceResult(writeResponse, writeResponse.getDiagnosticInfos());
            this.a(writeResponse.getResults(), (Object[])writeValueArray);
            return writeResponse;
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    private void a(long l2, LocalizedText localizedText) {
        for (ServerStatusListener serverStatusListener : this.eH) {
            try {
                serverStatusListener.onShutdown(this, l2, localizedText);
            }
            catch (Exception exception) {
                logger.error("Exception in ServerStatusListener", (Throwable)exception);
            }
        }
    }

    private void a(ServerState serverState, ServerState serverState2) {
        for (ServerStatusListener serverStatusListener : this.eH) {
            try {
                serverStatusListener.onStateChange(this, serverState, serverState2);
            }
            catch (Exception exception) {
                logger.error("Exception in ServerStatusListener", (Throwable)exception);
            }
        }
    }

    private void ae() {
        for (ServerStatusListener serverStatusListener : this.eH) {
            try {
                ServerStatusDataType serverStatusDataType = this.eF.get();
                StatusCode statusCode = this.eG.get();
                StatusCode statusCode2 = statusCode == null ? StatusCode.GOOD : statusCode;
                serverStatusListener.onStatusChange(this, serverStatusDataType, statusCode2);
            }
            catch (Exception exception) {
                logger.error("Exception in ServerStatusListener", (Throwable)exception);
            }
        }
    }

    private EndpointDescription[] getEndpoints() throws InvalidServerEndpointException, ConnectException, ServiceException {
        this.ei = this.discoverEndpoints();
        if (logger.isDebugEnabled()) {
            logger.debug("endpoints:" + Arrays.toString(this.ei));
        }
        if (this.ei == null || this.ei.length == 0) {
            throw new ServiceException("GetEndpointsResponse, endpoint list received from the server is empty.", new StatusCode(StatusCodes.Bad_UnexpectedError));
        }
        EndpointDescription[] endpointDescriptionArray = this.a(this.ei, this.aj());
        if (endpointDescriptionArray.length == 0 && this.as()) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                endpointDescriptionArray = this.a(this.ei, this.aj().replaceFirst("localhost", inetAddress.getHostName()));
                endpointDescriptionArray = this.a(this.ei, this.aj().replaceFirst("localhost", inetAddress.getCanonicalHostName()));
            }
            catch (UnknownHostException unknownHostException) {
                logger.info("Cannot convert localhost to HostName: ", (Throwable)unknownHostException);
            }
        }
        if (endpointDescriptionArray.length == 0) {
            endpointDescriptionArray = this.a(this.ei, (String)null);
        }
        if (endpointDescriptionArray.length == 0) {
            throw new InvalidServerEndpointException("Requested endpoint not supported by the server", this.aj(), this.getSecurityMode());
        }
        endpointDescriptionArray = EndpointUtil.sortBySecurityLevel(endpointDescriptionArray);
        return endpointDescriptionArray;
    }

    private String af() {
        if (this.ed == null) {
            return "";
        }
        return this.ed.getHost();
    }

    private UnsignedInteger a(Map<NodeId, DataValue> map, String string, NodeId nodeId, UnsignedInteger unsignedInteger) {
        try {
            DataValue dataValue = map.get(nodeId);
            if (dataValue.getStatusCode().isNotGood()) {
                throw new StatusException(dataValue.getStatusCode());
            }
            if (!(dataValue.getValue().getValue() instanceof UnsignedInteger)) {
                throw new IllegalStateException("OperationLimit value something else than UnsignedInteger");
            }
            return (UnsignedInteger)dataValue.getValue().getValue();
        }
        catch (Exception exception) {
            logger.warn("Could not Read OperationLimit: {} with NodeId: {}, either the server does not have the node or the read didn't return a Good value that can be interpreted as UnsignedInteger, value was: {}, using default value of {} instead (note that this will be overriden by clientside limits if lower)", new Object[]{string, nodeId, map.get(nodeId), unsignedInteger});
            return unsignedInteger;
        }
    }

    private UaApplication.Protocol ag() {
        if (this.ed == null) {
            return UaApplication.Protocol.OpcTcp;
        }
        return this.ed.getProtocol();
    }

    private RequestHeader a(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, String string) {
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setReturnDiagnostics(unsignedInteger);
        requestHeader.setTimeoutHint(unsignedInteger2);
        requestHeader.setAuditEntryId(string);
        requestHeader.setTimestamp(DateTime.currentTime());
        requestHeader.setRequestHandle(this.at());
        return requestHeader;
    }

    private StatusCode ah() {
        return this.eG.get();
    }

    private ServerStatusDataType ai() {
        return this.eF.get();
    }

    private synchronized SubscriptionAcknowledgement[] getSubscriptionAcknowledgements() {
        SubscriptionAcknowledgement[] subscriptionAcknowledgementArray = this.eb.toArray(new SubscriptionAcknowledgement[0]);
        this.eb = new ArrayList<SubscriptionAcknowledgement>();
        return subscriptionAcknowledgementArray;
    }

    private String aj() {
        if (this.ed == null) {
            return "";
        }
        return this.ed.getAddress();
    }

    private boolean a(PublishResponse publishResponse) throws ServiceException {
        logger.debug("handlePublishResponse: response={}", (Object)publishResponse.getNotificationMessage().getSequenceNumber());
        logger.trace("handlePublishResponse: response={}", (Object)publishResponse);
        if (this.isConnected()) {
            this.checkServiceResult(publishResponse, publishResponse.getDiagnosticInfos());
            if (this.et != null && !this.et.validatePublishResponse(this, publishResponse)) {
                return false;
            }
            Subscription subscription = this.getSubscriptionById(publishResponse.getSubscriptionId());
            if (subscription == null) {
                logger.info("handlePublishResponse: no subscription with ID={} SequenceNumber={}; response discarded", (Object)publishResponse.getSubscriptionId(), (Object)publishResponse.getNotificationMessage().getSequenceNumber());
                return false;
            }
            subscription.onPublishResponse(publishResponse);
            return true;
        }
        logger.debug("handlePublishResponse: not connected; response discarded");
        return false;
    }

    private DataValue[] a(NodeId nodeId, NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, StatusException, DecodingException {
        ByteString byteString;
        HistoryReadValueId historyReadValueId = new HistoryReadValueId();
        historyReadValueId.setNodeId(nodeId);
        if (numericRange != null) {
            historyReadValueId.setIndexRange(numericRange.toString());
        }
        ArrayList<DataValue> arrayList = null;
        do {
            ExtensionObject extensionObject;
            HistoryReadResult[] historyReadResultArray = this.historyRead(historyReadDetails, timestampsToReturn, false, historyReadValueId);
            this.checkOperationResult(historyReadResultArray[0].getStatusCode());
            if (historyReadResultArray[0].getStatusCode().getValue().equals(StatusCodes.Good_NoData) || (extensionObject = historyReadResultArray[0].getHistoryData()) == null) break;
            HistoryData historyData = (HistoryData)extensionObject.decode(this.eg.getEncoderContext());
            byteString = historyReadResultArray[0].getContinuationPoint();
            if (byteString == null && arrayList == null) {
                return historyData.getDataValues();
            }
            if (arrayList == null) {
                arrayList = new ArrayList<DataValue>();
            }
            arrayList.addAll(Arrays.asList(historyData.getDataValues()));
            historyReadValueId.setContinuationPoint(byteString);
            if (historyData.getDataValues().length == 0 && byteString != null) {
                logger.info("historyReadAll: Received empty HistoryData with continuationPoint");
                break;
            }
            logger.debug("historyReadAll: got {} values", (Object)historyData.getDataValues().length);
        } while (byteString != null);
        return arrayList == null ? new DataValue[]{} : arrayList.toArray(new DataValue[arrayList.size()]);
    }

    private HistoryEventFieldList[] b(NodeId nodeId, NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, StatusException, DecodingException {
        ByteString byteString;
        HistoryReadValueId historyReadValueId = new HistoryReadValueId();
        historyReadValueId.setNodeId(nodeId);
        if (numericRange != null) {
            historyReadValueId.setIndexRange(numericRange.toString());
        }
        ArrayList<HistoryEventFieldList> arrayList = null;
        do {
            ExtensionObject extensionObject;
            HistoryReadResult[] historyReadResultArray = this.historyRead(historyReadDetails, timestampsToReturn, false, historyReadValueId);
            this.checkOperationResult(historyReadResultArray[0].getStatusCode());
            if (historyReadResultArray[0].getStatusCode().getValue().equals(StatusCodes.Good_NoData) || (extensionObject = historyReadResultArray[0].getHistoryData()) == null) break;
            HistoryEvent historyEvent = (HistoryEvent)extensionObject.decode(this.eg.getEncoderContext());
            byteString = historyReadResultArray[0].getContinuationPoint();
            if (byteString == null && arrayList == null) {
                return historyEvent.getEvents();
            }
            if (arrayList == null) {
                arrayList = new ArrayList<HistoryEventFieldList>();
            }
            arrayList.addAll(Arrays.asList(historyEvent.getEvents()));
            historyReadValueId.setContinuationPoint(byteString);
        } while (byteString != null);
        return arrayList == null ? new HistoryEventFieldList[]{} : arrayList.toArray(new HistoryEventFieldList[arrayList.size()]);
    }

    private HistoryModifiedData c(NodeId nodeId, NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, StatusException, DecodingException {
        ByteString byteString;
        HistoryReadValueId historyReadValueId = new HistoryReadValueId();
        historyReadValueId.setNodeId(nodeId);
        if (numericRange != null) {
            historyReadValueId.setIndexRange(numericRange.toString());
        }
        ArrayList<DataValue> arrayList = null;
        ArrayList<ModificationInfo> arrayList2 = null;
        do {
            ExtensionObject extensionObject;
            HistoryReadResult[] historyReadResultArray = this.historyRead(historyReadDetails, timestampsToReturn, false, historyReadValueId);
            this.checkOperationResult(historyReadResultArray[0].getStatusCode());
            if (historyReadResultArray[0].getStatusCode().getValue().equals(StatusCodes.Good_NoData) || (extensionObject = historyReadResultArray[0].getHistoryData()) == null) break;
            HistoryModifiedData historyModifiedData = (HistoryModifiedData)extensionObject.decode(this.eg.getEncoderContext());
            byteString = historyReadResultArray[0].getContinuationPoint();
            if (byteString == null && arrayList == null) {
                return historyModifiedData;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<DataValue>();
                arrayList2 = new ArrayList<ModificationInfo>();
            }
            arrayList.addAll(Arrays.asList(historyModifiedData.getDataValues()));
            arrayList2.addAll(Arrays.asList(historyModifiedData.getModificationInfos()));
            historyReadValueId.setContinuationPoint(byteString);
        } while (byteString != null);
        return arrayList == null ? new HistoryModifiedData(new DataValue[0], new ModificationInfo[0]) : new HistoryModifiedData(arrayList.toArray(new DataValue[arrayList.size()]), arrayList2.toArray(new ModificationInfo[arrayList2.size()]));
    }

    private void ak() throws SessionActivationException {
        if (this.isConnected()) {
            this.W();
        }
    }

    private void al() {
        Application application = this.eg.getApplication();
        application.setApplicationName(this.getApplicationIdentity().getApplicationDescription().getApplicationName());
        application.setApplicationUri(this.getApplicationIdentity().getApplicationDescription().getApplicationUri());
        application.setProductUri(this.getApplicationIdentity().getApplicationDescription().getProductUri());
    }

    private void am() {
        this.eg.getApplication().setApplicationUri(this.applicationIdentity.getApplicationDescription().getApplicationUri());
        this.eg.getApplication().removeApplicationInstanceCertificates();
        if (this.applicationIdentity.getKeys() != null) {
            this.eg.getApplication().addApplicationInstanceCertificate(this.applicationIdentity.getKeys());
        }
        this.eg.getApplicationHttpsSettings().readFrom(this.eo);
        this.eg.getApplicationHttpsSettings().setKeyPair(this.applicationIdentity.getHttpsCertificate(), new Cert[0]);
        this.eg.getApplicatioOpcTcpSettings().setConnectTimeout(this.connectTimeout);
        this.eg.getApplicatioOpcTcpSettings().setReverseHelloAcceptTimeout(this.connectTimeout);
    }

    private void an() throws InvalidServerEndpointException, ConnectException, ServiceException {
        if (this.aj() == null) {
            throw new NullPointerException("Uri not defined.");
        }
        EndpointDescription[] endpointDescriptionArray = this.getEndpoints();
        this.el = endpointDescriptionArray[endpointDescriptionArray.length - 1];
        if (!this.el.getEndpointUrl().equals(this.aj())) {
            logger.info("Using an alternate endpoint URL '{}' instead of the requested '{}'", (Object)this.el.getEndpointUrl(), (Object)this.aj());
        }
        logger.debug("initEndpoint: endpoint={}", (Object)this.el);
    }

    private void ao() {
        this.registerModel(ClientInformationModel.MODEL);
        this.registerModel(GdsClientInformationModel.MODEL);
        if (this.isAutoDiscoverCodegenModels()) {
            this.registerAutoDiscoveredModels(ClientCodegenModelProvider.class);
        }
    }

    private DataValue ap() {
        try {
            HashSet<NodeId> hashSet = new HashSet<NodeId>();
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerRead);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite);
            hashSet.add(Identifiers.Server_NamespaceArray);
            i i2 = this.getAddressSpace().a(hashSet, Attributes.Value, TimestampsToReturn.Both, false);
            Map<NodeId, DataValue> map = i2.b(Attributes.Value);
            OperationLimits.Builder builder = OperationLimits.builder();
            builder.setMaxMonitoredItemsPerCall(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxMonitoredItemsPerCall", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerBrowse(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerBrowse", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerHistoryReadData(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerHistoryReadData", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerHistoryReadEvents(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerHistoryReadEvents", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerHistoryUpdateData(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerHistoryUpdateData", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerHistoryUpdateEvents(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerHistoryUpdateEvents", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerMethodCall(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerMethodCall", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerNodeManagement(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerNodeManagement", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerRead(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerRead", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerRead, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerRegisterNodes(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerRegisterNodes", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerTranslateBrowsePathsToNodeIds(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerTranslateBrowsePathsToNodeIds", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerWrite(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerWrite", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite, UnsignedInteger.MAX_VALUE));
            OperationLimits operationLimits = builder.build();
            OperationLimits operationLimits2 = this.getOperationLimits();
            this.ec = OperationLimits.min(operationLimits, operationLimits2);
            logger.debug("Initialized OperationLimits to: {}, client side limits were: {} and serverside limits were: {}", new Object[]{this.ec, operationLimits2, operationLimits});
            return map.get(Identifiers.Server_NamespaceArray);
        }
        catch (NullPointerException nullPointerException) {
            logger.info("Server doesn't support OperationLimits nodes or gives Null values, using client defaults: {}", (Object)this.getOperationLimits(), (Object)nullPointerException);
            this.ec = this.getOperationLimits();
            return null;
        }
        catch (Exception exception) {
            this.ec = this.getOperationLimits();
            logger.info("Failed to init OperationLimits from the server, using client defaults: {}", (Object)this.getOperationLimits(), (Object)exception);
            return null;
        }
    }

    private void aq() throws ServiceException {
        StatusCode statusCode;
        if (this.el == null) {
            throw new IllegalStateException("Endpoint should not be null");
        }
        if (this.el.getServerCertificate() == null && !this.eD.getMessageSecurityMode().equals(MessageSecurityMode.None)) {
            throw new ServiceException("Missing server certificate", StatusCodes.Bad_CertificateInvalid);
        }
        Cert cert = null;
        if (this.el.getServerCertificate() != null && this.el.getServerCertificate().getLength() != 0) {
            try {
                cert = new Cert(this.el.getServerCertificate().getValue());
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
        }
        this.eE = new ApplicationIdentity(cert, null);
        this.eE.setApplicationDescription(this.el.getServer(), false);
        if (!this.eD.getMessageSecurityMode().equals(MessageSecurityMode.None) && (statusCode = this.validateApplicationCertificate(this.eE)).isBad()) {
            throw new ServiceException("Invalid server certificate", statusCode);
        }
    }

    private void ar() {
        if (this.eX) {
            try {
                this.eT.init();
            }
            catch (TypeDictionaryException typeDictionaryException) {
                logger.warn("Could not init TypeDictionary, decoding custom Structures might not work", (Throwable)typeDictionaryException);
            }
        }
        if (this.eY) {
            this.getEncoderContext().setDynamicStructureSpecificationProvider(new EncoderContext.StructureSpecificationProvider(){

                @Override
                public StructureSpecification get(UaNodeId uaNodeId) {
                    logger.debug("Trying to resolve id {} StructureSpecification", (Object)uaNodeId);
                    StructureSpecification structureSpecification = UaClient.this.eT.getStructureSpecification(uaNodeId);
                    if (structureSpecification == null) {
                        logger.debug("Could not resolve id {} StructureSpecification", (Object)uaNodeId);
                    } else {
                        logger.debug("Resolved id {} StructureSpecification to: {}", (Object)uaNodeId, (Object)structureSpecification);
                    }
                    return structureSpecification;
                }
            });
        }
    }

    private boolean as() {
        return this.af().isEmpty() || this.af().toLowerCase().equals("localhost");
    }

    private UnsignedInteger at() {
        long l2 = 0L;
        while (l2 == 0L) {
            long l3 = this.er.incrementAndGet();
            l2 = l3 & 0xFFFFFFFFL;
        }
        return new UnsignedInteger(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void au() {
        if (this.isConnected() && this.eA != null) {
            UaClient uaClient = this;
            synchronized (uaClient) {
                this.notify();
            }
        }
    }

    private DataValue a(Object object) {
        DataValue dataValue;
        if (object instanceof DataValue) {
            dataValue = (DataValue)object;
        } else {
            Variant variant = this.b(object);
            dataValue = new DataValue(variant, StatusCode.GOOD);
        }
        return dataValue;
    }

    private Variant b(Object object) {
        Variant variant = object instanceof Variant ? (Variant)object : new Variant(object);
        return variant;
    }

    private BuildInfo av() throws ServiceException {
        NodeId[] nodeIdArray = new NodeId[]{Identifiers.Server_ServerStatus_BuildInfo_ProductUri, Identifiers.Server_ServerStatus_BuildInfo_ManufacturerName, Identifiers.Server_ServerStatus_BuildInfo_ProductName, Identifiers.Server_ServerStatus_BuildInfo_SoftwareVersion, Identifiers.Server_ServerStatus_BuildInfo_BuildNumber, Identifiers.Server_ServerStatus_BuildInfo_BuildDate};
        DataValue[] dataValueArray = this.readValues(nodeIdArray, TimestampsToReturn.Neither);
        BuildInfo buildInfo = new BuildInfo(dataValueArray[0].getValue().asClass(String.class, null), dataValueArray[1].getValue().asClass(String.class, null), dataValueArray[2].getValue().asClass(String.class, null), dataValueArray[3].getValue().asClass(String.class, null), dataValueArray[4].getValue().asClass(String.class, null), dataValueArray[5].getValue().asClass(DateTime.class, null));
        return buildInfo;
    }

    private AsyncResult<i> a(boolean bl, final Map<NodeId, Set<UnsignedInteger>> map, final TimestampsToReturn timestampsToReturn) {
        if (!bl) {
            final AsyncResultImpl<i> asyncResultImpl = new AsyncResultImpl<i>();
            StackUtils.getBlockingWorkExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        asyncResultImpl.setResult(UaClient.this.b(false, map, timestampsToReturn));
                    }
                    catch (ServiceException serviceException) {
                        asyncResultImpl.setError(new ServiceResultException(serviceException.getServiceResult(), (Throwable)serviceException));
                    }
                }
            });
            return asyncResultImpl;
        }
        int n2 = this.getActualOperationLimits().getMaxNodesPerRead().intValue();
        Set<h> set = h.a(map, timestampsToReturn).b(n2);
        final HashSet<AsyncResult<i>> hashSet = new HashSet<AsyncResult<i>>();
        for (h h2 : set) {
            hashSet.add(this.a(false, h2.M(), h2.getTimestampsToReturn()));
        }
        final AsyncResultImpl asyncResultImpl = new AsyncResultImpl();
        StackUtils.getBlockingWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                HashSet<i> hashSet2 = new HashSet<i>();
                for (AsyncResult asyncResult : hashSet) {
                    try {
                        hashSet2.add((i)asyncResult.waitForResult());
                    }
                    catch (ServiceResultException serviceResultException) {
                        asyncResultImpl.setError(serviceResultException);
                        break;
                    }
                }
                asyncResultImpl.setResult(i.b(hashSet2));
            }
        });
        return asyncResultImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aw() throws ServiceException {
        NodeId[] nodeIdArray = new NodeId[]{Identifiers.Server_ServerStatus_StartTime, Identifiers.Server_ServerStatus_CurrentTime, Identifiers.Server_ServerStatus_State, Identifiers.Server_ServerStatus_SecondsTillShutdown, Identifiers.Server_ServerStatus_ShutdownReason, Identifiers.Server_ServerStatus_BuildInfo};
        DataValue[] dataValueArray = this.readValues(nodeIdArray, TimestampsToReturn.Neither);
        DateTime dateTime = null;
        DateTime dateTime2 = null;
        ServerState serverState = null;
        BuildInfo buildInfo = null;
        UnsignedInteger unsignedInteger = null;
        LocalizedText localizedText = null;
        try {
            dateTime = dataValueArray[0].getValue().asClass(DateTime.class, null);
            dateTime2 = dataValueArray[1].getValue().asClass(DateTime.class, null);
            serverState = dataValueArray[2].getValue().asClass(ServerState.class, null);
            if (serverState == null) {
                serverState = ServerState.valueOf(((Number)dataValueArray[2].getValue().asClass(Number.class, ServerState.Unknown.getValue())).intValue());
            }
            if ((unsignedInteger = (UnsignedInteger)dataValueArray[3].getValue().asClass(UnsignedInteger.class, null)) == null) {
                Number number = dataValueArray[3].getValue().asClass(Number.class, 0);
                unsignedInteger = UnsignedInteger.valueOf(number.intValue());
            }
            if ((localizedText = (LocalizedText)dataValueArray[4].getValue().asClass(LocalizedText.class, null)) == null) {
                localizedText = new LocalizedText((String)dataValueArray[4].getValue().asClass(String.class, null), Locale.getDefault());
            }
            if ((buildInfo = (BuildInfo)dataValueArray[5].getValue().asClass(BuildInfo.class, null)) == null) {
                buildInfo = this.av();
            }
            this.a(new ServerStatusDataType(dateTime, dateTime2, serverState, buildInfo, unsignedInteger, localizedText), StatusCode.GOOD);
            this.eI.set(true);
        }
        catch (Exception exception) {
            logger.debug("Failure in readServerStatusElements", (Throwable)exception);
        }
        finally {
            this.a(new ServerStatusDataType(dateTime, dateTime2, serverState, buildInfo, unsignedInteger, localizedText), StatusCode.GOOD);
            this.eI.set(true);
        }
    }

    private synchronized void b(DataValue dataValue) throws ServiceException, StatusException {
        String[] stringArray = this.getEncoderContext().getNamespaceTable().toArray();
        DataValue dataValue2 = dataValue != null ? dataValue : this.readValue(Identifiers.Server_NamespaceArray);
        this.getEncoderContext().setNamespaceTable(NamespaceTable.createFromArray((String[])dataValue2.getValue().getValue()));
        this.eu = true;
        String[] stringArray2 = this.getEncoderContext().getNamespaceTable().toArray();
        if (stringArray2.length < stringArray.length) {
            logger.warn("refreshNamespaceTable, the old NamespaceArray: {} is not a subset of new NamespaceArray: {}, older NamespaceIndexes are obsolete", (Object)stringArray, (Object)stringArray2);
        } else {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (ObjectUtils.equals(stringArray[i2], stringArray2[i2])) continue;
                logger.warn("refreshNamespaceTable, the old NamespaceArray: {} is not a subset of new NamespaceArray: {}, older NamespaceIndexes are obsolete", (Object)stringArray, (Object)stringArray2);
                break;
            }
        }
        logger.debug("refreshNamespaceTable, old: {}, new: {}", (Object)stringArray, (Object)stringArray2);
    }

    private void ax() throws ServiceException, StatusException {
        DataValue dataValue = this.readValue(Identifiers.Server_ServerArray);
        this.getEncoderContext().setServerTable(ServerTable.createFromArray((String[])dataValue.getValue().getValue()));
        this.eJ = true;
    }

    private void ay() {
        for (Subscription subscription : this.eU) {
            try {
                subscription.republishAllAvailable();
            }
            catch (ServiceException serviceException) {
                logger.info("Subscription ID={} no longer valid (), recreating", (Object)subscription.getSubscriptionId(), (Object)serviceException.getServiceResult());
                subscription.reset();
            }
        }
    }

    private EndpointDescription[] a(EndpointDescription[] endpointDescriptionArray, String string) {
        return EndpointUtil.select(endpointDescriptionArray, string, this.ag().toString(), this.eD.getMessageSecurityMode(), this.eD.getSecurityPolicy(), null);
    }

    private void a(SessionChannel sessionChannel) {
        this.ef.set(sessionChannel);
    }

    private synchronized void a(ServerStatusDataType serverStatusDataType, StatusCode statusCode) {
        if (logger.isTraceEnabled()) {
            logger.trace("setServerStatusAndError: Status=" + (serverStatusDataType == null ? "null" : serverStatusDataType.getState()) + " Code=" + statusCode);
        }
        this.eF.set(serverStatusDataType);
        this.eG.set(statusCode);
    }

    private synchronized void startPublishing() {
        logger.debug("startPublishing");
        if (this.eA == null) {
            this.ez = new a();
            this.eA = new Thread(this.ez);
            this.eA.setName("PublishTask-" + this.toString());
            this.eA.start();
        }
        if (this.eB == null) {
            // empty if block
        }
    }

    private synchronized void stopPublishing() {
        if (this.eA != null) {
            logger.debug("stopPublishing: interrupting publishThread");
            this.notify();
            this.ez.terminate();
            this.ez = null;
            this.eA = null;
        }
        if (this.eB != null) {
            logger.debug("canceling publishTimer");
            this.eB.cancel();
            this.eB = null;
        }
    }

    private NodeId toNodeId(ExpandedNodeId expandedNodeId) throws StatusException {
        NodeId nodeId = null;
        try {
            nodeId = this.getNamespaceTable().toNodeId(expandedNodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(serviceResultException);
        }
        return nodeId;
    }

    private NodeId[] a(ExpandedNodeId[] expandedNodeIdArray) throws StatusException {
        NodeId[] nodeIdArray = new NodeId[expandedNodeIdArray.length];
        for (int i2 = 0; i2 < expandedNodeIdArray.length; ++i2) {
            nodeIdArray[i2] = this.toNodeId(expandedNodeIdArray[i2]);
        }
        return nodeIdArray;
    }

    private TransferResult[] az() throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("transferSubscriptions: subscriptions.size()={}", (Object)this.eU.size());
        }
        if (this.eU.size() > 0) {
            TransferSubscriptionsResponse transferSubscriptionsResponse;
            UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[this.eU.size()];
            for (int i2 = 0; i2 < this.eU.size(); ++i2) {
                unsignedIntegerArray[i2] = this.eU.get(i2).getSubscriptionId();
            }
            try {
                transferSubscriptionsResponse = this.u().TransferSubscriptions(this.getRequestHeader(), unsignedIntegerArray, true);
            }
            catch (ServiceFaultException serviceFaultException) {
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult(transferSubscriptionsResponse, transferSubscriptionsResponse.getDiagnosticInfos());
            TransferResult[] transferResultArray = transferSubscriptionsResponse.getResults();
            this.a(transferResultArray);
            return transferResultArray;
        }
        return new TransferResult[0];
    }

    private void aA() {
        int n2 = 0;
        for (UaApplication.DiagnosticMask diagnosticMask : this.ev) {
            n2 += diagnosticMask.getValue();
        }
        n2 <<= 5;
        for (UaApplication.DiagnosticMask diagnosticMask : this.eL) {
            n2 += diagnosticMask.getValue();
        }
        this.eh = UnsignedInteger.valueOf(n2);
    }

    protected synchronized void addSubscriptionAck(SubscriptionAcknowledgement subscriptionAcknowledgement) {
        this.eb.add(subscriptionAcknowledgement);
    }

    protected void finalize() throws Throwable {
        if (this.isConnected()) {
            System.err.println("UaClient.close() was never called. Still connected to " + this.aj() + " at finalize(). Check that you disconnect your connection properly.");
        }
        super.finalize();
    }

    protected HttpsSecurityPolicy[] getHttpsSecurityPolicies() {
        return this.getHttpsSettings().getHttpsSecurityPolicies();
    }

    protected void resetPublishRequestSetpoint() {
        this.ex.set(0);
    }

    protected void resetSubscriptionsAfterRemove(Subscription[] subscriptionArray, StatusCode[] statusCodeArray) {
        for (int i2 = 0; i2 < subscriptionArray.length; ++i2) {
            if (subscriptionArray[i2].getClient() == this) {
                subscriptionArray[i2].reset();
            }
            boolean bl = this.eU.remove(subscriptionArray[i2]);
            if (statusCodeArray[i2] != null) continue;
            statusCodeArray[i2] = bl ? StatusCode.GOOD : new StatusCode(StatusCodes.Good_NoData);
        }
    }

    protected void setHttpsSecurityPolicies(HttpsSecurityPolicy[] httpsSecurityPolicyArray) {
        this.getHttpsSettings().setHttpsSecurityPolicies(httpsSecurityPolicyArray);
    }

    void checkOperationResult(StatusCode statusCode) throws StatusException {
        if (statusCode.isBad()) {
            DiagnosticInfo[] diagnosticInfoArray = this.eq.get();
            if (diagnosticInfoArray == null || diagnosticInfoArray.length == 0) {
                throw new StatusException(statusCode);
            }
            throw new StatusException(statusCode, diagnosticInfoArray[0]);
        }
    }

    void a(Object[] objectArray, Object[] objectArray2) throws ServiceException {
        if (objectArray == null) {
            throw new ServiceException("Results == null");
        }
        if (objectArray.length != objectArray2.length) {
            throw new ServiceException("Size of results differs from requested");
        }
    }

    void checkServiceResult(ServiceResponse serviceResponse, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        ResponseHeader responseHeader = serviceResponse.getResponseHeader();
        this.es.set(responseHeader);
        this.eq.set(diagnosticInfoArray);
        if (responseHeader.getServiceResult().isBad()) {
            throw new ServiceException(responseHeader.getServiceResult(), responseHeader.getServiceDiagnostics());
        }
    }

    SessionChannel u() throws ServerConnectionException {
        logger.trace("getChannel");
        if (!this.isConnected()) {
            throw new ServerConnectionException("Server not connected", this.aj(), this.eD);
        }
        return this.ef.get();
    }

    UnsignedInteger aB() {
        return this.eh;
    }

    NamespaceTable a(boolean bl, DataValue dataValue) throws ServiceException, StatusException {
        if (!this.eu || bl) {
            this.b(dataValue);
        }
        return this.getNamespaceTable();
    }

    RequestHeader getRequestHeader() {
        return this.a(this.eh, this.timeoutHint, this.auditEntryId);
    }

    SubscriptionBase a(SubscriptionBase subscriptionBase) throws ServiceException, ServerConnectionException {
        logger.debug("modifySubscription: isConnected={}", (Object)this.isConnected());
        if (this.isConnected()) {
            ModifySubscriptionResponse modifySubscriptionResponse;
            try {
                logger.debug("modifySubscription: subscription={}", (Object)subscriptionBase);
                modifySubscriptionResponse = this.u().ModifySubscription(this.getRequestHeader(), subscriptionBase.getSubscriptionId(), subscriptionBase.getPublishingInterval(), UnsignedInteger.valueOf(subscriptionBase.getLifetimeCount()), UnsignedInteger.valueOf(subscriptionBase.getMaxKeepAliveCount()), UnsignedInteger.valueOf(subscriptionBase.getMaxNotificationsPerPublish()), UnsignedByte.valueOf(subscriptionBase.getPriority()));
                logger.debug("modifySubscription: response={}", (Object)modifySubscriptionResponse.getResponseHeader().getServiceResult());
            }
            catch (ServiceFaultException serviceFaultException) {
                logger.debug("modifySubscription: exception={}", (Throwable)serviceFaultException);
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("modifySubscription: exception={}", (Throwable)serviceResultException);
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult(modifySubscriptionResponse, null);
            subscriptionBase.setPublishingInterval(modifySubscriptionResponse.getRevisedPublishingInterval());
            subscriptionBase.setLifetimeCount(modifySubscriptionResponse.getRevisedLifetimeCount());
            subscriptionBase.setMaxKeepAliveCount(modifySubscriptionResponse.getRevisedMaxKeepAliveCount());
        }
        return subscriptionBase;
    }

    i b(boolean bl, Map<NodeId, Set<UnsignedInteger>> map, TimestampsToReturn timestampsToReturn) throws ServiceException {
        Object object;
        int n2;
        DataValue[] dataValueArray;
        if (bl) {
            try {
                return this.a(true, map, timestampsToReturn).waitForResult();
            }
            catch (ServiceResultException serviceResultException) {
                if (serviceResultException.getCause() instanceof ServiceException) {
                    throw (ServiceException)serviceResultException.getCause();
                }
                throw new ServiceException("Could not Read", serviceResultException);
            }
        }
        Double d2 = 0.0;
        ArrayList<ReadValueId> arrayList = new ArrayList<ReadValueId>();
        HashMap hashMap = new HashMap();
        for (NodeId nodeId : map.keySet()) {
            hashMap.put(nodeId, new HashMap());
            for (UnsignedInteger unsignedInteger : map.get(nodeId)) {
                arrayList.add(new ReadValueId(nodeId, unsignedInteger, null, null));
            }
        }
        ReadValueId[] readValueIdArray2 = arrayList.toArray(new ReadValueId[0]);
        int n3 = 0;
        if (readValueIdArray2.length > 1 && this.getActualOperationLimits() != null) {
            try {
                n3 = this.getActualOperationLimits().getMaxNodesPerRead().intValue();
            }
            catch (Exception exception) {
                logger.debug("read: Failed to get operationLimits.MaxNodesPerRead: ", (Throwable)exception);
            }
        }
        int n4 = 0;
        if (n3 > 0 && n3 < readValueIdArray2.length) {
            dataValueArray = new DataValue[readValueIdArray2.length];
            for (n2 = 0; n2 < readValueIdArray2.length; n2 += n3) {
                int n5 = Math.min(n3, readValueIdArray2.length - n2);
                ReadValueId[] readValueIdArray3 = Arrays.copyOfRange(readValueIdArray2, n2, n2 + n5);
                object = this.a(d2, timestampsToReturn, readValueIdArray3);
                ++n4;
                for (int i2 = 0; i2 < n5; ++i2) {
                    dataValueArray[n2 + i2] = ((ReadResponse)object).getResults()[i2];
                }
            }
        } else {
            ReadResponse readResponse = this.a(d2, timestampsToReturn, readValueIdArray2);
            ++n4;
            dataValueArray = readResponse.getResults();
        }
        for (n2 = 0; n2 < dataValueArray.length; ++n2) {
            DataValue dataValue = dataValueArray[n2];
            NodeId nodeId = ((ReadValueId)arrayList.get(n2)).getNodeId();
            object = ((ReadValueId)arrayList.get(n2)).getAttributeId();
            ((Map)hashMap.get(nodeId)).put(object, dataValue);
        }
        HashMap hashMap2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            hashMap2.put(entry.getKey(), Collections.unmodifiableMap((Map)entry.getValue()));
        }
        return i.b(Collections.unmodifiableMap(hashMap2), n4);
    }

    void e(UnsignedInteger unsignedInteger) {
        this.eh = unsignedInteger;
    }

    void b(SubscriptionBase subscriptionBase) throws ServiceException, StatusException {
        if (this.isConnected()) {
            SetPublishingModeResponse setPublishingModeResponse;
            try {
                setPublishingModeResponse = this.u().SetPublishingMode(this.getRequestHeader(), subscriptionBase.isPublishingEnabled(), subscriptionBase.getSubscriptionId());
            }
            catch (ServiceFaultException serviceFaultException) {
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult(setPublishingModeResponse, setPublishingModeResponse.getDiagnosticInfos());
            this.checkOperationResult(setPublishingModeResponse.getResults()[0]);
        }
    }

    static {
        UaClient.a(Attributes.AccessLevel, UnsignedByte.class);
        UaClient.a(Attributes.ArrayDimensions, UnsignedInteger[].class);
        UaClient.a(Attributes.BrowseName, QualifiedName.class);
        UaClient.a(Attributes.ContainsNoLoops, Boolean.class);
        UaClient.a(Attributes.DataType, NodeId.class);
        UaClient.a(Attributes.Description, LocalizedText.class);
        UaClient.a(Attributes.DisplayName, LocalizedText.class);
        UaClient.a(Attributes.EventNotifier, UnsignedByte.class);
        UaClient.a(Attributes.Executable, Boolean.class);
        UaClient.a(Attributes.Historizing, Boolean.class);
        UaClient.a(Attributes.InverseName, LocalizedText.class);
        UaClient.a(Attributes.IsAbstract, Boolean.class);
        UaClient.a(Attributes.MinimumSamplingInterval, Double.class);
        UaClient.a(Attributes.NodeClass, Integer.class);
        UaClient.a(Attributes.NodeId, NodeId.class);
        UaClient.a(Attributes.Symmetric, Boolean.class);
        UaClient.a(Attributes.UserAccessLevel, UnsignedByte.class);
        UaClient.a(Attributes.UserExecutable, Boolean.class);
        UaClient.a(Attributes.UserWriteMask, UnsignedInteger.class);
        UaClient.a(Attributes.ValueRank, Integer.class);
        UaClient.a(Attributes.WriteMask, UnsignedInteger.class);
    }

    private class a
    implements ResultListener<PublishResponse>,
    Runnable {
        private long fe;
        private final Logger logger = LoggerFactory.getLogger(a.class);
        private final AtomicInteger ff = new AtomicInteger(0);
        private volatile boolean fg = false;
        private final AtomicInteger fh = new AtomicInteger(0);

        public void b(PublishResponse publishResponse) {
            this.logger.debug("onCompleted entering");
            int n2 = this.ff.decrementAndGet();
            this.logger.debug("onCompleted publishRequestCount decremented, is={}", (Object)n2);
            try {
                PublishResponse publishResponse2 = publishResponse;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("onCompleted: ServiceResult={} Results={}", (Object)publishResponse2.getResponseHeader().getServiceResult(), (Object)Arrays.toString(publishResponse2.getResults()));
                }
                if (UaClient.this.a(publishResponse2)) {
                    this.aK();
                }
            }
            catch (ServiceException serviceException) {
                this.a(serviceException, serviceException.getServiceResult().getValue());
            }
            catch (Exception exception) {
                this.logger.error("Failed to handle a complete publish message", (Throwable)exception);
            }
        }

        @Override
        public void onError(ServiceResultException serviceResultException) {
            this.logger.debug("onError entering");
            int n2 = this.ff.decrementAndGet();
            this.logger.debug("onError publishRequestCount decremented, is: {}", (Object)n2);
            this.a(serviceResultException, serviceResultException.getStatusCode().getValue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.logger.debug("run");
            while (!this.fg) {
                this.aE();
                this.aI();
                this.aF();
                this.aC();
                try {
                    this.logger.trace("sleep");
                    UaClient uaClient = UaClient.this;
                    synchronized (uaClient) {
                        UaClient.this.wait(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.logger.debug("interrupted");
                }
            }
            this.logger.debug("terminated");
        }

        public void terminate() {
            this.fg = true;
        }

        private void aC() {
            this.logger.trace("checkServerStatus: statusCheckInterval={}", (Object)UaClient.this.eP);
            if (UaClient.this.eP > 0L) {
                StatusCode statusCode;
                boolean bl = UaClient.this.ai() != null;
                ServerState serverState = UaClient.this.getServerState();
                boolean bl2 = serverState.equals(ServerState.CommunicationFault);
                if (bl2 && (statusCode = UaClient.this.ah()) != null) {
                    UnsignedInteger unsignedInteger = statusCode.getValue();
                    bl2 = this.f(unsignedInteger);
                }
                boolean bl3 = bl2 || serverState.equals(ServerState.Shutdown) && System.currentTimeMillis() > UaClient.this.eO;
                boolean bl4 = System.currentTimeMillis() - this.fe > UaClient.this.eP;
                this.logger.trace("checkServerStatus: hasStatus={} commError={} isConnected={} timeToCheck={} timeToReconnect", new Object[]{bl, bl2, UaClient.this.isConnected(), bl4});
                if (UaClient.this.isAutoReconnect() && bl3) {
                    try {
                        UaClient.this.reconnect();
                        bl4 = true;
                    }
                    catch (Exception exception) {
                        this.logger.debug("checkServerStatus: reconnect failed: ", (Throwable)exception);
                    }
                }
                if (UaClient.this.isConnected() && (!bl || bl4)) {
                    UaClient.this.updateServerStatus();
                    this.fe = System.currentTimeMillis();
                    if (UaClient.this.en) {
                        UaClient.this.a(false);
                    }
                }
            }
        }

        private void aD() {
            for (Subscription subscription : UaClient.this.eU) {
                subscription.checkTimeout();
            }
        }

        private int aE() {
            int n2 = UaClient.this.ex.get();
            int n3 = this.ff.get();
            int n4 = this.fh.getAndSet(0);
            if (n4 > 0) {
                this.logger.debug("decrementPublishRequestSetpoint: sp={} currentCount={} tooManyPublishRequests={}", new Object[]{n2, n3, n4});
                n2 = n2 == 0 || n3 > 0 && n2 > n3 ? n3 : (n2 > n4 ? (n2 -= n4) : 1);
                this.logger.debug("decrementPublishRequestSetpoint: sp={}", (Object)n2);
                UaClient.this.ex.set(n2);
            }
            return n2;
        }

        private void a(Exception exception, UnsignedInteger unsignedInteger) {
            if (this.f(unsignedInteger)) {
                this.logger.debug("onError: {}", (Object)exception.getMessage());
            } else if (StatusCodes.Bad_TooManyPublishRequests.equals(unsignedInteger)) {
                this.fh.incrementAndGet();
                this.logger.debug("Got Bad_TooManyPublishRequest from the server. Current requests={}, toomanys={}", (Object)this.ff.get(), (Object)this.fh.get());
            } else if (StatusCodes.Bad_NoSubscription.equals(unsignedInteger)) {
                if (this.aH()) {
                    this.logger.info("Got Bad_NoSubscription as a PublishResponse, although we have connected Subscriptions");
                }
            } else {
                this.logger.warn("onError: ", (Throwable)exception);
            }
        }

        private void aF() {
            for (Subscription subscription : UaClient.this.eU) {
                try {
                    subscription.handleNotificationDatas();
                }
                catch (Exception exception) {
                    this.logger.error("handlePublishResponses", (Throwable)exception);
                }
            }
            this.aD();
        }

        private boolean aG() {
            for (Subscription subscription : UaClient.this.getSubscriptions()) {
                if (!subscription.isConnected() || !subscription.isAlive()) continue;
                return true;
            }
            return false;
        }

        private boolean aH() {
            for (Subscription subscription : UaClient.this.getSubscriptions()) {
                if (!subscription.isConnected() || subscription.isTimeout()) continue;
                return true;
            }
            return false;
        }

        private boolean hasPublishResponses() {
            for (Subscription subscription : UaClient.this.eU) {
                if (!subscription.hasPublishResponses()) continue;
                return true;
            }
            return false;
        }

        private boolean isActive() {
            ServerStatusDataType serverStatusDataType = null;
            try {
                serverStatusDataType = UaClient.this.getServerStatus();
                this.logger.trace("isActive: status={}", (Object)serverStatusDataType);
                if (serverStatusDataType == null && UaClient.this.eP == 0L) {
                    return true;
                }
                return serverStatusDataType != null && serverStatusDataType.getState().equals(ServerState.Running);
            }
            catch (ServerConnectionException serverConnectionException) {
                this.logger.trace("isActive: exception=", (Throwable)serverConnectionException);
                return false;
            }
            catch (StatusException statusException) {
                this.logger.trace("isActive: exception=", (Throwable)statusException);
                return false;
            }
        }

        private void aI() {
            boolean bl = this.aG();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("queuePublishRequests: subscription count:{}, hasConnectedAliveSubscriptions:{}", (Object)UaClient.this.eU.size(), (Object)bl);
            }
            if (bl) {
                for (int i2 = 0; i2 < 5 && this.aK(); ++i2) {
                }
            }
        }

        private void aJ() {
            UaClient.this.a(null);
        }

        private synchronized boolean aK() {
            int n2 = this.ff.get();
            int n3 = UaClient.this.getActualPublishRequestSetpoint();
            this.logger.trace("sendPublishRequest: requestCount={}, setPoint={}", (Object)n2, (Object)n3);
            if (this.isActive() && n2 < n3) {
                try {
                    SessionChannel sessionChannel = UaClient.this.u();
                    this.logger.debug("sendPublishRequest: channel={} secureChannel.isOpen={}", (Object)sessionChannel, (Object)sessionChannel.getSecureChannel().isOpen());
                    if (sessionChannel != null) {
                        RequestHeader requestHeader = UaClient.this.a(null, UaClient.this.getPublishRequestTimeout(), null);
                        PublishRequest publishRequest = new PublishRequest(requestHeader, UaClient.this.getSubscriptionAcknowledgements());
                        if (UaClient.this.et != null) {
                            UaClient.this.et.onBeforePublishRequest(UaClient.this, publishRequest);
                        }
                        AsyncResult<PublishResponse> asyncResult = sessionChannel.PublishAsync(publishRequest);
                        asyncResult.setListener(this);
                        int n4 = this.ff.incrementAndGet();
                        this.logger.debug("sendPublishRequest, publishRequestCount: {}", (Object)n4);
                        return true;
                    }
                }
                catch (ServerConnectionException serverConnectionException) {
                    this.logger.debug("ServerConnectionException: ", (Throwable)serverConnectionException);
                }
            }
            return false;
        }

        protected boolean f(UnsignedInteger unsignedInteger) {
            return unsignedInteger.equals(StatusCodes.Bad_ServerNotConnected) || unsignedInteger.equals(StatusCodes.Bad_Timeout) || unsignedInteger.equals(StatusCodes.Bad_SessionClosed) || unsignedInteger.equals(StatusCodes.Bad_SecureChannelIdInvalid) || unsignedInteger.equals(StatusCodes.Bad_SecureChannelClosed) || unsignedInteger.equals(StatusCodes.Bad_SessionIdInvalid) || unsignedInteger.equals(StatusCodes.Bad_SessionNotActivated);
        }

        @Override
        public /* synthetic */ void onCompleted(Object object) {
            this.b((PublishResponse)object);
        }
    }
}

