/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.client.ServerListException;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.ServerOnNetwork;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerListBase {
    private static Logger logger = LoggerFactory.getLogger(ServerListBase.class);
    protected DateTime lastCounterResetTime = new DateTime();
    protected final List<ApplicationDescription> servers = new CopyOnWriteArrayList<ApplicationDescription>();
    protected final List<ServerOnNetwork> serversOnNetwork = new CopyOnWriteArrayList<ServerOnNetwork>();

    public ServerListBase() {
    }

    public ServerListBase(String string) throws ServerListException {
        this.discover(string);
    }

    public void clear() {
        this.servers.clear();
    }

    public abstract void discover(String var1) throws ServerListException;

    public ApplicationDescription get(int n2) {
        return this.servers.get(n2);
    }

    public DateTime getLastCounterResetTime() {
        return this.lastCounterResetTime;
    }

    public ApplicationDescription[] getServers() {
        return this.servers.toArray(new ApplicationDescription[this.servers.size()]);
    }

    public ServerOnNetwork[] getServersOnNetwork() {
        return this.serversOnNetwork.toArray(new ServerOnNetwork[this.serversOnNetwork.size()]);
    }

    public boolean isEmpty() {
        return this.servers.isEmpty();
    }

    public int size() {
        return this.servers.size();
    }
}

