/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MonitoringFilterResult;
import com.prosysopc.ua.stack.core.MonitoringMode;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonitoredItem
extends MonitoredItemBase {
    private static AtomicInteger dw = new AtomicInteger(0);
    protected static Logger logger = LoggerFactory.getLogger(MonitoredItem.class);
    private StatusCode dx;
    private ExpandedNodeId dy;
    private boolean modified;
    private boolean dz;
    private Subscription dA;

    private static UnsignedInteger R() {
        return UnsignedInteger.valueOf(dw.incrementAndGet());
    }

    protected MonitoredItem(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode) {
        super(MonitoredItem.R(), null, null, unsignedInteger, monitoringMode);
        this.dy = expandedNodeId;
    }

    protected MonitoredItem(NodeId nodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode) {
        super(MonitoredItem.R(), null, nodeId, unsignedInteger, monitoringMode);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            MonitoredItem monitoredItem = (MonitoredItem)object;
            return this.dA == monitoredItem.dA;
        }
        return false;
    }

    public StatusCode getErrorCode() {
        return this.dx;
    }

    public ExpandedNodeId getExpandedNodeId() {
        return this.dy;
    }

    @Override
    public NodeId getNodeId() {
        if (this.dy != null) {
            try {
                return this.getSubscription().getClient().getNamespaceTable().toNodeId(this.dy);
            }
            catch (ServiceResultException serviceResultException) {
                throw new RuntimeException(serviceResultException);
            }
        }
        return super.getNodeId();
    }

    public Subscription getSubscription() {
        return this.dA;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isMonitoringModeModified() {
        return this.dz;
    }

    protected void clearModified() {
        this.modified = false;
    }

    protected void clearMonitoringModeModified() {
        this.dz = false;
    }

    protected void itemChanged() throws ServiceException {
        if (this.dA != null) {
            if (this.dA.isConnected()) {
                this.modified = true;
            }
            this.dA.itemChanged(this);
        }
    }

    @Override
    protected void monitoringModeChanged() throws ServiceException {
        super.monitoringModeChanged();
        if (this.dA != null) {
            if (this.dA.isConnected()) {
                this.dz = true;
            }
            this.dA.monitoringModeChanged(this);
        }
    }

    protected void setClientHandle(int n2) {
        this.clientHandle = UnsignedInteger.valueOf(n2);
    }

    protected void setErrorCode(StatusCode statusCode) {
        this.dx = statusCode;
    }

    @Override
    protected void setFilterResult(MonitoringFilterResult monitoringFilterResult) {
        super.setFilterResult(monitoringFilterResult);
    }

    @Override
    protected void setMonitoredItemId(UnsignedInteger unsignedInteger) {
        super.setMonitoredItemId(unsignedInteger);
    }

    protected void setRevisedQueueSize(UnsignedInteger unsignedInteger) {
        this.queueSize = unsignedInteger.longValue();
    }

    @Override
    protected void updateFilter() throws ServiceException {
        super.updateFilter();
        this.itemChanged();
    }

    @Override
    protected void updateQueue() throws ServiceException {
        super.updateQueue();
        this.itemChanged();
    }

    void a(Subscription subscription) {
        this.dA = subscription;
    }
}

