/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.SecureIdentity;
import com.prosysopc.ua.SecureIdentityException;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.core.UserTokenType;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserIdentity
extends SecureIdentity {
    private static Logger logger = LoggerFactory.getLogger(UserIdentity.class);
    protected static Map<String, UserTokenPolicy> policyMap = new HashMap<String, UserTokenPolicy>();
    private String password;
    protected byte[] encryptedPassword;
    protected byte[] issuedIdentityToken;
    protected String name;
    protected UserTokenType type;

    public static UserTokenPolicy getUserTokenPolicy(String string) {
        return policyMap.get(string);
    }

    public UserIdentity() {
        this.type = UserTokenType.Anonymous;
        this.name = null;
        this.password = null;
        this.issuedIdentityToken = null;
    }

    public UserIdentity(byte[] byArray) {
        this.name = null;
        this.password = null;
        this.issuedIdentityToken = byArray;
        this.type = UserTokenType.IssuedToken;
    }

    public UserIdentity(Cert cert, PrivKey privKey) {
        super(cert, privKey);
        this.name = null;
        this.password = null;
        this.issuedIdentityToken = null;
        this.type = UserTokenType.Certificate;
    }

    public UserIdentity(File file, File file2, String string) throws IOException, SecureIdentityException {
        super(file, file2, string);
        this.name = null;
        this.password = null;
        this.issuedIdentityToken = null;
        this.type = UserTokenType.Certificate;
    }

    public UserIdentity(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (string2 == null) {
            throw new NullPointerException("password");
        }
        this.name = string;
        this.password = string2;
        this.issuedIdentityToken = null;
        this.type = UserTokenType.UserName;
    }

    public UserIdentity(URL uRL, URL uRL2, String string) throws IOException, SecureIdentityException {
        super(uRL, uRL2, string);
        this.name = null;
        this.password = null;
        this.issuedIdentityToken = null;
        this.type = UserTokenType.Certificate;
    }

    @Override
    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean bl) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (bl && this.getClass() != object.getClass()) {
            return false;
        }
        UserIdentity userIdentity = (UserIdentity)object;
        if (this.type == null) {
            return userIdentity.type == null;
        }
        if (!this.type.equals(userIdentity.type)) {
            return false;
        }
        switch (this.type) {
            case Certificate: {
                if (super.equals(object)) break;
                return false;
            }
            case UserName: {
                if (this.name == null ? userIdentity.name != null : !this.name.equals(userIdentity.name)) {
                    return false;
                }
                if (!(this.password == null ? userIdentity.password != null : !this.password.equals(userIdentity.password))) break;
                return false;
            }
        }
        return true;
    }

    public byte[] getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public byte[] getIssuedIdentityToken() {
        return this.issuedIdentityToken;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public UserTokenType getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = this.type.hashCode();
        switch (this.type) {
            case Certificate: {
                n3 = 31 * n3 + super.hashCode();
                break;
            }
            case UserName: {
                n3 = 31 * n3 + (this.name == null ? 0 : this.name.hashCode());
                n3 = 31 * n3 + (this.password == null ? 0 : this.password.hashCode());
                break;
            }
        }
        return n3;
    }

    public String toString() {
        String string = String.format("Type=%s", this.type.toString());
        String string2 = null;
        switch (this.type) {
            case Certificate: {
                string2 = this.certificate.toString();
                break;
            }
            case UserName: {
                string2 = String.format("%s", this.name);
                break;
            }
        }
        if (string2 == null) {
            return string;
        }
        return string + " - " + string2;
    }

    protected void decryptPassword(UserIdentityToken userIdentityToken, ApplicationIdentity applicationIdentity, ByteString byteString, String string) throws SecureIdentityException {
        this.decryptPassword(userIdentityToken, applicationIdentity.getCertificates(), byteString, string);
    }

    protected void decryptPassword(UserIdentityToken userIdentityToken, KeyPair[] keyPairArray, ByteString byteString, String string) throws SecureIdentityException {
        SecurityAlgorithm securityAlgorithm;
        UserTokenPolicy userTokenPolicy;
        if (logger.isDebugEnabled()) {
            logger.debug("decryptPassword: token={}", (Object)userIdentityToken);
            logger.debug("decryptPassword: encryptedPassword={}", (Object)CryptoUtil.toHex(this.encryptedPassword));
        }
        if ((userTokenPolicy = UserIdentity.getUserTokenPolicy(userIdentityToken.getPolicyId())) == null) {
            throw new SecureIdentityException("Unknown security policy defined: policyId=" + userIdentityToken.getPolicyId());
        }
        byte[] byArray = null;
        if (string != null && !string.isEmpty()) {
            securityAlgorithm = SecurityAlgorithm.valueOfUri(string);
            if (securityAlgorithm == null) {
                throw new SecureIdentityException("Unknown encryption algorithm defined: algorithmUri=" + string);
            }
        } else {
            try {
                SecurityPolicy objectArray = SecurityPolicy.getSecurityPolicy(userTokenPolicy.getSecurityPolicyUri());
                securityAlgorithm = objectArray.getAsymmetricEncryptionAlgorithm();
            }
            catch (ServiceResultException serviceResultException) {
                throw new SecureIdentityException("Unknown security policy defined: policyUri=" + userTokenPolicy.getSecurityPolicyUri(), serviceResultException);
            }
        }
        if (securityAlgorithm == null) {
            this.password = new String(Arrays.copyOf(this.encryptedPassword, this.encryptedPassword.length), BinaryEncoder.UTF8);
        } else {
            byte[] byArray2;
            for (KeyPair keyPair : keyPairArray) {
                try {
                    byArray = this.decrypt(securityAlgorithm, this.encryptedPassword, keyPair.getPrivateKey());
                    logger.debug("Successfully decrypted with key size {}", (Object)keyPair.getPrivateKey().getPrivateKey().getModulus().bitLength());
                    break;
                }
                catch (Exception exception) {
                    logger.debug("Failed to decrypt with key size {}", (Object)keyPair.getPrivateKey().getPrivateKey().getModulus().bitLength(), (Object)exception);
                }
            }
            if (byArray == null) {
                throw new SecureIdentityException("Failed to decrypt user password");
            }
            try {
                byArray2 = Arrays.copyOfRange(byArray, byArray.length - byteString.getLength(), byArray.length);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new SecureIdentityException("Password string does not include server nonce", arrayIndexOutOfBoundsException);
            }
            if (!Arrays.equals(byArray2, byteString.getValue())) {
                throw new SecureIdentityException("Invalid server nonce.");
            }
            this.password = new String(Arrays.copyOf(byArray, byArray.length - byteString.getLength()), BinaryEncoder.UTF8);
        }
    }

    static {
        for (Field field : UserTokenPolicy.class.getDeclaredFields()) {
            UserTokenPolicy userTokenPolicy;
            if (!field.getType().equals(UserTokenPolicy.class)) continue;
            try {
                userTokenPolicy = (UserTokenPolicy)field.get(null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            policyMap.put(userTokenPolicy.getPolicyId(), userTokenPolicy);
        }
    }
}

