/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.core.RelativePathElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class UaRelativePath {
    private static final UaQualifiedName[] cm = new UaQualifiedName[0];
    private final UaQualifiedName[] cn;

    public static UaRelativePath from(NamespaceTable namespaceTable, QualifiedName ... qualifiedNameArray) {
        if (namespaceTable == null) {
            throw new IllegalArgumentException("The given namespace table cannot be null");
        }
        if (qualifiedNameArray == null) {
            throw new IllegalArgumentException("The given elements cannot be null");
        }
        ArrayList<UaQualifiedName> arrayList = new ArrayList<UaQualifiedName>();
        for (QualifiedName qualifiedName : qualifiedNameArray) {
            arrayList.add(UaQualifiedName.from(qualifiedName, namespaceTable));
        }
        return UaRelativePath.from(arrayList.toArray(cm));
    }

    public static UaRelativePath from(UaNamespace uaNamespace, String ... stringArray) {
        if (uaNamespace == null) {
            throw new IllegalArgumentException("The given namespace cannot be null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("The given elementNames cannot be null");
        }
        ArrayList<UaQualifiedName> arrayList = new ArrayList<UaQualifiedName>();
        for (String string : stringArray) {
            arrayList.add(UaQualifiedName.from(uaNamespace.getURI(), string));
        }
        return UaRelativePath.from(arrayList.toArray(cm));
    }

    public static UaRelativePath from(UaQualifiedName ... uaQualifiedNameArray) {
        return new UaRelativePath(uaQualifiedNameArray);
    }

    public static UaRelativePath standard(String ... stringArray) {
        return UaRelativePath.from(UaNamespace.STANDARD, stringArray);
    }

    private UaRelativePath(UaQualifiedName ... uaQualifiedNameArray) {
        if (uaQualifiedNameArray == null) {
            throw new IllegalArgumentException("The given elements cannot be null");
        }
        this.cn = Arrays.copyOf(uaQualifiedNameArray, uaQualifiedNameArray.length);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaRelativePath uaRelativePath = (UaRelativePath)object;
        return Arrays.equals(this.cn, uaRelativePath.cn);
    }

    public List<UaQualifiedName> getElements() {
        return Collections.unmodifiableList(Arrays.asList(this.cn));
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Arrays.hashCode(this.cn);
        return n3;
    }

    public RelativePath toRelativePath(NamespaceTable namespaceTable, ExpandedNodeId expandedNodeId, boolean bl, boolean bl2) {
        NodeId nodeId;
        if (namespaceTable == null) {
            throw new IllegalArgumentException("The given namespace table cannot be null");
        }
        try {
            nodeId = namespaceTable.toNodeId(expandedNodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new IllegalArgumentException("Cannot convert referenceType to nodeid ", serviceResultException);
        }
        ArrayList<RelativePathElement> arrayList = new ArrayList<RelativePathElement>();
        for (UaQualifiedName uaQualifiedName : this.cn) {
            arrayList.add(new RelativePathElement(nodeId, bl, bl2, uaQualifiedName.toQualifiedName(namespaceTable)));
        }
        return new RelativePath(arrayList.toArray(new RelativePathElement[arrayList.size()]));
    }

    public String toString() {
        return "UaRelativePath [elements=" + Arrays.toString(this.cn) + "]";
    }
}

