/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubscriptionBase
implements Comparable<SubscriptionBase> {
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionBase.class);
    private final AtomicReference<UnsignedInteger> bT = new AtomicReference<UnsignedInteger>(UnsignedInteger.ZERO);
    protected final Map<UnsignedInteger, MonitoredItemBase> items = new ConcurrentSkipListMap<UnsignedInteger, MonitoredItemBase>();
    protected long lifetimeCount;
    protected long maxKeepAliveCount;
    protected int maxNotificationsPerPublish;
    protected int priority;
    protected boolean publishingEnabled;
    protected double publishingInterval;
    protected int updateCount = 0;

    private static int a(UnsignedInteger unsignedInteger) {
        int n2 = unsignedInteger.intValue();
        if (n2 < 0) {
            return Integer.MAX_VALUE;
        }
        return n2;
    }

    public SubscriptionBase(UnsignedInteger unsignedInteger, boolean bl, double d2, long l2, long l3, int n2, int n3) {
        this.bT.set(unsignedInteger);
        this.publishingEnabled = bl;
        this.publishingInterval = d2;
        this.lifetimeCount = l2;
        this.maxKeepAliveCount = l3;
        this.maxNotificationsPerPublish = n2;
        this.priority = n3;
    }

    public SubscriptionBase(UnsignedInteger unsignedInteger, Boolean bl, Double d2, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3, UnsignedInteger unsignedInteger4, UnsignedByte unsignedByte) {
        this(unsignedInteger, (boolean)bl, (double)d2, unsignedInteger2.getValue(), unsignedInteger3.getValue(), SubscriptionBase.a(unsignedInteger4), unsignedByte.getValue());
    }

    public void addItem(MonitoredItemBase monitoredItemBase, UnsignedInteger unsignedInteger) {
        logger.debug("addItem: {}", (Object)monitoredItemBase);
        if (unsignedInteger == null) {
            throw new NullPointerException("itemId");
        }
        this.items.put(unsignedInteger, monitoredItemBase);
    }

    public void beginUpdate() {
        ++this.updateCount;
    }

    @Override
    public int compareTo(SubscriptionBase subscriptionBase) {
        return subscriptionBase.priority - this.priority;
    }

    public final void endUpdate() throws ServiceException {
        if (this.updateCount <= 0) {
            throw new RuntimeException("UpdateCount already 0. Unmatched beginUpdate/endUpdate.");
        }
        if (--this.updateCount == 0) {
            this.applyUpdates();
        }
    }

    public MonitoredItemBase getItem(NodeId nodeId, UnsignedInteger unsignedInteger) {
        for (MonitoredItemBase monitoredItemBase : this.items.values()) {
            if (!monitoredItemBase.getNodeId().equals(nodeId) || !monitoredItemBase.getAttributeId().equals(unsignedInteger)) continue;
            return monitoredItemBase;
        }
        return null;
    }

    public MonitoredItemBase getItem(UnsignedInteger unsignedInteger) throws StatusException {
        MonitoredItemBase monitoredItemBase;
        if (logger.isDebugEnabled()) {
            logger.debug("getItem: itemCount={}; itemId={}", (Object)this.getItemCount(), (Object)unsignedInteger);
        }
        if ((monitoredItemBase = this.items.get(unsignedInteger)) == null) {
            throw new StatusException(StatusCodes.Bad_MonitoredItemIdInvalid);
        }
        return monitoredItemBase;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public MonitoredItemBase[] getItems() {
        return this.items.values().toArray(new MonitoredItemBase[this.items.size()]);
    }

    public long getLifetimeCount() {
        return this.lifetimeCount;
    }

    public long getMaxKeepAliveCount() {
        return this.maxKeepAliveCount;
    }

    public int getMaxNotificationsPerPublish() {
        return this.maxNotificationsPerPublish;
    }

    public int getPriority() {
        return this.priority;
    }

    public double getPublishingInterval() {
        return this.publishingInterval;
    }

    public UnsignedInteger getSubscriptionId() {
        return this.bT.get();
    }

    public boolean hasItem(NodeId nodeId, UnsignedInteger unsignedInteger) {
        return this.getItem(nodeId, unsignedInteger) != null;
    }

    public boolean hasItem(UnsignedInteger unsignedInteger) {
        try {
            return this.getItem(unsignedInteger) != null;
        }
        catch (StatusException statusException) {
            return false;
        }
    }

    public boolean isPublishingEnabled() {
        return this.publishingEnabled;
    }

    public abstract MonitoredItemBase removeItem(MonitoredItemBase var1) throws ServiceException, StatusException;

    public MonitoredItemBase removeItem(UnsignedInteger unsignedInteger) throws ServiceException, StatusException {
        logger.debug("removeItem: {}", (Object)unsignedInteger);
        return this.items.remove(unsignedInteger);
    }

    public final void setLifetimeCount(long l2) throws ServiceException {
        this.setLifetimeCount(UnsignedInteger.valueOf(l2));
    }

    public void setLifetimeCount(UnsignedInteger unsignedInteger) throws ServiceException {
        if (this.lifetimeCount != unsignedInteger.getValue()) {
            this.lifetimeCount = unsignedInteger.getValue();
            this.paramChanged();
        }
    }

    public final void setMaxKeepAliveCount(long l2) throws ServiceException {
        this.setMaxKeepAliveCount(UnsignedInteger.valueOf(l2));
    }

    public void setMaxKeepAliveCount(UnsignedInteger unsignedInteger) throws ServiceException {
        if (this.maxKeepAliveCount != unsignedInteger.getValue()) {
            this.maxKeepAliveCount = unsignedInteger.getValue();
            this.paramChanged();
        }
    }

    public final void setMaxNotificationsPerPublish(long l2) throws ServiceException {
        this.setMaxNotificationsPerPublish(UnsignedInteger.valueOf(l2));
    }

    public void setMaxNotificationsPerPublish(UnsignedInteger unsignedInteger) throws ServiceException {
        int n2 = SubscriptionBase.a(unsignedInteger);
        if (this.maxNotificationsPerPublish != n2) {
            this.maxNotificationsPerPublish = n2;
            this.paramChanged();
        }
    }

    public final void setPriority(int n2) throws ServiceException {
        this.setPriority(UnsignedByte.valueOf(n2));
    }

    public void setPriority(UnsignedByte unsignedByte) throws ServiceException {
        if (this.priority != unsignedByte.getValue()) {
            logger.debug("setPriority: priority={} oldPriority={}", (Object)unsignedByte, (Object)this.priority);
            this.priority = unsignedByte.getValue();
            this.paramChanged();
        }
    }

    public void setPublishingEnabled(boolean bl) throws ServiceException, StatusException {
        if (this.publishingEnabled != bl) {
            this.publishingEnabled = bl;
            this.enabledChanged();
        }
    }

    public void setPublishingInterval(double d2) throws ServiceException {
        if (this.publishingInterval != d2) {
            this.publishingInterval = d2;
            this.paramChanged();
        }
    }

    public void setPublishingInterval(long l2, TimeUnit timeUnit) throws ServiceException {
        double d2;
        switch (timeUnit) {
            case MICROSECONDS: {
                d2 = (double)l2 / 1000.0;
                break;
            }
            case NANOSECONDS: {
                d2 = (double)l2 / 1000000.0;
                break;
            }
            default: {
                d2 = timeUnit.toMillis(l2);
            }
        }
        this.setPublishingInterval(d2);
    }

    public String toString() {
        return String.format("Subscription id=%s", this.getSubscriptionId() + " PublishingInterval=" + this.getPublishingInterval() + " isPublishingEnabled=" + this.isPublishingEnabled() + " priority=" + this.getPriority() + " lifetimeCount=" + this.getLifetimeCount() + " maxKeepAliveCount=" + this.getMaxKeepAliveCount() + " maxNotificationsPerPublish=" + this.getMaxNotificationsPerPublish());
    }

    protected void applyUpdates() throws ServiceException {
    }

    protected void enabledChanged() throws ServiceException, StatusException {
    }

    protected void paramChanged() throws ServiceException {
    }

    protected void setSubscriptionId(UnsignedInteger unsignedInteger) {
        if (unsignedInteger == null) {
            unsignedInteger = UnsignedInteger.ZERO;
        }
        this.bT.set(unsignedInteger);
    }
}

