/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaException;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;

public class ServiceException
extends UaException {
    private final DiagnosticInfo diagnosticInfo;
    private final StatusCode serviceResult;

    public ServiceException(ServiceFaultException serviceFaultException) {
        this(serviceFaultException.getMessage(), serviceFaultException);
    }

    public ServiceException(ServiceResultException serviceResultException) {
        this(serviceResultException.getMessage(), serviceResultException);
    }

    public ServiceException(StatusCode statusCode) {
        this.serviceResult = statusCode;
        this.diagnosticInfo = null;
    }

    public ServiceException(StatusCode statusCode, DiagnosticInfo diagnosticInfo) {
        this.serviceResult = statusCode;
        this.diagnosticInfo = diagnosticInfo;
    }

    public ServiceException(String string) {
        this(string, (StatusCode)null);
    }

    public ServiceException(String string, ServiceFaultException serviceFaultException) {
        this(string, serviceFaultException.getStatusCode(), serviceFaultException.getServiceFault() == null ? null : serviceFaultException.getServiceFault().getResponseHeader().getServiceDiagnostics(), (Throwable)serviceFaultException);
    }

    public ServiceException(String string, ServiceResultException serviceResultException) {
        this(string, serviceResultException.getStatusCode(), null, (Throwable)serviceResultException);
    }

    public ServiceException(String string, StatusCode statusCode) {
        super(string);
        this.serviceResult = statusCode;
        this.diagnosticInfo = new DiagnosticInfo(string, null, null, null, null, null, null);
    }

    public ServiceException(String string, StatusCode statusCode, DiagnosticInfo diagnosticInfo, Throwable throwable) {
        super(string, throwable);
        this.serviceResult = statusCode;
        this.diagnosticInfo = diagnosticInfo;
    }

    public ServiceException(String string, UnsignedInteger unsignedInteger) {
        this(string, new StatusCode(unsignedInteger));
    }

    public ServiceException(String string, UnsignedInteger unsignedInteger, DiagnosticInfo diagnosticInfo, Throwable throwable) {
        this(string, new StatusCode(unsignedInteger), diagnosticInfo, throwable);
    }

    public ServiceException(UnsignedInteger unsignedInteger) {
        this(new StatusCode(unsignedInteger));
    }

    public DiagnosticInfo getDiagnosticInfo() {
        return this.diagnosticInfo;
    }

    public StatusCode getServiceResult() {
        return this.serviceResult;
    }

    @Override
    public String toString() {
        String string;
        String string2 = string = this.diagnosticInfo == null ? "" : this.diagnosticInfo.toString();
        if (string.length() > 0) {
            string = " Diagnostics=" + string;
        }
        String string3 = this.serviceResult == null ? "" : "ServiceResult=" + this.serviceResult;
        return String.format("%s %s%s", super.toString(), string3, string);
    }
}

