/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.ModelException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AddNodesItem;
import com.prosysopc.ua.stack.core.AddReferencesItem;
import com.prosysopc.ua.stack.core.DataTypeAttributes;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.MethodAttributes;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ObjectAttributes;
import com.prosysopc.ua.stack.core.ObjectTypeAttributes;
import com.prosysopc.ua.stack.core.ReferenceTypeAttributes;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.VariableAttributes;
import com.prosysopc.ua.stack.core.VariableTypeAttributes;
import com.prosysopc.ua.stack.core.ViewAttributes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.xml.XmlDecoder;
import com.prosysopc.ua.stack.utils.XMLFactoryCache;
import com.prosysopc.ua.typedictionary.DynamicEnumeration;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class ModelParserBase {
    public static final String UTF8_BOM = "\ufeff";
    private static final boolean aj = System.getProperty("java.vendor").toLowerCase().contains("android");
    private static boolean ak = true;
    private static final Logger logger = LoggerFactory.getLogger(ModelParserBase.class);
    private String alias;
    private final HashMap<String, NodeId> al = new HashMap();
    private final UaApplication am;
    private boolean an;
    private final Set<ExpandedNodeId> ao = new TreeSet<ExpandedNodeId>();
    private String ap;
    private final Map<String, Class<?>> aq;
    private String locale;
    private final NamespaceTable ar;
    private Locator locator;
    private final d as = new d();
    private AddNodesItem at;
    private NodeAttributes au;
    private AddReferencesItem av;
    private final List<AddReferencesItem> aw = new ArrayList<AddReferencesItem>();
    private final List<AddNodesItem> nodes = new ArrayList<AddNodesItem>();
    private final Map<ExpandedNodeId, AddReferencesItem> ax = new HashMap<ExpandedNodeId, AddReferencesItem>();
    private String ay;
    private b az;
    private boolean aA;
    private XMLReader aB;
    private boolean aC;
    private boolean aD;
    private int aE = 0;
    private final List<AddReferencesItem> aF = new ArrayList<AddReferencesItem>();
    private final UnsignedInteger aG = UnsignedInteger.ZERO;
    private TransformerHandler aH;
    private DOMResult aI;
    List<String> ah = new ArrayList<String>();
    private final List<VariableAttributes> aJ = new ArrayList<VariableAttributes>();
    private final List<VariableTypeAttributes> aK = new ArrayList<VariableTypeAttributes>();
    private Map<UaNodeId, StructureSpecification> aL = new HashMap<UaNodeId, StructureSpecification>();
    private Map<UaNodeId, UaNodeId> aM = new HashMap<UaNodeId, UaNodeId>();
    private Map<UaNodeId, UaNodeId> aN = new HashMap<UaNodeId, UaNodeId>();
    private Map<UaNodeId, UaNodeId> aO = new HashMap<UaNodeId, UaNodeId>();
    private Set<UaNodeId> aP = new HashSet<UaNodeId>();
    private Map<UaNodeId, UaNodeId> aQ = new HashMap<UaNodeId, UaNodeId>();
    private Map<UaNodeId, UaNodeId> aR = new HashMap<UaNodeId, UaNodeId>();
    private Map<UaNodeId, UaNodeId> aS = new HashMap<UaNodeId, UaNodeId>();

    public static boolean isSkipValuesOnAndroid() {
        return ak;
    }

    public static void setSkipValuesOnAndroid(boolean bl) {
        ak = bl;
    }

    public ModelParserBase(UaApplication uaApplication) {
        this.aq = new HashMap();
        this.am = uaApplication;
        this.ar = new NamespaceTable();
    }

    public void createModel(boolean bl) throws ModelException, ServiceException {
        Map.Entry entry2;
        logger.debug("Starting model creation..");
        this.setFailOnFirstError(bl);
        ArrayList<AddNodesItem> arrayList = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList2 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList3 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList4 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList5 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList6 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList7 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList8 = new ArrayList<AddNodesItem>();
        block14: for (AddNodesItem addNodesItem : this.nodes) {
            if (this.ao.contains(addNodesItem.getRequestedNewNodeId())) {
                logger.debug("ignored: {} NodeId={}", (Object)addNodesItem.getBrowseName(), (Object)addNodesItem.getRequestedNewNodeId());
                continue;
            }
            if (addNodesItem.getNodeClass() == null) {
                arrayList5.add(addNodesItem);
                continue;
            }
            switch (addNodesItem.getNodeClass()) {
                case ReferenceType: {
                    arrayList.add(addNodesItem);
                    continue block14;
                }
                case DataType: {
                    arrayList2.add(addNodesItem);
                    continue block14;
                }
                case Method: {
                    arrayList8.add(addNodesItem);
                    continue block14;
                }
                case Object: {
                    arrayList3.add(addNodesItem);
                    continue block14;
                }
                case ObjectType: {
                    arrayList6.add(addNodesItem);
                    continue block14;
                }
                case Variable: {
                    arrayList4.add(addNodesItem);
                    continue block14;
                }
                case VariableType: {
                    arrayList7.add(addNodesItem);
                    continue block14;
                }
                case View: {
                    arrayList5.add(addNodesItem);
                    continue block14;
                }
            }
            logger.warn("Encountered unkown NodeClass, ignoring node: " + addNodesItem.getNodeClass());
        }
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        concurrentHashMap.putAll(this.aL);
        logger.debug("StructureSpecifications to resolve: {}", (Object)concurrentHashMap.size());
        if (!concurrentHashMap.isEmpty()) {
            boolean bl2 = true;
            while (bl2) {
                bl2 = false;
                for (Map.Entry entry2 : concurrentHashMap.entrySet()) {
                    if (!this.a((StructureSpecification)entry2.getValue())) continue;
                    concurrentHashMap.remove(entry2.getKey());
                    bl2 = true;
                }
                if (!concurrentHashMap.isEmpty()) continue;
                bl2 = false;
            }
        }
        if (!concurrentHashMap.isEmpty()) {
            logger.warn("Failed to resolve custom Structure types: {}", (Object)concurrentHashMap.keySet());
        } else {
            logger.debug("Resolved all unknown Structure types");
        }
        logger.debug("Undecoded Variable Values count: {}", (Object)this.aJ.size());
        logger.debug("Undecoded VariableType Values count: {}", (Object)this.aK.size());
        logger.debug("Attempting to decode them now");
        for (VariableAttributes variableAttributes : this.aJ) {
            entry2 = (ExtensionObject)variableAttributes.getValue();
            try {
                variableAttributes.setValue(((ExtensionObject)((Object)entry2)).decode(this.getEncoderContext()));
            }
            catch (DecodingException decodingException) {
                logger.debug("Could not decode {}", (Object)entry2, (Object)decodingException);
            }
        }
        for (VariableTypeAttributes variableTypeAttributes : this.aK) {
            entry2 = (ExtensionObject)variableTypeAttributes.getValue();
            try {
                variableTypeAttributes.setValue(((ExtensionObject)((Object)entry2)).decode(this.getEncoderContext()));
            }
            catch (DecodingException decodingException) {
                logger.debug("Could not decode {}", (Object)entry2, (Object)decodingException);
            }
        }
        this.addNodes(arrayList, "ReferenceTypes");
        this.addNodes(arrayList2, "DataTypes");
        this.m();
        this.addNodes(arrayList6, "ObjectTypeNodes");
        this.addNodes(arrayList7, "VariableTypeNodes");
        this.addNodes(arrayList3, "ObjectNodes");
        this.addNodes(arrayList4, "VariableNodes");
        this.addNodes(arrayList5, "OtherNodes");
        this.addNodes(arrayList8, "MethodNodes");
        this.addReferences(this.aF);
        for (AddNodesItem addNodesItem : arrayList3) {
            this.afterCreate(addNodesItem);
        }
        logger.debug("createModel: done. Errors={}", (Object)this.ah.size());
        if (!this.ah.isEmpty()) {
            throw new ModelException(this.ah);
        }
    }

    public EncoderContext getEncoderContext() {
        return this.am.getEncoderContext();
    }

    public List<String> getErrorList() {
        return this.ah;
    }

    public Collection<ExpandedNodeId> getIgnoredNodes() {
        return this.ao;
    }

    public List<AddNodesItem> getNodes() {
        return this.nodes;
    }

    public List<AddReferencesItem> getReferences() {
        return this.aF;
    }

    public boolean isFailOnFirstError() {
        return this.an;
    }

    public boolean isReadingExtensions() {
        return this.aC;
    }

    public void parseFile(InputStream inputStream) throws IOException, SAXException, ModelException {
        Charset charset = Charset.forName("UTF8");
        this.parseFile(inputStream, charset);
    }

    public void parseFile(InputStream inputStream, Charset charset) throws IOException, SAXException, ModelException {
        logger.debug("parseFile: charset={}" + charset);
        this.ap = "stream";
        this.aB = XMLReaderFactory.createXMLReader();
        this.aB.setContentHandler(this.as);
        this.aB.setErrorHandler(this.as);
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        inputStream.mark(10);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        logger.debug("encoding={}", (Object)inputStreamReader.getEncoding());
        char[] cArray = new char[2];
        inputStreamReader.read(cArray, 0, inputStreamReader.getEncoding().equals("UTF8") ? 1 : 2);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("cbuf=%04x %04x bom=%04x", cArray[0], (int)cArray[1], (int)UTF8_BOM.charAt(0)));
        }
        if (cArray[0] != UTF8_BOM.charAt(0)) {
            inputStream.reset();
            inputStreamReader = new InputStreamReader(inputStream);
        }
        this.k();
        this.aB.parse(new InputSource(inputStreamReader));
        if (!this.ah.isEmpty()) {
            throw new ModelException(this.ah);
        }
    }

    public void parseFile(URI uRI) throws SAXException, IOException, ModelException {
        if (logger.isDebugEnabled()) {
            logger.debug("parseFile:" + uRI);
        }
        this.ap = uRI.toString();
        InputStream inputStream = uRI.toURL().openStream();
        this.parseFile(inputStream);
    }

    public void setFailOnFirstError(boolean bl) {
        this.an = bl;
    }

    public void setIgnoredNodes(Collection<ExpandedNodeId> collection) {
        if (collection != null) {
            this.ao.addAll(collection);
        }
    }

    private void a(AddNodesItem addNodesItem) throws ModelException {
        try {
            NodeId nodeId = this.doAddNode(addNodesItem);
            if (!nodeId.getValue().equals(addNodesItem.getRequestedNewNodeId().getValue())) {
                logger.warn("addNode: {} requested NodeId={} actual NodeId={}", new Object[]{addNodesItem.getBrowseName(), addNodesItem.getRequestedNewNodeId(), nodeId});
            } else {
                logger.debug("addNode:{} requested NodeId={}", (Object)addNodesItem.getBrowseName(), (Object)addNodesItem.getRequestedNewNodeId());
            }
        }
        catch (Exception exception) {
            this.a(this.an, this.ah, exception, "Failed to create node: " + addNodesItem.getBrowseName() + " with id:" + addNodesItem.getRequestedNewNodeId());
        }
    }

    private void addReference(AddReferencesItem addReferencesItem) throws ModelException {
        block3: {
            try {
                this.doAddReference(addReferencesItem);
                if (logger.isDebugEnabled()) {
                    logger.debug("createModel: Adding refitem: " + addReferencesItem.getSourceNodeId().toString() + " --> " + addReferencesItem.getTargetNodeId().toString() + " forward:" + addReferencesItem.getIsForward() + " type: " + addReferencesItem.getReferenceTypeId());
                }
            }
            catch (Exception exception) {
                if (this.isIgnoredReference(addReferencesItem)) break block3;
                this.a(this.an, this.ah, exception, "Failed to create reference: " + addReferencesItem.getSourceNodeId() + "--->" + addReferencesItem.getTargetNodeId() + " forward:" + addReferencesItem.getIsForward() + " type: " + addReferencesItem.getReferenceTypeId());
            }
        }
    }

    private void a(Variant variant) {
        if (this.au != null) {
            logger.debug("addValue: {}", (Object)variant);
            if (this.au instanceof VariableAttributes) {
                ((VariableAttributes)this.au).setValue(variant.getValue());
                if (variant.getValue() != null && variant.getValue() instanceof ExtensionObject && ((ExtensionObject)variant.getValue()).isEncoded()) {
                    this.aJ.add((VariableAttributes)this.au);
                }
            }
            if (this.au instanceof VariableTypeAttributes) {
                ((VariableTypeAttributes)this.au).setValue(variant.getValue());
                if (variant.getValue() != null && variant.getValue() instanceof ExtensionObject && ((ExtensionObject)variant.getValue()).isEncoded()) {
                    this.aK.add((VariableTypeAttributes)this.au);
                }
            }
        }
    }

    private void b() {
        this.al.put(this.alias, this.a(this.ay, false));
    }

    private void a(Attributes attributes) {
        this.at = this.g(attributes);
        this.au = this.b(attributes);
        this.at.setNodeClass(NodeClass.DataType);
    }

    private NodeAttributes b(Attributes attributes) {
        DataTypeAttributes dataTypeAttributes = new DataTypeAttributes();
        this.a(attributes, dataTypeAttributes);
        dataTypeAttributes.setIsAbstract(this.a(attributes, "IsAbstract", false));
        return dataTypeAttributes;
    }

    private void c(Attributes attributes) {
        this.az = new b();
        this.az.aW = this.a(attributes, "IsUnion", false);
        this.az.aX = this.a(attributes, "IsOptionSet", false);
        this.az.name = this.b(attributes, "Name");
    }

    private void d(Attributes attributes) {
        if (this.az == null) {
            logger.warn("Field tag outside of Definition block, ignoring..");
            return;
        }
        a a2 = new a();
        a2.name = this.b(attributes, "Name", "");
        String string = this.b(attributes, "Value", null);
        if (string == null || string.isEmpty()) {
            String string2 = this.b(attributes, "DataType", "i=24");
            a2.dataType = this.a(string2, true);
            a2.isOptional = this.a(attributes, "IsOptional", false);
            a2.valueRank = this.a(attributes, "ValueRank", -1);
        } else {
            a2.aV = this.a(attributes, "Value", -1);
        }
        this.az.fields.add(a2);
    }

    private void e(Attributes attributes) {
        this.at = this.g(attributes);
        this.au = this.f(attributes);
        this.at.setNodeClass(NodeClass.Method);
    }

    private NodeAttributes f(Attributes attributes) {
        MethodAttributes methodAttributes = new MethodAttributes();
        this.a(attributes, methodAttributes);
        methodAttributes.setExecutable(this.a(attributes, "Executable", true));
        methodAttributes.setUserExecutable(this.a(attributes, "UserExecutable", true));
        return methodAttributes;
    }

    private void a(boolean bl, List<String> list, Exception exception, String string) throws ModelException {
        logger.warn("createModel: " + string + " ", (Throwable)exception);
        if (bl) {
            if (this.locator != null) {
                throw new ModelException(string, exception, this.locator.getLineNumber());
            }
            throw new ModelException(string, exception);
        }
        if (this.locator != null) {
            list.add(string + exception + " (near line " + this.locator.getLineNumber() + ")");
        } else {
            list.add(string + exception);
        }
    }

    private AddNodesItem g(Attributes attributes) {
        AddNodesItem addNodesItem = new AddNodesItem();
        ExpandedNodeId expandedNodeId = this.a(attributes, "NodeId");
        if (expandedNodeId == null) {
            throw new NullPointerException("createNode: NodeId should not be null");
        }
        addNodesItem.setRequestedNewNodeId(expandedNodeId);
        addNodesItem.setBrowseName(this.b(attributes, "BrowseName"));
        logger.debug("Creating node: {}", (Object)addNodesItem.getBrowseName().getName());
        return addNodesItem;
    }

    private void h(Attributes attributes) {
        this.at = this.g(attributes);
        this.au = this.i(attributes);
        this.at.setNodeClass(NodeClass.Object);
    }

    private ObjectAttributes i(Attributes attributes) {
        ObjectAttributes objectAttributes = new ObjectAttributes();
        this.a(attributes, objectAttributes);
        objectAttributes.setEventNotifier(this.a(attributes, "EventNotifier", UnsignedByte.valueOf(0)));
        return objectAttributes;
    }

    private void j(Attributes attributes) {
        this.at = this.g(attributes);
        this.au = this.k(attributes);
        this.at.setNodeClass(NodeClass.ObjectType);
    }

    private NodeAttributes k(Attributes attributes) {
        ObjectTypeAttributes objectTypeAttributes = new ObjectTypeAttributes();
        this.a(attributes, objectTypeAttributes);
        objectTypeAttributes.setIsAbstract(this.a(attributes, "IsAbstract", false));
        return objectTypeAttributes;
    }

    private void l(Attributes attributes) {
        if (this.at != null) {
            this.av = new AddReferencesItem();
            this.av.setIsForward(this.a(attributes, "IsForward", true));
            this.av.setReferenceTypeId(this.toGlobalNodeId(this.a(attributes, "ReferenceType", Identifiers.References)));
            NodeId nodeId = this.toGlobalNodeId(this.at.getRequestedNewNodeId());
            this.av.setSourceNodeId(nodeId);
        }
    }

    private void m(Attributes attributes) {
        this.at = this.g(attributes);
        this.au = this.n(attributes);
        this.at.setNodeClass(NodeClass.ReferenceType);
    }

    private NodeAttributes n(Attributes attributes) {
        ReferenceTypeAttributes referenceTypeAttributes = new ReferenceTypeAttributes();
        this.a(attributes, referenceTypeAttributes);
        referenceTypeAttributes.setIsAbstract(this.a(attributes, "IsAbstract", false));
        referenceTypeAttributes.setSymmetric(this.a(attributes, "Symmetric", false));
        return referenceTypeAttributes;
    }

    private void c() throws TransformerConfigurationException, SAXException {
        this.aI = new DOMResult();
        this.aH = XMLFactoryCache.getSAXTransformerFactory().newTransformerHandler();
        this.aH.setResult(this.aI);
        this.aH.startDocument();
        logger.debug("Created valueHandler");
    }

    private void o(Attributes attributes) {
        this.at = this.g(attributes);
        this.au = this.p(attributes);
        this.at.setNodeClass(NodeClass.Variable);
    }

    private NodeAttributes p(Attributes attributes) {
        VariableAttributes variableAttributes = new VariableAttributes();
        this.a(attributes, variableAttributes);
        variableAttributes.setAccessLevel(this.u(attributes));
        variableAttributes.setArrayDimensions(this.a(attributes, "ArrayDimensions", ""));
        variableAttributes.setDataType(this.toGlobalNodeId(this.a(attributes, "DataType", Identifiers.BaseDataType)));
        variableAttributes.setHistorizing(this.a(attributes, "Historizing", false));
        variableAttributes.setMinimumSamplingInterval(this.a(attributes, "MinimumSamplingInterval", 0.0));
        variableAttributes.setUserAccessLevel(this.a(attributes, "UserAccessLevel", UnsignedByte.valueOf(1)));
        variableAttributes.setValueRank(this.a(attributes, "ValueRank", -1));
        return variableAttributes;
    }

    private void q(Attributes attributes) {
        this.at = this.g(attributes);
        this.au = this.r(attributes);
        this.at.setNodeClass(NodeClass.VariableType);
    }

    private NodeAttributes r(Attributes attributes) {
        VariableTypeAttributes variableTypeAttributes = new VariableTypeAttributes();
        this.a(attributes, variableTypeAttributes);
        variableTypeAttributes.setIsAbstract(this.a(attributes, "IsAbstract", false));
        variableTypeAttributes.setValueRank(this.a(attributes, "ValueRank", -1));
        variableTypeAttributes.setArrayDimensions(this.a(attributes, "ArrayDimensions", ""));
        variableTypeAttributes.setDataType(this.toGlobalNodeId(this.a(attributes, "DataType", Identifiers.BaseDataType)));
        return variableTypeAttributes;
    }

    private void s(Attributes attributes) {
        this.at = this.g(attributes);
        this.au = this.t(attributes);
        this.at.setNodeClass(NodeClass.View);
    }

    private NodeAttributes t(Attributes attributes) {
        ViewAttributes viewAttributes = new ViewAttributes();
        this.a(attributes, viewAttributes);
        viewAttributes.setContainsNoLoops(this.a(attributes, "ContainsNoLoops", false));
        return viewAttributes;
    }

    private void d() {
        this.aC = false;
        logger.debug("Read extensions");
    }

    private void e() {
        if (this.au == null) {
            return;
        }
        this.at.setNodeAttributes(new ExtensionObject(this.au));
        this.nodes.add(this.at);
        int n2 = -1;
        try {
            n2 = this.am.getNamespaceTable().toNodeId(this.at.getRequestedNewNodeId()).getNamespaceIndex();
        }
        catch (Exception exception) {
            n2 = -1;
        }
        UaNodeId uaNodeId = UaNodeId.fromLocal(this.at.getRequestedNewNodeId(), this.am.getNamespaceTable());
        if (this.az != null && n2 != 0 && !this.am.getKnownDataTypeDictionary().knownAddressSpaceNamespaces().contains(uaNodeId.getNamespaceUri())) {
            Object object;
            boolean bl = false;
            boolean bl2 = false;
            for (a object22 : this.az.fields) {
                if (object22.aV != null) {
                    bl = true;
                    break;
                }
                if (!object22.isOptional.booleanValue()) continue;
                bl2 = true;
                break;
            }
            if (bl) {
                if (this.am.getEncoderContext().getEnumerationSpecification(uaNodeId) == null) {
                    object = EnumerationSpecification.builder();
                    ((EnumerationSpecification.Builder)object).setTypeId(uaNodeId);
                    ((EnumerationSpecification.Builder)object).setName(this.at.getBrowseName().getName());
                    HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
                    for (a a2 : this.az.fields) {
                        hashMap.put(a2.aV, a2.name);
                    }
                    ((EnumerationSpecification.Builder)object).setMappings(hashMap);
                    this.am.getEncoderContext().addEnumerationSpecification(((EnumerationSpecification.Builder)object).build());
                } else {
                    logger.debug("EncoderContext already had EnumerationSpecification for type {}, ignoring parsing", (Object)uaNodeId);
                }
            } else if (this.am.getEncoderContext().getStructureSpecification(uaNodeId) == null) {
                object = StructureSpecification.builder();
                ((StructureSpecification.Builder)object).setTypeId(uaNodeId);
                ((StructureSpecification.Builder)object).setName(this.at.getBrowseName().getName());
                if (this.az.aW.booleanValue()) {
                    ((StructureSpecification.Builder)object).setStructureType(StructureSpecification.StructureType.UNION);
                } else if (bl2) {
                    ((StructureSpecification.Builder)object).setStructureType(StructureSpecification.StructureType.OPTIONAL);
                } else {
                    ((StructureSpecification.Builder)object).setStructureType(StructureSpecification.StructureType.NORMAL);
                }
                for (a a3 : this.az.fields) {
                    FieldSpecification.Builder builder = FieldSpecification.builder();
                    UaNodeId uaNodeId2 = UaNodeId.fromLocal(a3.dataType, this.ar);
                    builder.setDataTypeId(uaNodeId2);
                    builder.setIsOptional(a3.isOptional);
                    builder.setValueRank(a3.valueRank);
                    builder.setName(a3.name);
                    Class<Object> clazz = null;
                    try {
                        clazz = ((UaDataType)this.am.getAddressSpace().getNode(uaNodeId2.asExpandedNodeId())).getJavaClass();
                    }
                    catch (Exception exception) {
                        if (this.am.getEncoderContext().getStructureSpecification(uaNodeId2) != null) {
                            clazz = DynamicStructure.class;
                        }
                        if (this.am.getEncoderContext().getEnumerationSpecification(uaNodeId2) != null) {
                            clazz = DynamicEnumeration.class;
                            builder.setEnumerationSpecification(this.am.getEncoderContext().getEnumerationSpecification(uaNodeId2));
                        }
                        logger.debug("Could not resolve the DataType of field {} for {} ({}), assuming it is a custom Structure", new Object[]{a3.name, this.at.getBrowseName(), this.at.getRequestedNewNodeId()});
                        clazz = DynamicStructure.class;
                    }
                    if (a3.valueRank > 0) {
                        for (int i2 = 0; i2 < a3.valueRank; ++i2) {
                            clazz = Array.newInstance(clazz, 0).getClass();
                        }
                    }
                    builder.setJavaClass(clazz);
                    ((StructureSpecification.Builder)object).addField(builder.build());
                }
                StructureSpecification structureSpecification = ((StructureSpecification.Builder)object).build();
                this.aL.put(structureSpecification.getTypeId(), structureSpecification);
            } else {
                logger.debug("EncoderContext already had StructureSpecification for type {}, ignoring parsing", (Object)uaNodeId);
            }
        }
        if (this.aR.containsKey(uaNodeId) && !this.aP.contains(uaNodeId)) {
            this.a(uaNodeId, this.aR.get(uaNodeId));
        }
        this.at = null;
        this.au = null;
        this.az = null;
    }

    private void f() {
        if (this.av != null) {
            if (this.aA) {
                this.av.setTargetNodeId(this.toGlobalExpandedNodeId(NodeId.parseNodeId(this.ay)));
            }
            this.aA = false;
            if (logger.isDebugEnabled()) {
                logger.debug("referenceToString(nodeReference): {}", (Object)this.b(this.av));
            }
            this.aw.add(this.av);
            this.av = null;
        }
    }

    private void g() {
        if (this.aw.size() == 0) {
            logger.debug("Zero references..");
        }
        for (AddReferencesItem addReferencesItem : this.aw) {
            UaNodeId uaNodeId;
            UaNodeId uaNodeId2;
            if (addReferencesItem.getReferenceTypeId().equals(Identifiers.HasTypeDefinition) && addReferencesItem.getIsForward().booleanValue()) {
                this.at.setTypeDefinition(addReferencesItem.getTargetNodeId());
            }
            this.aF.add(addReferencesItem);
            if (Identifiers.HasEncoding.equals(addReferencesItem.getReferenceTypeId())) {
                uaNodeId2 = UaNodeId.fromLocal(addReferencesItem.getSourceNodeId(), this.am.getNamespaceTable());
                uaNodeId = UaNodeId.fromLocal(addReferencesItem.getTargetNodeId(), this.am.getNamespaceTable());
                if (addReferencesItem.getIsForward().booleanValue()) {
                    this.aS.put(uaNodeId2, uaNodeId);
                    this.aR.put(uaNodeId, uaNodeId2);
                } else {
                    this.a(uaNodeId2, uaNodeId);
                }
            }
            if (!Identifiers.HasSubtype.equals(addReferencesItem.getReferenceTypeId())) continue;
            uaNodeId2 = UaNodeId.fromLocal(addReferencesItem.getSourceNodeId(), this.am.getNamespaceTable());
            uaNodeId = UaNodeId.fromLocal(addReferencesItem.getTargetNodeId(), this.am.getNamespaceTable());
            if (addReferencesItem.getIsForward().booleanValue()) {
                this.aQ.put(uaNodeId, uaNodeId2);
                continue;
            }
            this.aQ.put(uaNodeId2, uaNodeId);
        }
        this.aw.clear();
    }

    private void h() {
        String string = this.ay.trim();
        this.addNamespaceUri(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void j() throws TransformerFactoryConfigurationError, TransformerException, SAXException, DecodingException {
        this.aH.endDocument();
        if (!ModelParserBase.aj || !ModelParserBase.ak) {
            ModelParserBase.logger.debug("finalizing value:{}", (Object)this.aI.getNode());
            var1_1 = new StringWriter();
            var2_2 = XMLFactoryCache.getTransformerFactory().newTransformer();
            var2_2.setOutputProperty("omit-xml-declaration", "yes");
            var2_2.transform(new DOMSource(this.aI.getNode()), new StreamResult(var1_1));
            var3_3 = var1_1.toString();
            ModelParserBase.logger.debug("Parsed XML of value:\n{}", (Object)var3_3);
            var4_4 = new XmlElement(var3_3);
            var5_5 = new XmlDecoder(var4_4, this.getEncoderContext());
            try {
                var5_5.setNamespaceTable(this.ar);
                this.a(var5_5.getVariant(""));
            }
            catch (Exception var6_6) {
                ModelParserBase.logger.warn("Could not load the value of node: {}, (it is probably non-codegenerated Structure)", (Object)this.at.getRequestedNewNodeId(), (Object)var6_6);
                if (!ModelParserBase.logger.isDebugEnabled()) ** GOTO lbl25
                ModelParserBase.logger.debug("Failure was: ", (Throwable)var6_6);
            }
            finally {
                var5_5.close();
            }
        } else {
            ModelParserBase.logger.debug("finalizing value: skipping because we are on android and skipValuesOnAndroid setting is true");
        }
lbl25:
        // 4 sources

        this.aH = null;
    }

    private UnsignedByte u(Attributes attributes) {
        UnsignedInteger unsignedInteger = this.a(attributes, "AccessLevel", UnsignedInteger.ONE);
        if (unsignedInteger.longValue() <= 255L) {
            return UnsignedByte.valueOf(unsignedInteger.longValue());
        }
        HashSet<AccessLevelType.Fields> hashSet = new HashSet<AccessLevelType.Fields>();
        for (AccessLevelType.Fields fields : AccessLevelType.Fields.values()) {
            if (!unsignedInteger.isBitSet(fields.getBitPosition())) continue;
            hashSet.add(fields);
        }
        UnsignedByte unsignedByte = AccessLevelType.of(hashSet).getAsBuiltInType();
        logger.warn("Encountered larger than Byte AccessLevel value: {}, truncated to: {} (AccessLevelEx is not yet supported)", (Object)unsignedInteger, (Object)unsignedByte);
        return unsignedByte;
    }

    private UnsignedInteger[] a(Attributes attributes, String string, String string2) {
        String string3 = string2;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            string3 = attributes.getValue(i2);
            break;
        }
        if ("".equals(string3) || string3 == null) {
            return null;
        }
        if (string3.indexOf(",") < 0) {
            try {
                return new UnsignedInteger[]{UnsignedInteger.parseUnsignedInteger(string3)};
            }
            catch (Exception exception) {
                return null;
            }
        }
        String[] stringArray = string3.split(",");
        try {
            UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[stringArray.length];
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                unsignedIntegerArray[i3] = UnsignedInteger.parseUnsignedInteger(stringArray[i3]);
            }
            return unsignedIntegerArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Boolean a(Attributes attributes, String string, boolean bl) {
        Boolean bl2 = bl;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            bl2 = Boolean.parseBoolean(attributes.getValue(i2));
            break;
        }
        return bl2;
    }

    private Double a(Attributes attributes, String string, double d2) {
        double d3 = d2;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            d3 = Double.parseDouble(attributes.getValue(i2));
            break;
        }
        return d3;
    }

    private ExpandedNodeId a(Attributes attributes, String string) {
        ExpandedNodeId expandedNodeId = null;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            NodeId nodeId = NodeId.parseNodeId(attributes.getValue(i2));
            expandedNodeId = this.toGlobalExpandedNodeId(nodeId);
            break;
        }
        return expandedNodeId;
    }

    private Integer a(Attributes attributes, String string, int n2) {
        int n3 = n2;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            n3 = Integer.parseInt(attributes.getValue(i2));
            break;
        }
        return n3;
    }

    private String a(ExpandedNodeId expandedNodeId) {
        return this.ar.getUri(expandedNodeId.getNamespaceIndex());
    }

    private String b(NodeId nodeId) {
        String string = this.ar.getUri(nodeId.getNamespaceIndex());
        if (string == null) {
            throw new IllegalArgumentException("Invalid NamespaceIndex for nodeId=" + nodeId + " localNamespaceTable=" + this.ar);
        }
        return string;
    }

    private void a(Attributes attributes, NodeAttributes nodeAttributes) {
        nodeAttributes.setUserWriteMask(this.a(attributes, "UserWriteMask", UnsignedInteger.valueOf(0L)));
        nodeAttributes.setWriteMask(this.a(attributes, "WriteMask", UnsignedInteger.valueOf(0L)));
    }

    private NodeId a(Attributes attributes, String string, NodeId nodeId) {
        NodeId nodeId2 = nodeId;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            nodeId2 = this.b(attributes.getValue(i2));
            break;
        }
        return nodeId2;
    }

    private NodeId b(String string) {
        return this.a(string, true);
    }

    private NodeId a(String string, boolean bl) {
        if (bl && this.al.containsKey(string)) {
            return this.al.get(string);
        }
        return NodeId.parseNodeId(string);
    }

    private QualifiedName b(Attributes attributes, String string) {
        QualifiedName qualifiedName = null;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            qualifiedName = this.a(QualifiedName.parseQualifiedName(attributes.getValue(i2)));
            break;
        }
        return qualifiedName;
    }

    private String b(Attributes attributes, String string, String string2) {
        String string3 = string2;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            string3 = attributes.getValue(i2);
            break;
        }
        return string3;
    }

    private UnsignedByte a(Attributes attributes, String string, UnsignedByte unsignedByte) {
        UnsignedByte unsignedByte2 = unsignedByte;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            unsignedByte2 = UnsignedByte.parseUnsignedByte(attributes.getValue(i2));
            break;
        }
        return unsignedByte2;
    }

    private UnsignedInteger a(Attributes attributes, String string, UnsignedInteger unsignedInteger) {
        UnsignedInteger unsignedInteger2 = unsignedInteger;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            unsignedInteger2 = UnsignedInteger.parseUnsignedInteger(attributes.getValue(i2));
            break;
        }
        return unsignedInteger2;
    }

    private void a(String string, Class<?> clazz) {
        this.aq.put(string.toLowerCase(), clazz);
    }

    private void k() {
        this.a("SByte", Byte.class);
        this.a("Int16", Short.class);
        this.a("Int32", Integer.class);
        this.a("Int64", Long.class);
        this.a("Byte", UnsignedByte.class);
        this.a("UInt16", UnsignedShort.class);
        this.a("UInt32", UnsignedInteger.class);
        this.a("UInt64", UnsignedLong.class);
        this.a("Float", Float.class);
        this.a("Double", Double.class);
        this.a("Duration", Double.class);
        this.a("Boolean", Boolean.class);
        this.a("ByteString", ByteString.class);
        this.a("QualifiedName", QualifiedName.class);
        this.a("String", String.class);
        this.a("LocaleId", Locale.class);
        this.a("Guid", UUID.class);
        this.a("DateTime", DateTime.class);
        this.a("UtcTime", DateTime.class);
        this.a("DataValue", DataValue.class);
        this.a("DiagnosticInfo", DiagnosticInfo.class);
        this.a("LocalizedText", LocalizedText.class);
        this.a("ExpandedNodeId", ExpandedNodeId.class);
        this.a("NodeId", NodeId.class);
        this.a("XmlElement", XmlElement.class);
        this.a("ExtensionObject", ExtensionObject.class);
    }

    private boolean c(NodeId nodeId) {
        return nodeId.equals(Identifiers.HasComponent) || nodeId.equals(Identifiers.HasOrderedComponent) || nodeId.equals(Identifiers.HasProperty) || nodeId.equals(Identifiers.Organizes) || nodeId.equals(Identifiers.HasSubtype) || nodeId.equals(Identifiers.HasEncoding);
    }

    private boolean l() {
        return this.aE > 0;
    }

    private void m() {
        logger.debug("linkTypeNodesAndJavaClasses");
        this.a(Identifiers.SByte, Byte.class);
        this.a(Identifiers.Int16, Short.class);
        this.a(Identifiers.Int32, Integer.class);
        this.a(Identifiers.Int64, Long.class);
        this.a(Identifiers.Byte, UnsignedByte.class);
        this.a(Identifiers.UInt16, UnsignedShort.class);
        this.a(Identifiers.UInt32, UnsignedInteger.class);
        this.a(Identifiers.UInt64, UnsignedLong.class);
        this.a(Identifiers.Float, Float.class);
        this.a(Identifiers.Double, Double.class);
        this.a(Identifiers.Duration, Double.class);
        this.a(Identifiers.Decimal, BigDecimal.class);
        this.a(Identifiers.Boolean, Boolean.class);
        this.a(Identifiers.ByteString, ByteString.class);
        this.a(Identifiers.Enumeration, Integer.class);
        this.a(Identifiers.QualifiedName, QualifiedName.class);
        this.a(Identifiers.String, String.class);
        this.a(Identifiers.Guid, UUID.class);
        this.a(Identifiers.DateTime, DateTime.class);
        this.a(Identifiers.UtcTime, DateTime.class);
        this.a(Identifiers.DataValue, DataValue.class);
        this.a(Identifiers.DiagnosticInfo, DiagnosticInfo.class);
        this.a(Identifiers.LocalizedText, LocalizedText.class);
        this.a(Identifiers.ExpandedNodeId, ExpandedNodeId.class);
        this.a(Identifiers.NodeId, NodeId.class);
        this.a(Identifiers.XmlElement, XmlElement.class);
        this.a(Identifiers.StatusCode, StatusCode.class);
    }

    private void a(NodeId nodeId, Class<?> clazz) {
        try {
            ((UaDataType)this.getNode(nodeId)).setJavaClass(clazz);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    private int a(int n2) {
        String string = this.ar.getUri(n2);
        return this.getNamespaceTable().getIndex(string);
    }

    private void a(AddReferencesItem addReferencesItem) {
        if (this.ax.containsKey(addReferencesItem.getTargetNodeId())) {
            logger.debug("ParentMap Should only have one AddReferenceItem per node");
        } else {
            logger.debug("adding to parentmap; source:{} to target:{} typeofref:{}", new Object[]{addReferencesItem.getSourceNodeId(), addReferencesItem.getTargetNodeId(), addReferencesItem.getReferenceTypeId()});
            this.ax.put(addReferencesItem.getTargetNodeId(), addReferencesItem);
        }
    }

    private void n() {
        this.aA = true;
        this.ay = "";
    }

    private void v(Attributes attributes) {
        this.alias = this.b(attributes, "Alias", "");
    }

    private void w(Attributes attributes) {
        this.locale = this.b(attributes, "Locale", "");
    }

    private String b(AddReferencesItem addReferencesItem) {
        return String.format("finalizeReference: %s->%s (isForward=%s)", addReferencesItem.getSourceNodeId(), addReferencesItem.getTargetNodeId(), addReferencesItem.getIsForward());
    }

    private void a(UaNodeId uaNodeId, UaNodeId uaNodeId2) {
        if ("Default Binary".equalsIgnoreCase(this.at.getBrowseName().getName())) {
            this.aM.put(uaNodeId2, uaNodeId);
            this.aP.add(uaNodeId);
        } else if ("Default XML".equalsIgnoreCase(this.at.getBrowseName().getName())) {
            this.aN.put(uaNodeId2, uaNodeId);
            this.aP.add(uaNodeId);
        } else if ("Default JSON".equalsIgnoreCase(this.at.getBrowseName().getName())) {
            this.aO.put(uaNodeId2, uaNodeId);
            this.aP.add(uaNodeId);
        }
        this.aS.put(uaNodeId2, uaNodeId);
        this.aR.put(uaNodeId, uaNodeId2);
    }

    private void o() {
        if (this.aA && this.au != null) {
            this.au.setDescription(new LocalizedText(this.ay, this.locale));
        }
        this.aA = false;
    }

    private void p() {
        if (this.aA && this.au != null) {
            this.au.setDisplayName(new LocalizedText(this.ay, this.locale));
        }
        this.aA = false;
    }

    private void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private void q() {
        if (this.aA && this.au != null) {
            ((ReferenceTypeAttributes)this.au).setInverseName(new LocalizedText(this.ay, this.locale));
        }
        this.aA = false;
    }

    private void c(AddReferencesItem addReferencesItem) {
        logger.debug("setParent: node={} ref={}", (Object)this.at.getBrowseName(), (Object)this.b(addReferencesItem));
        if (!ExpandedNodeId.isNull(this.at.getParentNodeId())) {
            logger.warn("setParent: already defined!");
        }
        this.at.setParentNodeId(addReferencesItem.getTargetNodeId());
        this.at.setReferenceTypeId(addReferencesItem.getReferenceTypeId());
    }

    private void r() {
        this.aC = true;
        logger.debug("Reading extensions");
    }

    private QualifiedName a(QualifiedName qualifiedName) {
        return new QualifiedName(this.a(qualifiedName.getNamespaceIndex()), qualifiedName.getName());
    }

    private boolean a(StructureSpecification structureSpecification) {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.setName(structureSpecification.getName());
        builder.setTypeId(structureSpecification.getTypeId());
        builder.setBinaryEncodeId(this.aM.get(structureSpecification.getTypeId()));
        builder.setXmlEncodeId(this.aN.get(structureSpecification.getTypeId()));
        builder.setJsonEncodeId(this.aO.get(structureSpecification.getTypeId()));
        UaNodeId uaNodeId = this.aQ.get(structureSpecification.getTypeId());
        UaNodeId uaNodeId2 = UaNodeId.fromLocal(Identifiers.Structure, this.am.getNamespaceTable());
        if (!uaNodeId2.equals(uaNodeId) && this.am.getEncoderContext().getStructureSpecification(uaNodeId) != null) {
            StructureSpecification structureSpecification2 = this.am.getEncoderContext().getStructureSpecification(uaNodeId);
            if (StructureSpecification.StructureType.OPTIONAL == structureSpecification2.getStructureType()) {
                builder.setStructureType(StructureSpecification.StructureType.OPTIONAL);
            } else {
                builder.setStructureType(structureSpecification.getStructureType());
            }
            for (FieldSpecification fieldSpecification : structureSpecification2.getFields()) {
                builder.addField(fieldSpecification);
            }
        } else {
            builder.setStructureType(structureSpecification.getStructureType());
        }
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            builder.addField(fieldSpecification);
        }
        this.am.getEncoderContext().addStructureSpecification(builder.build());
        logger.debug("Resolved partial StructureSpecification for typeId: {}", (Object)structureSpecification.getTypeId());
        return true;
    }

    private void a(char[] cArray, int n2, int n3) {
        try {
            String string = new String(cArray, n2, n3);
            string = string.trim();
            if (string.isEmpty()) {
                return;
            }
            logger.debug("valueCharacters: {}", (Object)string);
            this.aH.characters(cArray, n2, n3);
        }
        catch (SAXException sAXException) {
            logger.error("Error in valueCharacters, start=" + n2 + " ,length=" + n3 + " ch len=" + cArray.length, (Throwable)sAXException);
        }
        catch (Exception exception) {
            String string = new String(cArray, n2, n3);
            string = string.trim();
            logger.error("Error in valueCharacters, start=" + n2 + " ,length=" + n3 + " ch len=" + cArray.length + " chars:" + (string.isEmpty() ? "isEmpty()=true" : string), (Throwable)exception);
        }
    }

    private void a(String string, String string2, String string3) {
        logger.debug("valueEndElement: localName={}", (Object)string2);
        try {
            this.aH.endElement(string, string2, string3);
        }
        catch (SAXException sAXException) {
            logger.error("Error in valueEndElement: localName=" + string2, (Throwable)sAXException);
        }
        catch (EmptyStackException emptyStackException) {
            logger.error("Error in valueEndElement: localName=" + string2, (Throwable)emptyStackException);
        }
    }

    private void a(String string, String string2, String string3, Attributes attributes) {
        logger.debug("valueStartElement: {}", (Object)string2);
        try {
            this.aH.startElement(string, string2, string3, attributes);
        }
        catch (SAXException sAXException) {
            logger.error("Error in valueStartElement", (Throwable)sAXException);
        }
    }

    protected void addNamespaceUri(String string) {
        this.ar.add(string);
        this.getNamespaceTable().add(string);
    }

    protected void addNodes(List<AddNodesItem> list, String string) throws ModelException, ServiceException {
        logger.debug("addNodes: {}", (Object)string);
        for (AddNodesItem addNodesItem : list) {
            this.a(addNodesItem);
        }
    }

    protected void addReferences(List<AddReferencesItem> list) throws ModelException {
        for (AddReferencesItem addReferencesItem : list) {
            this.addReference(addReferencesItem);
        }
    }

    protected void afterCreate(AddNodesItem addNodesItem) {
    }

    protected void characters(char[] cArray, int n2, int n3) {
        try {
            if (this.l()) {
                this.a(cArray, n2, n3);
            } else if (this.aA) {
                this.ay = this.ay + new String(cArray, n2, n3);
            }
        }
        catch (Exception exception) {
            logger.error("Error in ModelParser2.characters, start=" + n2 + ", length=" + n3, (Throwable)exception);
        }
    }

    protected NodeId doAddNode(AddNodesItem addNodesItem) throws StatusException, ServiceException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    protected void doAddReference(AddReferencesItem addReferencesItem) throws StatusException, ServiceException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    protected void endElement(String string, String string2, String string3) throws SAXException {
        logger.debug("endElement: {}", (Object)string2);
        try {
            if (this.l()) {
                this.a(string, string2, string3);
                if (string2.equals("Value")) {
                    logger.debug("endElement: readingValue={}", (Object)this.aE);
                    if (--this.aE <= 0) {
                        this.j();
                    }
                }
                return;
            }
            if (this.isReadingNamespaces() && string2.equals("Uri")) {
                this.h();
                return;
            }
            c c2 = c.valueOf(string2);
            switch (c2) {
                case bl: {
                    this.aD = false;
                    break;
                }
                case bq: 
                case br: 
                case bt: 
                case bu: 
                case bv: 
                case bw: 
                case bx: 
                case by: {
                    this.e();
                    break;
                }
                case aY: {
                    this.b();
                    break;
                }
                case bb: {
                    this.o();
                    break;
                }
                case bc: {
                    this.p();
                    break;
                }
                case bh: {
                    this.q();
                    break;
                }
                case bz: {
                    logger.error("endElement reached Value with readingValue false, localName={}", (Object)string2);
                    break;
                }
                case bm: {
                    this.f();
                    break;
                }
                case bn: {
                    this.g();
                    break;
                }
                case bf: {
                    this.d();
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!this.isReadingExtensions()) {
                logger.info("Unknown element in XML: " + string2);
            }
        }
        catch (Exception exception) {
            try {
                this.a(this.an, this.ah, exception, "Error in ModelParser2.endElement: localName=" + string2);
            }
            catch (ModelException modelException) {
                throw new SAXException("Error in ModelParser2.endElement: localName=" + string2, modelException);
            }
        }
    }

    protected abstract NamespaceTable getNamespaceTable();

    protected abstract UaNode getNode(NodeId var1) throws StatusException;

    protected abstract ServerTable getServerTable();

    protected boolean isIgnoredReference(AddReferencesItem addReferencesItem) {
        return this.ao.contains(this.getNamespaceTable().toExpandedNodeId(addReferencesItem.getSourceNodeId())) || this.ao.contains(addReferencesItem.getTargetNodeId());
    }

    protected boolean isReadingNamespaces() {
        return this.aD;
    }

    protected void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        logger.debug("startElement: {} readingValue={}", (Object)string2, (Object)this.aE);
        try {
            if (this.l()) {
                if (string2.equals("Value")) {
                    ++this.aE;
                }
                this.a(string, string2, string3, attributes);
                return;
            }
            if (this.isReadingNamespaces()) {
                if (string2.equals("Uri")) {
                    this.n();
                }
                return;
            }
            if (this.isReadingExtensions()) {
                return;
            }
            c c2 = c.valueOf(string2);
            switch (c2) {
                case bl: {
                    this.aD = true;
                    break;
                }
                case bq: {
                    this.a(attributes);
                    break;
                }
                case br: {
                    this.e(attributes);
                    break;
                }
                case bt: {
                    this.h(attributes);
                    break;
                }
                case bu: {
                    this.j(attributes);
                    break;
                }
                case bv: {
                    this.m(attributes);
                    break;
                }
                case bw: {
                    this.o(attributes);
                    break;
                }
                case bx: {
                    this.q(attributes);
                    break;
                }
                case by: {
                    this.s(attributes);
                    break;
                }
                case aY: {
                    this.v(attributes);
                    this.n();
                    break;
                }
                case bb: 
                case bc: 
                case bh: {
                    this.w(attributes);
                    this.n();
                    break;
                }
                case bz: {
                    ++this.aE;
                    this.c();
                    this.a(string, string2, string3, attributes);
                    logger.debug("Start - readingValue={}, element={}", (Object)this.aE, (Object)string2);
                    break;
                }
                case bn: {
                    break;
                }
                case bm: {
                    this.l(attributes);
                    this.n();
                    break;
                }
                case ba: {
                    this.c(attributes);
                    break;
                }
                case bg: {
                    this.d(attributes);
                    break;
                }
                case bf: {
                    this.r();
                    break;
                }
                default: {
                    logger.debug("Ignoring element {} in {}", (Object)string2, (Object)this.ap);
                    break;
                }
            }
        }
        catch (Exception exception) {
            try {
                this.a(this.an, this.ah, exception, "Error in ModelParser2.startElement: localName=" + string2);
            }
            catch (ModelException modelException) {
                throw new SAXException("Error in ModelParser2.startElement: localName=" + string2, modelException);
            }
        }
    }

    protected ExpandedNodeId toGlobalExpandedNodeId(NodeId nodeId) {
        return new ExpandedNodeId(this.aG, this.b(nodeId), nodeId.getValue());
    }

    protected NodeId toGlobalNodeId(ExpandedNodeId expandedNodeId) {
        return NodeId.get(expandedNodeId.getIdType(), this.getNamespaceTable().getIndex(expandedNodeId.getNamespaceUri()), expandedNodeId.getValue());
    }

    protected NodeId toGlobalNodeId(NodeId nodeId) {
        return NodeId.get(nodeId.getIdType(), this.a(nodeId.getNamespaceIndex()), nodeId.getValue());
    }

    private class d
    extends DefaultHandler {
        private d() {
        }

        @Override
        public void characters(char[] cArray, int n2, int n3) throws SAXException {
            ModelParserBase.this.characters(cArray, n2, n3);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            ModelParserBase.this.endElement(string, string2, string3);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            ModelParserBase.this.setDocumentLocator(locator);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ModelParserBase.this.startElement(string, string2, string3, attributes);
        }
    }

    private static enum c {
        aY,
        aZ,
        ba,
        bb,
        bc,
        bd,
        be,
        bf,
        bg,
        bh,
        bi,
        bj,
        bk,
        bl,
        bm,
        bn,
        bo,
        bp,
        bq,
        br,
        bs,
        bt,
        bu,
        bv,
        bw,
        bx,
        by,
        bz;

    }

    private static class b {
        public Boolean aW = false;
        public Boolean aX = false;
        public QualifiedName name;
        public final List<a> fields = new ArrayList<a>();

        private b() {
        }
    }

    private static class a {
        public NodeId dataType;
        public Boolean isOptional;
        public String name;
        public Integer aV;
        public Integer valueRank;

        private a() {
        }
    }
}

