/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Identifiers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventData {
    public static final QualifiedName[] EVENT_TYPE_PATH = new QualifiedName[]{new QualifiedName("EventType")};
    public static final QualifiedName[] TIME_PATH = new QualifiedName[]{new QualifiedName("Time")};
    private static final Logger logger = LoggerFactory.getLogger(EventData.class);
    private final List<LocalizedText> comments = new ArrayList<LocalizedText>();
    private final ByteString ad;
    private UaType ae;
    private final Map<List<QualifiedName>, Variant> fieldValues = new HashMap<List<QualifiedName>, Variant>();
    private final NodeId nodeId;

    public EventData(NodeId nodeId, ByteString byteString) {
        logger.debug("EventData: nodeId={}", (Object)nodeId);
        this.nodeId = nodeId;
        this.ad = byteString;
    }

    public EventData(UaNode uaNode, ByteString byteString) {
        logger.debug("EventData: node={}", (Object)uaNode);
        this.nodeId = uaNode.getNodeId();
        this.ad = byteString;
        this.b(uaNode);
        this.a(uaNode);
        logger.debug("EventData: eventTypeId={}", (Object)this.getEventTypeId());
    }

    public void addComment(LocalizedText localizedText) {
        this.comments.add(localizedText);
    }

    public LocalizedText[] getComments() {
        return this.comments.toArray(new LocalizedText[this.comments.size()]);
    }

    public ByteString getEventId() {
        return this.ad;
    }

    public UaType getEventType() {
        return this.ae;
    }

    public NodeId getEventTypeId() {
        if (this.ae == null) {
            Variant variant = this.getFieldValue(EVENT_TYPE_PATH);
            return variant == null ? NodeId.NULL : variant.asClass(NodeId.class, NodeId.NULL);
        }
        return this.ae.getNodeId();
    }

    public Set<List<QualifiedName>> getFieldNames() {
        return this.fieldValues.keySet();
    }

    public Variant getFieldValue(List<QualifiedName> list) {
        QualifiedName qualifiedName;
        Variant variant = this.fieldValues.get(list);
        if (variant == null && (qualifiedName = list.get(0)).getNamespaceIndex() == 0 && "EventId".equals(qualifiedName.getName())) {
            return new Variant(this.getEventId());
        }
        logger.debug(" getFieldValue return:{}", (Object)variant);
        return variant;
    }

    public Variant getFieldValue(QualifiedName[] qualifiedNameArray) {
        return this.getFieldValue(Arrays.asList(qualifiedNameArray));
    }

    public Variant[] getFieldValues(List<List<QualifiedName>> list) {
        logger.debug("getFieldList");
        int n2 = list.size();
        Variant[] variantArray = new Variant[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                List<QualifiedName> list2 = list.get(i2);
                variantArray[i2] = list2 != null ? this.getFieldValue(list2) : new Variant(this.getNodeId());
                logger.debug("getFieldList: field={}; fieldValue={}", list2, (Object)variantArray[i2]);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                logger.warn("getFieldList: " + indexOutOfBoundsException);
            }
        }
        return variantArray;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public DateTime getTime() {
        Variant variant = this.getFieldValue(TIME_PATH);
        return variant == null ? DateTime.MIN_VALUE : variant.asClass(DateTime.class, DateTime.MIN_VALUE);
    }

    public void setEventType(UaType uaType) {
        this.ae = uaType;
    }

    public void setFieldValue(List<QualifiedName> list, Variant variant) {
        this.fieldValues.put(list, variant);
    }

    public void setFieldValue(QualifiedName[] qualifiedNameArray, Variant variant) {
        this.setFieldValue(Arrays.asList(qualifiedNameArray), variant);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EventData: " + this.ad);
        for (List<QualifiedName> list : this.fieldValues.keySet()) {
            stringBuilder.append("\n " + list + "=" + this.getFieldValue(list));
        }
        return stringBuilder.toString();
    }

    private void a(UaNode uaNode) {
        this.a(uaNode, null);
    }

    private void a(UaNode uaNode, List<QualifiedName> list) {
        Object[] objectArray = uaNode.getReferences(Identifiers.HasComponent, false);
        if (logger.isDebugEnabled()) {
            logger.debug("addComponentFields: components=" + Arrays.toString(objectArray));
        }
        for (Object object : objectArray) {
            UaVariable uaVariable;
            Variant variant;
            UaNode uaNode2 = ((UaReference)object).getTargetNode();
            ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>();
            if (list != null) {
                arrayList.addAll(list);
            }
            arrayList.add(uaNode2.getBrowseName());
            if (uaNode2 instanceof UaVariable && (variant = this.a(uaVariable = (UaVariable)uaNode2)) != null && !variant.isEmpty()) {
                this.setFieldValue(arrayList, variant);
            }
            this.b(uaNode2, arrayList);
            this.a(uaNode2, arrayList);
        }
    }

    private void b(UaNode uaNode) {
        this.b(uaNode, null);
    }

    private void b(UaNode uaNode, List<QualifiedName> list) {
        Object[] objectArray = uaNode.getProperties();
        if (logger.isDebugEnabled()) {
            logger.debug("addPropertyFields: node=" + uaNode.getBrowseName() + "; properties=" + (objectArray == null ? "null" : Arrays.toString(objectArray)));
            logger.debug("basePath=" + (list == null ? "null" : list.toString()));
        }
        if (objectArray != null) {
            for (Object object : objectArray) {
                ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>(1);
                if (list != null) {
                    arrayList.addAll(list);
                }
                arrayList.add(object.getBrowseName());
                Variant variant = this.a((UaVariable)object);
                logger.debug("browsePath={}; v={}", arrayList, (Object)variant);
                if (variant == null || variant.isEmpty()) continue;
                this.setFieldValue(arrayList, variant);
            }
        }
    }

    private Variant a(UaVariable uaVariable) {
        if (uaVariable == null) {
            return null;
        }
        DataValue dataValue = uaVariable.getValue();
        if (dataValue == null || dataValue.isNull()) {
            return null;
        }
        return dataValue.getValue();
    }
}

