/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.BitField;
import com.prosysopc.ua.BitPosition;
import com.prosysopc.ua.OptionSetDataType;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractOptionSetDataType<T extends Enum<T>, S extends Number>
implements OptionSetDataType<T, S> {
    protected final BitField delegate;

    private static BitField computeBitFieldFixedSize(int n2, int ... nArray) {
        long l2 = 0L;
        for (int n3 : nArray) {
            l2 |= (long)(1 << n3);
        }
        if (n2 == 8) {
            byte by = (byte)l2;
            return UnsignedByte.getFromBits(by);
        }
        if (n2 == 16) {
            short s2 = (short)l2;
            return UnsignedShort.getFromBits(s2);
        }
        if (n2 == 32) {
            int n4 = (int)l2;
            return UnsignedInteger.getFromBits(n4);
        }
        if (n2 == 64) {
            return UnsignedLong.getFromBits(l2);
        }
        throw new IllegalArgumentException("Unsupported size for constructing BitField: " + n2);
    }

    protected static <T extends Enum<T>> BitField computeBitField(AbstractOptionSetDataType<T, ?> ... abstractOptionSetDataTypeArray) {
        if (abstractOptionSetDataTypeArray == null || abstractOptionSetDataTypeArray.length == 0) {
            return UnsignedByte.ZERO;
        }
        HashSet<T> hashSet = new HashSet<T>();
        for (AbstractOptionSetDataType<T, ?> abstractOptionSetDataType : abstractOptionSetDataTypeArray) {
            hashSet.addAll(abstractOptionSetDataType.toSet());
        }
        return AbstractOptionSetDataType.computeBitField(hashSet);
    }

    protected static BitField computeBitField(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return UnsignedByte.ZERO;
        }
        int n2 = -1;
        long l2 = 0L;
        for (int n3 : nArray) {
            if (n3 > n2) {
                n2 = n3;
            }
            l2 |= (long)(1 << n3);
        }
        if (n2 < 8) {
            byte by = (byte)l2;
            return UnsignedByte.getFromBits(by);
        }
        if (n2 < 16) {
            short s2 = (short)l2;
            return UnsignedShort.getFromBits(s2);
        }
        if (n2 < 32) {
            int n4 = (int)l2;
            return UnsignedInteger.getFromBits(n4);
        }
        if (n2 < 64) {
            return UnsignedLong.getFromBits(l2);
        }
        throw new IllegalArgumentException("Too large bit position: " + n2);
    }

    protected static <T extends Enum<T>> BitField computeBitField(Iterable<T> iterable) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Enum enum_ : iterable) {
            hashSet.add(((BitPosition)((Object)enum_)).getBitPosition());
        }
        Object object = new int[hashSet.size()];
        int n2 = 0;
        for (Integer n3 : hashSet) {
            object[n2] = n3;
            ++n2;
        }
        return AbstractOptionSetDataType.computeBitField((int[])object);
    }

    protected static <T extends Enum<T>> BitField computeBitField(T ... TArray) {
        if (TArray == null || TArray.length == 0) {
            return UnsignedByte.ZERO;
        }
        int[] nArray = new int[TArray.length];
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            nArray[i2] = ((BitPosition)TArray[i2]).getBitPosition();
        }
        return AbstractOptionSetDataType.computeBitField(nArray);
    }

    protected AbstractOptionSetDataType(BitField bitField) {
        this.delegate = bitField;
    }

    public final boolean contains(Iterable<T> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException("The given fields must include at least one field");
        }
        for (Enum enum_ : iterable) {
            if (this.contains((T)enum_)) continue;
            return false;
        }
        return true;
    }

    public final boolean contains(T t) {
        return this.isBitOn(t);
    }

    public final boolean contains(T ... TArray) {
        if (TArray == null || TArray.length == 0) {
            throw new IllegalArgumentException("The given fields must include at least one field");
        }
        for (T t : TArray) {
            if (this.contains(t)) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractOptionSetDataType abstractOptionSetDataType = (AbstractOptionSetDataType)object;
        if (this.delegate == null && abstractOptionSetDataType.delegate != null) {
            return false;
        }
        if (this.delegate instanceof Number && abstractOptionSetDataType.delegate instanceof Number) {
            return ((Number)((Object)this.delegate)).longValue() == ((Number)((Object)abstractOptionSetDataType.delegate)).longValue();
        }
        return false;
    }

    public final int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = this.delegate instanceof Number ? 31 * n3 + Long.valueOf(((Number)((Object)this.delegate)).longValue()).hashCode() : 31 * n3 + (this.delegate == null ? 0 : this.delegate.hashCode());
        return n3;
    }

    @Override
    public final boolean isBitOn(T t) {
        return this.isBitSet(((BitPosition)t).getBitPosition());
    }

    @Override
    public final boolean isBitSet(int n2) {
        return this.delegate.isBitSet(n2);
    }

    public final Set<T> toSet() {
        HashSet<Enum> hashSet = new HashSet<Enum>();
        for (Enum enum_ : this.allFields()) {
            if (!this.isBitOn(enum_)) continue;
            hashSet.add(enum_);
        }
        return hashSet;
    }

    public final String toString() {
        return this.delegate.toString();
    }

    private final int[] onBitsPositions(int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.isBitSet(i2)) continue;
            arrayList.add(i2);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            nArray[i3] = (Integer)arrayList.get(i3);
        }
        return nArray;
    }

    protected abstract EnumSet<T> allFields();

    protected final S computeBuiltInTypeValue(Class<S> clazz, int n2) {
        if (clazz.equals(this.delegate.getClass())) {
            return (S)((Number)clazz.cast(this.delegate));
        }
        return (S)((Number)clazz.cast(AbstractOptionSetDataType.computeBitFieldFixedSize(n2, this.onBitsPositions(n2))));
    }

    protected final boolean containsSets(AbstractOptionSetDataType<T, S> abstractOptionSetDataType) {
        if (abstractOptionSetDataType == null) {
            return true;
        }
        return this.contains((T)abstractOptionSetDataType.toSet());
    }

    protected final boolean containsSets(AbstractOptionSetDataType<T, S> ... abstractOptionSetDataTypeArray) {
        if (abstractOptionSetDataTypeArray == null || abstractOptionSetDataTypeArray.length == 0) {
            return true;
        }
        for (AbstractOptionSetDataType<T, S> abstractOptionSetDataType : abstractOptionSetDataTypeArray) {
            if (this.contains((T)abstractOptionSetDataType.toSet())) continue;
            return false;
        }
        return true;
    }
}

