/**
 * 
 */
package astri.test.testMasterCompImpl;

import java.sql.Timestamp;

import alma.ACS.MasterComponentImpl.MasterComponentImplBase;
import alma.ACS.MasterComponentImpl.statemachine.AlmaSubsystemActions;
import alma.acs.genfw.runtime.sm.AcsStateActionException;
import alma.alarmsystem.source.ACSAlarmSystemInterface;
import alma.alarmsystem.source.ACSAlarmSystemInterfaceFactory;
import alma.alarmsystem.source.ACSFaultState;
import astri.test.testComp1;
import astri.test.testComp1Helper;
import astri.test.testMasterCompOperations;

/**
 * @author astrisw
 *
 */
public class testMasterCompImpl extends MasterComponentImplBase
		implements testMasterCompOperations, AlmaSubsystemActions {

	/* (non-Javadoc)
	 * @see alma.ACS.MasterComponentImpl.statemachine.AlmaSubsystemActions#initSubsysPass1()
	 */
	private static String testComp1Name = "TESTCOMP1_1";
	testComp1 comp1 = null;
	@Override
	public void initSubsysPass1() throws AcsStateActionException {
		
			try {
				m_logger.fine("PASS1: connecting to " + testComp1Name);
				comp1 = testComp1Helper.narrow(m_containerServices.getComponent(testComp1Name));
				m_logger.info("PASS1 Inizializing component");
			} catch (Exception e) {
				throw new AcsStateActionException(e);
			}
			m_logger.fine("PASS1: monitor component");
			monitorComponent(comp1,new testCompResourceErrorHandler<testComp1> (testComp1Name,true));
			//monitorPingableResource(resource, name, err);
	}

	/* (non-Javadoc)
	 * @see alma.ACS.MasterComponentImpl.statemachine.AlmaSubsystemActions#initSubsysPass2()
	 */
	@Override
	public void initSubsysPass2() throws AcsStateActionException {
		
		m_logger.info("Pass2");
	}

	/* (non-Javadoc)
	 * @see alma.ACS.MasterComponentImpl.statemachine.AlmaSubsystemActions#reinitSubsystem()
	 */
	@Override
	public void reinitSubsystem() throws AcsStateActionException {
		
		m_logger.info("Reinit");
	}

	/* (non-Javadoc)
	 * @see alma.ACS.MasterComponentImpl.statemachine.AlmaSubsystemActions#shutDownSubsysPass1()
	 */
	@Override
	public void shutDownSubsysPass1() throws AcsStateActionException {

		m_logger.info("ShutDown1");
		stopMonitoringAllResources();
	}

	/* (non-Javadoc)
	 * @see alma.ACS.MasterComponentImpl.statemachine.AlmaSubsystemActions#shutDownSubsysPass2()
	 */
	@Override
	public void shutDownSubsysPass2() throws AcsStateActionException {
		
		m_logger.info("ShutDown2");
		m_containerServices.releaseComponent(testComp1Name);
	}

	/* (non-Javadoc)
	 * @see alma.ACS.MasterComponentImpl.MasterComponentImplBase#getActionHandler()
	 */
	@Override
	protected AlmaSubsystemActions getActionHandler() {
		
		return this;
	}
	
	protected class testCompResourceErrorHandler<T> extends DefaultResourceErrorHandler<T> {

		testCompResourceErrorHandler(String resourceName, boolean isComponent) {
			super(resourceName, isComponent);
		}
		

		@Override
		public boolean resourceUnreachable(T resource) {
			
			return super.resourceUnreachable(resource);
		}

		@Override
		public void badState(T resource, String stateName) {
			
			super.badState(resource, stateName);
		}

		@Override
		public void resourceRecovered(T resource) {

			super.resourceRecovered(resource);
		}
		
		protected void send_alarm(String faultMember, boolean active) {
			String faultFamily = "testMastC";
			int faultCode = 1;
			String faultState;
			if (active) {
				faultState = ACSFaultState.ACTIVE;
			} else {
				faultState=ACSFaultState.TERMINATE;
			}
			send_alarm(faultFamily, faultMember, faultCode, faultState);
		}
		
		protected void send_alarm(String faultFamily, String faultMember,
				int faultCode, String faultState) {
			try {
				ACSAlarmSystemInterface alarmSource = ACSAlarmSystemInterfaceFactory
						.createSource("TESTMASTERCOMP");
				ACSFaultState fs = ACSAlarmSystemInterfaceFactory.createFaultState(
						faultFamily, faultMember, faultCode);
				fs.setDescriptor(faultState);
				fs.setUserTimestamp(new Timestamp(System.currentTimeMillis()));

		
				alarmSource.push(fs);

			} catch (Exception e) {
				m_logger.warning("Failure when sending alarm: " + e);
				// throw new ArchiveEception(e.toString());
			}
		}
	}

	
}
