package astri.test.testComp1Impl;

import java.util.logging.Logger;

import alma.ACS.ComponentStates;
import alma.acs.component.ComponentLifecycle;
import alma.acs.component.ComponentLifecycleException;
import alma.acs.container.ContainerServices;
import alma.maciErrType.wrappers.AcsJComponentCleanUpEx;
import astri.test.testComp1Operations;

public class testComp1Impl implements ComponentLifecycle, testComp1Operations {

	private ContainerServices m_containerServices;
	private Logger m_logger;
	@Override
	public String name() {
		return m_containerServices.getName();
	}

	@Override
	public ComponentStates componentState() {
		return m_containerServices.getComponentStateManager().getCurrentState();
	}

	@Override
	public void doSomething() {
		m_logger.info("doSomething() called...");

	}

	@Override
	public void initialize(ContainerServices containerServices) throws ComponentLifecycleException {
		m_containerServices = containerServices;
		m_logger = m_containerServices.getLogger();
		m_logger.info("initialize() called...");

	}

	@Override
	public void execute() throws ComponentLifecycleException {
		m_logger.info("execute() called...");

	}

	@Override
	public void cleanUp() throws AcsJComponentCleanUpEx {
		m_logger.info("cleanUo() called...");

	}

	@Override
	public void aboutToAbort() {
		m_logger.info(" aboutToAbort() called...");

	}

}
