#ifndef _TmcdbGuiErrType_H_
#define _TmcdbGuiErrType_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.27 2012/02/29 12:50:09 tstaig Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "TmcdbGuiErrTypeC.h"

#include "acserrExceptionManager.h"
#include "acserrGenExport.h"

namespace TmcdbGuiErrType
{

class acserrGen_EXPORT TmcdbErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbError;
	static const char m_shortDescription[];
		
	public:
	
	static bool isEqual(ACSErr::Completion &completion);
	
	const char * getShortDescription() { return TmcdbErrorCompletion::m_shortDescription; }
		
	TmcdbErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class acserrGen_EXPORT TmcdbNoSuchRowCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbNoSuchRow;
	static const char m_shortDescription[];
		
	public:
	
	static bool isEqual(ACSErr::Completion &completion);
	
	const char * getShortDescription() { return TmcdbNoSuchRowCompletion::m_shortDescription; }
		
	TmcdbNoSuchRowCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbNoSuchRowCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbNoSuchRowCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbNoSuchRowCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbNoSuchRowCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbNoSuchRowCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class acserrGen_EXPORT TmcdbRowAlreadyExistsCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbRowAlreadyExists;
	static const char m_shortDescription[];
		
	public:
	
	static bool isEqual(ACSErr::Completion &completion);
	
	const char * getShortDescription() { return TmcdbRowAlreadyExistsCompletion::m_shortDescription; }
		
	TmcdbRowAlreadyExistsCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbRowAlreadyExistsCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbRowAlreadyExistsCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbRowAlreadyExistsCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbRowAlreadyExistsCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbRowAlreadyExistsCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class acserrGen_EXPORT TmcdbConnectionFailureCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbConnectionFailure;
	static const char m_shortDescription[];
		
	public:
	
	static bool isEqual(ACSErr::Completion &completion);
	
	const char * getShortDescription() { return TmcdbConnectionFailureCompletion::m_shortDescription; }
		
	TmcdbConnectionFailureCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbConnectionFailureCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbConnectionFailureCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbConnectionFailureCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbConnectionFailureCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbConnectionFailureCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class acserrGen_EXPORT TmcdbInitializationFailureCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbInitializationFailure;
	static const char m_shortDescription[];
		
	public:
	
	static bool isEqual(ACSErr::Completion &completion);
	
	const char * getShortDescription() { return TmcdbInitializationFailureCompletion::m_shortDescription; }
		
	TmcdbInitializationFailureCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbInitializationFailureCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbInitializationFailureCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbInitializationFailureCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbInitializationFailureCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbInitializationFailureCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class acserrGen_EXPORT TmcdbDuplicateKeyCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbDuplicateKey;
	static const char m_shortDescription[];
		
	public:
	
	static bool isEqual(ACSErr::Completion &completion);
	
	const char * getShortDescription() { return TmcdbDuplicateKeyCompletion::m_shortDescription; }
		
	TmcdbDuplicateKeyCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbDuplicateKeyCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbDuplicateKeyCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbDuplicateKeyCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbDuplicateKeyCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbDuplicateKeyCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class acserrGen_EXPORT TmcdbSqlCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbSql;
	static const char m_shortDescription[];
		
	public:
	
	static bool isEqual(ACSErr::Completion &completion);
	
	const char * getShortDescription() { return TmcdbSqlCompletion::m_shortDescription; }
		
	TmcdbSqlCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbSqlCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbSqlCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbSqlCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbSqlCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbSqlCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class acserrGen_EXPORT TmcdbKeyUpdateCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbKeyUpdate;
	static const char m_shortDescription[];
		
	public:
	
	static bool isEqual(ACSErr::Completion &completion);
	
	const char * getShortDescription() { return TmcdbKeyUpdateCompletion::m_shortDescription; }
		
	TmcdbKeyUpdateCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbKeyUpdateCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbKeyUpdateCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbKeyUpdateCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbKeyUpdateCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbKeyUpdateCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class acserrGen_EXPORT TmcdbDuplicateRowCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbDuplicateRow;
	static const char m_shortDescription[];
		
	public:
	
	static bool isEqual(ACSErr::Completion &completion);
	
	const char * getShortDescription() { return TmcdbDuplicateRowCompletion::m_shortDescription; }
		
	TmcdbDuplicateRowCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbDuplicateRowCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbDuplicateRowCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbDuplicateRowCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbDuplicateRowCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbDuplicateRowCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class acserrGen_EXPORT TmcdbInvalidDataTypeCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbInvalidDataType;
	static const char m_shortDescription[];
		
	public:
	
	static bool isEqual(ACSErr::Completion &completion);
	
	const char * getShortDescription() { return TmcdbInvalidDataTypeCompletion::m_shortDescription; }
		
	TmcdbInvalidDataTypeCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbInvalidDataTypeCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbInvalidDataTypeCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbInvalidDataTypeCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbInvalidDataTypeCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbInvalidDataTypeCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class TmcdbGuiErrTypeExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	TmcdbGuiErrTypeExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	TmcdbGuiErrTypeExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	TmcdbGuiErrTypeExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	TmcdbGuiErrTypeExImpl (TmcdbGuiErrType::TmcdbGuiErrTypeEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	TmcdbGuiErrType::TmcdbGuiErrTypeEx getTmcdbGuiErrTypeEx () { return TmcdbGuiErrType::TmcdbGuiErrTypeEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class acserrGen_EXPORT TmcdbErrorExImpl: public TmcdbGuiErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType;
	static const ACSErr::ErrorCode m_code = TmcdbError;
	static const char m_shortDescription[]  ;
	
	public:
		static bool isEqual(ACSErr::ACSbaseExImpl &ex);

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbErrorExImpl(const TmcdbErrorExImpl& ex) :
			TmcdbGuiErrTypeExImpl(const_cast<TmcdbErrorExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbErrorExImpl (const TmcdbGuiErrType::TmcdbErrorEx & ex) : 
			TmcdbGuiErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbGuiErrType::TmcdbErrorEx getTmcdbErrorEx () { return TmcdbGuiErrType::TmcdbErrorEx (getErrorTrace()); }
	
	template <class T >
	TmcdbErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class acserrGen_EXPORT TmcdbNoSuchRowExImpl: public TmcdbGuiErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType;
	static const ACSErr::ErrorCode m_code = TmcdbNoSuchRow;
	static const char m_shortDescription[]  ;
	
	public:
		static bool isEqual(ACSErr::ACSbaseExImpl &ex);

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbNoSuchRowExImpl(const TmcdbNoSuchRowExImpl& ex) :
			TmcdbGuiErrTypeExImpl(const_cast<TmcdbNoSuchRowExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbNoSuchRowExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbNoSuchRowExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbNoSuchRowExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbNoSuchRowExImpl (const TmcdbGuiErrType::TmcdbNoSuchRowEx & ex) : 
			TmcdbGuiErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbGuiErrType::TmcdbNoSuchRowEx getTmcdbNoSuchRowEx () { return TmcdbGuiErrType::TmcdbNoSuchRowEx (getErrorTrace()); }
	
	template <class T >
	TmcdbNoSuchRowExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class acserrGen_EXPORT TmcdbRowAlreadyExistsExImpl: public TmcdbGuiErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType;
	static const ACSErr::ErrorCode m_code = TmcdbRowAlreadyExists;
	static const char m_shortDescription[]  ;
	
	public:
		static bool isEqual(ACSErr::ACSbaseExImpl &ex);

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbRowAlreadyExistsExImpl(const TmcdbRowAlreadyExistsExImpl& ex) :
			TmcdbGuiErrTypeExImpl(const_cast<TmcdbRowAlreadyExistsExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbRowAlreadyExistsExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbRowAlreadyExistsExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbRowAlreadyExistsExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbRowAlreadyExistsExImpl (const TmcdbGuiErrType::TmcdbRowAlreadyExistsEx & ex) : 
			TmcdbGuiErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbGuiErrType::TmcdbRowAlreadyExistsEx getTmcdbRowAlreadyExistsEx () { return TmcdbGuiErrType::TmcdbRowAlreadyExistsEx (getErrorTrace()); }
	
	template <class T >
	TmcdbRowAlreadyExistsExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class acserrGen_EXPORT TmcdbConnectionFailureExImpl: public TmcdbGuiErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType;
	static const ACSErr::ErrorCode m_code = TmcdbConnectionFailure;
	static const char m_shortDescription[]  ;
	
	public:
		static bool isEqual(ACSErr::ACSbaseExImpl &ex);

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbConnectionFailureExImpl(const TmcdbConnectionFailureExImpl& ex) :
			TmcdbGuiErrTypeExImpl(const_cast<TmcdbConnectionFailureExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbConnectionFailureExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbConnectionFailureExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbConnectionFailureExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbConnectionFailureExImpl (const TmcdbGuiErrType::TmcdbConnectionFailureEx & ex) : 
			TmcdbGuiErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbGuiErrType::TmcdbConnectionFailureEx getTmcdbConnectionFailureEx () { return TmcdbGuiErrType::TmcdbConnectionFailureEx (getErrorTrace()); }
	
	template <class T >
	TmcdbConnectionFailureExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class acserrGen_EXPORT TmcdbInitializationFailureExImpl: public TmcdbGuiErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType;
	static const ACSErr::ErrorCode m_code = TmcdbInitializationFailure;
	static const char m_shortDescription[]  ;
	
	public:
		static bool isEqual(ACSErr::ACSbaseExImpl &ex);

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbInitializationFailureExImpl(const TmcdbInitializationFailureExImpl& ex) :
			TmcdbGuiErrTypeExImpl(const_cast<TmcdbInitializationFailureExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbInitializationFailureExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbInitializationFailureExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbInitializationFailureExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbInitializationFailureExImpl (const TmcdbGuiErrType::TmcdbInitializationFailureEx & ex) : 
			TmcdbGuiErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbGuiErrType::TmcdbInitializationFailureEx getTmcdbInitializationFailureEx () { return TmcdbGuiErrType::TmcdbInitializationFailureEx (getErrorTrace()); }
	
	template <class T >
	TmcdbInitializationFailureExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class acserrGen_EXPORT TmcdbDuplicateKeyExImpl: public TmcdbGuiErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType;
	static const ACSErr::ErrorCode m_code = TmcdbDuplicateKey;
	static const char m_shortDescription[]  ;
	
	public:
		static bool isEqual(ACSErr::ACSbaseExImpl &ex);

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbDuplicateKeyExImpl(const TmcdbDuplicateKeyExImpl& ex) :
			TmcdbGuiErrTypeExImpl(const_cast<TmcdbDuplicateKeyExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbDuplicateKeyExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbDuplicateKeyExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbDuplicateKeyExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbDuplicateKeyExImpl (const TmcdbGuiErrType::TmcdbDuplicateKeyEx & ex) : 
			TmcdbGuiErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbGuiErrType::TmcdbDuplicateKeyEx getTmcdbDuplicateKeyEx () { return TmcdbGuiErrType::TmcdbDuplicateKeyEx (getErrorTrace()); }
	
	template <class T >
	TmcdbDuplicateKeyExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class acserrGen_EXPORT TmcdbSqlExImpl: public TmcdbGuiErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType;
	static const ACSErr::ErrorCode m_code = TmcdbSql;
	static const char m_shortDescription[]  ;
	
	public:
		static bool isEqual(ACSErr::ACSbaseExImpl &ex);

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbSqlExImpl(const TmcdbSqlExImpl& ex) :
			TmcdbGuiErrTypeExImpl(const_cast<TmcdbSqlExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbSqlExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbSqlExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbSqlExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbSqlExImpl (const TmcdbGuiErrType::TmcdbSqlEx & ex) : 
			TmcdbGuiErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbGuiErrType::TmcdbSqlEx getTmcdbSqlEx () { return TmcdbGuiErrType::TmcdbSqlEx (getErrorTrace()); }
	
	template <class T >
	TmcdbSqlExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class acserrGen_EXPORT TmcdbKeyUpdateExImpl: public TmcdbGuiErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType;
	static const ACSErr::ErrorCode m_code = TmcdbKeyUpdate;
	static const char m_shortDescription[]  ;
	
	public:
		static bool isEqual(ACSErr::ACSbaseExImpl &ex);

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbKeyUpdateExImpl(const TmcdbKeyUpdateExImpl& ex) :
			TmcdbGuiErrTypeExImpl(const_cast<TmcdbKeyUpdateExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbKeyUpdateExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbKeyUpdateExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbKeyUpdateExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbKeyUpdateExImpl (const TmcdbGuiErrType::TmcdbKeyUpdateEx & ex) : 
			TmcdbGuiErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbGuiErrType::TmcdbKeyUpdateEx getTmcdbKeyUpdateEx () { return TmcdbGuiErrType::TmcdbKeyUpdateEx (getErrorTrace()); }
	
	template <class T >
	TmcdbKeyUpdateExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class acserrGen_EXPORT TmcdbDuplicateRowExImpl: public TmcdbGuiErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType;
	static const ACSErr::ErrorCode m_code = TmcdbDuplicateRow;
	static const char m_shortDescription[]  ;
	
	public:
		static bool isEqual(ACSErr::ACSbaseExImpl &ex);

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbDuplicateRowExImpl(const TmcdbDuplicateRowExImpl& ex) :
			TmcdbGuiErrTypeExImpl(const_cast<TmcdbDuplicateRowExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbDuplicateRowExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbDuplicateRowExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbDuplicateRowExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbDuplicateRowExImpl (const TmcdbGuiErrType::TmcdbDuplicateRowEx & ex) : 
			TmcdbGuiErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbGuiErrType::TmcdbDuplicateRowEx getTmcdbDuplicateRowEx () { return TmcdbGuiErrType::TmcdbDuplicateRowEx (getErrorTrace()); }
	
	template <class T >
	TmcdbDuplicateRowExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class acserrGen_EXPORT TmcdbInvalidDataTypeExImpl: public TmcdbGuiErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbGuiErrType;
	static const ACSErr::ErrorCode m_code = TmcdbInvalidDataType;
	static const char m_shortDescription[]  ;
	
	public:
		static bool isEqual(ACSErr::ACSbaseExImpl &ex);

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbInvalidDataTypeExImpl(const TmcdbInvalidDataTypeExImpl& ex) :
			TmcdbGuiErrTypeExImpl(const_cast<TmcdbInvalidDataTypeExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbInvalidDataTypeExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbInvalidDataTypeExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbInvalidDataTypeExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbInvalidDataTypeExImpl (const TmcdbGuiErrType::TmcdbInvalidDataTypeEx & ex) : 
			TmcdbGuiErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbGuiErrType::TmcdbInvalidDataTypeEx getTmcdbInvalidDataTypeEx () { return TmcdbGuiErrType::TmcdbInvalidDataTypeEx (getErrorTrace()); }
	
	template <class T >
	TmcdbInvalidDataTypeExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbGuiErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
