#!/usr/bin/env python
#
# ALMA - Atacama Large Millimeter Array
# (c) Associated Universities Inc., 2015
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

from threading import Thread
import sys
import time
import ACSErr
from Acspy.Clients.SimpleClient import PySimpleClient
from ACS import MasterComponent
from ACS import SUBSYSSTATE_AVAILABLE, SUBSYSSTATE_OFFLINE, SUBSYSSTATE_SHUTDOWN, SUBSYSSTATE_ONLINE, SUBSYSSTATE_OPERATIONAL, SUBSYSSTATE_PREINITIALIZED, SUBSYSSTATE_PRESHUTDOWN, SUBSYSSTATE_ERROR, COMPSTATE_OPERATIONAL


class Startup_test():
    '''
    Utility class to handle subsystem states 
    '''

    def __init__(self, comp=None):
        '''
        Specify which subsystems to start. 
        '''
        # Initialize subsystem master references
        self.client = PySimpleClient()
        self.cont_master = None
        self.cont=False
        self.maste_name=comp

### MAster Start ###
    def getMaster(self):
        self.cont_master = self.client.getComponent(self.maste_name)
        print (self.cont_master._get_componentState())
        if(self.cont_master._get_componentState()==COMPSTATE_OPERATIONAL):
            print("Master Operational")
            self.cont=True
            time.sleep(3)
            return True
        return False
    def getState(self):
        if (self.cont):
          a=self.cont_master._get_currentStateHierarchy().get_sync()
          val=a[0]
          compl=a[1]
          print(val,"TimeStamp:",compl.timeStamp)

    def initPass1(self):
        if (self.cont):
          self.cont_master.doTransition(MasterComponent.SUBSYSEVENT_INITPASS1)
          self.getState()
    def initPass2(self):
        self.cont_master.doTransition(MasterComponent.SUBSYSEVENT_INITPASS2)
        self.getState()
    def shudownPass1(self):
        self.cont_master.doTransition(MasterComponent.SUBSYSEVENT_SHUTDOWNPASS1)
        self.getState()
    def shudownPass2(self):
        self.cont_master.doTransition(MasterComponent.SUBSYSEVENT_SHUTDOWNPASS2)
        self.getState()

    def releaseMaster(self):
        self.client.releaseComponent(self.cont_master._get_name())
        self.client.disconnect()
        self.cont_master = None

# **************************************************
# MAIN Program
# **************************************************
if __name__ == '__main__':
    '''
    Use this to startup manually, or as an example for your test script.
    '''
    # Get the handler
    TCSstateHandler = Startup_test('TESTMASTERCOMP')
    ret=TCSstateHandler.getMaster()
    TCSstateHandler.getState()
    time.sleep(3)	
    # Startup
    if ( not ret):
        exit(1)
    else:
        TCSstateHandler.initPass1()
        time.sleep(3)
        TCSstateHandler.initPass2()
    
    input("Hit return to shutdown")
    TCSstateHandler.shudownPass1()
    time.sleep(3)
    TCSstateHandler.shudownPass2()
    TCSstateHandler.releaseMaster()
    exit(0)

