/*
 * Decompiled with CFR 0.152.
 */
package astri.test.testMasterCompImpl;

import alma.ACS.MasterComponent;
import alma.ACS.MasterComponentHelper;
import alma.ACS.MasterComponentImpl.StateChangeListener;
import alma.ACS.MasterComponentImpl.StateChangeSemaphore;
import alma.ACS.MasterComponentPackage.SubsystemStateEvent;
import alma.ACS.ROstringSeq;
import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.component.client.ComponentClient;
import alma.acs.util.AcsLocations;
import java.util.logging.Logger;
import org.omg.CORBA.Object;

public class testMasterCompClient {
    private static String masterName = "TESTMASTERCOMP";

    public static void main(String[] stringArray) throws Exception {
        Logger logger = Logger.getLogger(testMasterCompClient.class.getSimpleName());
        String string = null;
        string = AcsLocations.figureOutManagerLocation();
        if (string == null) {
            logger.severe("MANAGER_REFERENCE is missing");
            System.exit(-1);
        }
        ComponentClient componentClient = new ComponentClient(logger, string, "testMasterCompClient");
        MasterComponent masterComponent = null;
        if (componentClient.getContainerServices().findComponents(masterName, null).length > 0) {
            try {
                masterComponent = MasterComponentHelper.narrow((Object)componentClient.getContainerServices().getComponent(masterName));
            }
            catch (AcsJContainerServicesEx acsJContainerServicesEx) {
                logger.severe(acsJContainerServicesEx.getContextInfo());
                logger.warning("Could not connect to " + masterName + ":\n" + acsJContainerServicesEx.toString());
            }
        } else {
            logger.warning("ERROR: Did not find component" + masterName);
            componentClient.tearDown();
            System.exit(-1);
        }
        ROstringSeq rOstringSeq = masterComponent.currentStateHierarchy();
        StateChangeListener stateChangeListener = new StateChangeListener(logger);
        stateChangeListener.createMonitor(rOstringSeq, componentClient.getContainerServices());
        StateChangeSemaphore stateChangeSemaphore = stateChangeListener.getStateChangeSemaphore();
        String[] stringArray2 = stateChangeListener.getCurrentState();
        logger.info(stringArray2[0] + "/" + stringArray2[1] + "/" + stringArray2[2]);
        logger.info("Master State:***" + masterComponent.componentState().toString() + "***");
        stateChangeSemaphore.reset();
        masterComponent.doTransition(SubsystemStateEvent.SUBSYSEVENT_INITPASS1);
        stateChangeSemaphore.waitForStateChanges(2);
        stringArray2 = stateChangeListener.getCurrentState();
        logger.info(stringArray2[0] + "/" + stringArray2[1] + "/" + stringArray2[2]);
        logger.info("waiting to do something");
        Thread.sleep(10000L);
        stateChangeSemaphore.reset();
        masterComponent.doTransition(SubsystemStateEvent.SUBSYSEVENT_SHUTDOWNPASS1);
        stateChangeSemaphore.waitForStateChanges(2);
        stringArray2 = stateChangeListener.getCurrentState();
        logger.info(stringArray2[0] + "/" + stringArray2[1] + "/" + stringArray2[2]);
        Thread.sleep(10000L);
        stateChangeSemaphore.reset();
        masterComponent.doTransition(SubsystemStateEvent.SUBSYSEVENT_SHUTDOWNPASS2);
        stateChangeSemaphore.waitForStateChanges(2);
        stringArray2 = stateChangeListener.getCurrentState();
        logger.info(stringArray2[0] + "/" + stringArray2[1] + "/" + stringArray2[2]);
        componentClient.tearDown();
    }
}

