package astri.test.testPingComp1Impl;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Logger;

import alma.acs.nc.AcsEventPublisher;
import alma.acs.nc.NCPublisher;

import org.omg.CORBA.DoubleHolder;
import org.omg.CORBA.IntHolder;

import alma.ACS.ComponentStates;
import alma.ACSErrTypeCommon.wrappers.AcsJIllegalStateEventEx;
import alma.acs.component.ComponentLifecycle;
import alma.acs.container.ContainerServices;
import alma.acs.exceptions.AcsJException;
import astri.test.testPingComp1Operations;
import astri.test.testPingComp1Package.testPingCompNotificationEvent;

/**
 * A very simple java component template
*/ 
public class testPingComp1Impl implements ComponentLifecycle, testPingComp1Operations
{
	private ContainerServices m_containerServices;
	private Logger m_logger;
	private testPingCompNotificationEvent m_event=null;
	private AcsEventPublisher<testPingCompNotificationEvent> m_publisher = null;
	private pingResourseIP resource=null;
	/////////////////////////////////////////////////////////////
	// Implementation of ComponentLifecycle
	/////////////////////////////////////////////////////////////
	
	public void initialize(ContainerServices containerServices) {
		m_containerServices = containerServices;
		m_logger = m_containerServices.getLogger();
		try {
			m_publisher = m_containerServices.createNotificationChannelPublisher(CHANNELNAME_TEST,testPingCompNotificationEvent.class);
			m_logger.info("NCPublisher created.");
			resource= new pingResourseIP(m_logger,"myMAC","192.168.1.8");
		} catch (AcsJException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (UnknownHostException e) {
			e.printStackTrace();
		}
		m_logger.info("initialize() called...");
	}
    
	public void execute() {
		m_logger.info("execute() called...");
	}
    
	public void cleanUp() {
		try {
			m_publisher.disconnect();
		} catch (AcsJIllegalStateEventEx e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		m_logger.info("cleanUp() called..., nothing to clean up.");
	}
    
	public void aboutToAbort() {
		cleanUp();
		m_logger.info("abort...");
        
	}
	
	/////////////////////////////////////////////////////////////
	// Implementation of ACSComponent
	/////////////////////////////////////////////////////////////
	
	public ComponentStates componentState() {
		return m_containerServices.getComponentStateManager().getCurrentState();
		
	}
	public String name() {
		return m_containerServices.getName();
	}
	
	/////////////////////////////////////////////////////////////
	// Implementation of testPingComp1ImplOperations
	/////////////////////////////////////////////////////////////
	
	public String sayHello() {
		m_logger.info("sayHello called...");
		int nEvents=100;
		
		int k=0;
		while ( k< nEvents) {
			// Constructing the event
			Long timestamp= System.currentTimeMillis();
			
			m_event = new testPingCompNotificationEvent(timestamp.toString(), "testingEvent:"+Integer.valueOf(k).toString(),"text" );
			// Publishing the event
			try {
				m_publisher.publishEvent(m_event);
				m_logger.info("Sent event: "+k);
			} catch (AcsJException e) {
				m_logger.info("Problems sending event: "+k);
				e.printStackTrace();
			}
			// simulates the period
			try {
				Thread.sleep(100);
			} catch (InterruptedException e) {
				
				e.printStackTrace();
			}
			k++;
		}
		return "hello";
	}
	
	public String sayHelloWithParameters(String inString,
			DoubleHolder inoutDouble, IntHolder outInt) {
		m_logger.info("sayHello called with arguments inString=" + inString
				+ "; inoutDouble=" + inoutDouble.value
				+ ". Will return 'hello'...");
		outInt.value = (int) Math.round(Math.E * 10000000);
		return "hello";
	}

	@Override
	public boolean ping(boolean fast, boolean recursive, int id) {
		if (fast)  return true;
		else {
			/* insert here something releated to the connection to an external sesurce: eg a DB, a Device 
			 * an hearthbeat of the an OPC-UA server etc. 
			 */
			try {
				if (resource.sendPingRequest())
					return true;
			} catch (IOException e) {
				e.printStackTrace();
				return false;
			}
		}
		return false;
		
	}
}
