#!/bin/bash

#*******************************************************************************
# ALMA - Atacama Large Millimeter Array
# Copyright (c) ESO - European Southern Observatory, 2011
# (in the framework of the ALMA collaboration).
# All rights reserved.
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
#*******************************************************************************
if [ $# -lt 2 ]; then
	echo $"Usage: $0 USERLIST TABLESPACE_BASE_NAME"
	exit 1
fi

echo "Creating Tablespaces for Partitioning: the process could be quite long, please wait"
echo

TBS_BASE=$(echo ${!#} | tr [a-z] [A-Z])
USERLIST=$(echo $* | sed -e 's/'"$TBS_BASE"' *$//g')

if [ -z "$TBS_BASE" ]; then
	echo "Tablespace base name can't' be empty"
	echo $"Usage: $0 USERLIST TBS_BASE_NAME"
	exit 1
fi

DBF_BASE=$(echo $TBS_BASE | tr [A-Z] [a-z])

for INTERVAL in $(seq 1 6)
do

TBS_NAME=$(sqlplus -S / as sysdba<<EOF | grep -v ^$
set feedback off
set heading off
SELECT '$TBS_BASE' || TO_CHAR(TRUNC(SYSDATE+INTERVAL '$INTERVAL' MONTH, 'MM'), 'YYYYMMDD')  FROM dual;
quit
EOF
)

DBF_NAME=$(sqlplus -S / as sysdba<<EOF | grep -v ^$
set feedback off
set heading off
SELECT '$DBF_BASE' || TO_CHAR(TRUNC(SYSDATE+INTERVAL '$INTERVAL' MONTH, 'MM'), 'YYYYMMDD') FROM dual;
quit
EOF
)


sqlplus -S / as sysdba<<EOF
set echo on
CREATE TABLESPACE $TBS_NAME LOGGING
  DATAFILE '+GROUP3/ALMA/${DBF_NAME}.dbf' size 4096M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
  EXTENT MANAGEMENT LOCAL
  SEGMENT SPACE MANAGEMENT AUTO
  DEFAULT COMPRESS FOR ALL OPERATIONS;
ALTER TABLESPACE $TBS_NAME ADD DATAFILE '+GROUP3/ALMA/${DBF_NAME}_1.dbf' SIZE 4096M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M;
quit
EOF


for j in $USERLIST
do
	sqlplus -S / as sysdba<<-EOF
	set echo on
	ALTER USER $j QUOTA UNLIMITED ON $TBS_NAME;
	quit
	EOF
done

echo "Tablespace created"
sqlplus -S / as sysdba<<EOF
set feedback off
set heading off
set pages 1000
set lines 160
select t.TABLESPACE_NAME, t.STATUS, t.COMPRESS_FOR, d.FILE_NAME from dba_tablespaces t inner join dba_data_files d on t.TABLESPACE_NAME=d.TABLESPACE_NAME where t.TABLESPACE_NAME='$TBS_NAME';
quit
EOF

done
