CREATE  TABLE MonitorData (
    MonitorPointId NUMBER (10)     NOT NULL ,
    StartTime NUMBER (19)     NOT NULL ,
    EndTime NUMBER (19)     NOT NULL ,
    MonitorTS TIMESTAMP    (6) NOT NULL ,
    StartTS AS (to_timestamp('BC4712-01-01 00:00:00','BCYYYY-MM-DD HH24:MI:SS')+ numtodsinterval(StartTime/864000000000. + 2299160.0, 'DAY')),
    EndTS AS (to_timestamp('BC4712-01-01 00:00:00','BCYYYY-MM-DD HH24:MI:SS')+ numtodsinterval(EndTime/864000000000. + 2299160.0, 'DAY')),
    SampleSize NUMBER (10)     NOT NULL ,
    MonitorClob CLOB     NOT NULL ,
    MinStat BINARY_DOUBLE     NULL ,
    MaxStat BINARY_DOUBLE     NULL ,
    MeanStat BINARY_DOUBLE     NULL ,
    StdDevStat BINARY_DOUBLE     NULL
)
LOB (MonitorClob) STORE AS SECUREFILE (COMPRESS DEDUPLICATE)
;
