package alma.acs.tmcdb;
// Generated Apr 24, 2021, 3:15:50 AM by Hibernate Tools 5.3.7.Final


import alma.hibernate.util.StringEnumUserType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;

/**
 * MonitorPoint generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="`MONITORPOINT`"
    , uniqueConstraints =  @UniqueConstraint(columnNames={"`BACIPROPERTYID`", "`ASSEMBLYID`", "`INDICE`"})
)
@TypeDef(name="MonitorDataTypeEnum", typeClass=StringEnumUserType.class,
   parameters={ @Parameter(name="enumClassName", value="alma.acs.tmcdb.MonitorDataTypeEnum") })
public class MonitorPoint extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected Integer monitorPointId;
     protected BACIProperty BACIProperty;
     protected Assembly assembly;
     protected String monitorPointName;
     protected Integer indice;
     protected MonitorDataTypeEnum dataType;
     protected String RCA;
     protected Boolean teRelated;
     protected String rawDataType;
     protected String worldDataType;
     protected String units;
     protected Double scale;
     protected Double offset;
     protected String minRange;
     protected String maxRange;
     protected String description;
     private Set<MonitorData> monitorDatas = new HashSet<MonitorData>(0);

    public MonitorPoint() {
    }
   
    @Id @GeneratedValue(generator="alma_acs_tmcdb_MonitorPoint_MonitorPointIdGenerator")
    @GenericGenerator(name="alma_acs_tmcdb_MonitorPoint_MonitorPointIdGenerator", strategy="native",
       parameters = {@Parameter(name="sequence", value="MonitorPoint_seq")}
	)

    
    @Column(name="`MONITORPOINTID`", unique=true, nullable=false)
    public Integer getMonitorPointId() {
        return this.monitorPointId;
    }

    
    public void setMonitorPointId(Integer monitorPointId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("monitorPointId", this.monitorPointId, this.monitorPointId = monitorPointId);
        else
            this.monitorPointId = monitorPointId;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="`BACIPROPERTYID`", nullable=false)
    public BACIProperty getBACIProperty() {
        return this.BACIProperty;
    }

    
    public void setBACIProperty(BACIProperty BACIProperty) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("BACIProperty", this.BACIProperty, this.BACIProperty = BACIProperty);
        else
            this.BACIProperty = BACIProperty;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="`ASSEMBLYID`", nullable=false)
    public Assembly getAssembly() {
        return this.assembly;
    }

    
    public void setAssembly(Assembly assembly) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("assembly", this.assembly, this.assembly = assembly);
        else
            this.assembly = assembly;
    }


    
    @Column(name="`MONITORPOINTNAME`", nullable=false, length=128)
    public String getMonitorPointName() {
        return this.monitorPointName;
    }

    
    public void setMonitorPointName(String monitorPointName) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("monitorPointName", this.monitorPointName, this.monitorPointName = monitorPointName);
        else
            this.monitorPointName = monitorPointName;
    }


    
    @Column(name="`INDICE`", nullable=false)
    public Integer getIndice() {
        return this.indice;
    }

    
    public void setIndice(Integer indice) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("indice", this.indice, this.indice = indice);
        else
            this.indice = indice;
    }


    
    @Column(name="`DATATYPE`", nullable=false, length=16777216)
	@Type(type="MonitorDataTypeEnum")
    public MonitorDataTypeEnum getDataType() {
        return this.dataType;
    }

    
    public void setDataType(MonitorDataTypeEnum dataType) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("dataType", this.dataType, this.dataType = dataType);
        else
            this.dataType = dataType;
    }


    
    @Column(name="`RCA`", nullable=false, length=16777216)
    public String getRCA() {
        return this.RCA;
    }

    
    public void setRCA(String RCA) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("RCA", this.RCA, this.RCA = RCA);
        else
            this.RCA = RCA;
    }


    
    @Column(name="`TERELATED`", nullable=false)
    public Boolean getTeRelated() {
        return this.teRelated;
    }

    
    public void setTeRelated(Boolean teRelated) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("teRelated", this.teRelated, this.teRelated = teRelated);
        else
            this.teRelated = teRelated;
    }


    
    @Column(name="`RAWDATATYPE`", nullable=false, length=16777216)
    public String getRawDataType() {
        return this.rawDataType;
    }

    
    public void setRawDataType(String rawDataType) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("rawDataType", this.rawDataType, this.rawDataType = rawDataType);
        else
            this.rawDataType = rawDataType;
    }


    
    @Column(name="`WORLDDATATYPE`", nullable=false, length=16777216)
    public String getWorldDataType() {
        return this.worldDataType;
    }

    
    public void setWorldDataType(String worldDataType) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("worldDataType", this.worldDataType, this.worldDataType = worldDataType);
        else
            this.worldDataType = worldDataType;
    }


    
    @Column(name="`UNITS`", length=16777216)
    public String getUnits() {
        return this.units;
    }

    
    public void setUnits(String units) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("units", this.units, this.units = units);
        else
            this.units = units;
    }


    
    @Column(name="`SCALE`", precision=64, scale=0)
    public Double getScale() {
        return this.scale;
    }

    
    public void setScale(Double scale) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("scale", this.scale, this.scale = scale);
        else
            this.scale = scale;
    }


    
    @Column(name="`OFFSET`", precision=64, scale=0)
    public Double getOffset() {
        return this.offset;
    }

    
    public void setOffset(Double offset) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("offset", this.offset, this.offset = offset);
        else
            this.offset = offset;
    }


    
    @Column(name="`MINRANGE`", length=16777216)
    public String getMinRange() {
        return this.minRange;
    }

    
    public void setMinRange(String minRange) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("minRange", this.minRange, this.minRange = minRange);
        else
            this.minRange = minRange;
    }


    
    @Column(name="`MAXRANGE`", length=16777216)
    public String getMaxRange() {
        return this.maxRange;
    }

    
    public void setMaxRange(String maxRange) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("maxRange", this.maxRange, this.maxRange = maxRange);
        else
            this.maxRange = maxRange;
    }


    
    @Column(name="`DESCRIPTION`", nullable=false, length=16777216)
    public String getDescription() {
        return this.description;
    }

    
    public void setDescription(String description) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("description", this.description, this.description = description);
        else
            this.description = description;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="monitorPoint")
    public Set<MonitorData> getMonitorDatas() {
        return this.monitorDatas;
    }

    
    public void setMonitorDatas(Set<MonitorData> monitorDatas) {    
    	this.monitorDatas = monitorDatas;
    }

	public void addMonitorDatas(Set<MonitorData> elements) {
		if( this.monitorDatas != null )
			for(Iterator<MonitorData> it = elements.iterator(); it.hasNext(); )
				addMonitorDataToMonitorDatas((MonitorData)it.next());
	}

	public void addMonitorDataToMonitorDatas(MonitorData element) {
		if( !this.monitorDatas.contains(element) ) {
			this.monitorDatas.add(element);
		}
	}



   public boolean equalsContent(Object other) {
         if ( (this == other ) ) return true;
		 if ( (other == null ) ) return false;
		 if ( !(other instanceof MonitorPoint) ) return false;
		 MonitorPoint castOther = ( MonitorPoint ) other;

		 return ( (this.getBACIProperty()==castOther.getBACIProperty()) || ( this.getBACIProperty()!=null && castOther.getBACIProperty()!=null && this.getBACIProperty().equals(castOther.getBACIProperty()) ) )
 && ( (this.getAssembly()==castOther.getAssembly()) || ( this.getAssembly()!=null && castOther.getAssembly()!=null && this.getAssembly().equals(castOther.getAssembly()) ) )
 && ( (this.getIndice()==castOther.getIndice()) || ( this.getIndice()!=null && castOther.getIndice()!=null && this.getIndice().equals(castOther.getIndice()) ) );
   }

   public int hashCodeContent() {
         int result = 17;

         
         result = 37 * result + ( getBACIProperty() == null ? 0 : this.getBACIProperty().hashCode() );
         result = 37 * result + ( getAssembly() == null ? 0 : this.getAssembly().hashCode() );
         
         result = 37 * result + ( getIndice() == null ? 0 : this.getIndice().hashCode() );
         
         
         
         
         
         
         
         
         
         
         
         
         return result;
   }


}


