package alma.acs.tmcdb;
// Generated Apr 24, 2021, 3:15:50 AM by Hibernate Tools 5.3.7.Final


import alma.hibernate.util.HibernateXmlType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;

/**
 * Assembly generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="`ASSEMBLY`"
    , uniqueConstraints =  @UniqueConstraint(columnNames={"`SERIALNUMBER`", "`CONFIGURATIONID`"})
)
@TypeDef(name="xmltype", typeClass=HibernateXmlType.class)
public class Assembly extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected Integer assemblyId;
     protected HWConfiguration HWConfiguration;
     protected AssemblyType assemblyType;
     protected String serialNumber;
     protected String data;
     private Set<MonitorPoint> monitorPoints = new HashSet<MonitorPoint>(0);
     private Set<AssemblyOnline> assemblyOnlines = new HashSet<AssemblyOnline>(0);

    public Assembly() {
    }
   
    @Id @GeneratedValue(generator="alma_acs_tmcdb_Assembly_AssemblyIdGenerator")
    @GenericGenerator(name="alma_acs_tmcdb_Assembly_AssemblyIdGenerator", strategy="native",
       parameters = {@Parameter(name="sequence", value="Assembly_seq")}
	)

    
    @Column(name="`ASSEMBLYID`", unique=true, nullable=false)
    public Integer getAssemblyId() {
        return this.assemblyId;
    }

    
    public void setAssemblyId(Integer assemblyId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("assemblyId", this.assemblyId, this.assemblyId = assemblyId);
        else
            this.assemblyId = assemblyId;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="`CONFIGURATIONID`", nullable=false)
    public HWConfiguration getHWConfiguration() {
        return this.HWConfiguration;
    }

    
    public void setHWConfiguration(HWConfiguration HWConfiguration) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("HWConfiguration", this.HWConfiguration, this.HWConfiguration = HWConfiguration);
        else
            this.HWConfiguration = HWConfiguration;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="`ASSEMBLYTYPENAME`", nullable=false)
    public AssemblyType getAssemblyType() {
        return this.assemblyType;
    }

    
    public void setAssemblyType(AssemblyType assemblyType) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("assemblyType", this.assemblyType, this.assemblyType = assemblyType);
        else
            this.assemblyType = assemblyType;
    }


    
    @Column(name="`SERIALNUMBER`", nullable=false, length=256)
    public String getSerialNumber() {
        return this.serialNumber;
    }

    
    public void setSerialNumber(String serialNumber) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("serialNumber", this.serialNumber, this.serialNumber = serialNumber);
        else
            this.serialNumber = serialNumber;
    }


    
    @Column(name="`DATA`", length=16777216)
    @Type(type="xmltype")
    public String getData() {
        return this.data;
    }

    
    public void setData(String data) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("data", this.data, this.data = data);
        else
            this.data = data;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="assembly")
    public Set<MonitorPoint> getMonitorPoints() {
        return this.monitorPoints;
    }

    
    public void setMonitorPoints(Set<MonitorPoint> monitorPoints) {    
    	this.monitorPoints = monitorPoints;
    }

	public void addMonitorPoints(Set<MonitorPoint> elements) {
		if( this.monitorPoints != null )
			for(Iterator<MonitorPoint> it = elements.iterator(); it.hasNext(); )
				addMonitorPointToMonitorPoints((MonitorPoint)it.next());
	}

	public void addMonitorPointToMonitorPoints(MonitorPoint element) {
		if( !this.monitorPoints.contains(element) ) {
			this.monitorPoints.add(element);
		}
	}


@OneToMany(fetch=FetchType.LAZY, mappedBy="assembly")
    public Set<AssemblyOnline> getAssemblyOnlines() {
        return this.assemblyOnlines;
    }

    
    public void setAssemblyOnlines(Set<AssemblyOnline> assemblyOnlines) {    
    	this.assemblyOnlines = assemblyOnlines;
    }

	public void addAssemblyOnlines(Set<AssemblyOnline> elements) {
		if( this.assemblyOnlines != null )
			for(Iterator<AssemblyOnline> it = elements.iterator(); it.hasNext(); )
				addAssemblyOnlineToAssemblyOnlines((AssemblyOnline)it.next());
	}

	public void addAssemblyOnlineToAssemblyOnlines(AssemblyOnline element) {
		if( !this.assemblyOnlines.contains(element) ) {
			this.assemblyOnlines.add(element);
		}
	}



   public boolean equalsContent(Object other) {
         if ( (this == other ) ) return true;
		 if ( (other == null ) ) return false;
		 if ( !(other instanceof Assembly) ) return false;
		 Assembly castOther = ( Assembly ) other;

		 return ( (this.getHWConfiguration()==castOther.getHWConfiguration()) || ( this.getHWConfiguration()!=null && castOther.getHWConfiguration()!=null && this.getHWConfiguration().equals(castOther.getHWConfiguration()) ) )
 && ( (this.getSerialNumber()==castOther.getSerialNumber()) || ( this.getSerialNumber()!=null && castOther.getSerialNumber()!=null && this.getSerialNumber().equals(castOther.getSerialNumber()) ) );
   }

   public int hashCodeContent() {
         int result = 17;

         
         result = 37 * result + ( getHWConfiguration() == null ? 0 : this.getHWConfiguration().hashCode() );
         
         result = 37 * result + ( getSerialNumber() == null ? 0 : this.getSerialNumber().hashCode() );
         
         
         
         return result;
   }


}


