package alma.acs.tmcdb.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.List;

public class TableInheritance_HwConfigMonitoring extends AbstractTableInheritance {

	public TableInheritance_HwConfigMonitoring() {

		Map<String, String> tmpMap;

		map = new HashMap<String, String>();
			map.put("acacorrset", "BaseElement");
			map.put("antenna", "BaseElement");
			map.put("pad", "BaseElement");
			map.put("frontend", "BaseElement");
			map.put("photonicreference", "BaseElement");
			map.put("weatherstationcontroller", "BaseElement");
			map.put("centrallo", "BaseElement");
			map.put("aostiming", "BaseElement");
			map.put("holographytower", "BaseElement");
			map.put("corrquadrant", "BaseElement");
			map.put("corrquadrantrack", "BaseElement");
			map.put("corrstationbin", "BaseElement");
			map.put("correlatorbin", "BaseElement");

		tablesImplementingIdentifiable = new ArrayList<String>();
			tablesImplementingIdentifiable.add("hwconfiguration");
			tablesImplementingIdentifiable.add("antenna");
			tablesImplementingIdentifiable.add("acacorrdelays");
			tablesImplementingIdentifiable.add("pad");
			tablesImplementingIdentifiable.add("antennatopad");
			tablesImplementingIdentifiable.add("pointingmodel");
			tablesImplementingIdentifiable.add("focusmodel");

		tablesImplementingBackloggable = new ArrayList<String>();
			tablesImplementingBackloggable.add("bl_pointingmodelcoeff");
			tablesImplementingBackloggable.add("bl_pointingmodelcoeffoffset");
			tablesImplementingBackloggable.add("bl_focusmodelcoeff");
			tablesImplementingBackloggable.add("bl_focusmodelcoeffoffset");
			tablesImplementingBackloggable.add("bl_fedelay");
			tablesImplementingBackloggable.add("bl_ifdelay");
			tablesImplementingBackloggable.add("bl_lodelay");
			tablesImplementingBackloggable.add("bl_xpdelay");
			tablesImplementingBackloggable.add("bl_antennadelay");
			tablesImplementingBackloggable.add("bl_antenna");
			tablesImplementingBackloggable.add("bl_pad");
			tablesImplementingBackloggable.add("bl_antennatopad");

		keymap = new HashMap<String, String>();
			keymap.put("acacorrset","acacorrsetbaseelementfkey");
			keymap.put("antenna","antennabaseelementfkey");
			keymap.put("pad","padbaseelementfkey");
			keymap.put("frontend","frontendbaseelementfkey");
			keymap.put("photonicreference","photonrbaseelementfkey");
			keymap.put("weatherstationcontroller","weathescbaseelementfkey");
			keymap.put("centrallo","centrallobaseelementfkey");
			keymap.put("aostiming","aostimingbaseelementfkey");
			keymap.put("holographytower","hologrtbaseelementfkey");
			keymap.put("corrquadrant","corrquadrantbaseelementfkey");
			keymap.put("corrquadrantrack","corrqurbaseelementfkey");
			keymap.put("corrstationbin","corrstbbaseelementfkey");
			keymap.put("correlatorbin","correlbbaseelementfkey");

		List<String> keyColumns;
		keyColumnsMap = new HashMap<String, List<String>>();
				keyColumns = new ArrayList<String>();
				keyColumns.add("baseelementid");
			keyColumnsMap.put("acacorrset", keyColumns);
				keyColumns = new ArrayList<String>();
				keyColumns.add("baseelementid");
			keyColumnsMap.put("antenna", keyColumns);
				keyColumns = new ArrayList<String>();
				keyColumns.add("baseelementid");
			keyColumnsMap.put("pad", keyColumns);
				keyColumns = new ArrayList<String>();
				keyColumns.add("baseelementid");
			keyColumnsMap.put("frontend", keyColumns);
				keyColumns = new ArrayList<String>();
				keyColumns.add("baseelementid");
			keyColumnsMap.put("photonicreference", keyColumns);
				keyColumns = new ArrayList<String>();
				keyColumns.add("baseelementid");
			keyColumnsMap.put("weatherstationcontroller", keyColumns);
				keyColumns = new ArrayList<String>();
				keyColumns.add("baseelementid");
			keyColumnsMap.put("centrallo", keyColumns);
				keyColumns = new ArrayList<String>();
				keyColumns.add("baseelementid");
			keyColumnsMap.put("aostiming", keyColumns);
				keyColumns = new ArrayList<String>();
				keyColumns.add("baseelementid");
			keyColumnsMap.put("holographytower", keyColumns);
				keyColumns = new ArrayList<String>();
				keyColumns.add("baseelementid");
			keyColumnsMap.put("corrquadrant", keyColumns);
				keyColumns = new ArrayList<String>();
				keyColumns.add("baseelementid");
			keyColumnsMap.put("corrquadrantrack", keyColumns);
				keyColumns = new ArrayList<String>();
				keyColumns.add("baseelementid");
			keyColumnsMap.put("corrstationbin", keyColumns);
				keyColumns = new ArrayList<String>();
				keyColumns.add("baseelementid");
			keyColumnsMap.put("correlatorbin", keyColumns);

		List<String> keyPieces;
		keyPiecesMap = new HashMap<String, List<String>>();
				keyPieces = new ArrayList<String>();
				keyPieces.add("swconfigurationid");
			keyPiecesMap.put("hwconfiguration", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("urn");
				keyPieces.add("configurationid");
			keyPiecesMap.put("hwschemas", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("serialnumber");
				keyPieces.add("configurationid");
			keyPiecesMap.put("assembly", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("baseelementname");
				keyPieces.add("basetype");
				keyPieces.add("configurationid");
			keyPiecesMap.put("baseelement", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("antennaid");
				keyPieces.add("padid");
				keyPieces.add("starttime");
			keyPiecesMap.put("antennatopad", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("holographytowerid");
				keyPieces.add("padid");
			keyPiecesMap.put("holographytowertopad", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("antennaid");
				keyPieces.add("receiverband");
				keyPieces.add("polarization");
				keyPieces.add("sideband");
			keyPiecesMap.put("fedelay", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("antennaid");
				keyPieces.add("baseband");
				keyPieces.add("polarization");
				keyPieces.add("ifswitch");
			keyPiecesMap.put("ifdelay", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("antennaid");
				keyPieces.add("baseband");
			keyPiecesMap.put("lodelay", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("configurationid");
				keyPieces.add("receiverband");
				keyPieces.add("sideband");
				keyPieces.add("baseband");
			keyPiecesMap.put("xpdelay", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("startupname");
				keyPieces.add("configurationid");
			keyPiecesMap.put("startup", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("startupid");
				keyPieces.add("baseelementid");
				keyPieces.add("parent");
				keyPieces.add("baseelementtype");
			keyPiecesMap.put("baseelementstartup", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("baseelementstartupid");
				keyPieces.add("rolename");
			keyPiecesMap.put("assemblystartup", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("antennaid");
			keyPiecesMap.put("pointingmodel", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("pointingmodelid");
				keyPieces.add("coeffname");
			keyPiecesMap.put("pointingmodelcoeff", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("antennaid");
			keyPiecesMap.put("focusmodel", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("focusmodelid");
				keyPieces.add("coeffname");
			keyPiecesMap.put("focusmodelcoeff", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("bacipropertyid");
				keyPieces.add("assemblyid");
				keyPieces.add("indice");
			keyPiecesMap.put("monitorpoint", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("baseelementid");
				keyPieces.add("configurationid");
				keyPieces.add("starttime");
			keyPiecesMap.put("baseelementonline", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("assemblyid");
				keyPieces.add("baseelementonlineid");
			keyPiecesMap.put("assemblyonline", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("antennaid");
				keyPieces.add("frontendid");
				keyPieces.add("starttime");
			keyPiecesMap.put("antennatofrontend", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("version");
				keyPieces.add("modtime");
				keyPieces.add("operation");
				keyPieces.add("pointingmodelid");
				keyPieces.add("coeffname");
			keyPiecesMap.put("bl_pointingmodelcoeff", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("version");
				keyPieces.add("modtime");
				keyPieces.add("operation");
				keyPieces.add("pointingmodelid");
				keyPieces.add("coeffname");
				keyPieces.add("receiverband");
			keyPiecesMap.put("bl_pointingmodelcoeffoffset", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("version");
				keyPieces.add("modtime");
				keyPieces.add("operation");
				keyPieces.add("focusmodelid");
				keyPieces.add("coeffname");
			keyPiecesMap.put("bl_focusmodelcoeff", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("version");
				keyPieces.add("modtime");
				keyPieces.add("operation");
				keyPieces.add("focusmodelid");
				keyPieces.add("coeffname");
				keyPieces.add("receiverband");
			keyPiecesMap.put("bl_focusmodelcoeffoffset", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("version");
				keyPieces.add("modtime");
				keyPieces.add("operation");
				keyPieces.add("fedelayid");
			keyPiecesMap.put("bl_fedelay", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("version");
				keyPieces.add("modtime");
				keyPieces.add("operation");
				keyPieces.add("ifdelayid");
			keyPiecesMap.put("bl_ifdelay", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("version");
				keyPieces.add("modtime");
				keyPieces.add("operation");
				keyPieces.add("lodelayid");
			keyPiecesMap.put("bl_lodelay", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("version");
				keyPieces.add("modtime");
				keyPieces.add("operation");
				keyPieces.add("xpdelayid");
			keyPiecesMap.put("bl_xpdelay", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("version");
				keyPieces.add("modtime");
				keyPieces.add("operation");
				keyPieces.add("baseelementid");
			keyPiecesMap.put("bl_antennadelay", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("version");
				keyPieces.add("modtime");
				keyPieces.add("operation");
				keyPieces.add("baseelementid");
			keyPiecesMap.put("bl_antenna", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("version");
				keyPieces.add("modtime");
				keyPieces.add("operation");
				keyPieces.add("baseelementid");
			keyPiecesMap.put("bl_pad", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("version");
				keyPieces.add("modtime");
				keyPieces.add("operation");
				keyPieces.add("antennatopadid");
			keyPiecesMap.put("bl_antennatopad", keyPieces);

		cascadingTypes = new HashMap<String, CascadeType>();
			cascadingTypes.put("swconfigid", CascadeType.NONE);
			cascadingTypes.put("systemcountersconfig", CascadeType.NONE);
			cascadingTypes.put("assemblytypelruname", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("assemblytypecomptype", CascadeType.NONE);
			cascadingTypes.put("assemblyschemasconfig", CascadeType.NONE);
			cascadingTypes.put("hwschemaassemblytype", CascadeType.NONE);
			cascadingTypes.put("assemblyconfig", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("assemblyname", CascadeType.NONE);
			cascadingTypes.put("assemblyroleassembly", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("beconfig", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("acacdelantid", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("antennatopadantennaid", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("antennatopadpadid", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("wstopadweatherstationid", CascadeType.NONE);
			cascadingTypes.put("wstopadpadid", CascadeType.NONE);
			cascadingTypes.put("holotowertopadholotower", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("holotowertopadpad", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("antennafedelay", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("antennaifdelay", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("antennalodelay", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("hwconfigxpdelay", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("corrquad", CascadeType.NONE);
			cascadingTypes.put("corrstbinrack", CascadeType.NONE);
			cascadingTypes.put("corrbinrack", CascadeType.NONE);
			cascadingTypes.put("startupconfig", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("bestartupid", CascadeType.NONE);
			cascadingTypes.put("bestartupidbe", CascadeType.NONE);
			cascadingTypes.put("bestartupparent", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("assemblystartuprole", CascadeType.NONE);
			cascadingTypes.put("assemblystartupbestartup", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("defcanaddcomp", CascadeType.NONE);
			cascadingTypes.put("antennapmantenna", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("antpmtermpointingmodelid", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("antpmcoeffofftocoeff", CascadeType.NONE);
			cascadingTypes.put("antennafmantenna", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("antfmtermfocusmodelid", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("antfmcoeffofftocoeff", CascadeType.NONE);
			cascadingTypes.put("defaultcomponenttypeid", CascadeType.NONE);
			cascadingTypes.put("defaultcomponentassemblyid", CascadeType.NONE);
			cascadingTypes.put("defbacidefaultcomponenttypeid", CascadeType.NONE);
			cascadingTypes.put("defaulpntid", CascadeType.NONE);
			cascadingTypes.put("monitorpointassemblyid", CascadeType.NONE);
			cascadingTypes.put("monitorpointbacipropertyid", CascadeType.NONE);
			cascadingTypes.put("monitordatamonitorpointid", CascadeType.NONE);
			cascadingTypes.put("beonlineid", CascadeType.NONE);
			cascadingTypes.put("beonlineconfig", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("beassemblylistid", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("beassemblylistassemblyid", CascadeType.NONE);
			cascadingTypes.put("antennatofeantennaid", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("antennatofefrontendid", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("versioninfoswcnfid", CascadeType.NONE);
			cascadingTypes.put("antefftoantenna", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("recqualitytoantenna", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("recqualityparamtorecqual", CascadeType.NONE);
			cascadingTypes.put("holographytoantenna", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("holographyrefantenna", CascadeType.NONE);

		List<String> xmlClobColumns;
		xmlClobTableColumns = new HashMap<String, List<String>>();
				xmlClobColumns = new ArrayList<String>();
				xmlClobColumns.add("schema");
			xmlClobTableColumns.put("hwschemas", xmlClobColumns);
				xmlClobColumns = new ArrayList<String>();
				xmlClobColumns.add("data");
			xmlClobTableColumns.put("assembly", xmlClobColumns);
				xmlClobColumns = new ArrayList<String>();
				xmlClobColumns.add("xmldoc");
			xmlClobTableColumns.put("defaultcomponent", xmlClobColumns);

		sequences = new HashMap<String, String>();
			sequences.put("hwconfiguration", "HWConf_seq");
			sequences.put("hwschemas", "HwSchemas_seq");
			sequences.put("assembly", "Assembly_seq");
			sequences.put("baseelement", "BaseElement_seq");
			sequences.put("antennatopad", "AntennaToPad_seq");
			sequences.put("holographytowertopad", "HologrTTP_seq");
			sequences.put("fedelay", "FEDelay_seq");
			sequences.put("ifdelay", "IFDelay_seq");
			sequences.put("lodelay", "LODelay_seq");
			sequences.put("xpdelay", "XPDelay_seq");
			sequences.put("startup", "Startup_seq");
			sequences.put("baseelementstartup", "BaseElS_seq");
			sequences.put("assemblystartup", "AssembS_seq");
			sequences.put("pointingmodel", "PointiM_seq");
			sequences.put("pointingmodelcoeff", "PointiMC_seq");
			sequences.put("focusmodel", "FocusModel_seq");
			sequences.put("focusmodelcoeff", "FocusMC_seq");
			sequences.put("monitorpoint", "MonitorPoint_seq");
			sequences.put("baseelementonline", "BaseElO_seq");
			sequences.put("assemblyonline", "AssembO_seq");
			sequences.put("antennatofrontend", "AntennTFE_seq");
			sequences.put("bl_pointingmodelcoeff", "BL_PoiMC_seq");
			sequences.put("bl_pointingmodelcoeffoffset", "BL_PoiMCO_seq");
			sequences.put("bl_focusmodelcoeff", "BL_FocMC_seq");
			sequences.put("bl_focusmodelcoeffoffset", "BL_FocMCO_seq");
			sequences.put("bl_fedelay", "BL_FEDelay_seq");
			sequences.put("bl_ifdelay", "BL_IFDelay_seq");
			sequences.put("bl_lodelay", "BL_LODelay_seq");
			sequences.put("bl_xpdelay", "BL_XPDelay_seq");
			sequences.put("bl_antennadelay", "BL_AntD_seq");
			sequences.put("bl_antenna", "BL_Antenna_seq");
			sequences.put("bl_pad", "BL_Pad_seq");
			sequences.put("bl_antennatopad", "BL_AntTP_seq");
			sequences.put("antennaefficiency", "AntennE_seq");
			sequences.put("receiverquality", "ReceivQ_seq");
			sequences.put("receiverqualityparameters", "ReceivQP_seq");
			sequences.put("holography", "Holography_seq");

		duplicatedForeignKeys = new HashMap<String, String>();

		checkConstraints = new HashMap<String, Map<String, String>>();

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("hwconfiguration", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("systemcounters", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("lrutype", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("baseelementtype", "alma.acs.tmcdb.BEType");
			checkConstraints.put("assemblytype", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("hwschemas", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("assembly", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("assemblyrole", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("basetype", "alma.acs.tmcdb.BEType");
			checkConstraints.put("baseelement", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("baseband", "alma.acs.tmcdb.BaseBandEnum");
			checkConstraints.put("acacorrset", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("antennatype", "alma.acs.tmcdb.AntennaTypeEnum");
			checkConstraints.put("antenna", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("acacorrdelays", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("pad", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("frontend", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("photonicreference", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("weatherstationcontroller", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("centrallo", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("aostiming", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("holographytower", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("antennatopad", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("weatherstationtopad", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("holographytowertopad", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("receiverband", "alma.acs.tmcdb.ReceiverBandEnum");
	tmpMap.put("polarization", "alma.acs.tmcdb.PolarizationEnum");
	tmpMap.put("sideband", "alma.acs.tmcdb.SideBandEnum");
			checkConstraints.put("fedelay", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("baseband", "alma.acs.tmcdb.BaseBandEnum");
	tmpMap.put("polarization", "alma.acs.tmcdb.PolarizationEnum");
	tmpMap.put("ifswitch", "alma.acs.tmcdb.IFSwitchEnum");
			checkConstraints.put("ifdelay", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("baseband", "alma.acs.tmcdb.BaseBandEnum");
			checkConstraints.put("lodelay", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("receiverband", "alma.acs.tmcdb.ReceiverBandEnum");
	tmpMap.put("sideband", "alma.acs.tmcdb.SideBandEnum");
	tmpMap.put("baseband", "alma.acs.tmcdb.BaseBandEnum");
			checkConstraints.put("xpdelay", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("baseband", "alma.acs.tmcdb.BaseBandEnum");
			checkConstraints.put("corrquadrant", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("racktype", "alma.acs.tmcdb.RackTypeEnum");
			checkConstraints.put("corrquadrantrack", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("corrstationbin", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("correlatorbin", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("startup", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("baseelementtype", "alma.acs.tmcdb.BEStartupBEType");
			checkConstraints.put("baseelementstartup", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("assemblystartup", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("defaultcanaddress", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("pointingmodel", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("pointingmodelcoeff", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("receiverband", "alma.acs.tmcdb.ReceiverBandEnum");
			checkConstraints.put("pointingmodelcoeffoffset", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("focusmodel", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("focusmodelcoeff", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("receiverband", "alma.acs.tmcdb.ReceiverBandEnum");
			checkConstraints.put("focusmodelcoeffoffset", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("impllang", "alma.acs.tmcdb.ImplLangEnum");
			checkConstraints.put("defaultcomponent", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("defaultbaciproperty", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("datatype", "alma.acs.tmcdb.MonitorDataTypeEnum");
			checkConstraints.put("defaultmonitorpoint", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("datatype", "alma.acs.tmcdb.MonitorDataTypeEnum");
			checkConstraints.put("monitorpoint", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("monitordata", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("baseelementonline", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("assemblyonline", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("antennatofrontend", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("bl_versioninfo", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("operation", "alma.acs.tmcdb.OperationEnum");
			checkConstraints.put("bl_pointingmodelcoeff", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("operation", "alma.acs.tmcdb.OperationEnum");
	tmpMap.put("receiverband", "alma.acs.tmcdb.ReceiverBandEnum");
			checkConstraints.put("bl_pointingmodelcoeffoffset", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("operation", "alma.acs.tmcdb.OperationEnum");
			checkConstraints.put("bl_focusmodelcoeff", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("operation", "alma.acs.tmcdb.OperationEnum");
	tmpMap.put("receiverband", "alma.acs.tmcdb.ReceiverBandEnum");
			checkConstraints.put("bl_focusmodelcoeffoffset", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("operation", "alma.acs.tmcdb.OperationEnum");
	tmpMap.put("receiverband", "alma.acs.tmcdb.ReceiverBandEnum");
	tmpMap.put("polarization", "alma.acs.tmcdb.PolarizationEnum");
	tmpMap.put("sideband", "alma.acs.tmcdb.SideBandEnum");
			checkConstraints.put("bl_fedelay", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("operation", "alma.acs.tmcdb.OperationEnum");
	tmpMap.put("baseband", "alma.acs.tmcdb.BaseBandEnum");
	tmpMap.put("polarization", "alma.acs.tmcdb.PolarizationEnum");
	tmpMap.put("ifswitch", "alma.acs.tmcdb.IFSwitchEnum");
			checkConstraints.put("bl_ifdelay", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("operation", "alma.acs.tmcdb.OperationEnum");
	tmpMap.put("baseband", "alma.acs.tmcdb.BaseBandEnum");
			checkConstraints.put("bl_lodelay", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("operation", "alma.acs.tmcdb.OperationEnum");
	tmpMap.put("receiverband", "alma.acs.tmcdb.ReceiverBandEnum");
	tmpMap.put("sideband", "alma.acs.tmcdb.SideBandEnum");
	tmpMap.put("baseband", "alma.acs.tmcdb.BaseBandEnum");
			checkConstraints.put("bl_xpdelay", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("operation", "alma.acs.tmcdb.OperationEnum");
			checkConstraints.put("bl_antennadelay", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("operation", "alma.acs.tmcdb.OperationEnum");
	tmpMap.put("antennatype", "alma.acs.tmcdb.AntennaTypeEnum");
			checkConstraints.put("bl_antenna", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("operation", "alma.acs.tmcdb.OperationEnum");
			checkConstraints.put("bl_pad", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("operation", "alma.acs.tmcdb.OperationEnum");
			checkConstraints.put("bl_antennatopad", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("antennaefficiency", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("receiverquality", tmpMap);

			tmpMap = new HashMap<String,String>();
			checkConstraints.put("receiverqualityparameters", tmpMap);

			tmpMap = new HashMap<String,String>();
	tmpMap.put("obsmode", "alma.acs.tmcdb.ObsModeEnum");
			checkConstraints.put("holography", tmpMap);

	}
}
