/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.utils;

import alma.obops.tmcdbgui.utils.conversation.HwConfigurationConversationUtils;
import alma.obops.tmcdbgui.utils.conversation.StartupScenarioConversationUtils;
import alma.tmcdb.domain.Antenna;
import alma.tmcdb.domain.BaseElement;
import alma.tmcdb.domain.BaseElementStartup;
import alma.tmcdb.domain.HwConfiguration;
import alma.tmcdb.domain.StartupScenario;

/**
 * A test for adding baseelementstartups and removing them and adding them again!
 * @author sharring
 */
public class TestMoveBaseElementToAndFromStartupScenario extends
		AbstractSampleTmcdbTestCase 
{
	/**
	 * Tests the use case of cloning an existing HW configuration.
	 * @throws Exception 
	 */
	@SuppressWarnings("null")
	public void testAddRemoveBaseElementStartup() throws Exception
	{
		// get the config
		HwConfiguration config = HwConfigurationConversationUtils.getInstance().findConfigurationsByName("Test").get(0);
		assertNotNull(config);
		
		// get any antenna
		Antenna ant = null;
		for(BaseElement baseElement : config.getBaseElements())
		{
			if(baseElement instanceof Antenna)
			{
				ant = (Antenna) baseElement;
				break;
			}
		}
		assertNotNull(ant);

		// get any startup scenario
		StartupScenario startup = null;
		for(StartupScenario startupScenario : config.getStartupScenarios())
		{
			startup = startupScenario;
			break;
		}
		assertNotNull(startup);

		// hydrate the baseelementstartups
		StartupScenarioConversationUtils.getInstance().hydrateBaseElementStartups(startup);
		
		// if there is already a bestartup for our chosen antenna, we will first remove it
		BaseElementStartup besToRemove = null;
		for(BaseElementStartup bes : startup.getBaseElementStartups())
		{
			if(bes.getBaseElement().getId().equals(ant.getId()))
			{
				besToRemove = bes;
				break;
			}
		}
		if(null != besToRemove)
		{
			StartupScenarioConversationUtils.getInstance().removeBaseElementFromStartupScenario(besToRemove, besToRemove.getStartup());
		}
		
		// now count some things for later comparison/verification
		int besBefore = startup.getBaseElementStartups().size(); 
		
		// now, we want to add a new baseelementstartup to the startup scenario for our chosen antenna
		BaseElementStartup beStartup = StartupScenarioConversationUtils.getInstance().addBaseElementToStartupScenario(ant, startup);
		assertNotNull(beStartup);
		
		// verify that a baseelementstartup was indeed added
		int besPost = startup.getBaseElementStartups().size(); 
		assertEquals(besBefore + 1, besPost);
		
		// now add the same baseelement again, which should not result in a new baseelementstartup...
		// now, we want to add a new baseelementstartup to the startup scenario for our chosen antenna
		BaseElementStartup beStartupNull = StartupScenarioConversationUtils.getInstance().addBaseElementToStartupScenario(ant, startup);
		assertNull(beStartupNull);
		
		// now, we want to remove the baseelementstartup that we added
		StartupScenarioConversationUtils.getInstance().removeBaseElementFromStartupScenario(beStartup, beStartup.getStartup());
		
		// verify that a baseelementstartup was indeed removed
		besPost = startup.getBaseElementStartups().size(); 
		assertEquals(besBefore, besPost);
		
		// now, we want to add a new baseelementstartup for the chosen antenna
		BaseElementStartup beStartup2 = StartupScenarioConversationUtils.getInstance().addBaseElementToStartupScenario(ant, startup);
		assertNotNull(beStartup2);
		
		// verify that a baseelementstartup was indeed added
		besPost = startup.getBaseElementStartups().size(); 
		assertEquals(besBefore + 1, besPost);
		
	}
}
