/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.utils;

import java.util.List;

import alma.obops.tmcdbgui.utils.conversation.HwConfigurationConversationUtils;
import alma.obops.tmcdbgui.utils.conversation.StartupScenarioConversationUtils;
import alma.tmcdb.domain.HwConfiguration;
import alma.tmcdb.domain.StartupScenario;

public class TestCloneStartupScenarioUseCase extends
		AbstractSampleTmcdbTestCase 
{
	/**
	 * Tests the clone startup scenario use case.
	 * @throws Exception 
	 */
	public void testCloneStartupScenarioUseCase() 
	   throws Exception
	{
		List<HwConfiguration> configs = HwConfigurationConversationUtils.getInstance().findConfigurationsByName("Test");
		assertNotNull(configs);
		assertTrue(0 < configs.size());
		
		HwConfiguration config = configs.get(0);
		assertNotNull(config);
		
		// The 'real' use case when performed from w/in the GUI 
		// has another hydration thrown into the mix, but it seems uncessary;
		// however, just to completely emulate the GUI use case I'll leave it here.
		HwConfigurationConversationUtils.getInstance().hydrateConfiguration( config );
		
		// The 'real' use case when performed from w/in the GUI 
		// has a find thrown into the mix, but it seems unecessary;
		// however, just to completely emulate the GUI use case I'll leave it here.
		StartupScenario scenario = StartupScenarioConversationUtils.getInstance().findStartupScenario( config, "clonedstartup");
		assertNull(scenario);
		
		assertNotNull(config.getStartupScenarios());
		assertTrue(config.getStartupScenarios().size() > 0);
		
		StartupScenario scenarioToClone = config.getStartupScenarios().iterator().next();
		StartupScenarioConversationUtils.getInstance().cloneStartupScenario(scenarioToClone, "clonedstartup");
	}
}
