/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.utils;

import alma.obops.tmcdbgui.utils.conversation.HwConfigurationConversationUtils;
import alma.obops.tmcdbgui.utils.conversation.StartupScenarioConversationUtils;
import alma.tmcdb.domain.BaseElementStartup;
import alma.tmcdb.domain.BaseElementStartupType;
import alma.tmcdb.domain.HwConfiguration;
import alma.tmcdb.domain.StartupScenario;

public class TestCloneStartupScenarioThenRemoveAntennaStartup extends
		AbstractSampleTmcdbTestCase 
{
	/**
	 * Tests the use case of cloning an existing HW configuration.
	 * @throws Exception 
	 */
	@SuppressWarnings("null")
	public void testAddRemoveBaseElementStartup() throws Exception
	{
		// get the config
		HwConfiguration config = HwConfigurationConversationUtils.getInstance().findConfigurationsByName("Test").get(0);
		assertNotNull(config);
		
		// get any startup scenario
		StartupScenario startup = null;
		for(StartupScenario startupScenario : config.getStartupScenarios())
		{
			startup = startupScenario;
			break;
		}
		assertNotNull(startup);

		// hydrate the baseelementstartups
		StartupScenarioConversationUtils.getInstance().hydrateBaseElementStartups(startup);
		
		// clone our startup scenario
		StartupScenarioConversationUtils.getInstance().cloneStartupScenario(startup, startup.getName() + System.currentTimeMillis());
		
		// get any antenna startup
		BaseElementStartup bestartupToRemove = null;
		for(BaseElementStartup bes : startup.getBaseElementStartups())
		{
			if(bes.getType().equals(BaseElementStartupType.Antenna))
			{
				bestartupToRemove = bes;
				break;
			}
		}
		
		StartupScenarioConversationUtils.getInstance().removeBaseElementFromStartupScenario(bestartupToRemove, startup);
	}
}
