/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * NewAntennaWizardPage.java
 * 
 * Copyright European Southern Observatory 2008
 */

package alma.obops.tmcdbgui.wizards;


import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.hibernate.criterion.MatchMode;

/**
 * Wizard page to enter an Antenna description
 * 
 * @author amchavan, Sep 12, 2008
 * 
 */


public class QueryConfigurationsWizardPage extends WizardPage {

	private static final String HELP_TEXT = "Leave blank to get all Configurations. ";

	private boolean activeOnly = true;
	private boolean queryAllActiveStates = false;
	private MatchMode matchMode = MatchMode.ANYWHERE;
	protected Font font;
    protected Text nameText;
    
    protected QueryConfigurationsWizardPage( String pageName ) {
        super( pageName );
        setTitle( pageName );
        setDescription( "Please enter Configuration query criteria " );
    }

    public String getName() {
        return nameText.getText();
    }
    
    public boolean getActiveOnly() {
    	return activeOnly;
    }
    
	public MatchMode getMatchMode() {
		return this.matchMode;
	}
    
	public boolean getQueryAllActiveStates() {
		return this.queryAllActiveStates;
	}
	
    public void createControl( Composite parent ) 
    {
        Composite composite = new Composite( parent, SWT.NONE );
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        composite.setLayout( layout );
        layout.numColumns = 2;  // label, entry
        
        buildNameText(composite);
        buildHelpLabel(parent, composite);
        addFillers(composite);
        buildActiveComposite(composite);
        buildExactMatchComposite(composite);
        
        setPageComplete( true );
        setControl( composite );
    }

	private void buildNameText(Composite composite) {
		// Configuration name
        Label lName = new Label( composite, SWT.NONE );
        lName.setText( "Name" );
        
        nameText = new Text( composite, SWT.BORDER | SWT.SINGLE );
        GridData gridData = new GridData();
		gridData.horizontalAlignment = SWT.FILL;
		gridData.grabExcessHorizontalSpace = true;
		nameText.setLayoutData(gridData);
        
        // At each keystroke computes whether this page is complete
        KeyListener completionKL =  new KeyListener() {
            
            public void keyPressed( KeyEvent e ) {
                // ignore
            }

            public void keyReleased( KeyEvent e ) {
                setPageComplete( isComplete() );
            }

        };
        nameText.addKeyListener( completionKL );
	}

	private void buildHelpLabel(Composite parent, Composite composite) {
		Label helpLabel = new Label(composite, SWT.NONE );
        helpLabel.setText(HELP_TEXT);

        FontData fontData = helpLabel.getFont().getFontData()[0];
        font = new Font(parent.getDisplay(), new FontData(fontData.getName(), fontData
        	    .getHeight(), SWT.ITALIC));
        helpLabel.setFont(font);

        GridData gd = new GridData( GridData.FILL_HORIZONTAL );
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = SWT.END;
        gd.horizontalSpan = 2;
        helpLabel.setLayoutData(gd);
	}

	private void addFillers(Composite composite) {
		// some space fillers (emtpy labels)
        new Label(composite, SWT.None);
        new Label(composite, SWT.NONE);
	}

	private void buildExactMatchComposite(Composite composite) {
		GridData gd;
		Composite exactMatchComposite = new Composite( composite, SWT.NONE );
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = SWT.FILL;
        exactMatchComposite.setLayoutData(gd);
        
        GridLayout glayout = new GridLayout();
        glayout.numColumns = 2;
        exactMatchComposite.setLayout( glayout );
        
        SelectionListener matchModeSelectionListener = new SelectionListener() 
        {
			@Override
			public void widgetDefaultSelected(SelectionEvent evt) {
			}

			@Override
			public void widgetSelected(SelectionEvent evt) {
				Button button = (Button) evt.widget;
				if (button.getSelection()) {
					matchMode = MatchMode.EXACT;
				}
				else {
					matchMode = MatchMode.ANYWHERE;
				}
			}
        };
        Button exactMatchButton = new Button( exactMatchComposite, SWT.CHECK);
        exactMatchButton.setText("Exact string match");
        exactMatchButton.addSelectionListener( matchModeSelectionListener );
	}

	private void buildActiveComposite(Composite composite) {
		GridData gd;
		Composite activeComposite = new Composite( composite, SWT.NONE );
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = SWT.FILL;
        activeComposite.setLayoutData(gd);
        
        GridLayout glayout = new GridLayout();
        glayout.numColumns = 3;
        activeComposite.setLayout( glayout );
        
        Button[] radios = new Button[3];

        radios[0] = new Button(activeComposite, SWT.RADIO);
        radios[0].setSelection(true);
        radios[0].setText("Active only");

        radios[1] = new Button(activeComposite, SWT.RADIO);
        radios[1].setText("Inactive only");

        radios[2] = new Button(activeComposite, SWT.RADIO);
        radios[2].setText("All");
        
        SelectionListener activeOnlySelectionListener = new SelectionListener() 
        {
			@Override
			public void widgetDefaultSelected(SelectionEvent evt) {
			}

			@Override
			public void widgetSelected(SelectionEvent evt) {
				activeOnly = true;
				queryAllActiveStates = false;
			}
        };
        radios[0].addSelectionListener( activeOnlySelectionListener );
        
        SelectionListener inactiveOnlySelectionListener = new SelectionListener() 
        {
			@Override
			public void widgetDefaultSelected(SelectionEvent evt) {
			}

			@Override
			public void widgetSelected(SelectionEvent evt) {
				activeOnly = false;
				queryAllActiveStates = false;
			}
        };
        radios[1].addSelectionListener( inactiveOnlySelectionListener );
        
        SelectionListener bothSelectionListener = new SelectionListener() 
        {
			@Override
			public void widgetDefaultSelected(SelectionEvent evt) {
			}

			@Override
			public void widgetSelected(SelectionEvent evt) {
				activeOnly = false;
				queryAllActiveStates = true;
			}
        };
        radios[2].addSelectionListener( bothSelectionListener );
	}

    /** @return <code>true</code> when this page is complete */
    protected boolean isComplete() {
        boolean complete = 
            (nameText.getText().length() >= 0);
        return complete;
    }

    public void dispose() {
    	super.dispose();
    	font.dispose();
    }

}
