/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import java.util.Date;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import alma.obops.tmcdbgui.widgets.PadAttributesComposite;
import alma.obops.tmcdbgui.widgets.support.StatusListener;
import alma.tmcdb.domain.Coordinate;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Wizard page for collecting the basic attributes of an antenna pad.
 * @author sharring
 */
public class PadAttributesWizardPage extends WizardPage implements StatusListener
{		
	private PadAttributesComposite padAttributesComposite;
	private HwConfiguration configuration;
	
	/**
	 * Constructor.
	 * @param padAttributesPagename the name of the wizard page.
	 * @param configuration the configuration in which the new antenna pad will reside.
	 */
	public PadAttributesWizardPage(String padAttributesPagename, HwConfiguration configuration) 
	{
		super(padAttributesPagename);
		setTitle("New Pad");
		setDescription( "Specify the pad's name & physical attributes" );
		this.configuration = configuration;
	}

	public Coordinate getPosition() 
	{
		return padAttributesComposite.getPosition();
	}

	public Double getCableDelay() 
	{
		return padAttributesComposite.getCableDelay();
	}

	public Date getCommissionDate() 
	{
		return padAttributesComposite.getCommissionDate();
	}
	
	public String getPadName()
	{
		return padAttributesComposite.getPadName();
	}

	@Override
	public void createControl(Composite parent) 
	{
		this.padAttributesComposite = new PadAttributesComposite(parent, SWT.NONE, configuration);
		padAttributesComposite.addStatusListener(this);
		this.setControl(padAttributesComposite);
		this.setPageComplete(false);
	}
	
	@Override
	public void updateErrorStatus(String newStatusMessage) 
	{
		this.setErrorMessage(newStatusMessage);
	}

	@Override
	public void notifyOfCompletion(boolean complete) 
	{
		this.setPageComplete(complete);
	}
}
