/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * NewAntennaWizardPage.java
 * 
 * Copyright European Southern Observatory 2008
 */

package alma.obops.tmcdbgui.wizards;


import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * Wizard page to enter an Antenna description
 * 
 * @author amchavan, Sep 12, 2008
 * 
 */


public class NewStartupScenarioWizardPage extends WizardPage {
    
    public String getName() {
        return name.getText();
    }

    protected Text name;
    
    protected NewStartupScenarioWizardPage( String pageName ) {
        super( pageName );
        setTitle( pageName );
        setDescription( "Please enter all data needed to create a new StartupScenario" );
    }

    public void createControl( Composite parent ) {
        Composite composite = new Composite( parent, SWT.NONE );
        
        GridLayout layout = new GridLayout();
        composite.setLayout( layout );
        layout.numColumns = 2;  // label, entry
        
        // Scenario name
        Label lName = new Label( composite, SWT.NULL );
        lName.setText( "Name" );
        name = new Text( composite, SWT.BORDER | SWT.SINGLE );
        GridData gd = new GridData( GridData.FILL_HORIZONTAL );
        name.setLayoutData( gd );

//        // Antenna type
//        Label lType = new Label( composite, SWT.NULL );
//        lType.setText( "Type" );
//        type = new Combo( composite, SWT.READ_ONLY );
//        type.setItems( Antenna.AntennaTypes );
//
//        // Component
//        Label lComp = new Label( composite, SWT.NULL );
//        lComp.setText( "Component" );
//        component = new Combo( composite, SWT.READ_ONLY );
//        component.setItems( compNames );
        
        // At each keystroke computes whether this page is complete
        KeyListener completionKL =  new KeyListener() {
            
            public void keyPressed( KeyEvent e ) {
                // ignore
            }

            public void keyReleased( KeyEvent e ) {
                setPageComplete( isComplete() );
            }

        };
        name.addKeyListener( completionKL );
        
//        // At every menu selection computes whether this page is complete
//        SelectionListener completionSL =  new SelectionListener() {
//
//            public void widgetDefaultSelected( SelectionEvent e ) {
//                setPageComplete( isComplete() );
//            }
//
//            public void widgetSelected( SelectionEvent e ) {
//                setPageComplete( isComplete() );
//            }
//        };
//        type.addSelectionListener( completionSL );
//        component.addSelectionListener( completionSL );
        
        setPageComplete( false );
        setControl( composite );
    }

    /** @return <code>true</code> when this page is complete */
    protected boolean isComplete() {
        boolean complete = 
            (name.getText().length() > 0) /* &&
            (type.getSelectionIndex() != -1 ) &&
            (component.getSelectionIndex() != -1 ) */
            ;
        return complete;
    }
}
