/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * NewAntennaWizard.java
 * 
 * Copyright European Southern Observatory 2008
 */

package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

import alma.obops.tmcdbgui.handlers.NewStartupScenarioAction;


/**
 * Very basic Wizard to collect input for a new startup scenario
 * 
 * @author amchavan, Sep 12, 2008
 * 
 */



public class NewStartupScenarioWizard extends Wizard {

    public static final String PAGENAME = "New Startup Scenario description";
    protected NewStartupScenarioAction callback;
    protected NewStartupScenarioWizardPage page;
    
    /**
     * @param compNames  Names of the available Components
     */
    public NewStartupScenarioWizard( NewStartupScenarioAction callback ) {
        this.callback = callback;
//        setNeedsProgressMonitor( true );
    }

    /** @see org.eclipse.jface.wizard.Wizard#addPages() */
    public void addPages() {
        this.page = new NewStartupScenarioWizardPage( PAGENAME );
        addPage( page );
    }

    /** @see org.eclipse.jface.wizard.Wizard#performFinish()*/
    public boolean performFinish() {
        
        callback.setName( page.getName() );
        return true;
    }

    /** 
     * @see org.eclipse.jface.wizard.Wizard#canFinish()
     */
    public boolean canFinish() {
        IWizardPage[] pages = getPages();
        for( int i = 0; i < pages.length; i++ ) {
            if( !pages[i].isPageComplete() ) {
                return false;
            }
        }
        return true;
    }
}