/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) NRAO - National Radio Astronomy Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/

package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.WorkbenchException;

import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.NotificationServiceMapping;
import alma.obops.tmcdbgui.editors.NotificationServiceMappingEditor;
import alma.obops.tmcdbgui.editors.inputs.NotificationServiceMappingEditorInput;
import alma.obops.tmcdbgui.perspectives.SwConfigurationPerspective;

public class NewNotificationServiceMappingWizard extends Wizard implements INewWizard 
{
	private static final String NOTIFY_EVENT_CHANNEL_FACTORY = "NotifyEventChannelFactory";
	private static final String PAGENAME = "New Notification Service Mapping";
	private IWorkbench _workbench;
	private NotificationServiceMapping _mapping;
	private Configuration _owningConfiguration;

	/**
	 * @param compNames  Names of the available Components
	 */
	public NewNotificationServiceMappingWizard( Configuration config ) {
		this._owningConfiguration = config;
	}

	/** @see org.eclipse.jface.wizard.Wizard#addPages() */
	public void addPages() {
		WizardPage page = new NewNotificationServiceMappingPage( PAGENAME, _mapping);
		addPage( page );
	}

	@Override
	public boolean performFinish() 
	{
		// Open the ContainerStartupOption editor with the new _containerStartupOption information
		NotificationServiceMappingEditorInput dmei = new NotificationServiceMappingEditorInput(_mapping);
		try {
			_workbench.getActiveWorkbenchWindow().getActivePage().openEditor(dmei, NotificationServiceMappingEditor.ID);
			_workbench.showPerspective(SwConfigurationPerspective.ID, _workbench.getActiveWorkbenchWindow());
		} catch (WorkbenchException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
	
	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		_workbench = workbench;
		_mapping = new NotificationServiceMapping();
		_mapping.setConfiguration(_owningConfiguration);
		_mapping.setDefaultNotificationService(NOTIFY_EVENT_CHANNEL_FACTORY);
	}

	/** 
	 * @see org.eclipse.jface.wizard.Wizard#canFinish()
	 */
	public boolean canFinish() {
		IWizardPage[] pages = getPages();
		for( int i = 0; i < pages.length; i++ ) {
			if( !pages[i].isPageComplete() ) {
				return false;
			}
		}
		return true;
	}

}
