/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) NRAO - National Radio Astronomy Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/

package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.WorkbenchException;

import alma.acs.tmcdb.DomainsMapping;
import alma.acs.tmcdb.NotificationServiceMapping;
import alma.obops.tmcdbgui.editors.DomainsMappingEditor;
import alma.obops.tmcdbgui.editors.inputs.DomainsMappingEditorInput;
import alma.obops.tmcdbgui.handlers.NewChannelMappingAction;
import alma.obops.tmcdbgui.perspectives.SwConfigurationPerspective;

public class NewDomainsMappingWizard extends Wizard implements INewWizard 
{
	private static final String PAGENAME = "New Notification Service Domain Mapping";
	private IWorkbench _workbench;
	private DomainsMapping _mapping;
	private NotificationServiceMapping _nsMapping;
	private ChooseNotificationServiceWizardPage nsPage;

	/**
	 * @param compNames  Names of the available Components
	 */
	public NewDomainsMappingWizard( NotificationServiceMapping nsmapping ) {
		this._nsMapping = nsmapping;
	}

	/** @see org.eclipse.jface.wizard.Wizard#addPages() */
	public void addPages() {
		WizardPage page = new NewDomainsMappingDefineNameWizardPage( PAGENAME, _mapping);
		addPage( page );
		nsPage = new ChooseNotificationServiceWizardPage("for the new Domain Mapping", 
				NewChannelMappingAction.getNotificationServiceStrings(_nsMapping.getConfiguration()));
		addPage(nsPage);
	}

	@Override
	public boolean performFinish() 
	{
		_mapping.setNotificationService(nsPage.getNotificationServiceName());
		
		// Open the ContainerStartupOption editor with the new _containerStartupOption information
		DomainsMappingEditorInput dmei = new DomainsMappingEditorInput(_mapping);
		try {
			_workbench.getActiveWorkbenchWindow().getActivePage().openEditor(dmei, DomainsMappingEditor.ID);
			_workbench.showPerspective(SwConfigurationPerspective.ID, _workbench.getActiveWorkbenchWindow());
		} catch (WorkbenchException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
	
	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		_workbench = workbench;
		_mapping = new DomainsMapping();
		_mapping.setNotificationServiceMapping(_nsMapping);
	}

	/** 
	 * @see org.eclipse.jface.wizard.Wizard#canFinish()
	 */
	public boolean canFinish() {
		IWizardPage[] pages = getPages();
		for( int i = 0; i < pages.length; i++ ) {
			if( !pages[i].isPageComplete() ) {
				return false;
			}
		}
		return true;
	}
}
