/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * NewContainerWizard.java
 */
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.WorkbenchException;

import alma.acs.tmcdb.Computer;
import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.Container;
import alma.obops.tmcdbgui.editors.ContainerEditor;
import alma.obops.tmcdbgui.editors.inputs.ContainerEditorInput;
import alma.obops.tmcdbgui.perspectives.SwConfigurationPerspective;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Wizard for creating a new {@link Container} object.
 * 
 * If during the launching of this wizard a {@link HwConfiguration} was selected,
 * its associated SW configuration is used as the default configuration
 * for the new container.
 * 
 * If a {@link Computer} object was selected during the launching of this wizard,
 * its associated SW configuration is used as the default configuration
 * for the new container, and the computer itself is used as the default computer
 * for the new container.
 * 
 * @author rtobar, Mar 1, 2010
 *
 */
public class NewContainerWizard extends Wizard implements INewWizard {

	private IWorkbench _workbench;
	private Container _cont;
	private Configuration configuration;
	
	public NewContainerWizard(Configuration config)
	{
		this.configuration = config;
	}

	@Override
	public boolean performFinish() {

		// Set initial non-nullable values if they are null
		if( _cont.getPath() == null )
			_cont.setPath("");

		// Open the Container editor with the new container information
		ContainerEditorInput cei = new ContainerEditorInput(_cont);
		try {
			_workbench.getActiveWorkbenchWindow().getActivePage().openEditor(cei, ContainerEditor.ID);
			_workbench.showPerspective(SwConfigurationPerspective.ID, _workbench.getActiveWorkbenchWindow());
		} catch (WorkbenchException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {

		_workbench = workbench;
		_cont = new Container();
		_cont.setConfiguration(configuration);

		if( selection != null && selection.size() == 1 ) {
			if( selection.getFirstElement() instanceof Computer ) {
				Computer comp = (Computer)selection.getFirstElement();
				_cont.setComputer(comp);
			}
		}

	}

	@Override
	public void addPages() {
		addPage(new NewContainerPage("New Container", _cont));
	}

	
}
