/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.WorkbenchException;

import alma.acs.tmcdb.Container;
import alma.acs.tmcdb.ContStartOptType;
import alma.acs.tmcdb.ContainerStartupOption;
import alma.obops.tmcdbgui.editors.ContainerStartupOptionEditor;
import alma.obops.tmcdbgui.editors.inputs.ContainerStartupOptionEditorInput;
import alma.obops.tmcdbgui.perspectives.SwConfigurationPerspective;

public class NewContainerStartupOptionWizard extends Wizard implements INewWizard 
{
	private IWorkbench _workbench;
	private ContainerStartupOption _containerStartupOption;
	private Container container;
	
	public NewContainerStartupOptionWizard(Container container)
	{
		this.container = container;
	}
	
	@Override
	public boolean performFinish() 
	{
		// Open the ContainerStartupOption editor with the new _containerStartupOption information
		ContainerStartupOptionEditorInput cei = new ContainerStartupOptionEditorInput(_containerStartupOption);
		try {
			_workbench.getActiveWorkbenchWindow().getActivePage().openEditor(cei, ContainerStartupOptionEditor.ID);
			_workbench.showPerspective(SwConfigurationPerspective.ID, _workbench.getActiveWorkbenchWindow());
		} catch (WorkbenchException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {

		_workbench = workbench;
		_containerStartupOption = new ContainerStartupOption();
		_containerStartupOption.setOptionName("");
		_containerStartupOption.setOptionType(ContStartOptType.ENV_VAR);
		_containerStartupOption.setOptionValue("");
		_containerStartupOption.setContainer(container);
	}

	@Override
	public void addPages() {
		addPage(new NewContainerStartupOptionPage("New ContainerStartupOption", _containerStartupOption));
	}

}
